/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.crs.model.core;

import cerent.cms.model.ModelUpdateType;
import com.cisco.crs.model.core.CLIParserError;
import com.cisco.crs.model.core.CLIResponse;
import com.cisco.crs.model.core.ICLIAdapter;
import com.cisco.crs.model.core.NonCachedValue;
import com.cisco.crs.model.core.Value;
import com.cisco.crs.poller.IPollerClient;
import com.cisco.crs.poller.ModelPoller;

public class CachedValue
extends NonCachedValue
implements IPollerClient {
    private Boolean locked = false;

    public CachedValue(ICLIAdapter iCLIAdapter) {
        super(iCLIAdapter);
    }

    public void init() {
        if (this.getCLIAdapter().getObserver() != null) {
            this.addObserver(this.getCLIAdapter().getObserver());
        }
        ModelPoller.getInstance(this.getCLIAdapter().getNMD()).addPollerClient(this);
    }

    public Value get() {
        return this.value;
    }

    public void dispose() {
        if (this.getCLIAdapter().getObserver() != null) {
            this.deleteObserver(this.getCLIAdapter().getObserver());
        }
        ModelPoller.getInstance(this.getCLIAdapter().getNMD()).deletePollerClient(this);
        super.dispose();
    }

    public String getCommand() {
        return this.getCLIAdapter().getCLICommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResult(String string) {
        if (this.db.isFinestEnabled()) {
            this.db.println("handleResult: " + string);
        }
        Boolean bl = this.locked;
        synchronized (bl) {
            if (this.isLocked()) {
                this.unlock();
                return;
            }
            ICLIAdapter iCLIAdapter = this.getCLIAdapter();
            CLIResponse cLIResponse = null;
            try {
                cLIResponse = iCLIAdapter.getParser().parseResponse(string);
            }
            catch (CLIParserError cLIParserError) {
                this.db.warning("Cannot update cached value: " + cLIParserError.getMessage());
                return;
            }
            if (this.db.isFinestEnabled()) {
                this.db.println("handleResult: newValue is " + cLIResponse);
            }
            if (this.value.update(cLIResponse)) {
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Boolean bl = this.locked;
        synchronized (bl) {
            this.locked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Boolean bl = this.locked;
        synchronized (bl) {
            this.locked = false;
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void handleError(Exception exception) {
        this.db.warning("Caught error while updating cahed value " + this.prettyString() + ": " + exception.getMessage());
    }

    public String prettyString() {
        return this.getCLIAdapter().getLabel();
    }

    public String toString() {
        return this.prettyString();
    }
}

