/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc310cl.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.ui.ppm.PpmSlot;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import com.cisco.ctc310cl.ui.shelf.CardPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.List;

public class CTXCard
extends CardGraphic {
    private PpmSlot[] ppmSlots = null;
    private static final int LG_PORT_RADIUS = 10;
    private static final int SM_PORT_RADIUS = 7;

    public CTXCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "CTXCard"));
        this.createChildren();
    }

    private void createChildren() {
        List list = this.entityM.getDescendantsOfEqType(149);
        this.ppmSlots = new PpmSlot[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)list.get(i);
            this.ppmSlots[i] = new PpmSlot(pluggableSlotModel, this.parent, this.db, this.getPpmBounds(i));
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        this.paintWbeConnector(graphics2D, 5);
        this.paintBbeHighDensityDs3Connector(graphics2D, 51);
        if (this.ppmSlots != null) {
            for (n3 = 0; n3 < this.ppmSlots.length; ++n3) {
                if (this.ppmSlots[n3] == null) continue;
                this.ppmSlots[n3].draw(graphics2D);
                Rectangle rectangle = this.getPpmBounds(n3);
                float f = (float)(rectangle.getX() + rectangle.getWidth() / 2.0);
                float f2 = (float)(rectangle.getY() + rectangle.getHeight() + 10.0);
                this.drawLabel(graphics2D, String.valueOf(n3 + 1), f, f2);
            }
        }
        n3 = 170;
        int n4 = 30;
        CardPainter.paintRJ45(graphics2D, "LAN", n3 + n4);
        CardPainter.paintRJ45(graphics2D, "BITS", n3 + n4 * 2);
        CardPainter.paintRJ45(graphics2D, "ALARM", n3 + n4 * 3);
        CardPainter.paintRJ45(graphics2D, "CRAFT", n3 + n4 * 4);
        CardPainter.paintRJ45(graphics2D, "UDC", n3 + n4 * 5);
        this.paintDs3Connectors(graphics2D, 125);
        graphics2D.setColor(color);
    }

    private void paintDs3Connectors(Graphics2D graphics2D, int n) {
        int n2 = 6;
        int n3 = 3;
        int n4 = n;
        int n5 = 30;
        int n6 = 40;
        for (int i = 0; i < n2; ++i) {
            if (i % 2 > 0) {
                int n7 = (n4 += n6) - 17;
                this.drawLabel(graphics2D, String.valueOf((i + 1) / 2), n7 + 3, n3 + 6);
                this.drawLabel(graphics2D, "DS3", n7, n3 + 13);
                this.drawLabel(graphics2D, "EC1", n7, n3 + 20);
            } else {
                n4 += i != 0 ? n5 : 0;
            }
            graphics2D.drawArc(n4, n3, 20, 20, 0, 360);
            graphics2D.drawArc(n4 + 3, n3 + 3, 14, 14, 0, 360);
        }
    }

    private void paintWbeConnector(Graphics2D graphics2D, int n) {
        int n2 = 20;
        int n3 = 45;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n3, 120.0, n2, 5.0, 5.0);
        int n4 = 40;
        this.drawLabel(graphics2D, "DS1(1-21)", n + n4, n3 + n2 + 10);
        graphics2D.draw(double_);
    }

    private void paintBbeHighDensityDs3Connector(Graphics2D graphics2D, int n) {
        int n2 = 15;
        int n3 = 15;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n3, 60.0, n2, 5.0, 5.0);
        int n4 = 10;
        this.drawLabel(graphics2D, "EXPANSION", n + n4, n3 + n2 + 10);
        graphics2D.draw(double_);
    }

    protected Rectangle getPpmBounds(int n) {
        int n2 = 40;
        int n3 = 130 + n * 31;
        return new Rectangle(n3, n2, 26, 23);
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.ppmSlots.length; ++i) {
                if (!this.ppmSlots[i].contains(mouseEvent.getPoint())) continue;
                return this.ppmSlots[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return null;
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, float f, float f2) {
        Font font = graphics2D.getFont();
        Font font2 = font.deriveFont(7.0f);
        graphics2D.setFont(font2);
        graphics2D.drawString(string, f, f2);
        graphics2D.setFont(font);
    }
}

