/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds3xmLineUpdate;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ProtCardDualPane;
import cerent.cms.ui.ds3xm.Ds3xmCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import cerent.util.SDebug;
import cerent.util.UObservable;
import com.cisco.ctc454.ui.ds3xm12.Ds3xm12MaintenancePane;
import com.cisco.ctc454.ui.ds3xm12.Ds3xm12PmPane;
import com.cisco.ctc454.ui.ds3xm12.Ds3xm12ProvPane;
import java.util.Observable;
import java.util.Observer;

public class Ds3xm12CardTabbedView
extends Ds3xmCardTabbedView
implements Observer {
    protected Ds123LineModel[] ds3All;
    private ModuleObservable myObs;
    private static final SDebug db = new SDebug("Ds3xm12CardTabbedView");

    public Ds3xm12CardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
        this.registerForLocalUpdates();
    }

    public Observable getObservable() {
        if (this.myObs == null) {
            this.myObs = new ModuleObservable();
        }
        return this.myObs;
    }

    protected void initLines(ModuleModel moduleModel) {
        Ds3xmModuleModel ds3xmModuleModel = (Ds3xmModuleModel)moduleModel;
        this.ds3Lines = ds3xmModuleModel.getFilteredDs3Lines();
        this.ds1Lines = ds3xmModuleModel.getDs1Lines();
        this.ds3All = (Ds123LineModel[])ds3xmModuleModel.getLineModels();
    }

    public Pane getMaintenanceTab() {
        return new Ds3xm12MaintenancePane("Maintenance", this, this.ds3Lines, this.ds1Lines);
    }

    public Pane getPerformanceTab() {
        return new ProtCardDualPane(this, (ModuleModel)this.getUiModel(), new Ds3xm12PmPane("Performance", this, this.ds3All, this.ds1Lines));
    }

    public Pane getProvTab() {
        return new Ds3xm12ProvPane("Provisioning", this, this.ds3Lines, this.ds1Lines);
    }

    public Ds123LineModel[] getUnfilteredLines() {
        return this.ds3All;
    }

    private ModuleModelUpdate changeModel(Observable observable) {
        Ds3xmModuleModel ds3xmModuleModel = (Ds3xmModuleModel)this.getUiModel();
        Ds3xmLineUpdate ds3xmLineUpdate = null;
        if (observable instanceof ModuleModel && ds3xmModuleModel != null) {
            Model[] modelArray = (Ds123LineModel[])ds3xmModuleModel.getLineModels();
            Model[] modelArray2 = ds3xmModuleModel.getDs1Lines();
            Model[] modelArray3 = ds3xmModuleModel.getFilteredDs3Lines();
            if (modelArray.length != this.ds3All.length) {
                this.ds3Lines = modelArray3;
                this.ds1Lines = modelArray2;
                this.ds3All = modelArray;
                ds3xmLineUpdate = new Ds3xmLineUpdate(modelArray, modelArray2, modelArray3);
            }
        }
        return ds3xmLineUpdate;
    }

    public void update(Observable observable, Object object) {
        int n = -1;
        ModuleModelUpdate moduleModelUpdate = null;
        n = object instanceof IObjectMessageInfo ? ((IObjectMessageInfo)object).getUpdateType() : ((Integer)object).intValue();
        if (db.on()) {
            db.println("update(): ob=" + observable + ", arg=" + object);
        }
        switch (n) {
            case 1: {
                if (db.on()) {
                    db.println("Changing a model...");
                }
                moduleModelUpdate = this.changeModel(observable);
                break;
            }
            case 2: {
                if (!db.on()) break;
                db.println("Adding a model...");
                break;
            }
            case 0: {
                if (!db.on()) break;
                db.println("Removing a model...");
                break;
            }
        }
        if (this.myObs != null && moduleModelUpdate != null) {
            if (db.on()) {
                db.println("Models changed.  Sending update.");
            }
            this.myObs.changed();
            this.myObs.notifyObservers(moduleModelUpdate);
        }
        if (db.on()) {
            db.println("update(): exit");
        }
    }

    protected void registerForLocalUpdates() {
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        if (moduleModel != null) {
            moduleModel.addObserver(this);
            if (db.on()) {
                db.println("Registered model: " + this.model);
            }
        }
    }

    protected void deregisterFromLocalUpdates() {
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        if (moduleModel != null) {
            moduleModel.deleteObserver(this);
            if (db.on()) {
                db.println("Deregistered parent: " + this.model);
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.deregisterFromLocalUpdates();
    }

    private class ModuleObservable
    extends UObservable {
        private ModuleObservable() {
        }

        public void changed() {
            this.setChanged();
        }
    }
}

