/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import com.cisco.ctc455.ui.ms.MsFmecBlankCard;
import com.cisco.ctc455.ui.shelf.FmecBlankCard;
import com.cisco.ctc455.ui.shelf.FmecConnector;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;

public class PinConnector
extends FmecConnector {
    protected static final int OFFSET = 4;
    private static final float[] dash1 = new float[]{1.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    private Polygon dbConnector;
    private boolean fill;
    private boolean isMSNEcard = false;
    private BasicStroke stroke = new BasicStroke(1.0f);
    private int columnPins = 2;

    public PinConnector(FmecBlankCard fmecBlankCard, int n, int n2, boolean bl) {
        super(fmecBlankCard, n, n2);
        this.fill = bl;
    }

    public PinConnector(MsFmecBlankCard msFmecBlankCard, int n, int n2, boolean bl) {
        super(msFmecBlankCard, n, n2);
        this.isMSNEcard = true;
        this.fill = bl;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.stroke = basicStroke;
    }

    public void setColumnOfPins(int n) {
        this.columnPins = n;
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        int[] nArray = new int[]{n, n + this.width, n + this.width, n};
        int[] nArray2 = new int[]{n2 + (this.isMSNEcard ? 2 : 4), n2, n2 + this.height, n2 + this.height - (this.isMSNEcard ? 2 : 4)};
        this.dbConnector = new Polygon(nArray, nArray2, 4);
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.setColor(this.color);
        if (this.fill) {
            graphics2D2.fill(this.dbConnector);
        }
        graphics2D2.setColor(Color.black);
        graphics2D2.setStroke(this.stroke);
        graphics2D2.draw(this.dbConnector);
        if (!this.isMSNEcard) {
            Line2D.Double double_ = null;
            int n3 = 0;
            for (int i = 0; i < this.columnPins; ++i) {
                n3 = n + this.width * (i + 1) / (this.columnPins + 1);
                double_ = new Line2D.Double(n3, n2 + 4 + 2, n3, n2 + this.height - 4 - 1);
                graphics2D2.setStroke(dashed);
                graphics2D2.draw(double_);
            }
        }
    }

    public boolean isFilled() {
        return this.fill;
    }
}

