/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.model.EntityModel;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.PluggableModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;

public class TCCCard
extends CardGraphic {
    private static final String TCC2P_LABEL = "TCC2P";
    private static final float OVAL_W_TO_CARD_W_RATIO = 0.25f;
    private static final float OVAL_Y_OFFSET_TO_CARD_H_RATIO = 0.5681818f;
    private static final float RECT_W_TO_CARD_W_RATIO = 0.41666666f;
    private static final float RECT_H_TO_RECT_W_RATIO = 1.5f;
    private static final float RECT_Y_OFFSET_TO_CARD_H_RATIO = 0.65909094f;
    private static final float LAN_Y_OFFSET_TO_CARD_H_RATIO = 0.76363635f;
    private final int OVAL_WIDTH;
    private final int OVAL_X_OFFSET;
    private final int OVAL_Y_OFFSET;
    private final int RECT_WIDTH;
    private final int RECT_HEIGHT;
    private final int RECT_X_OFFSET;
    private final int RECT_Y_OFFSET;
    private final int LAN_Y_OFFSET;
    private final Rectangle lanRectangle;
    private final int cardWidth;

    public TCCCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        super(entityModel, abstractShelfLayout, new SDebug((KDebug)AbstractShelfLayout.db, "TCCCard:" + entityModel.getSlot()));
        int n = this.cardPainter.getCardHeight();
        this.cardWidth = this.cardPainter.getCardWidth();
        this.OVAL_WIDTH = (int)Math.round((double)((float)this.cardWidth * 0.25f) * 0.86);
        this.OVAL_X_OFFSET = (this.cardWidth - this.OVAL_WIDTH) / 2;
        this.OVAL_Y_OFFSET = (int)Math.round((double)((float)n * 0.5681818f) * 0.86);
        this.RECT_WIDTH = Math.round((float)this.cardWidth * 0.41666666f);
        this.RECT_HEIGHT = (int)Math.round((double)((float)this.RECT_WIDTH * 1.5f) * 0.86);
        this.RECT_X_OFFSET = (this.cardWidth - this.RECT_WIDTH) / 2;
        this.RECT_Y_OFFSET = (int)Math.round((double)((float)n * 0.65909094f) * 0.86);
        this.LAN_Y_OFFSET = (int)Math.round((double)((float)n * 0.76363635f) * 0.86) + 2;
        this.lanRectangle = new Rectangle(this.RECT_X_OFFSET, this.RECT_Y_OFFSET, this.RECT_WIDTH, this.RECT_HEIGHT);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.drawOval(this.OVAL_X_OFFSET, this.OVAL_Y_OFFSET, this.OVAL_WIDTH, this.OVAL_WIDTH);
        graphics2D.draw(this.lanRectangle);
        Font font = graphics2D.getFont();
        graphics2D.setFont(font.deriveFont((float)(font.getSize() - 1)));
        graphics2D.setColor(Color.black);
        String string = "LAN";
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = (this.cardWidth - fontMetrics.stringWidth(string)) / 2;
        graphics2D.drawString(string, n3, this.LAN_Y_OFFSET);
        graphics2D.setFont(font);
    }

    public String getEqLabel() {
        String string;
        block6: {
            string = this.entityM.getEqLabel();
            List list = this.entityM.getMfgEntities();
            MfgEntityModel mfgEntityModel = null;
            if (list.size() > 0) {
                mfgEntityModel = (MfgEntityModel)list.get(0);
            }
            if (mfgEntityModel != null) {
                try {
                    if (mfgEntityModel.getMfgData().name.equals("TCC2")) {
                        string = mfgEntityModel.getMfgData().name;
                        if (this.isTCC2P()) {
                            string = TCC2P_LABEL;
                        }
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block6;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return string;
    }

    private boolean isTCC2P() {
        String string;
        PluggableModel pluggableModel;
        Map map;
        boolean bl = false;
        if (this.entityM instanceof PluggableModel && (map = (pluggableModel = (PluggableModel)this.entityM).getExtraInfoMap()).containsKey("SWTYPE") && (string = (String)map.get("SWTYPE")).equals("1")) {
            bl = true;
        }
        return bl;
    }

    protected String getEqTypeName() {
        return this.getEqLabel();
    }
}

