/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherLineUpdate;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.Model;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ModuleModelUpdate;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.ITabName;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.Pane;
import cerent.cms.ui.PluggableCardTabbedView;
import cerent.cms.ui.event.IEventPanelController;
import com.cisco.ctc600.ui.asap.AsapMaintenancePane;
import com.cisco.ctc600.ui.asap.AsapPmPane;
import com.cisco.ctc600.ui.asap.AsapProvPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;

public class AsapCardTabbedView
extends PluggableCardTabbedView
implements ITabName {
    private ArrayList ocnLinesList;
    private Map etherLinesMap;

    public AsapCardTabbedView(ModuleModel moduleModel, IEventPanelController iEventPanelController, IUiToolkit iUiToolkit) {
        super(moduleModel, iEventPanelController, iUiToolkit);
    }

    protected void init() {
        int n;
        AsapModuleModel asapModuleModel = (AsapModuleModel)this.getUiModel();
        TdmLineModel[] tdmLineModelArray = asapModuleModel.getTdmLines();
        int n2 = tdmLineModelArray.length;
        this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(tdmLineModelArray));
        this.getOM().addObservable((Observable[])tdmLineModelArray);
        AsapEtherLineModel[] asapEtherLineModelArray = asapModuleModel.getEtherLineModels();
        int n3 = asapEtherLineModelArray.length;
        this.etherLinesMap = Collections.synchronizedMap(new TreeMap(new EtherLineModelComparator()));
        this.getOM().addObservable((Observable[])asapEtherLineModelArray);
        this._interfaceContainers = Collections.synchronizedMap(new HashMap(n2 + n3));
        for (n = 0; n < n3; ++n) {
            this.etherLinesMap.put(asapEtherLineModelArray[n], asapEtherLineModelArray[n].getPosLineModel());
            this.addContainerMap(asapEtherLineModelArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            this.addContainerMap(tdmLineModelArray[n]);
        }
        super.init();
    }

    private TdmLineModel[] getOcnLinesArray() {
        return this.ocnLinesList.toArray(new TdmLineModel[this.ocnLinesList.size()]);
    }

    private AsapEtherLineModel[] getEtherLinesArray() {
        return this.etherLinesMap.keySet().toArray(new AsapEtherLineModel[this.etherLinesMap.size()]);
    }

    private AsapPosLineModel[] getPosLinesArray() {
        return this.etherLinesMap.values().toArray(new AsapPosLineModel[this.etherLinesMap.size()]);
    }

    protected List addModel(Observable observable) {
        AsapModuleModel asapModuleModel = (AsapModuleModel)this.getUiModel();
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        if (observable instanceof PpmModel) {
            IPortContainer iPortContainer = (IPortContainer)((Object)observable);
            Model[] modelArray = asapModuleModel.getTdmLines();
            int n = modelArray.length;
            EtherLineModel[] etherLineModelArray = asapModuleModel.getEtherLineModels();
            AsapPosLineModel[] asapPosLineModelArray = asapModuleModel.getPosLineModels();
            int n2 = etherLineModelArray.length;
            if (n != this.ocnLinesList.size()) {
                Iterator iterator = iPortContainer.getContainedPorts().iterator();
                while (iterator.hasNext()) {
                    this.addContainerMap(((PortModel)iterator.next()).getInterfaceModel(), iPortContainer);
                }
                this.ocnLinesList = new ArrayList<TdmLineModel>(Arrays.asList(modelArray));
                this.getOM().addObservable((Observable[])modelArray);
                arrayList.add(new OcnLineUpdate(modelArray, iPortContainer));
                db.fine("Added TDM line model...");
            } else if (n2 != this.etherLinesMap.size() && n2 == asapPosLineModelArray.length) {
                for (PortModel portModel : iPortContainer.getContainedPorts()) {
                    AsapEtherLineModel asapEtherLineModel = (AsapEtherLineModel)portModel.getInterfaceModel();
                    this.etherLinesMap.put(asapEtherLineModel, asapEtherLineModel.getPosLineModel());
                    this.addContainerMap(asapEtherLineModel, iPortContainer);
                }
                this.getOM().addObservable((Observable[])etherLineModelArray);
                arrayList.add(new EtherLineUpdate(etherLineModelArray, this.getPosLinesArray(), iPortContainer));
                db.fine("Added Ethernet/POS line models...");
            }
        }
        return arrayList.size() > 0 ? arrayList : super.addModel(observable);
    }

    protected List removeModel(Observable observable) {
        ArrayList<ModuleModelUpdate> arrayList = new ArrayList<ModuleModelUpdate>();
        IPortContainer iPortContainer = (IPortContainer)this._interfaceContainers.get(observable);
        if (observable instanceof IInterfaceModel) {
            this.removeContainerMap((IInterfaceModel)observable);
        }
        this.getOM().removeObservable(observable);
        if (this.ocnLinesList.remove(observable)) {
            arrayList.add(new OcnLineUpdate(this.getOcnLinesArray(), iPortContainer));
        } else if (observable instanceof AsapEtherLineModel) {
            this.etherLinesMap.remove(observable);
            arrayList.add(new EtherLineUpdate(this.getEtherLinesArray(), this.getPosLinesArray(), iPortContainer));
        }
        return arrayList.size() > 0 ? arrayList : super.removeModel(observable);
    }

    public Pane getMaintenanceTab() {
        return new AsapMaintenancePane("Maintenance", this, this.getOcnLinesArray(), this.getEtherLinesArray(), this.getPosLinesArray());
    }

    public Pane getPerformanceTab() {
        return new AsapPmPane("Performance", this, this.getOcnLinesArray(), this.getEtherLinesArray(), this.getPosLinesArray());
    }

    public Pane getProvTab() {
        return new AsapProvPane("Optical", this, this.getOcnLinesArray(), this.getEtherLinesArray(), this.getPosLinesArray());
    }

    public void destroy() {
        this.ocnLinesList.clear();
        this.etherLinesMap.clear();
        super.destroy();
    }

    class EtherLineModelComparator
    implements Comparator {
        EtherLineModelComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((AsapEtherLineModel)object).getIndex() - ((AsapEtherLineModel)object2).getIndex();
        }
    }
}

