/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.event.StoreObservable;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.asap.PimSlotView;
import com.cisco.ctc600.ui.shelf.CardView600;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JPanel;

public class AsapCardView
extends CardView600 {
    public static final int ASAP_CARD_WIDTH = 395;
    public static final int ASAP_CARD_HEIGHT = 204;
    private PimSlotView[] pimSlotViews = null;
    private List ppmList = new ArrayList();
    private static final SDebug db = new SDebug("AsapCardView");

    public AsapCardView(EntityModel entityModel) {
        super(entityModel);
        this.setLayout(new BorderLayout(0, 0));
        this.createChildren();
    }

    protected void addPorts(boolean bl) {
    }

    protected void createChildren() {
        block6: {
            try {
                this.registerForLocalUpdates();
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.ipadx = 2;
                gridBagConstraints.ipady = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                List list = this.model.getChildren();
                if (db.on()) {
                    db.println("Number of PIM slot is " + list.size());
                }
                this.pimSlotViews = new PimSlotView[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (db.on()) {
                        db.println("Entity for PIM slot [" + i + "] is " + entityModel);
                    }
                    if (entityModel == null) {
                        if (!db.on()) continue;
                        db.println("Entity for PIM slot [" + i + "] is NULL");
                        continue;
                    }
                    PluggableSlotModel pluggableSlotModel = null;
                    if (!(entityModel instanceof PluggableSlotModel)) continue;
                    pluggableSlotModel = (PluggableSlotModel)entityModel;
                    this.pimSlotViews[i] = new PimSlotView(pluggableSlotModel);
                    gridBagConstraints.gridx = i + 1;
                    jPanel.add((Component)this.pimSlotViews[i], gridBagConstraints);
                }
                this.add((Component)jPanel, "Center");
            }
            catch (Exception exception) {
                if (!db.on()) break block6;
                db.println("Exception while creating PIM slots");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void registerForLocalUpdates() {
        int n;
        if (this.ppmList != null) {
            for (n = 0; n < this.ppmList.size(); ++n) {
                ((EntityModel)this.ppmList.get(n)).deleteObserver(this);
            }
            this.ppmList.clear();
        }
        this.ppmList = this.model.getDescendantsOfType(eEqType.PPM_1_PORT);
        for (n = 0; n < this.ppmList.size(); ++n) {
            ((EntityModel)this.ppmList.get(n)).addObserver(this);
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        if (observable instanceof EntityModel && object instanceof Integer) {
            this.registerForLocalUpdates();
        }
        super.update(observable, object);
        super.repaint(1, 1, 30, 60);
    }

    public PimSlotView[] getChildren() {
        return this.pimSlotViews;
    }

    protected Dimension getCardSize() {
        return new Dimension(395, 204);
    }

    protected int getLedXOffset() {
        return 10;
    }

    protected int getLedYOffset() {
        return 14;
    }

    public void dispose() {
        int n;
        if (this.pimSlotViews != null) {
            for (n = 0; n < this.pimSlotViews.length; ++n) {
                if (this.pimSlotViews[n] == null) continue;
                this.pimSlotViews[n].dispose();
                this.pimSlotViews[n] = null;
            }
        }
        this.pimSlotViews = null;
        for (n = 0; n < this.ppmList.size(); ++n) {
            EntityModel entityModel = (EntityModel)this.ppmList.get(n);
            if (entityModel == null) continue;
            entityModel.deleteObserver(this);
        }
        super.dispose();
    }
}

