/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Node.sCopyInfo;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.Busy;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.ui.AbstractDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.ObserverProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CustomComboBoxModel;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.model.PreferredCopyModel;
import com.cisco.ctc600.ui.shelf.ShelfMaintenancePane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SmpPreferredCopyPane
extends ObserverProvPane
implements ActionListener {
    private static final SDebug db = new SDebug((KDebug)ShelfMaintenancePane.db, "SmpPreferredCopyPane");
    private static final String preferred = "Preferred: ";
    private static final String selected = "Currently Used: ";
    private static final String[] printableStrings = new String[]{"Copy A", "Copy B", "Both Copies", "Copy Unavailable"};
    protected PlatformNodeModel nodeModel;
    private CustomComboBoxModel preferredComboModel = new CustomComboBoxModel();
    private static final int TEXT_FIELD_LENGTH = 17;
    private ObservableManager observableManager;
    private PreferredCopyDataSourceControl pcdsControl;
    private PreferredCopyModel copyModel;
    private JComboBox preferredCombo = new JComboBox(this.preferredComboModel);
    private JTextField txtClockSyncCopy = new JTextField(17);
    private JTextField txtDataCopy = new JTextField(17);
    private JTextField txtPreferredClockSyncCopy = new JTextField(17);
    private JTextField txtPreferredDataCopy = new JTextField(17);
    private JButton updatePreferredCopyButton = new JButton("Refresh");
    private JLabel updatePreferredCopyLabel = new JLabel("");

    public SmpPreferredCopyPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.observableManager = new ObservableManager((Observer)((Object)this), true);
        this.pcdsControl = new PreferredCopyDataSourceControl();
        this.setDataSourceControl(this.pcdsControl);
        if (!this.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            this.removeButtonPanel();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.updatePreferredCopyButton) {
            this.reset();
        } else if (actionEvent.getSource() == this.preferredCombo) {
            this.updatePreferredCombo();
        }
    }

    public void destroy() {
        this.updatePreferredCopyButton = null;
        this.updatePreferredCopyLabel = null;
        this.txtPreferredClockSyncCopy = null;
        this.txtPreferredDataCopy = null;
        this.txtClockSyncCopy = null;
        this.txtDataCopy = null;
        this.preferredComboModel = null;
        this.preferredCombo = null;
        this.pcdsControl = null;
        super.destroy();
    }

    public void enteringPage() throws Exception {
        if (this.nodeModel == null) {
            this.init();
        }
        super.enteringPage();
    }

    private JPanel createClockSyncCopyBox() {
        JPanel jPanel = new JPanel(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.setBorder(BorderFactory.createTitledBorder("Clock and Sync Copy"));
        jPanel.add((Component)new JLabel(preferred), gridBagConstraints);
        this.txtPreferredClockSyncCopy.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.25;
        jPanel.add((Component)this.txtPreferredClockSyncCopy, gridBagConstraints);
        gridBagConstraints.gridx += 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(selected), gridBagConstraints);
        this.txtClockSyncCopy.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.25;
        jPanel.add((Component)this.txtClockSyncCopy, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDataCopyBox() {
        JPanel jPanel = new JPanel(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.setBorder(BorderFactory.createTitledBorder("Data Copy"));
        jPanel.add((Component)new JLabel(preferred), gridBagConstraints);
        this.txtPreferredDataCopy.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.25;
        jPanel.add((Component)this.txtPreferredDataCopy, gridBagConstraints);
        gridBagConstraints.gridx += 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(selected), gridBagConstraints);
        this.txtDataCopy.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.25;
        jPanel.add((Component)this.txtDataCopy, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Set Preferred: "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.25;
        jPanel.add((Component)this.preferredCombo, gridBagConstraints);
        return jPanel;
    }

    private JPanel createRefreshButtonBox() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.updatePreferredCopyButton);
        jPanel.add(this.updatePreferredCopyLabel);
        return jPanel;
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.nodeModel = (PlatformNodeModel)this.getUiModel().getNodeModel();
        this.copyModel = this.nodeModel.getPreferredCopyModel();
        this.initPanel();
        this.updatePreferredCopyButton.addActionListener(this);
        this.preferredCombo.addActionListener(this);
    }

    private void initPanel() {
        JPanel jPanel = SmpPreferredCopyPane.createVerticalPanel(null);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane, "Center");
        jPanel.add(this.createDataCopyBox());
        jPanel.add(this.createClockSyncCopyBox());
        jPanel.add(this.createRefreshButtonBox());
    }

    private void updateComboModel() {
        this.preferredComboModel.removeAllElements();
        this.observableManager.setObservable(null);
        Object[] objectArray = this.copyModel.getPreferredCopyCandidates();
        for (int i = 0; i < objectArray.length; ++i) {
            this.observableManager.addObservable((Observable)((Object)this.copyModel.getXcModel((String)objectArray[i])));
        }
        this.preferredComboModel.setElements(objectArray);
        this.preferredCombo.setEnabled(this.preferredComboModel.getSize() > 0);
        this.resetDirty();
    }

    private void updatePreferredCombo() {
        if (this.preferredComboModel.getSize() > 1 && this.preferredCombo.getSelectedIndex() >= 0) {
            this.pcdsControl.setDirty();
            this.setDirty();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SmpPreferredCopyPane;
    }

    class PreferredCopyDataSourceControl
    extends AbstractDataSourceControl {
        PreferredCopyDataSourceControl() {
        }

        public void applyToModel() {
            int n = SmpPreferredCopyPane.this.preferredCombo.getSelectedIndex();
            if (n >= 0) {
                try {
                    SmpPreferredCopyPane.this.copyModel.setPreferredCopy((String)SmpPreferredCopyPane.this.preferredCombo.getSelectedItem());
                }
                catch (ProvisionError provisionError) {
                    eProvDataError eProvDataError2 = ((xProvisionError)provisionError.getUserException()).dataError;
                    if (eProvDataError2 == eProvDataError.PROV_GENERIC_ERROR) {
                        this.handleError(EMC.EID_XC_FAILURE);
                    } else if (eProvDataError2 == eProvDataError.ALREADY_LOCKED_OUT) {
                        this.handleError(EMC.EID_XC_LOCKED);
                    }
                }
                catch (ProtectFailedOrMissing protectFailedOrMissing) {
                    this.handleError(EMC.EID_XC_FAILURE);
                }
                catch (WorkingFailedOrMissing workingFailedOrMissing) {
                    this.handleError(EMC.EID_XC_FAILURE);
                }
                catch (AlreadyLocked alreadyLocked) {
                    this.handleError(EMC.EID_XC_LOCKED);
                }
                catch (ProtectLocked protectLocked) {
                    this.handleError(EMC.EID_XC_LOCKED);
                }
                catch (WorkingLocked workingLocked) {
                    this.handleError(EMC.EID_XC_LOCKED);
                }
                catch (ProtectActive protectActive) {
                    this.handleError(EMC.EID_XC_PROT_ACTIVE);
                }
                catch (Busy busy) {
                    this.handleError(EMC.EID_XC_BUSY);
                }
                catch (InvalidState invalidState) {
                    this.handleError(EMC.EID_XC_INVALID_STATE);
                }
                catch (DuplexLocked duplexLocked) {
                    this.handleError(EMC.EID_XC_LOCKED);
                }
                catch (DuplexUnlocked duplexUnlocked) {
                    this.handleError(EMC.EID_XC_LOCKED);
                }
            }
        }

        private void handleError(EID eID) {
            ErrorMsg.displayDetailed((Component)((Object)SmpPreferredCopyPane.this), eID, "Unable to set preferred data copy.");
        }

        public void refreshFromModel() {
            SmpPreferredCopyPane.this.updatePreferredCopyLabel.setText("Preferred Copy last refreshed at " + new Date().toString());
            sCopyInfo sCopyInfo2 = null;
            sCopyInfo2 = SmpPreferredCopyPane.this.copyModel.getCopyInfo();
            if (sCopyInfo2 != null) {
                SmpPreferredCopyPane.this.txtPreferredClockSyncCopy.setText(printableStrings[sCopyInfo2.preferredClock.value()]);
                SmpPreferredCopyPane.this.txtPreferredDataCopy.setText(printableStrings[sCopyInfo2.preferredData.value()]);
                SmpPreferredCopyPane.this.txtClockSyncCopy.setText(printableStrings[sCopyInfo2.selectedClock.value()]);
                SmpPreferredCopyPane.this.txtDataCopy.setText(printableStrings[sCopyInfo2.selectedData.value()]);
                SmpPreferredCopyPane.this.updateComboModel();
            }
        }

        public IObservableManager getObservableManager() {
            if (db.on()) {
                db.println("getObservableManager: state = " + SmpPreferredCopyPane.this.observableManager.getBlockingModeControllerState());
            }
            return SmpPreferredCopyPane.this.observableManager;
        }

        public void disposeDataSource() {
        }
    }
}

