/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600sdh;

import cerent.cms.IPlatform;
import cerent.cms.ReferencePlatform;
import cerent.cms.idl.Common.sClassBSubnetAddr;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.vf.AbstractVersionedFeature;
import cerent.cms.ui.AbstractCardViewPanel;
import cerent.cms.ui.CardTabbedViewFactory;
import cerent.cms.ui.CardViewController;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.Pane;
import cerent.cms.ui.ShelfViewController;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import cerent.util.IpSubnet;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import com.cisco.ctc600.model.vf.Blsr2FiberVersionedFeature;
import com.cisco.ctc600.ui.CardViewPanel;
import com.cisco.ctc600.ui.PlatformCardTabbedViewFactory;
import com.cisco.ctc600.ui.network.IconStore;
import com.cisco.ctc600.ui.shelf.CardBehavior600;
import com.cisco.ctc600.ui.shelf.CardFactory;
import com.cisco.ctc600.ui.shelf.CardPainter;
import com.cisco.ctc600.ui.shelf.InternalSubnetPane;
import com.cisco.ctc600.ui.shelf.ShelfLayout;
import com.cisco.ctc600.ui.shelf.ShelfMaintenancePane;
import com.cisco.ctc600sdh.model.AlarmDecoderDefs;
import com.cisco.ctc600sdh.model.PlatformNodeModel;
import com.cisco.ctc600sdh.model.nedefaults.NodeDefaults;
import com.cisco.ctc600sdh.model.vf.Blsr4FiberVersionedFeature;
import com.cisco.ctc600sdh.ui.shelf.ShelfProvPane;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Platform
extends ReferencePlatform {
    private static final Boolean ds3FarEnd = new Boolean(false);
    private static final int[] supported600XcCardEqTypes = new int[]{91, 59};
    private static final LANAccessMode[] LAN_ACCESS_MODE = new LANAccessMode[]{LANAccessMode.DCC_ONLY, LANAccessMode.FRONT_ONLY, LANAccessMode.BACKPLANE_ONLY, LANAccessMode.FRONT_BACKPLANE};
    private static final HashMap versionedFeatureMap = new HashMap();
    private static final Map opticalLoopback601Map;
    private static final Map timingMode601Map;
    private static final String[] pm601ColumnNames;
    static final int[] vw601Masks;
    static final int XCON_A_SLOT = 6;
    static final int XCON_B_SLOT = 8;
    static final int XCON_A_SLOT_INDEX = 786432;
    static final int XCON_B_SLOT_INDEX = 0x100000;
    public static final int XCON_A_INDEX = 786433;
    public static final int XCON_B_INDEX = 0x100001;
    private static Platform instance;

    public static IPlatform instance() {
        return instance;
    }

    private Platform() {
    }

    public boolean is600SDH() {
        return true;
    }

    public boolean is600() {
        return true;
    }

    public Image[] getIcons(NodeModelDelegate nodeModelDelegate) {
        return IconStore.getIcons(nodeModelDelegate);
    }

    public CardTabbedViewFactory getCardTabbedViewFactory() {
        return PlatformCardTabbedViewFactory.instance();
    }

    public AbstractCardViewPanel getCardViewPanel(ModuleModel moduleModel, CardViewController cardViewController) {
        return new CardViewPanel(moduleModel, cardViewController);
    }

    public CardGraphic createCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout) {
        return CardFactory.createCard(entityModel, abstractShelfLayout);
    }

    public ICardPainter getCardPainter(CardGraphic cardGraphic) {
        return new CardPainter(cardGraphic);
    }

    public CardBehavior getCardBehavior(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        return new CardBehavior600(sDebug, nodeModelDelegate);
    }

    public AbstractShelfLayout getShelfLayout(IChassisModel iChassisModel, ShelfViewController shelfViewController) {
        return new ShelfLayout(iChassisModel, shelfViewController);
    }

    public AbstractShelfProvPane getShelfProvPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        return new ShelfProvPane(string, tabbedView, iGuestPaneFactory);
    }

    public AbstractShelfMaintenancePane getShelfMaintenancePane(String string, TabbedView tabbedView) {
        return new ShelfMaintenancePane(string, tabbedView);
    }

    public AbstractVersionedFeature getVersionedFeature(Feature feature) {
        return (AbstractVersionedFeature)versionedFeatureMap.get(feature);
    }

    public Pane getInternalSubnetPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory, NodeModelDelegate nodeModelDelegate) {
        return new InternalSubnetPane(string, tabbedView, iGuestPaneFactory, (PlatformNodeModel)nodeModelDelegate);
    }

    public IpSubnet[] getInternalSubnets(NodeModelDelegate nodeModelDelegate) {
        try {
            sClassBSubnetAddr[] sClassBSubnetAddrArray = ((PlatformNodeModel)nodeModelDelegate).getInternalSubnetModel().getInternalSubnet();
            return new IpSubnet[]{new IpSubnet(sClassBSubnetAddrArray[0].addr[0], sClassBSubnetAddrArray[0].addr[1], 0, 0, 16), new IpSubnet(sClassBSubnetAddrArray[1].addr[0], sClassBSubnetAddrArray[1].addr[1], 0, 0, 16), DEFAULT_INTERNAL_NETWORK};
        }
        catch (Exception exception) {
            if (exception instanceof AbstractCmsIOException) {
                throw (AbstractCmsIOException)((Object)exception);
            }
            throw new CmsCommFailException(exception.getMessage());
        }
    }

    public int[] getOsiModes() {
        int[] nArray = new int[]{1, 2};
        return nArray;
    }

    public String[] getSonetMonTypeNames() {
        return AlarmDecoderDefs.getSonetMonTypeNames();
    }

    public String[] getSdhMonTypeNames() {
        return AlarmDecoderDefs.getSdhMonTypeNames();
    }

    public Map[] getEqTypeNameMapsForDefaults() {
        return NodeDefaults.getEqTypeNameMaps();
    }

    public Object[][] getDefaultsList(String string) {
        return NodeDefaults.getDefaultsList(string);
    }

    public Object[] getListOfDefaultsLists() {
        return NodeDefaults.getListOfDefaultsLists();
    }

    public int[] getSupportedXcCardEqTypes() {
        return supported600XcCardEqTypes;
    }

    public LANAccessMode[] getSupportedLanAccessModes() {
        return LAN_ACCESS_MODE;
    }

    public boolean isConfigurableSDPSupported() {
        return false;
    }

    public boolean supportsXCSwitchOperations() {
        return false;
    }

    public boolean supportsPPC() {
        return false;
    }

    public int dayPmTableColumns() {
        return 31;
    }

    public String[] getPmColumnNames() {
        return pm601ColumnNames;
    }

    public boolean hasInventoryUserCode() {
        return true;
    }

    public boolean isRIPPaneSupported() {
        return false;
    }

    public int getMaxCmsAuditEvents() {
        return 1200;
    }

    public boolean showPjMon() {
        return false;
    }

    public boolean showSSM() {
        return true;
    }

    public boolean supportsTdmInfo() {
        return false;
    }

    public boolean supportsTdmTransceiver(int n) {
        return true;
    }

    public boolean isSnmpProxyCapable() {
        return true;
    }

    public boolean isFanTrayAlarmable() {
        return true;
    }

    public boolean isBlsrProtectionSupport() {
        return true;
    }

    public Map getTimingModeAttributeMap() {
        return timingMode601Map;
    }

    public Map getLoopbackAttributeMap() {
        return opticalLoopback601Map;
    }

    public String getControlCardName() {
        return "TSC";
    }

    public int getFanCount() {
        return 3;
    }

    public boolean hasDccTunneling() {
        return false;
    }

    public int getNumberOfTimingOutRef() {
        return 3;
    }

    public boolean isAISThresholdProvisionable() {
        return true;
    }

    public boolean isBitsOutStateProvisionable() {
        return true;
    }

    public boolean isPotentiallyLcdIpCapable() {
        return false;
    }

    public boolean isRetrieveDiagnosticsImplemented() {
        return true;
    }

    public int getBiggestStitchedEtherPath() {
        return -1;
    }

    public boolean Oc3SupportsLDC() {
        return true;
    }

    public boolean isBridgeAndRollCapable() {
        return true;
    }

    public boolean suppressMonitorCkt() {
        return true;
    }

    public boolean isMaxMultiCastDropsCapable() {
        return true;
    }

    public boolean isCAPCapable() {
        return true;
    }

    public boolean isBackupRestoreWithOptions() {
        return true;
    }

    public boolean isPortOOSserviceAfecting() {
        return false;
    }

    public boolean suppressDsIface() {
        return true;
    }

    public boolean suppressVtIface() {
        return true;
    }

    public int[] getVwMasks() {
        return vw601Masks;
    }

    public int getXconASlot() {
        return 6;
    }

    public int getXconBSlot() {
        return 8;
    }

    public int getXconASlotIndex() {
        return 786432;
    }

    public int getXconBSlotIndex() {
        return 0x100000;
    }

    public int getXconAIndex() {
        return 786433;
    }

    public int getXconBIndex() {
        return 0x100001;
    }

    public boolean isESMCapable() {
        return true;
    }

    public boolean isUcpUnicCapable() {
        return false;
    }

    public boolean isEnhancedCircuitRepairCapable() {
        return false;
    }

    public boolean isSpanUpgradeCapable() {
        return false;
    }

    public boolean isSnmpSetCapable() {
        return false;
    }

    public boolean allowsManualXcSwitching() {
        return false;
    }

    public boolean isScreenEntitiesCapable() {
        return false;
    }

    public boolean isISTUCapable() {
        return false;
    }

    public boolean isVCATCapable() {
        return false;
    }

    public boolean isLCASCapable() {
        return false;
    }

    public String getPlatformName() {
        return "15600SDH";
    }

    public Boolean ds3HasFarEnd() {
        return ds3FarEnd;
    }

    public boolean isSecureModeSupported() {
        return false;
    }

    public boolean canSendPdip() {
        return false;
    }

    public boolean supportsDetailedSwUpgradeInfo() {
        return true;
    }

    public boolean supportsJ0onOCnCards() {
        return true;
    }

    public boolean supportsServerTrail() {
        return true;
    }

    public boolean suppressPortGroupingCkt() {
        return true;
    }

    public TDMTerminology getTDMTerminology() {
        return SDHTDMTerminology.instance();
    }

    public boolean supportsE1ImpedenceSetting() {
        return true;
    }

    static {
        versionedFeatureMap.put(Feature.BLSR_2F_VERSIONING, new Blsr2FiberVersionedFeature());
        versionedFeatureMap.put(Feature.BLSR_4F_VERSIONING, new Blsr4FiberVersionedFeature());
        opticalLoopback601Map = new TreeMap();
        timingMode601Map = new TreeMap();
        Platform.putAttribute(opticalLoopback601Map, 0, "None");
        Platform.putAttribute(opticalLoopback601Map, 1, "Terminal (Inward)");
        Platform.putAttribute(opticalLoopback601Map, 2, "Facility (Line)");
        Platform.putAttribute(opticalLoopback601Map, 3, "Payload");
        Platform.putAttribute(timingMode601Map, 0, "External");
        Platform.putAttribute(timingMode601Map, 1, "Line");
        Platform.putAttribute(timingMode601Map, 2, "Mixed");
        pm601ColumnNames = new String[]{"Param", "Curr", "Prev", "Prev-1", "Prev-2", "Prev-3", "Prev-4", "Prev-5", "Prev-6", "Prev-7", "Prev-8", "Prev-9", "Prev-10", "Prev-11", "Prev-12", "Prev-13", "Prev-14", "Prev-15", "Prev-16", "Prev-17", "Prev-18", "Prev-19", "Prev-20", "Prev-21", "Prev-22", "Prev-23", "Prev-24", "Prev-25", "Prev-26", "Prev-27", "Prev-28", "Prev-29", "Prev-30", "Prev-31", "Prev-32"};
        vw601Masks = new int[]{8, 4, 2, 1, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768};
        instance = new Platform();
    }
}

