/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.debug;

import cerent.cms.IPlatform;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ISideModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchPatchCord;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OptLinkModel;
import cerent.cms.model.OpticalPatchCordModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.model.SideInUse;
import cerent.cms.model.SideModel;
import cerent.cms.model.SideModels;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.util.SDebug;
import java.util.ArrayList;
import org.omg.CORBA.UserException;

public class DeleteInternalPatchCords {
    private SideModels smod;
    private boolean allSidesDeleted = true;
    private SDebug db;

    public DeleteInternalPatchCords(NodeModelDelegate nodeModelDelegate, SDebug sDebug) {
        this.db = sDebug;
        OpticalPatchCordModel opticalPatchCordModel = OpticalPatchCordModel.getInstance(nodeModelDelegate);
        OptLinkModel[] optLinkModelArray = opticalPatchCordModel.getAllOptLinkModel();
        boolean bl = false;
        if (optLinkModelArray.length == 0) {
            bl = true;
        }
        String string = "PatchCord cannot be deleted.";
        for (int i = 0; i < optLinkModelArray.length; ++i) {
            try {
                opticalPatchCordModel.deleteOpticalLink(optLinkModelArray[i].getToPortModel(), optLinkModelArray[i].getFromPortModel());
                bl = true;
                continue;
            }
            catch (FeatureUnsupported featureUnsupported) {
                bl = false;
                SDebug.printStackTrace((Throwable)featureUnsupported);
                continue;
            }
            catch (Busy busy) {
                bl = false;
                SDebug.printStackTrace((Throwable)busy);
                continue;
            }
            catch (NoSuchPatchCord noSuchPatchCord) {
                bl = false;
                SDebug.printStackTrace((Throwable)noSuchPatchCord);
                continue;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                bl = false;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            catch (NoSuchEquipment noSuchEquipment) {
                bl = false;
                SDebug.printStackTrace((Throwable)noSuchEquipment);
            }
        }
        if (bl) {
            INodeModel iNodeModel;
            SideModels sideModels;
            this.smod = sideModels = SideModels.getInstance(nodeModelDelegate);
            ISideModel[] iSideModelArray = sideModels.getSides();
            if (iSideModelArray.length == 0) {
                this.allSidesDeleted = true;
            }
            ISideModel[] iSideModelArray2 = this.filterPSMSide(iSideModelArray);
            this.deleteSides(iSideModelArray2);
            if (this.allSidesDeleted && (iNodeModel = sideModels.getNodeModel()) instanceof NodeModelDelegate) {
                IPlatform iPlatform = ((NodeModelDelegate)iNodeModel).getPlatform();
                CardBehavior cardBehavior = iPlatform.getCardBehavior((NodeModelDelegate)iNodeModel, sDebug);
                Integer[] integerArray = iNodeModel.getEntityTable().getElementIndices();
                for (int i = 0; i < integerArray.length; ++i) {
                    try {
                        EntityModel entityModel = (EntityModel)iNodeModel.getEntityTable().getEntityModelByIndex(integerArray[i].intValue());
                        if (!(entityModel instanceof ModuleModel)) continue;
                        try {
                            if (!((ModuleModel)entityModel).isPreProvisioned()) continue;
                            ((ModuleModel)entityModel).unprovision();
                        }
                        catch (ProvisionError provisionError) {
                            SDebug.printStackTrace((Throwable)provisionError);
                        }
                        catch (ResourceInUse resourceInUse) {
                            SDebug.printStackTrace((Throwable)resourceInUse);
                        }
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
        }
    }

    private void deleteSides(ISideModel[] iSideModelArray) {
        if (iSideModelArray == null || iSideModelArray.length == 0) {
            return;
        }
        ArrayList<ISideModel> arrayList = new ArrayList<ISideModel>();
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < iSideModelArray.length; ++i) {
            ISideModel iSideModel = iSideModelArray[i];
            if (iSideModel == null) continue;
            try {
                this.smod.deleteSide(iSideModel.getId(), iSideModel.getLineIn());
                arrayList.add(iSideModel);
                continue;
            }
            catch (WrongNodeSide wrongNodeSide) {
                this.allSidesDeleted = false;
                this.db.println("Wrong Node Side");
                SDebug.printStackTrace((Throwable)wrongNodeSide);
                continue;
            }
            catch (SideInUse sideInUse) {
                this.allSidesDeleted = false;
                this.db.println("Side Cannot be deletedThe side is carrying services or traffic.");
                continue;
            }
            catch (UserException userException) {
                this.allSidesDeleted = false;
                this.db.println(userException.getMessage());
            }
        }
    }

    private ISideModel[] filterPSMSide(ISideModel[] iSideModelArray) {
        int n;
        ISideModel[] iSideModelArray2 = new ISideModel[8];
        ArrayList<ISideModel> arrayList = new ArrayList<ISideModel>();
        for (n = 0; n < 8; ++n) {
            iSideModelArray2[n] = null;
        }
        if (iSideModelArray != null) {
            for (n = 0; n < iSideModelArray.length; ++n) {
                DwdmSide.SideEnum sideEnum = DwdmSide.getValue(iSideModelArray[n].getId());
                if (sideEnum != null) {
                    if (iSideModelArray2[sideEnum.toInt() - 1] != null) continue;
                    iSideModelArray2[sideEnum.toInt() - 1] = iSideModelArray[n];
                    arrayList.add(iSideModelArray[n]);
                    continue;
                }
                if (DwdmSide.getSideLabelFromOffset(iSideModelArray[n].getId()) != "Unknown") continue;
                arrayList.add(iSideModelArray[n]);
            }
        }
        return arrayList.toArray(new SideModel[0]);
    }
}

