/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.persistence.ActivatorData;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;

public class ActFilePersistence {
    protected Logger logger = Debug.getNamedLogger("jacorb.activator");

    public ActivatorData read() {
        ActivatorData actData;
        block9: {
            actData = null;
            String dataFile = Environment.getProperty("jacorb.imr.act_data_file");
            if (dataFile != null) {
                File f = new File(dataFile);
                try {
                    if (f.exists()) {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                        actData = (ActivatorData)ois.readObject();
                    }
                    break block9;
                }
                catch (IOException ioe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: Unable to read Activator data file " + dataFile + "! ");
                    }
                    break block9;
                }
                catch (ClassNotFoundException cnfe) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.warn("WARNING: Activator data file " + dataFile + " does not contain valid object" + "! ");
                    }
                    break block9;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("WARNING: Activator data file name not configured! ");
            }
        }
        if (actData == null) {
            actData = new ActivatorData();
        }
        return actData;
    }

    public void write(ActivatorData actData) {
        String dataFile = Environment.getProperty("jacorb.imr.act_data_file");
        if (dataFile == null && this.logger.isDebugEnabled()) {
            this.logger.warn("WARNING: Activator data file name not configured creating \"actdata.dat\" in current directory, ");
            dataFile = "actdata.dat";
        }
        File f = new File(dataFile);
        this.write(f, actData);
    }

    public void backup(ActivatorData actData) {
        String dataFile = Environment.getProperty("jacorb.imr.act_backup_file");
        boolean write = true;
        if (dataFile != null) {
            File f = new File(dataFile);
            this.write(f, actData);
        }
    }

    private void write(File file, ActivatorData actData) {
        block2: {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(actData);
                oos.flush();
                oos.close();
            }
            catch (IOException ioe) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.warn("Unable to write Activator data to file " + file.getName() + " :: " + ioe.getMessage());
            }
        }
    }
}

