/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;

public class MulticastClient {
    int port = 0;
    DatagramSocket s = null;
    ArrayList returnPackets = new ArrayList();
    Logger logger = Debug.getNamedLogger("jacorb.multicast");

    public MulticastClient(int port) throws SocketException {
        this.port = port;
        this.s = new DatagramSocket();
    }

    public void multicastSend(byte[] data) throws UnknownHostException, IOException {
        long waitTime = 0L;
        InetAddress group = InetAddress.getByName("230.0.0.1");
        DatagramPacket dgp = new DatagramPacket(data, data.length, group, this.port);
        try {
            this.s.setSoTimeout(3000);
        }
        catch (SocketException se) {
            this.logger.warn("ERROR :: got exception setting socket timeout", se);
        }
        this.s.send(dgp);
        waitTime = System.currentTimeMillis() + 3000L;
        while (System.currentTimeMillis() < waitTime) {
            try {
                DatagramPacket returned = new DatagramPacket(new byte[1024], 1024);
                this.s.receive(returned);
                this.returnPackets.add(returned);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("MulticastClient timedout");
            }
        }
    }

    public byte[][] getReturnedData() {
        byte[][] returnedData = new byte[this.returnPackets.size()][];
        for (int i = 0; i < this.returnPackets.size(); ++i) {
            returnedData[i] = ((DatagramPacket)this.returnPackets.get(i)).getData();
        }
        return returnedData;
    }

    public void close() {
        this.s.close();
    }
}

