/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jacorb.ir.RepositoryImpl;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;

public class RepositoryID {
    private static Map boxedValueHelpers = new HashMap();

    public static String className(String repId) {
        return RepositoryID.className(repId, null);
    }

    public static String className(String repId, String suffix) {
        if (repId.startsWith("RMI:")) {
            return repId.substring(4, repId.indexOf(58, 4)) + (suffix != null ? suffix : "");
        }
        if (repId.startsWith("IDL:")) {
            String id = repId.substring(4, repId.lastIndexOf(58)) + (suffix != null ? suffix : "");
            if (id.equals("omg.org/CORBA/WStringValue")) {
                return "java.lang.String";
            }
            int firstSlash = id.indexOf("/");
            String prefix = firstSlash == -1 ? "" : id.substring(0, firstSlash);
            if (prefix.equals("omg.org")) {
                return RepositoryID.ir2scopes("org.omg", id.substring(firstSlash + 1));
            }
            if (prefix.indexOf(46) != -1) {
                return RepositoryID.ir2scopes(RepositoryID.reversePrefix(prefix), id.substring(firstSlash + 1));
            }
            if (prefix.equals("imr")) {
                return RepositoryID.ir2scopes("org.jacorb.imrutility", id);
            }
            return RepositoryID.ir2scopes("", id);
        }
        throw new INTF_REPOS("Unrecognized RepositoryID: " + repId);
    }

    private static final String reversePrefix(String prefix) {
        StringTokenizer tok = new StringTokenizer(prefix, ".");
        String result = tok.nextToken();
        while (tok.hasMoreTokens()) {
            result = tok.nextToken() + '.' + result;
        }
        return result;
    }

    private static String ir2scopes(String prefix, String s) {
        if (s.indexOf("/") < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, "/");
        int count = strtok.countTokens();
        StringBuffer sb = new StringBuffer();
        sb.append(prefix);
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            Class c = null;
            c = sb.toString().length() > 0 ? RepositoryID.loadClass(sb.toString() + "." + sc) : RepositoryID.loadClass(sc);
            if (c == null) {
                if (sb.toString().length() > 0) {
                    sb.append("." + sc);
                } else {
                    sb.append(sc);
                }
            } else if (i < count - 1) {
                sb.append("." + sc + "Package");
            } else {
                sb.append("." + sc);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String repId(Class c) {
        if (IDLEntity.class.isAssignableFrom(c)) {
            String className = c.getName();
            String head = "";
            String body = "";
            if (className.startsWith("org.omg") || className.startsWith("org/omg")) {
                if (className.length() > 7) {
                    body = className.substring(7);
                }
                return "IDL:omg.org/" + RepositoryID.scopesToIR(body) + ":1.0";
            }
            return "IDL:" + RepositoryID.scopesToIR(className) + ":1.0";
        }
        return ValueHandler.getRMIRepositoryID(c);
    }

    private static String scopesToIR(String s) {
        if (s.indexOf(".") < 0) {
            return s;
        }
        StringTokenizer strtok = new StringTokenizer(s, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String sc = strtok.nextToken();
            scopes[i] = sc.endsWith("Package") ? sc.substring(0, sc.indexOf("Package")) : sc;
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        if (scopes.length > 1) {
            for (int i2 = 0; i2 < scopes.length - 1; ++i2) {
                sb.append(scopes[i2] + "/");
            }
        }
        sb.append(scopes[scopes.length - 1]);
        return sb.toString();
    }

    public static String toRepositoryID(String className, boolean resolveClass) {
        if (className.equals("") || className.startsWith("IDL:") || className.startsWith("RMI:")) {
            return className;
        }
        if (resolveClass) {
            Class c = RepositoryID.loadClass(className);
            if (c == null) {
                throw new IllegalArgumentException("cannot find class: " + className);
            }
            return RepositoryID.repId(c);
        }
        return "IDL:" + className + ":1.0";
    }

    public static String toRepositoryID(String className) {
        return RepositoryID.toRepositoryID(className, true);
    }

    private static Class loadClass(String name) {
        try {
            if (RepositoryImpl.loader != null) {
                return RepositoryImpl.loader.loadClass(name);
            }
            return Environment.classForName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static BoxedValueHelper getBoxedValueHelper(String repId) {
        BoxedValueHelper result = (BoxedValueHelper)boxedValueHelpers.get(repId);
        if (result == null) {
            if (boxedValueHelpers.containsKey(repId)) {
                return null;
            }
            result = RepositoryID.createBoxedValueHelper(repId);
            boxedValueHelpers.put(repId, result);
        }
        return result;
    }

    private static BoxedValueHelper createBoxedValueHelper(String repId) {
        String className = RepositoryID.className(repId, "Helper");
        Class c = RepositoryID.loadClass(className);
        if (c != null) {
            try {
                return (BoxedValueHelper)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        if (Debug.isDebugEnabled()) {
            Debug.output("Failed to load class " + className);
        }
        return null;
    }
}

