/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Hashtable;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jacorb.ir.gui.typesystem.AbstractContainer;
import org.jacorb.ir.gui.typesystem.ModelBuilder;
import org.jacorb.ir.gui.typesystem.NodeMapper;
import org.jacorb.ir.gui.typesystem.TypeAssociator;
import org.jacorb.ir.gui.typesystem.TypeSystem;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRAlias;
import org.jacorb.ir.gui.typesystem.remote.IRArray;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IREnum;
import org.jacorb.ir.gui.typesystem.remote.IREnumMember;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRFixed;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IRModule;
import org.jacorb.ir.gui.typesystem.remote.IRNode;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRParameter;
import org.jacorb.ir.gui.typesystem.remote.IRPrimitive;
import org.jacorb.ir.gui.typesystem.remote.IRRepository;
import org.jacorb.ir.gui.typesystem.remote.IRSequence;
import org.jacorb.ir.gui.typesystem.remote.IRString;
import org.jacorb.ir.gui.typesystem.remote.IRStruct;
import org.jacorb.ir.gui.typesystem.remote.IRStructMember;
import org.jacorb.ir.gui.typesystem.remote.IRUnion;
import org.jacorb.ir.gui.typesystem.remote.IRUnionMember;
import org.jacorb.ir.gui.typesystem.remote.IRValue;
import org.jacorb.ir.gui.typesystem.remote.IRValueBox;
import org.jacorb.ir.gui.typesystem.remote.IRValueMember;
import org.jacorb.ir.gui.typesystem.remote.IRWstring;
import org.jacorb.util.Debug;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Contained;
import org.omg.CORBA.ContainedHelper;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.IRObjectHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.UnionMember;

public class RemoteTypeSystem
extends TypeSystem {
    Repository rep;
    ORB orb = ORB.init(new String[0], null);
    private static Hashtable knownIRObjects = new Hashtable();
    private static String test = "";
    private static int test2;

    public RemoteTypeSystem() throws InvalidName {
        this.rep = RepositoryHelper.narrow(this.orb.resolve_initial_references("InterfaceRepository"));
    }

    public RemoteTypeSystem(String ior) {
        this.rep = RepositoryHelper.narrow(this.orb.string_to_object(ior));
    }

    @Override
    public DefaultTreeModel createTreeModelRoot() {
        if (this.treeModel != null) {
            return this.treeModel;
        }
        IRRepository startNode = new IRRepository(this.rep);
        this.treeModel = ModelBuilder.getSingleton().createTreeModelRoot(startNode);
        return this.treeModel;
    }

    public static TypeSystemNode createTypeSystemNode(java.lang.Object obj) {
        if (obj == null) {
            Debug.output(3, "A reference from the Repository is null... (but it should not)");
            return null;
        }
        IRObject irObject = null;
        TypeSystemNode result = null;
        System.out.flush();
        if (obj instanceof IRObject) {
            try {
                irObject = IRObjectHelper.narrow((Object)obj);
            }
            catch (BAD_PARAM bp) {
                // empty catch block
            }
        }
        if (irObject != null) {
            result = (TypeSystemNode)knownIRObjects.get(irObject);
            if (result != null) {
                Debug.output(2, result.getInstanceNodeTypeName() + " " + result.getAbsoluteName() + " (cached)");
                return result;
            }
            try {
                Contained contained = ContainedHelper.narrow(irObject);
                result = (TypeSystemNode)knownIRObjects.get(contained.id());
                if (result != null) {
                    Debug.output(2, result.getInstanceNodeTypeName() + " " + result.getAbsoluteName() + " (cached by id)");
                    return result;
                }
            }
            catch (BAD_PARAM bp) {
                // empty catch block
            }
            try {
                switch (irObject.def_kind().value()) {
                    case 6: {
                        result = new IRModule(irObject);
                        break;
                    }
                    case 5: {
                        result = new IRInterface(irObject);
                        break;
                    }
                    case 3: {
                        result = new IRConstant(irObject);
                        break;
                    }
                    case 2: {
                        result = new IRAttribute(irObject);
                        break;
                    }
                    case 7: {
                        result = new IROperation(irObject);
                        break;
                    }
                    case 4: {
                        result = new IRException(irObject);
                        break;
                    }
                    case 10: {
                        result = new IRStruct(irObject);
                        break;
                    }
                    case 11: {
                        result = new IRUnion(irObject);
                        break;
                    }
                    case 13: {
                        result = new IRPrimitive(irObject);
                        break;
                    }
                    case 19: {
                        result = new IRFixed(irObject);
                        break;
                    }
                    case 14: {
                        result = new IRString(irObject);
                        break;
                    }
                    case 18: {
                        result = new IRWstring(irObject);
                        break;
                    }
                    case 9: {
                        result = new IRAlias(irObject);
                        break;
                    }
                    case 15: {
                        result = new IRSequence(irObject);
                        break;
                    }
                    case 12: {
                        result = new IREnum(irObject);
                        break;
                    }
                    case 16: {
                        result = new IRArray(irObject);
                        break;
                    }
                    case 21: {
                        result = new IRValueBox(irObject);
                        break;
                    }
                    case 20: {
                        result = new IRValue(irObject);
                        break;
                    }
                    case 22: {
                        result = new IRValueMember(irObject);
                        break;
                    }
                    default: {
                        System.out.println("Unknown/senseless DefinitionKind returned from Repository: " + irObject.def_kind().value());
                        break;
                    }
                }
            }
            catch (Exception exc) {
                Debug.output(3, exc);
            }
            if (result instanceof IRInterface && ((IRInterface)result).getName().equals("Container")) {
                int nanu = ((IRNode)result).irObject.hashCode();
                int nanu2 = irObject.hashCode();
                if (test.equals(((IRInterface)result).getAbsoluteName())) {
                    System.out.println("bug!");
                }
                test = ((IRInterface)result).getAbsoluteName();
                test2 = ((IRNode)result).irObject.hashCode();
            }
            if (result != null) {
                knownIRObjects.put(irObject, result);
                if (knownIRObjects.get(irObject) == null) {
                    System.out.println("wasislos?");
                }
                if (result instanceof IRNode && !((IRNode)result).repositoryID.equals("")) {
                    knownIRObjects.put(((IRNode)result).repositoryID, result);
                }
            }
        } else {
            if (knownIRObjects.get(obj) != null) {
                return (TypeSystemNode)knownIRObjects.get(obj);
            }
            if (obj instanceof StructMember) {
                StructMember structMember = (StructMember)obj;
                if (knownIRObjects.get("structmember" + structMember.name + structMember.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("structmember" + structMember.name + structMember.type.kind().toString());
                }
                result = new IRStructMember((StructMember)obj);
                knownIRObjects.put("structmember" + structMember.name + structMember.type.kind().toString(), result);
            } else if (obj instanceof UnionMember) {
                UnionMember unionMember = (UnionMember)obj;
                if (knownIRObjects.get("unionmember" + unionMember.name + unionMember.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("unionmember" + unionMember.name + unionMember.type.kind().toString());
                }
                result = new IRUnionMember((UnionMember)obj);
                knownIRObjects.put("unionmember" + unionMember.name + unionMember.type.kind().toString(), result);
            } else if (obj instanceof ParameterDescription) {
                ParameterDescription parDesc = (ParameterDescription)obj;
                if (knownIRObjects.get("parameter" + parDesc.name + parDesc.type.kind().toString()) != null) {
                    return (TypeSystemNode)knownIRObjects.get("parameter" + parDesc.name + parDesc.type.kind().toString());
                }
                result = new IRParameter(parDesc);
                knownIRObjects.put("parameter" + parDesc.name + parDesc.type.kind().toString(), result);
            } else if (obj instanceof String) {
                if (knownIRObjects.get((String)obj) != null) {
                    return (IREnumMember)knownIRObjects.get((String)obj);
                }
                result = new IREnumMember((String)obj);
                knownIRObjects.put(obj, result);
            }
        }
        if (result != null) {
            Debug.output(2, result.getInstanceNodeTypeName() + " " + result.getAbsoluteName());
        } else {
            Debug.output(2, "result is null ");
        }
        return result;
    }

    @Override
    public DefaultTableModel getTableModel(DefaultMutableTreeNode treeNode) {
        DefaultTableModel tableModel = new DefaultTableModel();
        java.lang.Object[] colIdentifiers = new java.lang.Object[]{"Item", "Type", "Name"};
        tableModel.setColumnIdentifiers(colIdentifiers);
        if (treeNode != null && treeNode.getUserObject() instanceof AbstractContainer) {
            for (int i = 0; i < this.treeModel.getChildCount(treeNode); ++i) {
                TypeSystemNode childNode = (TypeSystemNode)((DefaultMutableTreeNode)treeNode.getChildAt(i)).getUserObject();
                String type = "";
                if (childNode instanceof TypeAssociator) {
                    type = ((TypeAssociator)((java.lang.Object)childNode)).getAssociatedType();
                }
                java.lang.Object[] row = new java.lang.Object[]{new NodeMapper(childNode, childNode.getInstanceNodeTypeName()), new NodeMapper(childNode, type), new NodeMapper(childNode, childNode.getName())};
                tableModel.addRow(row);
            }
        }
        return tableModel;
    }

    @Override
    public TreeExpansionListener getTreeExpansionListener(TreeModel treeModel) {
        return ModelBuilder.getSingleton().getTreeExpansionListener(treeModel);
    }

    @Override
    public TreeModel getTreeModel() {
        if (this.treeModel != null) {
            return this.treeModel;
        }
        try {
            IRRepository startNode = new IRRepository(this.rep);
            this.treeModel = ModelBuilder.getSingleton().buildTreeModelAsync(startNode);
            return this.treeModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

