/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.NO_MEMORY;

public final class BufferManager {
    private List[] bufferPool;
    private byte[] bufferMax = null;
    private static int MAX;
    private static final int MIN_OFFSET = 5;
    private static final int THRESHOLD = 20;
    private static final int MEM_BUFSIZE = 256;
    private static final int MIN_PREFERRED_BUFS = 10;
    private Reaper reaper;
    private static int time;
    private static BufferManager singleton;

    private BufferManager() {
        MAX = Environment.getMaxManagedBufSize();
        this.bufferPool = new List[MAX];
        for (int i = 0; i < MAX; ++i) {
            this.bufferPool[i] = new ArrayList();
        }
        int m_pos = 0;
        int j = 256;
        while (j > 1) {
            j >>= 1;
            ++m_pos;
        }
        for (int min = 0; min < 10; ++min) {
            this.bufferPool[m_pos - 5].add(new byte[256]);
        }
        if (time > 0) {
            this.reaper = new Reaper(time);
            this.reaper.setName("BufferManager MaxCache Reaper");
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    public static BufferManager getInstance() {
        return singleton;
    }

    private static int log2up(int n) {
        int l = 0;
        int nn = n - 1;
        while (nn >> l != 0) {
            ++l;
        }
        return l;
    }

    private static int log2down(int n) {
        int l = 0;
        int nn = n;
        while (nn >> l != 0) {
            ++l;
        }
        return l - 1;
    }

    public byte[] getPreferredMemoryBuffer() {
        return this.getBuffer(256);
    }

    public synchronized byte[] getBuffer(int initial) {
        return this.getBuffer(initial, false);
    }

    public synchronized byte[] getBuffer(int initial, boolean cdrStr) {
        byte[] result;
        int log = BufferManager.log2up(initial);
        if (log >= MAX) {
            try {
                if (!cdrStr || time < 0) {
                    result = new byte[initial];
                }
                if (this.bufferMax == null || this.bufferMax.length < initial) {
                    this.bufferMax = new byte[initial * 2];
                }
                result = this.bufferMax;
                this.bufferMax = null;
            }
            catch (OutOfMemoryError e) {
                Debug.output(2, "BufferManager failed to allocate sufficient memory for byte array");
                throw new NO_MEMORY();
            }
        } else {
            List s = this.bufferPool[log > 5 ? log - 5 : 0];
            result = !s.isEmpty() ? (byte[])s.remove(s.size() - 1) : new byte[log > 5 ? 1 << log : 32];
        }
        return result;
    }

    public synchronized void returnBuffer(byte[] current) {
        this.returnBuffer(current, false);
    }

    synchronized void returnBuffer(byte[] current, boolean cdrStr) {
        int log_curr;
        if (current != null && (log_curr = BufferManager.log2down(current.length)) >= 5) {
            if (log_curr > MAX) {
                if (cdrStr && time >= 0 && (this.bufferMax == null || this.bufferMax.length < current.length)) {
                    this.bufferMax = current;
                }
                return;
            }
            List s = this.bufferPool[log_curr - 5];
            if (s.size() < 20) {
                s.add(current);
            }
        }
    }

    public void release() {
        int i = MAX;
        while (i > 0) {
            this.bufferPool[--i].clear();
        }
        if (this.reaper != null) {
            this.reaper.done = true;
            this.reaper.wake();
        }
    }

    static /* synthetic */ byte[] access$002(BufferManager x0, byte[] x1) {
        x0.bufferMax = x1;
        return x1;
    }

    static {
        time = 0;
        if (Environment.hasProperty("jacorb.bufferManagerMaxFlush")) {
            time = Environment.getIntProperty("jacorb.bufferManagerMaxFlush", 10);
        }
        singleton = new BufferManager();
    }

    private class Reaper
    extends Thread {
        public boolean done;
        private final int sleepInterval;

        public Reaper(int sleepInterval) {
            super("BufferManagerReaper");
            this.done = false;
            this.sleepInterval = sleepInterval * 1000;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    long time = (long)this.sleepInterval + System.currentTimeMillis();
                    do {
                        Reaper.sleep(this.sleepInterval);
                    } while (System.currentTimeMillis() <= time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) break;
                if (Debug.isDebugEnabled()) {
                    Debug.output(4, "Reaper thread purging maxBufferCache. It had size: " + (BufferManager.this.bufferMax == null ? 0 : BufferManager.this.bufferMax.length));
                }
                BufferManager.access$002(BufferManager.this, null);
            }
        }

        public synchronized void wake() {
            this.notify();
        }
    }
}

