/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UnknownUserException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.Messaging.ExceptionHolder;

public class ExceptionHolderImpl
extends ExceptionHolder {
    public ExceptionHolderImpl(ReplyInputStream is) {
        int status = is.getStatus().value();
        if (status == 1) {
            this.is_system_exception = false;
        } else if (status == 2) {
            this.is_system_exception = true;
        } else {
            throw new RuntimeException("attempt to create ExceptionHolder for non-exception reply");
        }
        this.byte_order = is.littleEndian;
        this.marshaled_exception = is.getBody();
    }

    public ExceptionHolderImpl(SystemException ex) {
        this.is_system_exception = true;
        this.byte_order = false;
        CDROutputStream output = new CDROutputStream();
        SystemExceptionHelper.write(output, ex);
        this.marshaled_exception = output.getBufferCopy();
    }

    public ExceptionHolderImpl() {
    }

    @Override
    public void raise_exception() throws UserException {
        CDRInputStream input = new CDRInputStream(null, this.marshaled_exception, this.byte_order);
        if (this.is_system_exception) {
            throw SystemExceptionHelper.read(input);
        }
        input.mark(0);
        String id = input.read_string();
        try {
            input.reset();
        }
        catch (IOException ioe) {
            Debug.output(2, "Unexpected IOException: " + ioe);
        }
        UserException result = null;
        try {
            result = this.exceptionFromHelper(id, input);
        }
        catch (Exception e) {
            throw new UnknownUserException();
        }
        throw result;
    }

    @Override
    public void raise_exception_with_list(ExceptionList exc_list) throws UserException {
        throw new NO_IMPLEMENT("raise_exception_with_list not yet implemented");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.marshaled_exception.length; ++i) {
            result.append(this.marshaled_exception[i] + "(" + (char)this.marshaled_exception[i] + ")  ");
        }
        return result.toString();
    }

    public UserException exceptionFromHelper(String id, InputStream input) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String name = RepositoryID.className(id, "Helper");
        Class helper = Environment.classForName(name);
        Method readMethod = helper.getMethod("read", Environment.classForName("org.omg.CORBA.portable.InputStream"));
        Object result = readMethod.invoke(null, input);
        return (UserException)result;
    }

    public byte[] marshal() {
        byte[] buffer = BufferManager.getInstance().getBuffer(this.marshaled_exception.length + 128);
        CDROutputStream output = new CDROutputStream(buffer);
        output.write_value((Serializable)this, "IDL:omg.org/Messaging/ExceptionHolder:1.0");
        return buffer;
    }
}

