/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.Any;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IDLEntity;

public class TypeCode
extends org.omg.CORBA.TypeCode {
    private int kind = -1;
    private String id = null;
    private String name = null;
    private int member_count = 0;
    private String[] member_name = null;
    private org.omg.CORBA.TypeCode[] member_type = null;
    private short[] member_visibility = null;
    private Any[] member_label = null;
    private short value_modifier = 0;
    private org.omg.CORBA.TypeCode discriminator_type = null;
    private int default_index = -1;
    private int length = -1;
    private org.omg.CORBA.TypeCode content_type = null;
    private short scale;
    private short digits;
    private boolean recursive = false;
    private TypeCode actualTypecode = null;
    private boolean secondIteration = false;
    private static org.omg.CORBA.TypeCode[] primitive_tcs;
    private static Map primitive_tcs_map;

    private static void put_primitive_tcs(Class clz, int kind) {
        primitive_tcs_map.put(clz, primitive_tcs[kind]);
    }

    public TypeCode(int _kind) {
        this.kind = _kind;
    }

    static org.omg.CORBA.TypeCode get_primitive_tc(int _kind) {
        if (primitive_tcs[_kind] == null) {
            throw new BAD_PARAM("No primitive TypeCode for kind " + _kind);
        }
        return primitive_tcs[_kind];
    }

    public boolean is_primitive() {
        return !this.is_recursive() && primitive_tcs[this.kind] != null;
    }

    public TypeCode(String id) {
        this.id = id;
        this.recursive = true;
        this.kind = -1;
        this.actualTypecode = null;
    }

    public TypeCode(int _kind, String _id, String _name, StructMember[] _members) {
        this.kind = _kind;
        this.id = _id;
        this.name = _name != null ? _name.replace('.', '_') : "";
        this.member_count = _members.length;
        this.member_name = new String[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = _members[i].name;
            this.member_type[i] = _members[i].type;
        }
        this.resolveRecursion();
    }

    public TypeCode(String _id, String _name, org.omg.CORBA.TypeCode _discriminator_type, UnionMember[] _members) {
        this.kind = 16;
        this.id = _id;
        this.name = _name != null ? _name.replace('.', '_') : "";
        this.discriminator_type = _discriminator_type;
        this.member_count = _members.length;
        this.member_name = new String[this.member_count];
        this.member_label = new Any[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = _members[i].name;
            this.member_label[i] = (Any)_members[i].label;
            if (this.member_label[i].kind().equals(TCKind.tk_octet) && (Byte)this.member_label[i].value() == 0) {
                this.default_index = i;
            }
            this.member_type[i] = _members[i].type;
        }
        this.resolveRecursion();
    }

    public TypeCode(String _id, String _name, String[] _members) {
        this.kind = 17;
        this.id = _id;
        this.name = _name != null ? _name.replace('.', '_') : "";
        this.member_count = _members.length;
        this.member_name = new String[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = _members[i];
        }
    }

    public TypeCode(int _kind, String _id, String _name, org.omg.CORBA.TypeCode _original_type) {
        this.id = _id;
        this.kind = _kind;
        this.name = _name != null ? _name.replace('.', '_') : "";
        this.content_type = _original_type;
    }

    public TypeCode(int _kind, String _id, String _name) {
        this.kind = _kind;
        this.id = _id;
        this.name = _name != null ? _name.replace('.', '_') : "";
    }

    public TypeCode(int _kind, int _bound) {
        this.kind = _kind;
        this.length = _bound;
    }

    public TypeCode(int _kind, int _bound, org.omg.CORBA.TypeCode _element_type) {
        this.kind = _kind;
        this.length = _bound;
        this.content_type = _element_type;
        if (this.content_type == null) {
            throw new BAD_PARAM("TypeCode.ctor, content_type null");
        }
    }

    public TypeCode(short _digits, short _scale) {
        this.kind = 28;
        this.digits = _digits;
        this.scale = _scale;
    }

    public TypeCode(String id, String _name, short type_modifier, org.omg.CORBA.TypeCode concrete_base, ValueMember[] members) {
        this.kind = 29;
        this.id = id;
        this.name = _name != null ? _name.replace('.', '_') : "";
        this.value_modifier = type_modifier;
        this.content_type = concrete_base;
        this.setValueMembers(members);
    }

    private void setValueMembers(ValueMember[] members) {
        this.member_count = members != null ? members.length : 0;
        this.member_name = new String[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        this.member_visibility = new short[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = members[i].name;
            this.member_type[i] = members[i].type;
            this.member_visibility[i] = members[i].access;
        }
    }

    @Override
    public boolean equal(org.omg.CORBA.TypeCode tc) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                    TypeCode jtc = (TypeCode)tc;
                    jtc.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean result = this.actualTypecode.equal(jtc.actualTypecode);
                    this.secondIteration = false;
                    return result;
                }
                return tc.equal(this.actualTypecode);
            }
            if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                TypeCode jtc = (TypeCode)tc;
                jtc.checkActualTC();
                return this.equal(jtc.actualTypecode);
            }
            if (this.kind().value() != tc.kind().value()) {
                return false;
            }
            if (!(this.kind != 14 && this.kind != 15 && this.kind != 16 && this.kind != 17 && this.kind != 21 && this.kind != 22 && this.kind != 29 && this.kind != 30 && this.kind != 31 && this.kind != 32 && this.kind != 33 || this.id().equals(tc.id()) && this.name().equals(tc.name()))) {
                return false;
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != tc.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (!this.member_name(i).equals(tc.member_name(i))) {
                        return false;
                    }
                    if (this.kind != 17 && !this.member_type(i).equal(tc.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(tc.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == tc.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equal(tc.discriminator_type()) && this.default_index() == tc.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != tc.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equal(tc.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != tc.fixed_digits() || this.fixed_scale() != tc.fixed_scale())) {
                return false;
            }
            if (this.kind == 29) {
                if (this.type_modifier() != tc.type_modifier()) {
                    return false;
                }
                if (this.concrete_base_type() != null || tc.concrete_base_type() != null) {
                    if (this.concrete_base_type() == null || tc.concrete_base_type() == null) {
                        return false;
                    }
                    if (!this.concrete_base_type().equal(tc.concrete_base_type())) {
                        return false;
                    }
                }
            }
        }
        catch (Bounds b) {
            return false;
        }
        catch (BadKind bk) {
            return false;
        }
        return true;
    }

    @Override
    public TCKind kind() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.kind();
        }
        return TCKind.from_int(this.kind);
    }

    public int _kind() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode._kind();
        }
        return this.kind;
    }

    @Override
    public String id() throws BadKind {
        if (this.is_recursive()) {
            return this.id;
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.id;
            }
            case 18: 
            case 19: 
            case 20: {
                throw new BadKind();
            }
            case 21: 
            case 22: {
                return this.id;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                throw new BadKind();
            }
            case 29: 
            case 30: {
                return this.id;
            }
            case 31: {
                throw new BadKind();
            }
            case 32: 
            case 33: {
                return this.id;
            }
        }
        throw new BadKind();
    }

    @Override
    public String name() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.name();
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.name;
            }
        }
        throw new BadKind();
    }

    @Override
    public int member_count() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_count();
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this.member_count;
            }
        }
        throw new BadKind();
    }

    @Override
    public String member_name(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_name(index);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                if (index >= 0 && index < this.member_count) {
                    return this.member_name[index];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.TypeCode member_type(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_type(index);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                if (index >= 0 && index < this.member_count) {
                    return this.member_type[index];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.Any member_label(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_label(index);
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        if (index < 0 || index >= this.member_count) {
            throw new Bounds();
        }
        return this.member_label[index];
    }

    @Override
    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.discriminator_type();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.discriminator_type;
    }

    @Override
    public int default_index() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.default_index();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.default_index;
    }

    @Override
    public int length() throws BadKind {
        switch (this.kind) {
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this.length;
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        switch (this.kind) {
            case 19: 
            case 20: 
            case 21: 
            case 30: {
                return this.content_type;
            }
        }
        throw new BadKind();
    }

    @Override
    public short fixed_digits() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.digits;
    }

    @Override
    public short fixed_scale() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.scale;
    }

    @Override
    public org.omg.CORBA.TypeCode get_compact_typecode() {
        int i;
        TypeCode result = new TypeCode(this.kind, this.id, "");
        result.member_count = this.member_count;
        if (this.member_name != null) {
            result.member_name = new String[this.member_name.length];
            for (i = 0; i < result.member_name.length; ++i) {
                result.member_name[i] = "";
            }
        }
        if (this.member_type != null) {
            result.member_type = new TypeCode[this.member_type.length];
            for (i = 0; i < result.member_type.length; ++i) {
                result.member_type[i] = this.member_type[i].get_compact_typecode();
            }
        }
        result.member_visibility = this.member_visibility;
        result.member_label = this.member_label;
        result.value_modifier = this.value_modifier;
        result.discriminator_type = this.discriminator_type;
        result.default_index = this.default_index;
        result.length = this.length;
        if (this.content_type != null) {
            result.content_type = this.content_type.get_compact_typecode();
        }
        result.scale = this.scale;
        result.digits = this.digits;
        result.recursive = this.recursive;
        result.actualTypecode = this.actualTypecode;
        result.secondIteration = this.secondIteration;
        result.resolveRecursion(result);
        if (Debug.isDebugEnabled()) {
            Debug.output("Compacting typecode " + this + " and returning " + result);
        }
        return result;
    }

    @Override
    public short member_visibility(int index) throws BadKind, Bounds {
        if (this.kind != 29) {
            throw new BadKind();
        }
        if (index < 0 || index >= this.member_count) {
            throw new Bounds();
        }
        return this.member_visibility[index];
    }

    @Override
    public short type_modifier() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.value_modifier;
    }

    @Override
    public org.omg.CORBA.TypeCode concrete_base_type() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.content_type;
    }

    @Override
    public boolean equivalent(org.omg.CORBA.TypeCode tc) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                    TypeCode jtc = (TypeCode)tc;
                    jtc.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean result = this.actualTypecode.equivalent(jtc.actualTypecode);
                    this.secondIteration = false;
                    return result;
                }
                return tc.equivalent(this.actualTypecode);
            }
            if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                TypeCode jtc = (TypeCode)tc;
                jtc.checkActualTC();
                return this.equivalent(jtc.actualTypecode);
            }
            if (this.kind().value() == 21) {
                return this.content_type().equivalent(tc);
            }
            if (tc.kind().value() == 21) {
                return this.equivalent(tc.content_type());
            }
            if (this.kind().value() != tc.kind().value()) {
                return false;
            }
            if ((this.kind == 14 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 21 || this.kind == 22 || this.kind == 29 || this.kind == 30 || this.kind == 31 || this.kind == 32 || this.kind == 33) && this.id().length() > 0 && tc.id().length() > 0) {
                return this.id().equals(tc.id());
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != tc.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (this.kind != 17 && !this.member_type(i).equivalent(tc.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(tc.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == tc.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equivalent(tc.discriminator_type()) && this.default_index() == tc.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != tc.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equivalent(tc.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != tc.fixed_digits() || this.fixed_scale() != tc.fixed_scale())) {
                return false;
            }
            if (!(this.kind != 29 || this.type_modifier() == tc.type_modifier() && this.concrete_base_type().equivalent(tc.concrete_base_type()))) {
                return false;
            }
        }
        catch (Bounds b) {
            return false;
        }
        catch (BadKind bk) {
            return false;
        }
        return true;
    }

    public void toSequence() {
        this.kind = 19;
    }

    public String toString() {
        return "{TypeCode: Kind=" + this.kind + " (" + this.kindToString(this.kind) + "), ID=" + this.id + ", recursive=" + this.recursive + "}";
    }

    private String kindToString(int kind) {
        switch (kind) {
            case -1: {
                return "recursive";
            }
            case 0: {
                return "tk_null";
            }
            case 1: {
                return "tk_void";
            }
            case 2: {
                return "tk_short";
            }
            case 3: {
                return "tk_long";
            }
            case 4: {
                return "tk_ushort";
            }
            case 5: {
                return "tk_ulong";
            }
            case 6: {
                return "tk_float";
            }
            case 7: {
                return "tk_double";
            }
            case 8: {
                return "tk_boolean";
            }
            case 9: {
                return "tk_char";
            }
            case 10: {
                return "tk_octet";
            }
            case 11: {
                return "tk_any";
            }
            case 12: {
                return "tk_TypeCode";
            }
            case 13: {
                return "tk_Principal";
            }
            case 14: {
                return "tk_objref";
            }
            case 15: {
                return "tk_struct";
            }
            case 16: {
                return "tk_union";
            }
            case 17: {
                return "tk_enum";
            }
            case 18: {
                return "tk_string";
            }
            case 19: {
                return "tk_sequence";
            }
            case 20: {
                return "tk_array";
            }
            case 21: {
                return "tk_alias";
            }
            case 22: {
                return "tk_except";
            }
            case 23: {
                return "tk_longlong";
            }
            case 24: {
                return "tk_ulonglong";
            }
            case 25: {
                return "tk_longdouble";
            }
            case 26: {
                return "tk_wchar";
            }
            case 27: {
                return "tk_wstring";
            }
            case 28: {
                return "tk_fixed";
            }
            case 29: {
                return "tk_value";
            }
            case 30: {
                return "tk_value_box";
            }
            case 31: {
                return "tk_native";
            }
            case 32: {
                return "tk_abstract_interface";
            }
            case 33: {
                return "tk_local_interface";
            }
        }
        throw new BAD_PARAM();
    }

    public boolean is_recursive() {
        return this.recursive;
    }

    public static boolean isRecursive(org.omg.CORBA.TypeCode tc) {
        return tc instanceof TypeCode ? ((TypeCode)tc).is_recursive() : false;
    }

    public static String idlTypeName(org.omg.CORBA.TypeCode tc) {
        return tc instanceof TypeCode ? ((TypeCode)tc).idlTypeName() : "(foreign typecode)";
    }

    public String idlTypeName() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.idlTypeName();
        }
        switch (this.kind().value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                try {
                    return TypeCode.idToIDL(this.id());
                }
                catch (BadKind bk) {
                    // empty catch block
                }
            }
            case 1: {
                return "void";
            }
            case 18: {
                return "string";
            }
            case 27: {
                return "wstring";
            }
            case 20: {
                try {
                    return TypeCode.idlTypeName(this.content_type()) + "[]";
                }
                catch (BadKind bk) {
                    // empty catch block
                }
            }
            case 3: {
                return "long";
            }
            case 5: {
                return "ulong";
            }
            case 23: {
                return "long long";
            }
            case 24: {
                return "ulong long";
            }
            case 4: {
                return "ushort";
            }
            case 2: {
                return "short";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 28: {
                try {
                    return "fixed <" + this.fixed_digits() + "," + this.fixed_scale() + ">";
                }
                catch (BadKind bk) {
                    // empty catch block
                }
            }
            case 8: {
                return "boolean";
            }
            case 10: {
                return "octet";
            }
            case 9: {
                return "char";
            }
            case 26: {
                return "wchar";
            }
            case 11: {
                return "any";
            }
            case 19: {
                try {
                    return "sequence <" + TypeCode.idlTypeName(this.content_type()) + ">";
                }
                catch (BadKind badKind) {
                    // empty catch block
                }
            }
        }
        return "* no typeName for TK " + this.kind().value() + " *";
    }

    private static String idToIDL(String s) {
        if (s.length() > 4) {
            s = s.startsWith("IDL:") ? s.substring(4, s.lastIndexOf(":")) : s.replace('.', '/') + ":1.0";
        }
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '/') continue;
            sb.setCharAt(i, ':');
            sb.insert(i, ':');
        }
        return sb.toString();
    }

    public static org.omg.CORBA.TypeCode originalType(org.omg.CORBA.TypeCode tc) {
        if (TypeCode.isRecursive(tc)) {
            return tc;
        }
        try {
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return tc;
    }

    public static TypeCode create_tc(Class clz) {
        return TypeCode.create_tc(clz, new HashMap());
    }

    private static TypeCode create_tc(Class clz, Map knownTypes) {
        if (clz.isPrimitive()) {
            return (TypeCode)primitive_tcs_map.get(clz);
        }
        if (knownTypes.containsKey(clz)) {
            TypeCode newTypeCode = new TypeCode(RepositoryID.repId(clz));
            newTypeCode.setActualTC((TypeCode)knownTypes.get(clz));
            return newTypeCode;
        }
        if (clz.isArray()) {
            TypeCode newTypeCode = new TypeCode(30, RepositoryID.repId(clz), "Java_array", new TypeCode(19, 0, TypeCode.create_tc(clz.getComponentType(), knownTypes)));
            return newTypeCode;
        }
        if (ValueHandler.assignableFrom(clz)) {
            return new TypeCode(14, RepositoryID.repId(clz), clz.getName());
        }
        if (IDLEntity.class.isAssignableFrom(clz)) {
            String helperClassName = clz.getName() + "Helper";
            try {
                ClassLoader cl = clz.getClassLoader();
                Class<?> helperClass = null;
                helperClass = cl != null ? cl.loadClass(helperClassName) : Class.forName(helperClassName);
                Method typeMethod = helperClass.getMethod("type", null);
                TypeCode newTypeCode = (TypeCode)typeMethod.invoke(null, null);
                return newTypeCode;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot create TypeCode for class " + clz + "\nReason: Error loading helper class " + helperClassName + "\n" + e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Cannot create TypeCode for class: " + clz + "\nReason: no type() method in helper class " + helperClassName + "\n" + e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot create TypeCode for class: " + clz + "\n" + e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Cannot create TypeCode for class: " + clz + "\nReason: exception in type() method\n " + e.getTargetException());
            }
        }
        if (clz == Serializable.class || clz == Externalizable.class || clz == Object.class) {
            return (TypeCode)TypeCode.get_primitive_tc(11);
        }
        if (TypeCode.isMappedToAnAbstractInterface(clz)) {
            TypeCode newTypeCode = new TypeCode(32, RepositoryID.repId(clz), clz.getName());
            return newTypeCode;
        }
        Class superClass = clz.getSuperclass();
        TypeCode superTypeCode = null;
        if (superClass != null && superClass != Object.class) {
            superTypeCode = TypeCode.create_tc(superClass, knownTypes);
        }
        TypeCode newTypeCode = new TypeCode(RepositoryID.repId(clz), clz.getName(), 0, superTypeCode, new ValueMember[0]);
        knownTypes.put(clz, newTypeCode);
        newTypeCode.setValueMembers(TypeCode.getValueMembers(clz, knownTypes));
        knownTypes.remove(clz);
        return newTypeCode;
    }

    private static boolean isMappedToAnAbstractInterface(Class clz) {
        if (!clz.isInterface()) {
            return false;
        }
        Method[] methods = clz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Class jRemoteEx;
            Class<?>[] exceps = methods[i].getExceptionTypes();
            try {
                jRemoteEx = Environment.classForName("java.rmi.RemoteException");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            for (j = 0; j < exceps.length && !exceps[j].isAssignableFrom(jRemoteEx); ++j) {
            }
            if (j != exceps.length) continue;
            return false;
        }
        return true;
    }

    private static ValueMember[] getValueMembers(Class clz, Map knownTypes) {
        ArrayList<ValueMember> result = new ArrayList<ValueMember>();
        Field[] fields = clz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 0x98) != 0) continue;
            result.add(TypeCode.createValueMember(fields[i], knownTypes));
        }
        return result.toArray(new ValueMember[0]);
    }

    private static ValueMember createValueMember(Field f, Map knownTypes) {
        Class<?> type = f.getType();
        String id = RepositoryID.repId(type);
        TypeCode tc = TypeCode.create_tc(type, knownTypes);
        short access = (f.getModifiers() & 1) != 0 ? (short)1 : 0;
        return new ValueMember(f.getName(), id, "", "1.0", tc, null, access);
    }

    private void resolveRecursion() {
        if (this.kind == 15 || this.kind == 16) {
            this.resolveRecursion(this);
        }
    }

    private void resolveRecursion(TypeCode actual) {
        if (this.member_type == null) {
            return;
        }
        block4: for (int i = 0; i < this.member_type.length; ++i) {
            org.omg.CORBA.TypeCode typeCode = TypeCode.originalType(this.member_type[i]);
            if (!(typeCode instanceof TypeCode)) continue;
            TypeCode tc = (TypeCode)typeCode;
            switch (tc.kind) {
                case 15: 
                case 16: {
                    tc.resolveRecursion(actual);
                    continue block4;
                }
                case 19: {
                    typeCode = TypeCode.originalType(tc.content_type);
                    if (!(typeCode instanceof TypeCode)) continue block4;
                    tc = (TypeCode)typeCode;
                    if (tc.is_recursive() && tc.id.equals(actual.id)) {
                        tc.setActualTC(actual);
                        continue block4;
                    }
                    tc.resolveRecursion(actual);
                }
            }
        }
    }

    private void setActualTC(TypeCode tc) {
        if (this.is_recursive()) {
            this.actualTypecode = tc;
        }
    }

    private void checkActualTC() {
        if (this.is_recursive() && this.actualTypecode == null) {
            throw new BAD_INV_ORDER();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof org.omg.CORBA.TypeCode)) {
            return false;
        }
        return this.equal((org.omg.CORBA.TypeCode)obj);
    }

    public int hashCode() {
        int result = this.id == null ? super.hashCode() : this.id.hashCode();
        return result;
    }

    static {
        int i;
        primitive_tcs = new TypeCode[34];
        primitive_tcs_map = new HashMap();
        for (i = 0; i <= 13; ++i) {
            TypeCode.primitive_tcs[i] = new TypeCode(i);
        }
        for (i = 23; i <= 26; ++i) {
            TypeCode.primitive_tcs[i] = new TypeCode(i);
        }
        TypeCode.primitive_tcs[18] = new TypeCode(18, 0);
        TypeCode.primitive_tcs[27] = new TypeCode(27, 0);
        TypeCode.primitive_tcs[28] = new TypeCode(1, 0);
        TypeCode.primitive_tcs[14] = new TypeCode(14, "IDL:omg.org/CORBA/Object:1.0", "Object");
        TypeCode.primitive_tcs[29] = new TypeCode("IDL:omg.org/CORBA/portable/ValueBase:1.0", "ValueBase", 0, null, new ValueMember[0]);
        TypeCode.put_primitive_tcs(Boolean.TYPE, 8);
        TypeCode.put_primitive_tcs(Character.TYPE, 26);
        TypeCode.put_primitive_tcs(Byte.TYPE, 10);
        TypeCode.put_primitive_tcs(Short.TYPE, 2);
        TypeCode.put_primitive_tcs(Integer.TYPE, 3);
        TypeCode.put_primitive_tcs(Long.TYPE, 23);
        TypeCode.put_primitive_tcs(Float.TYPE, 6);
        TypeCode.put_primitive_tcs(Double.TYPE, 7);
    }
}

