/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.util.Debug;
import org.omg.CORBA.TIMEOUT;

public abstract class AbstractSocketFactory
implements SocketFactory {
    public static final boolean isJDK14 = System.getProperty("java.version").indexOf("1.4") >= 0;
    protected final Logger logger = Debug.getNamedLogger("jacorb.orb.iiop");

    @Override
    public Socket createSocket(final String host, final int port, int timeout) throws IOException, UnknownHostException {
        final Socket[] socket = new Socket[1];
        final IOException[] exception = new IOException[1];
        Thread connectThread = new Thread("SocketConnectorThread"){

            @Override
            public void run() {
                try {
                    socket[0] = AbstractSocketFactory.this.createSocket(host, port);
                }
                catch (IOException e) {
                    exception[0] = e;
                }
            }
        };
        connectThread.start();
        try {
            connectThread.join(timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        String connection_info = host + ":" + port;
        if (exception[0] != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect to " + connection_info + " with timeout=" + timeout + " raised exception: " + exception[0].toString());
            }
            throw exception[0];
        }
        if (socket[0] == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect to " + connection_info + " with timeout=" + timeout + " timed out");
            }
            connectThread.interrupt();
            throw new TIMEOUT("connection timeout of " + timeout + " milliseconds expired");
        }
        return socket[0];
    }
}

