/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.factory.DefaultServerSocketFactory;
import org.jacorb.orb.factory.DefaultSocketFactory;
import org.jacorb.orb.factory.PortRangeSocketFactory;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class SocketFactoryManager {
    private static final String FACTORY_PROP = "jacorb.net.socket_factory";
    private static final String SERVER_FACTORY_PROP = "jacorb.net.server_socket_factory";
    private static final String TCP_LISTENER = "jacorb.net.tcp_listener";
    private static final String SSL_LISTENER = "jacorb.security.ssl.ssl_listener";
    private static SocketFactory socketFactory;
    private static SocketFactory sslSocketFactory;
    private static ServerSocketFactory serverSocketFactory;
    private static SSLServerSocketFactory sslServerSocketFactory;
    private static Logger logger;
    private static TCPConnectionListener tcpListener;
    private static SSLSessionListener sslListener;
    private static ORB orb;

    private static String getSocketFactoryName(String optionalClass, Class defaultClass) {
        if (AbstractSocketFactory.isJDK14) {
            try {
                return Environment.classForName(optionalClass).getName();
            }
            catch (Exception e) {
                logger.warn("detected JDK 1.4+. However couldn't locate socket factory " + optionalClass + ". Will default to " + defaultClass.getName());
                return defaultClass.getName();
            }
        }
        return defaultClass.getName();
    }

    public static synchronized void initialiseSocketFactories(ORB _orb) {
        orb = _orb;
        String className = Environment.getProperty(FACTORY_PROP);
        if (className == null || className.length() == 0) {
            String portNo = Environment.getProperty("jacorb.net.socket_factory.port.min");
            className = portNo != null && portNo.length() > 0 ? SocketFactoryManager.getSocketFactoryName("org.jacorb.orb.factory.JDK14PortRangeSocketFactory", PortRangeSocketFactory.class) : SocketFactoryManager.getSocketFactoryName("org.jacorb.orb.factory.JDK14DefaultSocketFactory", DefaultSocketFactory.class);
        }
        logger.info("Using SocketFactory: " + className);
        socketFactory = SocketFactoryManager.getFactory(className);
        if (Environment.getSupportSSL()) {
            String s = Environment.getProperty("jacorb.ssl.socket_factory");
            if (s == null || s.length() == 0) {
                throw new INITIALIZE("SSL support is on, but the property \"jacorb.ssl.socket_factory\" is not set!");
            }
            try {
                Class ssl = Environment.classForName(s);
                Constructor constr = null;
                try {
                    constr = ssl.getConstructor(ORB.class);
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                if (constr == null) {
                    try {
                        constr = ssl.getConstructor(org.omg.CORBA.ORB.class);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
                sslSocketFactory = constr == null ? (SocketFactory)ssl.newInstance() : (SocketFactory)constr.newInstance(orb);
                if (logger.isDebugEnabled()) {
                    logger.debug("Created SSLSocketFactory instance from class " + s);
                }
            }
            catch (InvocationTargetException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL socket factory invocation failure", e.getTargetException());
                }
                e.getTargetException().printStackTrace();
                throw new INITIALIZE("SSL support is on, but there was an invocation failure with the ssl socket factory " + s + ": " + e.getTargetException());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (logger.isDebugEnabled()) {
                    logger.debug("SSL socket factory instantiation failure", e);
                }
                throw new INITIALIZE("SSL support is on, but the ssl socket factory can't be instantiated: " + e);
            }
        }
    }

    public static SocketFactory getSocketFactory() {
        if (socketFactory == null) {
            throw new INTERNAL("Socket factory is null");
        }
        return socketFactory;
    }

    public static SocketFactory getSSLSocketFactory() {
        if (sslSocketFactory == null) {
            throw new INTERNAL("SSL Socket factory is null");
        }
        return sslSocketFactory;
    }

    public static synchronized ServerSocketFactory getServerSocketFactory() {
        if (serverSocketFactory != null) {
            return serverSocketFactory;
        }
        String className = Environment.getProperty(SERVER_FACTORY_PROP);
        serverSocketFactory = className == null || className.length() == 0 ? new DefaultServerSocketFactory() : SocketFactoryManager.getServerFactory(className);
        return serverSocketFactory;
    }

    public static synchronized SSLServerSocketFactory getSSLServerSocketFactory() {
        if (sslServerSocketFactory == null && Environment.getSupportSSL()) {
            String className = Environment.getProperty("jacorb.ssl.server_socket_factory");
            if (className == null || className.length() == 0) {
                throw new INITIALIZE("SSL support is on, but the property \"jacorb.ssl.server_socket_factory\" is not set!");
            }
            Object factory = SocketFactoryManager.getFactoryObject(className);
            if (!(factory instanceof SSLServerSocketFactory)) {
                throw new INITIALIZE("Custom factory " + className + " does not implement SSLServerSocketFactory");
            }
            sslServerSocketFactory = (SSLServerSocketFactory)factory;
        }
        return sslServerSocketFactory;
    }

    public static TCPConnectionListener getTCPListener() {
        return tcpListener;
    }

    public static SSLSessionListener getSSLListener() {
        return sslListener;
    }

    private static SocketFactory getFactory(String className) {
        Object factory = SocketFactoryManager.getFactoryObject(className);
        if (factory instanceof SocketFactory) {
            return (SocketFactory)factory;
        }
        throw new INITIALIZE("Custom factory " + className + " does not implement SocketFactory");
    }

    private static ServerSocketFactory getServerFactory(String className) {
        Object factory = SocketFactoryManager.getFactoryObject(className);
        if (factory instanceof ServerSocketFactory) {
            return (ServerSocketFactory)factory;
        }
        throw new INITIALIZE("Custom factory " + className + " does not implement ServerSocketFactory");
    }

    private static Object getFactoryObject(String className) {
        Object factory;
        Constructor ctor = null;
        try {
            Class sfClass = Environment.classForName(className);
            if (orb != null) {
                try {
                    ctor = sfClass.getConstructor(ORB.class);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    ctor = sfClass.getConstructor(org.omg.CORBA.ORB.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            factory = ctor != null ? ctor.newInstance(orb) : sfClass.newInstance();
        }
        catch (InvocationTargetException e) {
            logger.error("Error in Constructor of Factory class: " + className, e.getTargetException());
            throw new INITIALIZE("Failed to create custom socket factory: " + className + ": " + e.getTargetException());
        }
        catch (Exception e) {
            logger.error("Failed to create custom socket factory: " + className, e);
            throw new INITIALIZE("Failed to create custom socket factory: " + className);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SocketFactoryManager: created " + factory.getClass().getName());
        }
        return factory;
    }

    static {
        logger = Debug.getNamedLogger("jacorb.orb.factory");
        tcpListener = (TCPConnectionListener)Environment.getObjectProperty(TCP_LISTENER);
        sslListener = (SSLSessionListener)Environment.getObjectProperty(SSL_LISTENER);
    }
}

