/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.ETF.Profile;
import org.omg.IOP.ServiceContext;

public class ClientConnection
implements ReplyListener,
ConnectionListener {
    private final GIOPConnection connection;
    private final ORB orb;
    private final HashMap replies;
    private final HashMap sasContexts;
    private static long last_client_context_id = 0L;
    private int client_count = 0;
    private int id_count = 0;
    private final ClientConnectionManager conn_mg;
    private boolean client_initiated = true;
    private final String info;
    private boolean gracefulStreamClose = false;
    private final Profile registeredProfile;
    private final Logger logger = Debug.getNamedLogger("jacorb.giop");

    public ClientConnection(GIOPConnection connection, ORB orb, ClientConnectionManager conn_mg, Profile registeredProfile, boolean client_initiated) {
        this.connection = connection;
        this.orb = orb;
        this.conn_mg = conn_mg;
        this.registeredProfile = registeredProfile;
        this.info = registeredProfile.toString();
        this.client_initiated = client_initiated;
        if (!client_initiated) {
            this.id_count = 1;
        }
        connection.setReplyListener(this);
        connection.setConnectionListener(this);
        this.replies = new HashMap();
        this.sasContexts = new HashMap();
    }

    public final GIOPConnection getGIOPConnection() {
        return this.connection;
    }

    public Profile getRegisteredProfile() {
        return this.registeredProfile;
    }

    public ServiceContext setCodeSet(ParsedIOR pior) {
        if (this.isTCSNegotiated()) {
            return null;
        }
        if (pior.getEffectiveProfile().version().minor == 0) {
            this.connection.markTCSNegotiated();
            return null;
        }
        CodeSetComponentInfo info = pior.getCodeSetComponentInfo();
        if (info == null || Environment.getIgnoreComponentInfo()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No CodeSetComponentInfo in IOR. Will use default CodeSets");
            }
            this.connection.markTCSNegotiated();
            return null;
        }
        int tcs = CodeSet.selectTCS(info);
        int tcsw = CodeSet.selectTCSW(info);
        if (tcs == -1 || tcsw == -1) {
            if (Debug.isDebugEnabled()) {
                CodeSetComponent original = info.ForCharData;
                Debug.output("Attempted to negotiate with target codeset " + CodeSet.csName(original.native_code_set) + " to match with " + CodeSet.csName(CodeSet.getTCSDefault()));
                Debug.output("Target has " + (original.conversion_code_sets == null ? 0 : original.conversion_code_sets.length) + " conversion codesets and native has " + CodeSet.csName(CodeSet.getConversionDefault()));
                Debug.output("Was negotiating with IOR " + pior.getIORString());
            }
            throw new CODESET_INCOMPATIBLE("WARNING: CodeSet negotiation failed! No matching " + (tcs == -1 ? "normal" : "wide") + " CodeSet found");
        }
        this.connection.setCodeSets(tcs, tcsw);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully negotiated Codesets. Using " + CodeSet.csName(tcs) + " as TCS and " + CodeSet.csName(tcsw) + " as TCSW");
        }
        CDROutputStream os = new CDROutputStream(this.orb);
        os.beginEncapsulatedArray();
        CodeSetContextHelper.write(os, new CodeSetContext(tcs, tcsw));
        byte[] result = os.getBufferCopy();
        os.close();
        return new ServiceContext(1, result);
    }

    public boolean isTCSNegotiated() {
        return this.connection.isTCSNegotiated();
    }

    public int getTCS() {
        return this.connection.getTCS();
    }

    public int getTCSW() {
        return this.connection.getTCSW();
    }

    public String getInfo() {
        return this.info;
    }

    public synchronized int getId() {
        int id = this.id_count;
        this.id_count += 2;
        return id;
    }

    public synchronized void incClients() {
        ++this.client_count;
    }

    public synchronized boolean decClients() {
        boolean result = false;
        --this.client_count;
        if (this.client_count == 0) {
            result = true;
        }
        return result;
    }

    public boolean isClientInitiated() {
        return this.client_initiated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(MessageOutputStream os, ReplyPlaceholder placeholder, int request_id, boolean response_expected) {
        Integer key = new Integer(request_id);
        HashMap hashMap = this.replies;
        synchronized (hashMap) {
            this.replies.put(key, placeholder);
        }
        try {
            this.sendRequest(os, response_expected);
        }
        catch (SystemException e) {
            HashMap hashMap2 = this.replies;
            synchronized (hashMap2) {
                this.replies.remove(key);
            }
            throw e;
        }
    }

    public void sendRequest(MessageOutputStream os, boolean response_expected) {
        try {
            this.connection.sendRequest(os, response_expected);
        }
        catch (IOException e) {
            Debug.output(2, e);
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void close() {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyReceived(byte[] reply, GIOPConnection connection) {
        connection.decPendingMessages();
        Integer key = new Integer(Messages.getRequestId(reply));
        ReplyPlaceholder placeholder = null;
        HashMap hashMap = this.replies;
        synchronized (hashMap) {
            placeholder = (ReplyPlaceholder)this.replies.remove(key);
        }
        if (placeholder != null) {
            ReplyInputStream ris = new ReplyInputStream(this.orb, reply);
            ris.setCodeSet(this.getTCS(), this.getTCSW());
            placeholder.replyReceived(ris);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received an unknown reply");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locateReplyReceived(byte[] reply, GIOPConnection connection) {
        connection.decPendingMessages();
        Integer key = new Integer(Messages.getRequestId(reply));
        ReplyPlaceholder placeholder = null;
        HashMap hashMap = this.replies;
        synchronized (hashMap) {
            placeholder = (ReplyPlaceholder)this.replies.remove(key);
        }
        if (placeholder != null) {
            placeholder.replyReceived(new LocateReplyInputStream(this.orb, reply));
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received an unknown reply");
        }
    }

    @Override
    public void closeConnectionReceived(byte[] close_conn, GIOPConnection connection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Received CloseConnection message");
        }
        if (this.client_initiated) {
            this.gracefulStreamClose = true;
            ((ClientGIOPConnection)connection).closeAllowReopen();
            this.streamClosed();
        }
    }

    @Override
    public void connectionClosed() {
        if (!this.client_initiated) {
            this.conn_mg.removeConnection(this);
        }
        this.streamClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamClosed() {
        HashMap hashMap = this.replies;
        synchronized (hashMap) {
            if (this.replies.size() > 0) {
                if (this.gracefulStreamClose) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Stream closed. Will remarshal " + this.replies.size() + " messages");
                    }
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Abnormal connection termination. Lost " + this.replies.size() + " outstanding replie(s)!");
                }
                Iterator entries = this.replies.values().iterator();
                while (entries.hasNext()) {
                    ReplyPlaceholder placeholder = (ReplyPlaceholder)entries.next();
                    if (this.gracefulStreamClose) {
                        placeholder.retry();
                    } else {
                        placeholder.cancel();
                    }
                    entries.remove();
                }
            }
        }
        this.gracefulStreamClose = false;
    }

    public Profile get_server_profile() {
        return this.connection.getTransport().get_server_profile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheSASContext(byte[] client_authentication_token) {
        long client_context_id = 0L;
        String key = new String(client_authentication_token);
        HashMap hashMap = this.sasContexts;
        synchronized (hashMap) {
            if (!this.sasContexts.containsKey(key)) {
                client_context_id = ++last_client_context_id;
                this.sasContexts.put(key, new Long(client_context_id));
                client_context_id = -client_context_id;
            } else {
                client_context_id = (Long)this.sasContexts.get(key);
            }
        }
        return client_context_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long purgeSASContext(long client_context_id) {
        HashMap hashMap = this.sasContexts;
        synchronized (hashMap) {
            Iterator entries = this.sasContexts.keySet().iterator();
            while (entries.hasNext()) {
                Object key = entries.next();
                if ((Long)this.sasContexts.get(key) != client_context_id) continue;
                entries.remove();
                break;
            }
        }
        return client_context_id;
    }
}

