/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirClientRequestListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;

public class ClientConnectionManager {
    private final ORB orb;
    private final Map connections = new HashMap();
    private RequestListener request_listener = null;
    private final MessageReceptorPool receptor_pool;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private final Logger logger = Debug.getNamedLogger("jacorb.giop");

    public ClientConnectionManager(ORB orb, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) {
        this.orb = orb;
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
        this.request_listener = new NoBiDirClientRequestListener();
        int maxIdleThreads = Environment.getIntPropertyWithDefault("jacorb.connection.client.max_idle_receptor_threads", 5);
        int maxThreads = Environment.getIntPropertyWithDefault("jacorb.connection.client.max_receptor_threads", 1000);
        this.receptor_pool = new MessageReceptorPool("ClientMessageReceptor", maxThreads, maxIdleThreads);
    }

    public void setRequestListener(RequestListener listener) {
        this.request_listener = listener;
    }

    public synchronized ClientConnection getConnection(Profile profile) {
        ClientConnection c = (ClientConnection)this.connections.get(profile);
        if (c == null) {
            int tag = profile.tag();
            Factories factories = this.transport_manager.getFactories(tag);
            if (factories == null) {
                throw new RuntimeException("No transport plugin for profile tag " + tag);
            }
            GIOPConnection connection = this.giop_connection_manager.createClientGIOPConnection(profile, factories.create_connection(null), this.request_listener, null);
            c = new ClientConnection(connection, this.orb, this, profile, true);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ClientConnectionManager: created new conn to target " + c.getInfo());
            }
            this.receptor_pool.connectionCreated(connection);
            this.connections.put(profile, c);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("ClientConnectionManager: found conn to target " + c.getInfo());
        }
        c.incClients();
        return c;
    }

    public synchronized void releaseConnection(ClientConnection c) {
        if (c.decClients()) {
            c.close();
            this.connections.remove(c.getRegisteredProfile());
        }
    }

    public synchronized void removeConnection(ClientConnection c) {
        this.connections.remove(c.getRegisteredProfile());
    }

    public synchronized void addConnection(GIOPConnection connection) {
        this.addConnection(connection, connection.getTransport().get_server_profile());
    }

    public synchronized void addConnection(GIOPConnection connection, Profile profile) {
        if (!this.connections.containsKey(profile)) {
            ClientConnection c = new ClientConnection(connection, this.orb, this, profile, false);
            c.incClients();
            this.connections.put(profile, c);
        }
    }

    public void shutdown() {
        Iterator i = new HashSet(this.connections.values()).iterator();
        while (i.hasNext()) {
            ((ClientConnection)i.next()).close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ClientConnectionManager shut down (all connections released)");
        }
        this.connections.clear();
        this.receptor_pool.shutdown();
    }
}

