/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.ProfileBase;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class MultipleComponentProfile
extends ProfileBase
implements Cloneable {
    public MultipleComponentProfile() {
        this.version = new Version(1, 2);
    }

    public MultipleComponentProfile(byte[] data) {
        this.version = new Version(1, 2);
        this.components = new TaggedComponentList(data);
    }

    public MultipleComponentProfile(TaggedComponent[] multipleComponents) {
        this.version = new Version(1, 2);
        this.components = new TaggedComponentList();
        for (int i = 0; i < multipleComponents.length; ++i) {
            this.components.addComponent(multipleComponents[i]);
        }
    }

    public MultipleComponentProfile(TaggedComponentList components) {
        this.version = new Version(1, 2);
        this.components = components;
    }

    @Override
    public void marshal(TaggedProfileHolder tagged_profile, TaggedComponentSeqHolder components) {
        int i;
        CDROutputStream profileDataStream = new CDROutputStream();
        profileDataStream.beginEncapsulatedArray();
        profileDataStream.write_long(this.components.size() + components.value.length);
        for (i = 0; i < this.components.asArray().length; ++i) {
            TaggedComponentHelper.write(profileDataStream, this.components.asArray()[i]);
        }
        for (i = 0; i < components.value.length; ++i) {
            TaggedComponentHelper.write(profileDataStream, components.value[i]);
        }
        tagged_profile.value = new TaggedProfile(this.tag(), profileDataStream.getBufferCopy());
        profileDataStream.close();
    }

    @Override
    public Profile copy() {
        try {
            return (Profile)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("error cloning profile: " + e);
        }
    }

    @Override
    public boolean is_match(Profile prof) {
        return false;
    }

    @Override
    public int tag() {
        return 1;
    }

    @Override
    public byte[] getAddressProfile() {
        CDROutputStream addressProfileStream = new CDROutputStream();
        addressProfileStream.beginEncapsulatedArray();
        addressProfileStream.write_long(this.components.size());
        for (int i = 0; i < this.components.asArray().length; ++i) {
            TaggedComponentHelper.write(addressProfileStream, this.components.asArray()[i]);
        }
        return addressProfileStream.getBufferCopy();
    }

    @Override
    public short encapsulation() {
        return 2;
    }
}

