/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.RemarshalException;

public abstract class ReplyPlaceholder {
    protected final Object lock = new Object();
    private boolean ready = false;
    protected boolean communicationException = false;
    protected boolean remarshalException = false;
    private boolean timeoutException = false;
    protected MessageInputStream in = null;
    protected final int timeout = Environment.clientPendingReplyTimeout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replyReceived(MessageInputStream in) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isTimeoutException()) {
                this.in = in;
                this.setReady(true);
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                this.communicationException = true;
                this.setReady(true);
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void retry() {
        Object object = this.lock;
        synchronized (object) {
            this.remarshalException = true;
            this.setReady(true);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInputStream getInputStream(boolean hasTimeoutPolicy) throws RemarshalException {
        boolean _shouldUseTimeout = !hasTimeoutPolicy && this.timeout > 0;
        long _maxWait = _shouldUseTimeout ? System.currentTimeMillis() + (long)this.timeout : Long.MAX_VALUE;
        long _timeout = _shouldUseTimeout ? (long)this.timeout : 0L;
        Object object = this.lock;
        synchronized (object) {
            try {
                while (!this.ready && System.currentTimeMillis() < _maxWait) {
                    this.lock.wait(_timeout);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!this.ready && _shouldUseTimeout) {
                this.timeoutException = true;
            }
            if (this.remarshalException) {
                throw new RemarshalException();
            }
            if (this.communicationException) {
                throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.isTimeoutException()) {
                throw new TIMEOUT("client timeout reached");
            }
            return this.in;
        }
    }

    protected void setTimeoutException(boolean timeoutException) {
        this.timeoutException = timeoutException;
    }

    protected boolean isTimeoutException() {
        return this.timeoutException;
    }

    protected void setReady(boolean ready) {
        this.ready = ready;
    }

    protected boolean isReady() {
        return this.ready;
    }
}

