/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ServerGIOPConnection
extends GIOPConnection {
    private static final byte[] CLOSE_CONNECTION_MESSAGE = new byte[]{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0};
    private final GIOPConnectionManager manager;
    private boolean closeOnReadTimeout = false;
    private final boolean delayClose;
    private final Set indices = new HashSet();
    public ConcurrentLinkedQueue outstandingRequests;

    public ServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider, GIOPConnectionManager manager) {
        super(profile, transport, request_listener, reply_listener, statistics_provider);
        this.manager = manager;
        this.delayClose = Environment.isPropertyOn("jacorb.connection.delay_close");
        if (Environment.isPropertyOn("jacorb.poa.checkRequestIDs")) {
            this.outstandingRequests = new ConcurrentLinkedQueue();
        }
    }

    boolean tryClose() {
        if (this.tryDiscard()) {
            this.sendCloseConnection();
            this.closeOnReadTimeout = true;
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDiscard() {
        if (!this.hasPendingMessages()) {
            byte[] byArray = this.pendingUndecidedSync;
            synchronized (this.pendingUndecidedSync) {
                this.discard_messages = true;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseConnection() {
        try {
            this.getWriteLock();
            this.write(CLOSE_CONNECTION_MESSAGE, 0, CLOSE_CONNECTION_MESSAGE.length);
            this.transport.flush();
            if (this.statistics_provider != null) {
                this.statistics_provider.flushed();
            }
            if (this.delayClose && this.transport instanceof IIOPConnection) {
                ((IIOPConnection)this.transport).turnOnFinalTimeout();
            } else {
                this.do_close = true;
                this.transport.close();
            }
        }
        catch (COMM_FAILURE e) {
            Debug.output(1, e);
        }
        finally {
            this.releaseWriteLock();
        }
        this.closeCleanup();
    }

    @Override
    protected void readTimedOut() {
        if (this.closeOnReadTimeout) {
            this.close();
        } else {
            this.tryClose();
        }
    }

    @Override
    protected void streamClosed() {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        this.closeCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCleanup() {
        ServerGIOPConnection serverGIOPConnection = this;
        synchronized (serverGIOPConnection) {
            Object[] contents = this.indices.toArray();
            for (int i = 0; i < contents.length; ++i) {
                this.manager.removeContextKey(this, (Integer)contents[i]);
            }
            this.indices.clear();
        }
        if (this.manager != null) {
            this.manager.unregisterServerGIOPConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] addContextKey(GIOPConnection gc, byte[] object_key, byte[] oid, List scopes) {
        byte[] result = this.manager.addContextKey(gc, object_key, oid, scopes);
        Integer index = new Integer(((result[3] & 0xFF) << 24) + ((result[4] & 0xFF) << 16) + ((result[5] & 0xFF) << 8) + ((result[6] & 0xFF) << 0));
        ServerGIOPConnection serverGIOPConnection = this;
        synchronized (serverGIOPConnection) {
            this.indices.add(index);
        }
        return result;
    }

    @Override
    public GIOPConnectionManager.ContextKey getContextKey(GIOPConnection gc, byte[] key) {
        return this.manager.getContextKey(gc, key);
    }

    @Override
    public void addOutstandingRequest(int requestId) {
        this.outstandingRequests.add(requestId);
    }

    public int peekOutStandingRequest() {
        Object result = this.outstandingRequests.peek();
        return result == null ? -1 : (Integer)result;
    }

    public void popOutstandingRequest() {
        this.outstandingRequests.remove();
    }
}

