/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.omg.ETF.Profile;

public class ServerIIOPConnection
extends IIOPConnection {
    private final boolean is_ssl;
    private final IIOPProfile profile;

    public ServerIIOPConnection(Socket socket, boolean is_ssl) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.is_ssl = is_ssl;
        this.in_stream = socket.getInputStream();
        this.out_stream = new BufferedOutputStream(socket.getOutputStream());
        IIOPAddress address = new IIOPAddress(socket.getInetAddress().getHostAddress(), socket.getPort());
        this.profile = new IIOPProfile(address, null);
        this.connection_info = address.toString();
        this.connected = true;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Opened new server-side TCP/IP transport to " + this.connection_info);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.socket.getClass().isAssignableFrom(Socket.class)) {
                    try {
                        this.socket.shutdownOutput();
                    }
                    catch (SocketException e) {
                        // empty catch block
                    }
                }
                this.socket.close();
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
            }
            catch (IOException ex) {
                throw this.to_COMM_FAILURE(ex);
            }
            finally {
                if (SocketFactoryManager.getTCPListener() != null) {
                    String localhost;
                    try {
                        this.socket.getInetAddress();
                        localhost = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException uhe) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
                        }
                        localhost = "127.0.0.1";
                    }
                    SocketFactoryManager.getTCPListener().connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), this.socket.getLocalPort(), localhost));
                }
            }
            this.socket = null;
            this.connected = false;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Closed server-side transport to " + this.connection_info);
            }
        }
    }

    @Override
    public void connect(Profile server_profile, long time_out) {
    }

    @Override
    public boolean isSSL() {
        return this.is_ssl;
    }

    @Override
    public Profile get_server_profile() {
        return this.profile;
    }
}

