/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.listener;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.listener.SSLSessionEvent;
import org.jacorb.util.Debug;

public class SSLHandshakeListener
implements HandshakeCompletedListener {
    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        X509Certificate[] certs = null;
        String localhost = null;
        try {
            certs = event.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (Debug.isDebugEnabled()) {
                Debug.output("handshakeCompleted - SSLPeerUnverifiedException");
            }
            certs = new X509Certificate[]{};
        }
        try {
            event.getSocket().getInetAddress();
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (Debug.isDebugEnabled()) {
                Debug.output("Unable to resolve local IP address - using default");
            }
            localhost = "127.0.0.1";
        }
        SocketFactoryManager.getSSLListener().sessionCreated(new SSLSessionEvent(event.getSource(), event.getSocket().getInetAddress().getHostAddress(), event.getSocket().getPort(), certs, event.getSocket().getLocalPort(), localhost, null));
    }
}

