/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.typecode;

import java.util.Arrays;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.typecode.TypeCodeCache;
import org.jacorb.util.Debug;

public abstract class AbstractTypeCodeCache
implements TypeCodeCache {
    protected final Map cache = this.newCache();
    private final Logger logger = Debug.getNamedLogger("jacorb.orb.cdr");

    protected abstract Map newCache();

    @Override
    public void cacheTypeCode(String repositoryID, TypeCodeCache.Pair[] entries) {
        TypeCodeCache.Pair[] copy = this.copy(entries);
        this.put(repositoryID, copy);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("put into cache: " + repositoryID + " => " + Arrays.asList(copy));
        }
    }

    protected abstract void put(String var1, TypeCodeCache.Pair[] var2);

    @Override
    public TypeCodeCache.Pair[] getCachedTypeCodes(String repositoryID) {
        TypeCodeCache.Pair[] fromCache = (TypeCodeCache.Pair[])this.cache.get(repositoryID);
        if (fromCache == null) {
            return null;
        }
        TypeCodeCache.Pair[] copy = this.copy(fromCache);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("cache hit: " + repositoryID + " => " + Arrays.asList(copy));
        }
        return copy;
    }

    private TypeCodeCache.Pair[] copy(TypeCodeCache.Pair[] fromCache) {
        TypeCodeCache.Pair[] copy = new TypeCodeCache.Pair[fromCache.length];
        for (int i = 0; i < fromCache.length; ++i) {
            copy[i] = fromCache[i];
        }
        return copy;
    }
}

