/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;

public class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private Current current;
    private Vector pool;
    private int unused_size;
    private int max_pool_size;
    private int min_pool_size;
    private boolean inUse = false;

    protected RPPoolManager(Current _current, int min, int max) {
        this.current = _current;
        this.max_pool_size = max;
        this.min_pool_size = min;
    }

    private void addProcessor() {
        RequestProcessor rp = new RequestProcessor(this);
        this.current._addContext(rp, rp);
        rp.setDaemon(true);
        this.pool.addElement(rp);
        ++this.unused_size;
        rp.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.add(this.pmListener, listener);
    }

    protected synchronized void destroy() {
        if (this.pool == null || !this.inUse) {
            return;
        }
        Object[] rps = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(rps);
        for (int i = 0; i < rps.length; ++i) {
            if (((RequestProcessor)rps[i]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(rps[i]);
            --this.unused_size;
            this.current._removeContext((Thread)rps[i]);
            ((RequestProcessor)rps[i]).end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.unused_size;
    }

    protected synchronized RequestProcessor getProcessor(boolean noblock) {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.size() == 0 && this.unused_size < this.max_pool_size || noblock) {
            this.addProcessor();
        }
        while (this.pool.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        RequestProcessor rp = (RequestProcessor)this.pool.remove(this.pool.size() - 1);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(rp, this.pool.size(), this.unused_size);
        }
        return rp;
    }

    private void init() {
        this.pool = new Vector(this.max_pool_size);
        for (int i = 0; i < this.min_pool_size; ++i) {
            this.addProcessor();
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor rp) {
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(rp);
            this.notifyAll();
        } else {
            --this.unused_size;
            this.current._removeContext(rp);
            rp.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(rp, this.pool.size(), this.unused_size);
        }
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, listener);
    }
}

