/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Hashtable;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.ATLAS.ATLASProfile;
import org.omg.ATLAS.ATLASProfileHelper;
import org.omg.ATLAS.AuthTokenData;
import org.omg.ATLAS.AuthTokenDispenser;
import org.omg.ATLAS.AuthTokenDispenserHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;

public class SASClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    protected static final int SecurityAttributeService = 15;
    protected final String DEFAULT_NAME = "SASClientInterceptor";
    protected Codec codec = null;
    protected String name = "SASClientInterceptor";
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS.CSS");
    protected byte[] contextToken = new byte[0];
    protected boolean useStateful = true;
    protected Hashtable atlasCache = new Hashtable();
    protected ISASContext sasContext = null;

    public SASClientInterceptor(ORBInitInfo info) throws UnknownEncoding {
        Encoding encoding = new Encoding(0, 1, 0);
        this.codec = info.codec_factory().create_codec(encoding);
        this.useStateful = Boolean.valueOf(Environment.getProperty("jacorb.security.sas.stateful", "true"));
        String contextClass = Environment.getProperty("jacorb.security.sas.contextClass");
        if (contextClass != null) {
            try {
                Class c = Environment.classForName(contextClass);
                this.sasContext = (ISASContext)c.newInstance();
            }
            catch (Exception e) {
                logger.error("Could not instantiate class " + contextClass + ": " + e);
            }
        }
        if (this.sasContext == null) {
            logger.error("Could not load SAS context class: " + contextClass);
        } else {
            this.sasContext.initClient();
        }
    }

    public void setContextToken(byte[] contextToken) {
        this.contextToken = contextToken;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (ri.operation().equals("_is_a")) {
            return;
        }
        if (ri.operation().equals("_non_existent")) {
            return;
        }
        ORB orb = ((ClientRequestInfoImpl)ri).orb;
        CompoundSecMechList csmList = null;
        try {
            TaggedComponent tc = ri.get_effective_component(33);
            CDRInputStream is = new CDRInputStream(null, tc.component_data);
            is.openEncapsulatedArray();
            csmList = CompoundSecMechListHelper.read(is);
        }
        catch (BAD_PARAM e) {
            logger.debug("Did not find tagged component TAG_CSI_SEC_MECH_LIST: " + ri.operation());
        }
        catch (Exception e) {
            logger.warn("Did not find tagged component TAG_CSI_SEC_MECH_LIST: " + e);
        }
        if (csmList == null) {
            return;
        }
        if (csmList.mechanism_list[0].as_context_mech.target_supports == 0 && csmList.mechanism_list[0].as_context_mech.target_requires == 0 && csmList.mechanism_list[0].sas_context_mech.target_supports == 0 && csmList.mechanism_list[0].sas_context_mech.target_requires == 0) {
            return;
        }
        ClientConnection connection = ((ClientRequestInfoImpl)ri).connection;
        long client_context_id = 0L;
        if (this.useStateful) {
            client_context_id = connection.cacheSASContext("css".getBytes());
        }
        if (client_context_id < 0L) {
            logger.info("New SAS Context: " + -client_context_id);
        }
        AuthorizationElement[] authorizationList = this.getATLASTokens(orb, csmList);
        try {
            Any msg = null;
            if (client_context_id <= 0L) {
                IdentityToken identityToken = new IdentityToken();
                identityToken.absent(true);
                this.contextToken = this.sasContext.createClientContext(ri, csmList);
                msg = this.makeEstablishContext(orb, -client_context_id, authorizationList, identityToken, this.contextToken);
            } else {
                msg = this.makeMessageInContext(orb, client_context_id, false);
            }
            ri.add_request_service_context(new ServiceContext(15, this.codec.encode_value(msg)), true);
        }
        catch (Exception e) {
            logger.warn("Could not set security service context: " + e);
            throw new NO_PERMISSION("SAS Could not set security service context: " + e, 1245904897, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public void send_poll(ClientRequestInfo ri) {
    }

    @Override
    public void receive_reply(ClientRequestInfo ri) {
        IDLEntity reply;
        SASContextBody contextBody = null;
        ServiceContext ctx = null;
        try {
            ctx = ri.get_reply_service_context(15);
        }
        catch (BAD_PARAM e) {
            logger.debug("No SAS security context found: " + ri.operation());
        }
        catch (Exception e) {
            logger.warn("No SAS security context found: " + e);
        }
        if (ctx == null || ctx.context_data.length <= 1) {
            return;
        }
        try {
            Any msg = this.codec.decode_value(ctx.context_data, SASContextBodyHelper.type());
            contextBody = SASContextBodyHelper.extract(msg);
        }
        catch (Exception e) {
            logger.warn("Could not parse SAS reply: " + e);
            throw new NO_PERMISSION("SAS Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        ClientConnection connection = ((ClientRequestInfoImpl)ri).connection;
        if (contextBody.discriminator() == 1) {
            reply = contextBody.complete_msg();
            if (reply.client_context_id > 0L && !reply.context_stateful) {
                connection.purgeSASContext(reply.client_context_id);
            }
        }
        if (contextBody.discriminator() == 4) {
            reply = contextBody.error_msg();
            if (((ContextError)reply).client_context_id > 0L) {
                connection.purgeSASContext(((ContextError)reply).client_context_id);
            }
        }
    }

    @Override
    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        IDLEntity reply;
        SASContextBody contextBody = null;
        ServiceContext ctx = null;
        try {
            ctx = ri.get_reply_service_context(15);
        }
        catch (BAD_PARAM e) {
            logger.debug("No SAS security context found (exception): " + ri.operation());
        }
        catch (Exception e) {
            logger.warn("No SAS security context found (exception): " + e);
        }
        if (ctx == null) {
            return;
        }
        try {
            Any msg = this.codec.decode_value(ctx.context_data, SASContextBodyHelper.type());
            contextBody = SASContextBodyHelper.extract(msg);
        }
        catch (Exception e) {
            logger.warn("Could not parse SAS reply: " + e);
            throw new NO_PERMISSION("SAS Could not parse SAS reply: " + e, 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        ClientConnection connection = ((ClientRequestInfoImpl)ri).connection;
        if (contextBody.discriminator() == 1) {
            reply = contextBody.complete_msg();
            if (reply.client_context_id > 0L && !reply.context_stateful) {
                connection.purgeSASContext(reply.client_context_id);
            }
        }
        if (contextBody.discriminator() == 4) {
            reply = contextBody.error_msg();
            if (((ContextError)reply).client_context_id > 0L) {
                connection.purgeSASContext(((ContextError)reply).client_context_id);
            }
        }
    }

    @Override
    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    protected Any makeEstablishContext(org.omg.CORBA.ORB orb, long client_context_id, AuthorizationElement[] authorization_token, IdentityToken identity_token, byte[] client_authentication_token) {
        EstablishContext msg = new EstablishContext();
        msg.client_context_id = client_context_id;
        msg.client_authentication_token = client_authentication_token;
        msg.identity_token = identity_token;
        msg.authorization_token = authorization_token;
        SASContextBody contextBody = new SASContextBody();
        contextBody.establish_msg(msg);
        Any any = orb.create_any();
        SASContextBodyHelper.insert(any, contextBody);
        return any;
    }

    protected Any makeMessageInContext(org.omg.CORBA.ORB orb, long client_context_id, boolean discard_context) {
        MessageInContext msg = new MessageInContext();
        msg.client_context_id = client_context_id;
        msg.discard_context = discard_context;
        SASContextBody contextBody = new SASContextBody();
        contextBody.in_context_msg(msg);
        Any any = orb.create_any();
        SASContextBodyHelper.insert(any, contextBody);
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationElement[] getATLASTokens(org.omg.CORBA.ORB orb, CompoundSecMechList csmList) throws NO_PERMISSION {
        Serializable any;
        ATLASProfile atlasProfile = null;
        try {
            ServiceConfiguration[] authorities = csmList.mechanism_list[0].sas_context_mech.privilege_authorities;
            for (int i = 0; i < authorities.length; ++i) {
                if (authorities[i].syntax != 3) continue;
                any = this.codec.decode(authorities[i].name);
                atlasProfile = ATLASProfileHelper.extract((Any)any);
            }
        }
        catch (Exception e) {
            logger.warn("Error parsing ATLAS from IOR: " + e);
            throw new NO_PERMISSION("SAS Error parsing ATLAS from IOR: " + e, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        if (atlasProfile == null) {
            return new AuthorizationElement[0];
        }
        String cacheID = new String(atlasProfile.the_cache_id);
        String locator = atlasProfile.the_locator.the_url();
        if (locator != null) {
            locator = URLDecoder.decode(locator);
        }
        any = this.atlasCache;
        synchronized (any) {
            if (this.atlasCache.containsKey(cacheID)) {
                return ((AuthTokenData)this.atlasCache.get((java.lang.Object)cacheID)).auth_token;
            }
        }
        AuthTokenDispenser dispenser = null;
        try {
            Object obj = orb.string_to_object(locator);
            dispenser = AuthTokenDispenserHelper.narrow((Object)obj);
        }
        catch (Exception e) {
            logger.warn("Could not find ATLAS server " + locator + ": " + e);
            throw new NO_PERMISSION("SAS Could not find ATLAS server " + locator + ": " + e, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        if (dispenser == null) {
            logger.warn("SAS found null ATLAS server " + locator);
            throw new NO_PERMISSION("SAS found null ATLAS server " + locator, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        AuthTokenData data = null;
        try {
            data = dispenser.get_my_authorization_token();
        }
        catch (Exception e) {
            logger.warn("Error getting ATLAS tokens from server " + locator + ": " + e);
            throw new NO_PERMISSION("SAS Error getting ATLAS tokens from server: " + e, 1245904898, CompletionStatus.COMPLETED_NO);
        }
        Hashtable hashtable = this.atlasCache;
        synchronized (hashtable) {
            this.atlasCache.put(cacheID, data);
        }
        return data.auth_token;
    }
}

