/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.standardInterceptors.SASComponentInterceptor;
import org.jacorb.security.sas.ATLASPolicyFactory;
import org.jacorb.security.sas.SASClientInterceptor;
import org.jacorb.security.sas.SASPolicyFactory;
import org.jacorb.security.sas.SASTargetInterceptor;
import org.jacorb.util.Debug;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    private static Logger logger = Debug.getNamedLogger("jacorb.SAS");
    public static final int SecurityAttributeService = 15;
    public static int sasPrincipalNamePIC = -1;

    @Override
    public void post_init(ORBInitInfo info) {
        try {
            sasPrincipalNamePIC = info.allocate_slot_id();
            info.add_server_request_interceptor(new SASTargetInterceptor(info));
        }
        catch (DuplicateName duplicateName) {
            logger.error("TSS DuplicateName", duplicateName);
        }
        catch (UnknownEncoding unknownEncoding) {
            logger.error("TSS UnknownEncoding", unknownEncoding);
        }
        try {
            info.add_client_request_interceptor(new SASClientInterceptor(info));
        }
        catch (DuplicateName duplicateName) {
            logger.error("CSS DuplicateName", duplicateName);
        }
        catch (UnknownEncoding unknownEncoding) {
            logger.error("CSS UnknownEncoding", unknownEncoding);
        }
        try {
            info.add_ior_interceptor(new SASComponentInterceptor(info));
        }
        catch (DuplicateName duplicateName) {
            logger.error("IOR DuplicateName", duplicateName);
        }
        info.register_policy_factory(100, new SASPolicyFactory());
        info.register_policy_factory(101, new ATLASPolicyFactory());
    }

    @Override
    public void pre_init(ORBInitInfo info) {
    }
}

