/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;
import org.jacorb.util.Environment;

public class SSLServerSocketFactory
extends SSLRandom
implements org.jacorb.orb.factory.SSLServerSocketFactory {
    private ServerSocketFactory factory = this.createServerSocketFactory();
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    private boolean change_roles = false;
    private String[] cipher_suites = null;

    public SSLServerSocketFactory(ORB orb) throws Exception {
        StringTokenizer tokenizer;
        int tokens;
        if (this.factory == null && this.logger.isErrorEnabled()) {
            this.logger.error("Unable to create ServerSocketFactory!");
        }
        if ((Environment.getIntProperty("jacorb.security.ssl.server.supported_options", 16) & 0x40) != 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Will create SSL sockets that request client authentication");
            }
            this.request_mutual_auth = true;
        }
        if ((Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16) & 0x40) != 0) {
            this.require_mutual_auth = true;
            this.request_mutual_auth = false;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Will create SSL sockets that require client authentication");
            }
        }
        this.change_roles = Environment.isPropertyOn("jacorb.security.change_ssl_roles");
        String cipher_suite_list = Environment.getProperty("jacorb.security.ssl.server.cipher_suites");
        if (cipher_suite_list != null && (tokens = (tokenizer = new StringTokenizer(cipher_suite_list, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[tokens];
            while (tokenizer.hasMoreElements()) {
                this.cipher_suites[--tokens] = tokenizer.nextToken();
            }
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        return s;
    }

    @Override
    public boolean isSSL(ServerSocket s) {
        return s instanceof SSLServerSocket;
    }

    @Override
    public void switchToClientMode(Socket socket) {
        if (this.change_roles) {
            ((SSLSocket)socket).setUseClientMode(true);
        }
    }

    private ServerSocketFactory createServerSocketFactory() throws Exception {
        String keystore_passphrase;
        String keystore_location = Environment.getProperty("jacorb.security.keystore");
        if (keystore_location == null) {
            System.out.print("Please enter key store file name: ");
            keystore_location = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        if ((keystore_passphrase = Environment.getProperty("jacorb.security.keystore_password")) == null) {
            System.out.print("Please enter store passphrase: ");
            keystore_passphrase = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        KeyStore key_store = KeyStoreUtil.getKeyStore(keystore_location, keystore_passphrase.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(Environment.isJ9 ? "IbmX509" : "SunX509");
        kmf.init(key_store, keystore_passphrase.toCharArray());
        TrustManagerFactory tmf = null;
        if ((Environment.getIntProperty("jacorb.security.ssl.server.required_options", 16) & 0x40) != 0 || (Environment.getIntProperty("jacorb.security.ssl.server.supported_options", 16) & 0x40) != 0) {
            tmf = TrustManagerFactory.getInstance(Environment.isJ9 ? "IbmX509" : "SunX509");
            if (Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks")) {
                tmf.init(key_store);
            } else {
                tmf.init((KeyStore)null);
            }
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf.getKeyManagers(), tmf == null ? null : tmf.getTrustManagers(), this.getSecureRandom());
        return ctx.getServerSocketFactory();
    }
}

