/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.CORBA.ORB;

public class SSLSocketFactory
extends AbstractSocketFactory {
    private SocketFactory factory = null;
    private boolean change_roles = false;
    private String[] cipher_suites = null;
    private final SSLRandom sslRandom = new SSLRandom();
    private final Logger logger = Debug.getNamedLogger("jacorb.security.jsse");

    public SSLSocketFactory(ORB orb) throws Exception {
        StringTokenizer tokenizer;
        int tokens;
        this.factory = this.createSocketFactory();
        if (this.factory == null && this.logger.isErrorEnabled()) {
            this.logger.error("Unable to create SSLSocketFactory!");
        }
        this.change_roles = Environment.isPropertyOn("jacorb.security.change_ssl_roles");
        String cipher_suite_list = Environment.getProperty("jacorb.security.ssl.client.cipher_suites");
        if (cipher_suite_list != null && (tokens = (tokenizer = new StringTokenizer(cipher_suite_list, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[tokens];
            while (tokenizer.hasMoreElements()) {
                this.cipher_suites[--tokens] = tokenizer.nextToken();
            }
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket s = (SSLSocket)this.factory.createSocket(host, port);
        if (this.change_roles) {
            s.setUseClientMode(false);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (SocketFactoryManager.getSSLListener() != null) {
            s.addHandshakeCompletedListener(new SSLHandshakeListener());
        }
        return s;
    }

    @Override
    public boolean isSSL(Socket s) {
        return s instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws Exception {
        KeyManagerFactory kmf = null;
        KeyStore key_store = null;
        if (Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks") || (Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16) & 0x40) != 0) {
            String keystore_passphrase;
            String keystore_location = Environment.getProperty("jacorb.security.keystore");
            if (keystore_location == null) {
                System.out.print("Please enter key store file name: ");
                keystore_location = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            if ((keystore_passphrase = Environment.getProperty("jacorb.security.keystore_password")) == null) {
                System.out.print("Please enter store pass phrase: ");
                keystore_passphrase = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            key_store = KeyStoreUtil.getKeyStore(keystore_location, keystore_passphrase.toCharArray());
            if ((Environment.getIntProperty("jacorb.security.ssl.client.supported_options", 16) & 0x40) != 0) {
                kmf = KeyManagerFactory.getInstance(Environment.isJ9 ? "IbmX509" : "SunX509");
                kmf.init(key_store, keystore_passphrase.toCharArray());
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(Environment.isJ9 ? "IbmX509" : "SunX509");
        if (key_store != null && Environment.isPropertyOn("jacorb.security.jsse.trustees_from_ks")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading certs from keystore " + key_store);
            }
            tmf.init(key_store);
        } else {
            tmf.init((KeyStore)null);
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf == null ? null : kmf.getKeyManagers(), tmf.getTrustManagers(), this.sslRandom.getSecureRandom());
        return ctx.getSocketFactory();
    }
}

