/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Environment;

public final class Debug {
    private static final char[] lookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static Logger logger;

    public static final void initialize() {
        logger = Environment.getLogger();
    }

    public static boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    public static void output(String msg) {
        if (logger == null) {
            System.out.println(msg);
        } else {
            logger.debug(msg);
        }
    }

    public static final void output(int msg_level, String msg) {
        if (logger == null) {
            System.out.println(msg);
        } else {
            Debug.output(logger, msg_level, msg);
        }
    }

    public static synchronized void output(int msg_level, String name, byte[] bs) {
        Debug.output(msg_level, name, bs, 0, bs.length);
    }

    public static synchronized void output(String name, byte[] bs) {
        Debug.output(3, name, bs, 0, bs.length);
    }

    public static synchronized void output(int msg_level, String name, byte[] bs, int len) {
        Debug.output(msg_level, name, bs, 0, len);
    }

    public static synchronized void output(int msg_level, String name, byte[] bs, int start, int len) {
        if (logger != null && logger.isDebugEnabled()) {
            StringBuffer chars = new StringBuffer();
            StringBuffer hex = new StringBuffer();
            hex.append("Hexdump [" + name + "] len=" + len + "," + bs.length);
            for (int i = start; i < start + len; ++i) {
                if (i % 16 == 0) {
                    Debug.output(hex.append(chars).toString());
                    chars = new StringBuffer();
                    hex = new StringBuffer();
                }
                chars.append(Debug.toAscii(bs[i]));
                hex.append(Debug.toHex(bs[i]));
                if (i % 4 != 3) continue;
                chars.append(' ');
                hex.append(' ');
            }
            if (len % 16 != 0) {
                int pad = 0;
                int delta_bytes = 16 - len % 16;
                pad = delta_bytes * 3;
                pad += delta_bytes / 4;
                for (int i = 0; i < pad; ++i) {
                    chars.insert(0, ' ');
                }
            }
            Debug.output(hex.append(chars).toString());
        }
    }

    public static final String toHex(byte b) {
        StringBuffer sb = new StringBuffer();
        int upper = b >> 4 & 0xF;
        sb.append(lookup[upper]);
        int lower = b & 0xF;
        sb.append(lookup[lower]);
        sb.append(' ');
        return sb.toString();
    }

    public static final char toAscii(byte b) {
        if (b > 31 && b < 127) {
            return (char)b;
        }
        return '.';
    }

    private static final boolean isEnabled(Logger logger, int level) {
        return level == 0 && logger.isFatalErrorEnabled() || level == 1 && logger.isErrorEnabled() || level == 2 && logger.isWarnEnabled() || level == 3 && logger.isInfoEnabled() || level == 4 && logger.isDebugEnabled();
    }

    private static final void output(Logger logger, int level, String message) {
        switch (level) {
            case 0: {
                if (!logger.isFatalErrorEnabled()) break;
                logger.fatalError(message);
                break;
            }
            case 1: {
                if (!logger.isErrorEnabled()) break;
                logger.error(message);
                break;
            }
            case 2: {
                if (logger.isWarnEnabled()) {
                    logger.warn(message);
                }
            }
            case 3: {
                if (!logger.isInfoEnabled()) break;
                logger.info(message);
                break;
            }
            case 4: {
                if (!logger.isDebugEnabled()) break;
                logger.debug(message);
                break;
            }
            default: {
                logger.warn(message + "(logged at unknown log level " + level + ", defaults to WARN)");
            }
        }
    }

    public static final void output(Logger logger, int msg_level, Throwable e) {
        if (Debug.isEnabled(logger, msg_level)) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                PrintStream pos = new PrintStream(bos);
                e.printStackTrace(pos);
                bos.close();
                pos.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            Debug.output(logger, msg_level, bos.toString());
        }
    }

    public static final void output(int msg_level, Throwable e) {
        if (logger == null) {
            System.out.println("############################ StackTrace ############################");
            e.printStackTrace(System.out);
            System.out.println("####################################################################");
        } else {
            Debug.output(logger, msg_level, e);
        }
    }

    public static Logger getNamedLogger(String name) {
        return Environment.getLoggerFactory().getNamedLogger(name);
    }

    static {
        Debug.initialize();
    }
}

