/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.threadpool;

import java.util.LinkedList;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.util.Debug;
import org.jacorb.util.threadpool.ConsumerFactory;
import org.jacorb.util.threadpool.ConsumerTie;
import org.omg.CORBA.NO_RESOURCES;

public class ThreadPool {
    private int max_threads = 0;
    private int max_idle_threads = 0;
    private int total_threads = 0;
    private int idle_threads = 0;
    private LinkedList job_queue = null;
    private ConsumerFactory factory = null;
    private Logger logger = Debug.getNamedLogger("jacorb.util.tpool");
    private boolean shutdown = false;
    private String threadName = null;
    private int threadCount = 0;

    public ThreadPool(ConsumerFactory factory, String threadName) {
        this(new LinkedList(), factory, 10, 10, threadName);
    }

    public ThreadPool(ConsumerFactory factory, int max_threads, int max_idle_threads, String threadName) {
        this(new LinkedList(), factory, max_threads, max_idle_threads, threadName);
    }

    private ThreadPool(LinkedList job_queue, ConsumerFactory factory, int max_threads, int max_idle_threads, String threadName) {
        this.job_queue = job_queue;
        this.factory = factory;
        this.max_threads = max_threads;
        this.max_idle_threads = max_idle_threads;
        this.threadName = threadName + "-";
    }

    protected synchronized Object getJob() {
        if (this.idle_threads >= this.max_idle_threads) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] Telling thread to exit (too many idle)");
            }
            --this.total_threads;
            return null;
        }
        ++this.idle_threads;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] added idle thread");
        }
        while (!this.shutdown && this.job_queue.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] job queue empty");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                Debug.output(3, e);
            }
        }
        if (this.shutdown) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] removed idle thread (job scheduled)");
        }
        return this.job_queue.removeFirst();
    }

    public synchronized void putJob(Object job) {
        this.job_queue.add(job);
        this.notifyAll();
        if (this.idle_threads <= 0) {
            if (this.total_threads < this.max_threads) {
                this.createNewThread();
            } else {
                this.job_queue.remove(job);
                this.logger.error("(Pool)[" + this.idle_threads + "/" + this.total_threads + "] no idle threads but maximum number of threads reached (" + this.max_threads + ")");
                throw new NO_RESOURCES("(Pool)[" + this.idle_threads + "/" + this.total_threads + "] no idle threads but maximum number of threads reached (" + this.max_threads + ")");
            }
        }
        --this.idle_threads;
    }

    private void createNewThread() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] creating new thread");
        }
        Thread t = new Thread((Runnable)new ConsumerTie(this, this.factory.create()), this.threadName + this.threadCount++);
        t.setDaemon(true);
        t.start();
        ++this.total_threads;
    }

    public synchronized void shutdown() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[" + this.idle_threads + "/" + this.total_threads + "] shutting down pool");
        }
        this.shutdown = true;
        this.notifyAll();
    }
}

