/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.model.ANS.IANSNode;
import java.util.ArrayList;

public class ANSNode
implements IANSNode {
    protected boolean dirty = false;
    protected String name = null;
    private ANSNode parent = null;
    private ArrayList children = null;

    public ANSNode(String string) {
        this.name = string;
        this.parent = null;
        this.children = null;
    }

    public ANSNode(String string, ANSNode aNSNode) {
        this.name = string;
        this.parent = aNSNode;
        this.children = null;
    }

    public ANSNode(String string, ANSNode aNSNode, ArrayList arrayList) {
        this.name = string;
        this.parent = aNSNode;
        this.children = arrayList;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.name;
        }
        if (this.parent.getParent() == null) {
            return this.name;
        }
        return this.parent.getFullName() + "." + this.name;
    }

    public IANSNode getParent() {
        return this.parent;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }
    }

    public void resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    ((IANSNode)this.children.get(i)).resetDirty();
                }
            }
        }
    }

    protected void recalcDirty() {
        this.dirty = false;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (!((IANSNode)this.children.get(i)).isDirty()) continue;
                this.setDirty();
            }
        }
        if (this.parent != null && !this.dirty) {
            this.parent.recalcDirty();
        }
    }

    public void setParent(IANSNode iANSNode) {
        this.parent = (ANSNode)iANSNode;
    }

    public IANSNode[] getChildren() {
        if (this.children == null) {
            return new ANSNode[0];
        }
        return this.children.toArray(new ANSNode[0]);
    }

    public void addChild(IANSNode iANSNode) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(iANSNode);
        iANSNode.setParent(this);
    }
}

