/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.If.General;
import cerent.cms.idl.Optics.sRange;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.sParameterInfo;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sParameterValue;
import cerent.cms.idl.OpticsTopology.xNoSuchParameter;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UserException;

public class NeANSModel
extends Model {
    protected NodeModelDelegate nmd;
    private static final SDebug db = new SDebug("NeANSModel");
    private AnsParamList ansParamList = null;
    private ImportParameter importParameter = null;
    private Map ansParamsMap;
    private EventDispatcher dispatcher;
    private boolean isAnsParamsMapinit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnsParamModel[] getAnsParamList() {
        Map map = this.ansParamsMap;
        synchronized (map) {
            return this.ansParamsMap.values().toArray(new AnsParamModel[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnsParamModel[] getAnsParamsByType(eParamType eParamType2) {
        ArrayList<AnsParamModel> arrayList = new ArrayList<AnsParamModel>();
        Map map = this.ansParamsMap;
        synchronized (map) {
            AnsParamModel ansParamModel = null;
            sParameterKey sParameterKey2 = null;
            Iterator iterator = this.ansParamsMap.values().iterator();
            while (iterator.hasNext()) {
                ansParamModel = (AnsParamModel)iterator.next();
                sParameterKey2 = ansParamModel.getParamKey();
                if (sParameterKey2.type != eParamType2) continue;
                arrayList.add(ansParamModel);
            }
            return arrayList.toArray(new AnsParamModel[0]);
        }
    }

    private void printKey(String string, sParameterKey sParameterKey2) {
        db.println("--------------------------------------------------");
        db.println("call:" + string);
        db.print("sParameterKey= [");
        db.print(this.mapParameterKey(sParameterKey2));
        db.println("]");
    }

    private void printVal(int n) {
        db.println("val=" + new Integer(n).toString());
    }

    public void importParameter(sParameterKey sParameterKey2, String string) {
        sRange sRange2 = new sRange(-300, 500);
        sParameterValue sParameterValue2 = new sParameterValue(false, Integer.decode(string), sRange2);
        sParameterInfo sParameterInfo2 = new sParameterInfo(0, sParameterKey2, sParameterValue2);
        if (NeANSModel.db.on) {
            this.printKey("importParameter", sParameterKey2);
            this.printVal(sParameterValue2.currentValue);
        }
        try {
            this.importParameter.set(sParameterInfo2);
        }
        catch (UserException userException) {
            // empty catch block
        }
    }

    private boolean keyEquals(sParameterKey sParameterKey2, sParameterKey sParameterKey3) {
        return sParameterKey2.side.value() == sParameterKey3.side.value() && sParameterKey2.cat.value() == sParameterKey3.cat.value() && sParameterKey2.type.value() == sParameterKey3.type.value() && sParameterKey2.spectrum.value() == sParameterKey3.spectrum.value() && sParameterKey2.spectrumIndex == sParameterKey3.spectrumIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParam(Object object, int n) {
        AnsParamModel ansParamModel = null;
        if (object instanceof sParameterKey) {
            sParameterKey sParameterKey2 = (sParameterKey)object;
            if (db.on()) {
                this.printKey("setParam", sParameterKey2);
                this.printVal(n);
            }
            Map map = this.ansParamsMap;
            synchronized (map) {
                ansParamModel = (AnsParamModel)this.ansParamsMap.get(this.mapParameterKey(sParameterKey2));
                try {
                    ansParamModel.setParamValue(n);
                    if (db.on()) {
                        db.println("set param completed");
                    }
                }
                catch (xNoSuchParameter xNoSuchParameter2) {
                    db.println("set param exception NoSuchParameter");
                }
                catch (xProvisioningError xProvisioningError2) {
                    db.println("set param exception xProvisioningError");
                }
                catch (UserException userException) {
                    db.println("sset param exception UserException");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAnsParamMap() {
        Map map = this.ansParamsMap;
        synchronized (map) {
            return this.ansParamsMap;
        }
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteParamByRef(AnsParamModel ansParamModel) {
        Map map = this.ansParamsMap;
        synchronized (map) {
            ansParamModel.deleteObserver(this);
            Object v = this.ansParamsMap.remove(this.mapParameterKey(ansParamModel.getParamInfo().key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAnsParams() {
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalParamList, 0, (Observer)this);
        }
        Map map = this.ansParamsMap;
        synchronized (map) {
            if (!this.isAnsParamsMapinit) {
                this.discoverAnsParamList(this.ansParamsMap, true);
            }
            this.isAnsParamsMapinit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAnsParams() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalParamList, 0, (Observer)this);
            this.dispatcher = null;
        }
        Map map = this.ansParamsMap;
        synchronized (map) {
            Iterator iterator = this.ansParamsMap.values().iterator();
            while (iterator.hasNext()) {
                AnsParamModel ansParamModel = (AnsParamModel)iterator.next();
                ansParamModel.deleteObserver(this);
                ansParamModel.destroy();
            }
            this.ansParamsMap.clear();
            this.isAnsParamsMapinit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverAnsParamList(Map map, boolean bl) {
        sParameterInfo[] sParameterInfoArray = null;
        try {
            sParameterInfoArray = (sParameterInfo[])this.ansParamList.get();
        }
        catch (xNoSuchParameter xNoSuchParameter2) {
        }
        catch (UserException userException) {
            // empty catch block
        }
        Map map2 = map;
        synchronized (map2) {
            for (int i = 0; i < sParameterInfoArray.length; ++i) {
                if (db.on()) {
                    db.print(i + ") ");
                    this.printKey("discoverAnsParamList", sParameterInfoArray[i].key);
                    this.printVal(sParameterInfoArray[i].value.currentValue);
                }
                AnsParamModel ansParamModel = new AnsParamModel(this.nmd, sParameterInfoArray[i]);
                if (bl) {
                    ansParamModel.init();
                }
                ansParamModel.addObserver(this);
                map.put(this.mapParameterKey(sParameterInfoArray[i].key), ansParamModel);
            }
        }
    }

    private String mapParameterKey(sParameterKey sParameterKey2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(sParameterKey2.side.value());
        stringBuffer.append("-");
        stringBuffer.append(sParameterKey2.dwdmIO.value());
        stringBuffer.append("-");
        stringBuffer.append(sParameterKey2.cat.value());
        stringBuffer.append("-");
        stringBuffer.append(sParameterKey2.type.value());
        stringBuffer.append("-");
        stringBuffer.append(sParameterKey2.spectrum.value());
        stringBuffer.append("-");
        stringBuffer.append(sParameterKey2.spectrumIndex);
        return stringBuffer.toString();
    }

    private void updateParamsLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateLocalStructure() {
        if (NeANSModel.db.on) {
            db.println("Sending UpdateStructure");
        }
        this.updateParamsStructure();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateParamsStructure() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        Map map = this.ansParamsMap;
        synchronized (map) {
            AnsParamModel ansParamModel;
            Object e;
            this.discoverAnsParamList(hashMap, false);
            Collection collection = this.getAddedObjects(this.ansParamsMap.keySet(), hashMap.keySet());
            Collection collection2 = this.getDeletedObjects(this.ansParamsMap.keySet(), hashMap.keySet());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                ansParamModel = (AnsParamModel)hashMap.get(e);
                ansParamModel.init();
                this.ansParamsMap.put(e, ansParamModel);
                bl = true;
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                ansParamModel = (AnsParamModel)this.ansParamsMap.get(e);
                this.ansParamsMap.remove(e);
                ansParamModel.deleteObserver(this);
                ansParamModel.destroy();
                bl = true;
            }
        }
        return bl;
    }

    private Collection getAddedObjects(Set set, Set set2) {
        return this.getUpdateObjects(set, set2, true);
    }

    private Collection getDeletedObjects(Set set, Set set2) {
        return this.getUpdateObjects(set, set2, false);
    }

    private Collection getUpdateObjects(Set set, Set set2, boolean bl) {
        HashSet hashSet = null;
        if (bl) {
            hashSet = new HashSet(set2);
            hashSet.removeAll(set);
        } else {
            hashSet = new HashSet(set);
            hashSet.removeAll(set2);
        }
        return hashSet;
    }

    public NeANSModel(NodeModelDelegate nodeModelDelegate) {
        super(db);
        this.nmd = nodeModelDelegate;
        this.ansParamsMap = new HashMap();
        this.ansParamList = new AnsParamList(this.nmd, "NeANSModel::ansParamList");
        this.importParameter = new ImportParameter(this.nmd, "NeANSModel:importParameter");
    }

    public void init() {
        db.info("Initing NeANSManager " + this.toString());
        super.init0();
        this.initAnsParams();
    }

    public void delete() {
        db.info("Deleting NeANSModel " + this.toString());
        this.dispose();
    }

    public void destroy() {
        db.info("Destroying NeANSModel " + this.toString());
        super.destroy();
    }

    public void dispose() {
        db.info("Disposing NeANSModel " + this.toString());
        this.disposeAnsParams();
        super.dispose();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void updateLocal() {
        this.updateParamsLocal();
    }

    public void update(Observable observable, Object object) {
        if (NeANSModel.db.on) {
            db.println("AnsParamModel::update");
        }
        if (!(observable instanceof AnsParamModel)) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: 
                case 2: {
                    if (NeANSModel.db.on) {
                        db.println("Making structural changes.");
                    }
                    this.updateLocalStructure();
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (observable instanceof AnsParamModel) {
            this.updateLocal();
        } else if (NeANSModel.db.on) {
            db.println("update(): Observable = " + observable + ", arg = " + object);
        }
    }

    private cerent.cms.idl.Node.General getNodeRef() {
        return this.nmd.getIorRepository().getNodeRef();
    }

    private General getIfRef() {
        return this.nmd.getIorRepository().getIfRef();
    }

    class ImportParameter
    extends NonCachedValue {
        public ImportParameter(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            NeANSModel.this.getDwdmOpticalSetupRef().importParameter((sParameterInfo)object);
        }

        public Object outer() {
            return NeANSModel.this;
        }
    }

    class AnsParamList
    extends NonCachedValue {
        public AnsParamList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return NeANSModel.this.getDwdmOpticalSetupRef().getParamList();
        }

        protected void setValue(Object object) throws UserException {
            NeANSModel.this.getDwdmOpticalSetupRef().setParamList((sParameterInfo[])object);
        }

        public Object outer() {
            return NeANSModel.this;
        }
    }
}

