/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AuditTrail;
import cerent.cms.model.InvalidData;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OperationInProgress;
import cerent.launcher.DownloadState;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.job.IJobProgressControl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;

public class AuditTrailArchive
implements Observer {
    private String fileName;
    private NodeModelDelegate node;
    private IJobProgressControl observer;
    private DownloadState state;
    private int error;
    private String errorMsg;
    private File tempFile;
    private FileWriter out;
    private static final SDebug db = new SDebug("AuditTrailArchive");

    public AuditTrailArchive(String string, NodeModelDelegate nodeModelDelegate, IJobProgressControl iJobProgressControl) {
        this.fileName = string;
        this.node = nodeModelDelegate;
        this.observer = iJobProgressControl;
        this.tempFile = null;
        this.state = null;
        this.error = 200;
        this.errorMsg = null;
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.state = new DownloadState("Audit Trail Archive for " + this.node.getName());
            this.state.addObserver((Observer)this);
            this.state.setMaximum(4L);
            this.createFiles();
            this.state.doStep(1L);
            AuditTrail[] auditTrailArray = this.doStartArchive();
            this.state.doStep(1L);
            if (auditTrailArray.length <= 0) {
                throw new IOException("Archive is up to date.");
            }
            for (int i = 0; i < auditTrailArray.length; ++i) {
                this.out.write(auditTrailArray[i].toString() + "\n");
            }
            this.state.doStep(1L);
            this.doCompleteArchive(true, null);
            this.state.doFinalStep();
            db.fine("Returning from AuditTrailArchive.run() with value " + this.error);
        }
        catch (Exception exception) {
            db.println("Caught exception in AuditTrailArchive.run()");
            SDebug.printStackTrace((Throwable)exception);
            this.doCompleteArchive(false, exception);
        }
        finally {
            this.dispose();
        }
    }

    private void doCompleteArchive(boolean bl, Exception exception) {
        Throwable throwable = exception;
        int n = this.error = bl ? 200 : -1;
        if (throwable != null) {
            this.errorMsg = throwable.toString();
        }
        try {
            this.removeFiles(bl);
        }
        catch (Exception exception2) {
            db.println("Caught exception in doCompleteArchive while trying to removeFiles(" + bl + ")");
            SDebug.printStackTrace((Throwable)exception2);
            if (throwable == null) {
                throwable = new AnnotatedException("Failed to complete archive. Could not remove files.", exception2);
                this.error = -1;
                this.errorMsg = throwable.toString();
            }
            bl = false;
        }
        try {
            this.node.completeAuditTrailArchive(bl);
        }
        catch (OperationInProgress operationInProgress) {
            if (throwable == null) {
                throwable = new AnnotatedException("Failed to complete archive. Another archive is in progress.", (Exception)((Object)operationInProgress));
                this.error = -1;
                this.errorMsg = throwable.toString();
            }
        }
        catch (Exception exception3) {
            db.println("Caught exception in doCompleteArchive while trying to completeAuditTrailArchive(" + bl + ")");
            SDebug.printStackTrace((Throwable)exception3);
            if (throwable == null) {
                throwable = new AnnotatedException("Failed to complete archive.", exception3);
                this.error = -1;
                this.errorMsg = throwable.toString();
            }
            try {
                this.removeFiles(false);
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
    }

    private void createFiles() throws IOException {
        File file = new File(this.fileName);
        if (file.exists()) {
            db.fine(this.fileName + " exists, creating temp file");
            this.tempFile = new File(file.getParentFile(), "TMP" + file.getName());
            db.fine("created tempFile " + this.tempFile.getName() + " in directory " + this.tempFile.getCanonicalPath());
            if (!file.renameTo(this.tempFile)) {
                throw new IOException("Cannot create needed tempFile" + this.tempFile.getCanonicalPath());
            }
        }
        this.out = new FileWriter(this.fileName);
    }

    private void removeFiles(boolean bl) throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
        if (!bl) {
            File file = new File(this.fileName);
            if (this.tempFile != null) {
                this.tempFile.renameTo(file);
                this.tempFile = null;
            } else {
                file.delete();
                file = null;
            }
        }
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
        if (this.tempFile != null) {
            this.tempFile.delete();
            this.tempFile = null;
        }
        if (this.state != null) {
            this.state.deleteObserver((Observer)this);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.observer != null) {
            this.observer.setPercentCompleted(this.state.getPercent());
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private AuditTrail[] doStartArchive() throws AnnotatedException {
        try {
            return this.node.startAuditTrailArchive();
        }
        catch (InvalidData invalidData) {
            throw new AnnotatedException("Could not get audit trail records.", (Exception)((Object)invalidData));
        }
        catch (OperationInProgress operationInProgress) {
            throw new AnnotatedException("Failed to start archive. Another archive is in progress.", (Exception)((Object)operationInProgress));
        }
    }
}

