/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.EntityContainer;
import cerent.cms.model.EnvAlarmModel;
import cerent.cms.model.EnvControlModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.WbeSlot;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CtxModuleModel
extends PluggableCarrierModel
implements IModuleModel {
    public CtxModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(eEqType2);
        } else {
            PortModel[] portModelArray = this.getPortModels(eEqType2);
            if (this.db.on()) {
                this.db.println("Found " + portModelArray.length + " ports");
            }
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Ds123 ports...");
                    }
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                case 28: 
                case 29: 
                case 31: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Tdm ports...");
                    }
                    interfaceModelArray = new TdmLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                default: {
                    this.db.println("Could not get lines for CTX Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 32: 
                case 34: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new Ds123PortModel[0]);
                    break;
                }
                case 28: 
                case 29: 
                case 31: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new TdmPortModel[0]);
                    break;
                }
                default: {
                    this.db.println("Could not get ports for CTX Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs1Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS1_VT_MAPPED);
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public EnvAlarmModel[] getAlarmInput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_ALARM);
        return list.toArray(new EnvAlarmModel[list.size()]);
    }

    public EnvControlModel[] getControlOutput() {
        List list = this.getEnvModels(eEqType.ENVIRONMENT_CONTROL);
        return list.toArray(new EnvControlModel[list.size()]);
    }

    public TdmLineModel[] getEc1Lines() {
        return (TdmLineModel[])this.getLineModels(eEqType.EC1_PORT);
    }

    public TdmLineModel[] getOpticalLines() {
        List list = this.getPpmPortModels();
        TdmLineModel[] tdmLineModelArray = new TdmLineModel[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            tdmLineModelArray[n++] = (TdmLineModel)((PortModel)iterator.next()).getInterfaceModel();
        }
        return tdmLineModelArray;
    }

    private List getEnvModels(eEqType eEqType2) {
        List list = this.getDescendantsOfType(eEqType2);
        return list;
    }

    public List getPortsInGroup(IPortModel iPortModel, int n) {
        boolean bl = CircuitSize.getCircuitSize((int)n).isLo(this.getNodeModel().getFramingType());
        List list = null;
        list = !bl && iPortModel.getEqType() == 34 ? this.getDescendantsOfEqType(34) : super.getPortsInGroup(iPortModel, n);
        return list;
    }

    public String toString() {
        return "Ctx" + super.toString();
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        ILoNum iLoNum;
        block4: {
            int n3;
            iLoNum = null;
            PortModel portModel = null;
            PortModel[] portModelArray = this.getPortModels(eEqType.DS1_VT_MAPPED);
            for (n3 = 0; portModel == null && n3 < portModelArray.length; ++n3) {
                if (portModelArray[n3].getPort() != n) continue;
                portModel = portModelArray[n3];
            }
            if (portModel != null) {
                try {
                    n3 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
                    int n4 = Model.getFramingType(this.getNodeModelDelegate()).getEnum();
                    iLoNum = HoLoFactory.idlVt2LoNum(n4, n3, n);
                }
                catch (AnnotatedException annotatedException) {
                    this.db.println("In getLoNumForPort, could not get framing type!");
                    if (!this.db.on()) break block4;
                    SDebug.printStackTrace((Throwable)annotatedException);
                }
            }
        }
        return iLoNum;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        IHoNum iHoNum;
        block2: {
            iHoNum = null;
            try {
                int n3 = n - 1;
                int n4 = Model.getFramingType(this.getNodeModelDelegate()).getEnum();
                int n5 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
                IHoNum iHoNum2 = HoLoFactory.createFirstHoNum(n4);
                ILoNum iLoNum = HoLoFactory.createFirstLoNum(n4, n5);
                IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum2, iLoNum);
                iHoLoNum = HoLoFactory.addGroupOffset(iHoLoNum, n3);
                iHoNum = iHoLoNum.getHoNum();
            }
            catch (AnnotatedException annotatedException) {
                this.db.println("In getHoNumForPort, could not get framing type!");
                if (!this.db.on()) break block2;
                SDebug.printStackTrace((Throwable)annotatedException);
            }
        }
        return iHoNum;
    }

    public int getPortForPath(ILoNum iLoNum, IHoNum iHoNum) {
        int n;
        block8: {
            n = 0;
            if (iLoNum == null) {
                try {
                    int n2 = Model.getFramingType(this.getNodeModelDelegate()).getEnum();
                    if (HoLoFactory.createFirstHoNum(n2).equals(iHoNum)) {
                        n = 1;
                    }
                    break block8;
                }
                catch (AnnotatedException annotatedException) {
                    this.db.println("In getPortForPath, could not get FramingType!");
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)annotatedException);
                    }
                    break block8;
                }
            }
            int n3 = iLoNum.getLoPathWidth();
            if (iHoNum == null && n3 == 7) {
                n = 0;
            } else {
                Ds123PortModel[] ds123PortModelArray = (Ds123PortModel[])this.getPortModels(eEqType.DS1_VT_MAPPED);
                int n4 = ds123PortModelArray.length;
                int n5 = 0;
                for (int i = 1; i <= n4; ++i) {
                    IHoNum iHoNum2;
                    ILoNum iLoNum2 = this.getLoNumForPort(i, n3);
                    if (iLoNum2 == null || !iLoNum2.equals(iLoNum) || iHoNum == null || (iHoNum2 = this.getHoNumForPort(i, n3)) == null || !iHoNum2.equals(iHoNum)) continue;
                    n5 = i;
                    break;
                }
                n = n5;
            }
        }
        return n;
    }

    public boolean isDeletable() {
        return false;
    }

    public boolean isComboModule() {
        return true;
    }

    boolean isPortNumUnique(int n) {
        switch (n) {
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public BbeSlot getBbeSlot() throws CmsNoSuchEntityException {
        return (BbeSlot)this.getSlot(eEqType.BBE_SLOT);
    }

    public WbeSlot getWbeSlot() throws CmsNoSuchEntityException {
        return (WbeSlot)this.getSlot(eEqType.WBE_SLOT);
    }

    private EntityContainer getSlot(eEqType eEqType2) throws CmsNoSuchEntityException {
        List list = this.getChildrenOfType(eEqType2);
        if (list.size() != 1) {
            this.db.println("Found " + list.size() + " Slots!");
            throw new CmsNoSuchEntityException("Wrong number of Slots!");
        }
        return (EntityContainer)list.get(0);
    }

    public boolean supportsAls() {
        return true;
    }

    public boolean isSupportingBLSR() {
        return false;
    }

    public boolean supportsLoopbackAis() {
        return true;
    }

    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        return !(iPortModel instanceof TdmPortModel) || !((TdmPortModel)iPortModel).isOptical();
    }

    public PathTraceInfo[] getJ1PathTraceInfo() throws CTCUserException {
        ArrayList<PathTraceInfo> arrayList = new ArrayList<PathTraceInfo>();
        PathTraceInfo[] pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs3Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getEc1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getOpticalLines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        return arrayList.toArray(new PathTraceInfo[arrayList.size()]);
    }

    boolean supportXC() {
        return true;
    }

    public boolean supportsPhysicalPm() {
        return true;
    }
}

