/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataComm;
import cerent.cms.model.NodeModelDelegate;
import cerent.launcher.CtcHttpRetriever;
import cerent.launcher.DownloadState;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobProgressControl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.zip.GZIPOutputStream;

public class DataReceive
implements Observer {
    private String hostName;
    private String userName;
    private String password;
    private String session;
    private String fileName;
    private IJobProgressControl observer;
    private CtcHttpRetriever retriever;
    private DownloadState state;
    private int error;
    private int operation;
    private String operationName;
    private String errorMsg;
    private String dbTypes;
    private File tempFile;
    private File origFile;
    private String ccName;
    private TDMTerminology terms;
    private static final SDebug db = new SDebug("DataReceive");

    public DataReceive(NodeModelDelegate nodeModelDelegate, int n, String string, IJobProgressControl iJobProgressControl) {
        this.fileName = string;
        this.observer = iJobProgressControl;
        this.operation = n;
        this.origFile = null;
        this.tempFile = null;
        this.hostName = nodeModelDelegate.getHostName();
        this.userName = nodeModelDelegate.getUserName();
        this.password = nodeModelDelegate.getUserPassword();
        this.terms = nodeModelDelegate.getTDMTerminology();
        this.session = DataComm.getSession(nodeModelDelegate);
        this.dbTypes = "";
        this.state = null;
        this.error = 200;
        this.errorMsg = null;
        if (n == 1) {
            this.operationName = "Backup Database";
            this.dbTypes = nodeModelDelegate.getDbTypes();
        } else {
            this.operationName = "Retrieve Diagnostics";
        }
        this.ccName = nodeModelDelegate.getPlatform().getControlCardName();
    }

    public void start() {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        OutputStream outputStream;
        block15: {
            outputStream = null;
            this.checkFileExistence(this.fileName);
            URL uRL = null;
            switch (this.operation) {
                case 6: {
                    uRL = new URL("http://" + this.hostName + "/diagnostics/");
                    outputStream = new GZIPOutputStream(new FileOutputStream(this.fileName));
                    break;
                }
                case 1: {
                    uRL = new URL("http://" + this.hostName + "/database/");
                    outputStream = new FileOutputStream(this.fileName);
                    break;
                }
                default: {
                    throw new Exception("Invalid request for operation " + this.operation);
                }
            }
            this.state = new DownloadState(this.operationName + " for " + this.hostName);
            this.state.addObserver((Observer)this);
            this.retriever = new CtcHttpRetriever();
            this.error = this.retriever.transferContent(uRL, this.session + this.dbTypes + this.userName + ":" + this.password, outputStream, this.state);
            this.errorMsg = DataComm.getErrorMsg(this.error, this.operationName, this.ccName, this.terms);
            if (this.aborted() || this.error != 200) {
                this.purgeFile(this.fileName);
            } else if (this.origFile != null && this.tempFile != null && this.tempFile.exists()) {
                this.origFile.delete();
                boolean bl = this.tempFile.renameTo(this.origFile);
                db.fine("renaming " + this.tempFile.getCanonicalPath() + " to " + this.origFile.getCanonicalPath() + " status=" + bl);
            }
            if (!db.on()) break block15;
            db.println("Returning from DataReceive.run() with value " + this.error);
        }
        Object var5_5 = null;
        this.dispose();
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                db.println("Caught exception in DataReceive.run()");
                SDebug.printStackTrace((Throwable)exception);
                this.error = -1;
                this.errorMsg = exception.getMessage();
                this.purgeFile(this.fileName);
                Object var5_6 = null;
                this.dispose();
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.dispose();
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void checkFileExistence(String string) {
        block4: {
            try {
                this.origFile = new File(string);
                if (this.origFile.exists()) {
                    db.fine(this.origFile.getCanonicalPath() + " exists");
                    this.tempFile = new File(string + "9Z_7Y_5X");
                    this.tempFile.delete();
                    if (this.tempFile.createNewFile()) {
                        this.fileName = this.tempFile.getCanonicalPath();
                        db.fine("setting current file to " + this.fileName);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                if (!DataReceive.db.on) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.tempFile = null;
    }

    private void purgeFile(String string) {
        block3: {
            try {
                db.fine("calling purgeFile");
                File file = new File(string);
                if (file.exists()) {
                    boolean bl = file.delete();
                    db.fine("purging " + string + " status=" + bl);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                db.println("Caught exception in DataReceive.purgeFile()");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean aborted() {
        return this.retriever == null ? false : this.retriever.aborted();
    }

    public void abort() {
        if (this.retriever != null) {
            this.retriever.abort();
        }
    }

    public boolean failed() {
        return this.error != 200;
    }

    public void dispose() {
        if (this.state != null) {
            this.state.deleteObserver((Observer)this);
        }
    }

    public void update(Observable observable, Object object) {
        if (this.observer != null) {
            this.observer.setPercentCompleted(this.state.getPercent());
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

