/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.LinkedList;
import java.util.List;

public class Ds123ModuleModel
extends ModuleModel {
    private Integer numPorts = null;

    public Ds123ModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = new Ds123LineModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? (PortModel[])this.getChildrenOfType(eEqType2).toArray(new Ds123PortModel[0]) : (PortModel[])this.getDescendantsOfClassType(7).toArray(new Ds123PortModel[0]);
        this.numPorts = portModelArray == null ? new Integer(0) : new Integer(portModelArray.length);
        return portModelArray == null ? new Ds123PortModel[]{} : portModelArray;
    }

    public List getConnectionsList() {
        List list = null;
        ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
        if (protectionGroupModel != null && this.isProtectModule()) {
            ModuleModel moduleModel = (ModuleModel)protectionGroupModel.getProtectedModuleModel();
            if (moduleModel != null) {
                list = moduleModel.getConnectionsList();
            }
        } else {
            PortModel[] portModelArray = this.getPortModels();
            list = new LinkedList();
            for (int i = 0; i < portModelArray.length; ++i) {
                list.addAll(portModelArray[i].getConnectionsList());
            }
        }
        return list == null ? new LinkedList() : list;
    }

    public String toString() {
        return "Ds123" + super.toString();
    }

    protected boolean isElectricalCard() {
        boolean bl = false;
        int n = this.getEqType();
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 108: 
            case 109: 
            case 145: 
            case 185: {
                bl = true;
            }
        }
        return bl;
    }

    protected int getNumPorts() {
        if (this.numPorts == null) {
            this.getPortModels();
        }
        return this.numPorts;
    }

    protected void checkPortNumber(int n) {
        if (n <= 0 || n > this.getNumPorts()) {
            throw new IllegalArgumentException("invalid port #" + n);
        }
    }

    ILoNum getLoNumForPort(int n, int n2, IHoLoNum iHoLoNum) {
        IHoLoNum iHoLoNum2;
        this.checkPortNumber(n);
        ILoNum iLoNum = null;
        int n3 = this.getNodeModel().getFramingType();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n5 = n - 1;
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n3);
        ILoNum iLoNum2 = HoLoFactory.createFirstLoNum(n3, n4);
        if (iHoLoNum == null) {
            iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, iLoNum2);
        } else {
            iHoLoNum2 = iHoLoNum;
            iHoLoNum2.setHoNum(iHoNum);
            iHoLoNum2.setLoNum(iLoNum2);
        }
        if (this.isElectricalCard()) {
            HoLoFactory.increaseGroupOffset(iHoLoNum2, n5);
            iLoNum = iHoLoNum2.getLoNum();
        } else {
            iLoNum = super.getLoNumForPort(n, n2);
        }
        return iLoNum;
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        return this.getLoNumForPort(n, n2, null);
    }

    IHoNum getHoNumForPort(int n, int n2, IHoLoNum iHoLoNum) {
        this.checkPortNumber(n);
        IHoNum iHoNum = null;
        int n3 = this.getNodeModel().getFramingType();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n5 = n - 1;
        if (this.isElectricalCard()) {
            IHoLoNum iHoLoNum2;
            IHoNum iHoNum2 = HoLoFactory.createFirstHoNum(n3);
            ILoNum iLoNum = HoLoFactory.createFirstLoNum(n3, n4);
            if (iHoLoNum == null) {
                iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum2, iLoNum);
            } else {
                iHoLoNum2 = iHoLoNum;
                iHoLoNum2.setHoNum(iHoNum2);
                iHoLoNum2.setLoNum(iLoNum);
            }
            HoLoFactory.increaseGroupOffset(iHoLoNum2, n5);
            iHoNum = iHoLoNum2.getHoNum();
        } else {
            iHoNum = super.getHoNumForPort(n, n2);
        }
        return iHoNum;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        return this.getHoNumForPort(n, n2, null);
    }
}

