/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eBackPlaneRate;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.UserException;

public class Ds3xmModuleModel
extends Ds123ModuleModel {
    private BackplaneRate backplaneRate;

    public Ds3xmModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2);
        this.backplaneRate = new BackplaneRate(this.node, "Ds3xmModuleModel.backplaneRate");
    }

    public Ds123LineModel[] getFilteredDs3Lines() {
        Ds123LineModel[] ds123LineModelArray = (Ds123LineModel[])this.getLineModels();
        if (this.getEqType() == 8) {
            return ds123LineModelArray;
        }
        int n = ds123LineModelArray.length != 36 ? 18 : 24;
        Ds123LineModel[] ds123LineModelArray2 = new Ds123LineModel[n];
        int n2 = 0;
        for (int i = 0; i < ds123LineModelArray.length; ++i) {
            if (i >= 12 && (i <= 11 || i % 2 != 1)) continue;
            ds123LineModelArray2[n2] = ds123LineModelArray[i];
            ++n2;
        }
        return ds123LineModelArray2;
    }

    public Ds123LineModel[] getPortedDs3Lines() {
        Ds123LineModel[] ds123LineModelArray = (Ds123LineModel[])this.getLineModels();
        if (this.getEqType() == 8) {
            return ds123LineModelArray;
        }
        Ds123LineModel[] ds123LineModelArray2 = new Ds123LineModel[12];
        for (int i = 0; i < 12; ++i) {
            ds123LineModelArray2[i] = ds123LineModelArray[i];
        }
        return ds123LineModelArray2;
    }

    public Ds123LineModel[] getDs1Lines() {
        Collection collection = InterfaceModel.getHigherLayerModels(this.getLineModels(), 1);
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel = (InterfaceModel)iterator.next();
            if (!(interfaceModel instanceof Ds123LineModel)) continue;
            arrayList.add(interfaceModel);
        }
        return arrayList.toArray(new Ds123LineModel[arrayList.size()]);
    }

    public eBackPlaneRate getBackplaneRate() {
        eBackPlaneRate eBackPlaneRate2 = eBackPlaneRate.BACKPLANE_RATE_DEFAULT;
        if (this.getEqType() == 145) {
            try {
                eBackPlaneRate2 = (eBackPlaneRate)this.backplaneRate.get();
                if (this.db.on()) {
                    this.db.println("getBackplaneRate(): " + eBackPlaneRate2);
                }
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                if (this.db.on()) {
                    this.db.println("NE doesn't support getBackplaneRate operation");
                }
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
        return eBackPlaneRate2;
    }

    public void setBackplaneRate(eBackPlaneRate eBackPlaneRate2) {
        if (this.getEqType() == 145) {
            try {
                this.backplaneRate.set(eBackPlaneRate2);
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
        }
    }

    public boolean supportsHighSpeedBackplaneRate() {
        int n = this.getSlot();
        SlotModel slotModel = (SlotModel)this.getParent();
        AbstractSlotPolicy abstractSlotPolicy = this.getNodeModelDelegate().getSlotPolicy();
        boolean bl = abstractSlotPolicy.hasEqType(slotModel, eEqType.XC192_CARD) || !abstractSlotPolicy.hasEqType(slotModel, eEqType.XCVT_CARD) && !abstractSlotPolicy.hasEqType(slotModel, eEqType.XC_CARD);
        return bl || abstractSlotPolicy.isHighSpeedSlot(n);
    }

    public boolean isOneForNProtectModule() {
        return this.isProtectModule() && this.getProtectionGroupModel().getProtectType() == eProtectionType.ONE_FOR_N;
    }

    protected void updateLocal() {
        this.backplaneRate.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        this.backplaneRate.dispose();
        super.dispose();
    }

    private class BackplaneRate
    extends CachedValue {
        public BackplaneRate(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return Ds3xmModuleModel.this.getIModuleRef().getBackPlaneRate();
        }

        protected void setValue(Object object) throws UserException {
            Ds3xmModuleModel.this.getIModuleRef().setBackPlaneRate((eBackPlaneRate)object);
        }

        public Object outer() {
            return Ds3xmModuleModel.this;
        }
    }
}

