/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.ePayloadType;
import cerent.cms.idl.Dwdm.eTermMode;
import cerent.cms.idl.Dwdm.eWavelength;
import cerent.cms.idl.Dwdm.sDwdmCardConfig;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.ConfigError;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.FcmrLineModel;
import cerent.cms.model.GfpLineModel;
import cerent.cms.model.GfpPortModel;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IOpticsPmModel;
import cerent.cms.model.IRmonModel;
import cerent.cms.model.ISupportsRMON;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.MrSlot;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DwdmModuleModel
extends PluggableCarrierModel
implements IDwdmModuleModel {
    private static final int WL_PREFIX = 3;
    private static final String[] WL_ARRAY = EnumStrings.getStrings((Class)(class$cerent$cms$idl$Dwdm$eWavelength == null ? (class$cerent$cms$idl$Dwdm$eWavelength = DwdmModuleModel.class$("cerent.cms.idl.Dwdm.eWavelength")) : class$cerent$cms$idl$Dwdm$eWavelength));
    private static final SDebug db;
    static /* synthetic */ Class class$cerent$cms$idl$Dwdm$eWavelength;

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, db);
    }

    public DwdmModuleModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, sDebug);
        this.index = n;
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray;
        block4: {
            PortModel[] portModelArray;
            block6: {
                block5: {
                    block3: {
                        portModelArray = this.getPortModels(eEqType2);
                        interfaceModelArray = null;
                        if (eEqType2 != null) break block3;
                        interfaceModelArray = super.getLineModels(null);
                        break block4;
                    }
                    if (eEqType2 != eEqType.DWDM_CLIENT_PORT) break block5;
                    interfaceModelArray = new DwdmCliLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (DwdmCliLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break block4;
                }
                if (eEqType2 != eEqType.DWDM_TRUNK_PORT) break block6;
                interfaceModelArray = new DwdmTrkLineModel[portModelArray.length];
                for (int i = 0; i < portModelArray.length; ++i) {
                    interfaceModelArray[i] = (DwdmTrkLineModel)portModelArray[i].getInterfaceModel();
                }
                break block4;
            }
            if (eEqType2 != eEqType.GFP_PORT) break block4;
            interfaceModelArray = new GfpLineModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (GfpLineModel)portModelArray[i].getInterfaceModel();
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 186: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new GfpPortModel[0]);
                    break;
                }
                case 122: 
                case 123: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new DwdmPortModel[0]);
                    break;
                }
                default: {
                    db.println("Could not get ports for DWDM Card!");
                    if (!db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public DwdmPortModel[] getDwdmPorts() {
        DwdmPortModel[] dwdmPortModelArray = this.getDwdmCliPorts();
        DwdmPortModel[] dwdmPortModelArray2 = this.getDwdmTrkPorts();
        DwdmPortModel[] dwdmPortModelArray3 = new DwdmPortModel[dwdmPortModelArray.length + dwdmPortModelArray2.length];
        System.arraycopy(dwdmPortModelArray, 0, dwdmPortModelArray3, 0, dwdmPortModelArray.length);
        System.arraycopy(dwdmPortModelArray2, 0, dwdmPortModelArray3, dwdmPortModelArray.length, dwdmPortModelArray2.length);
        return dwdmPortModelArray3;
    }

    public GfpPortModel[] getGfpPorts() {
        return (GfpPortModel[])this.getPortModels(eEqType.GFP_PORT);
    }

    public AbstractDwdmLineModel[] getDwdmLineModels() {
        DwdmCliLineModel[] dwdmCliLineModelArray = this.getDwdmCliLineModels();
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = new AbstractDwdmLineModel[dwdmCliLineModelArray.length + dwdmTrkLineModelArray.length];
        System.arraycopy(dwdmCliLineModelArray, 0, abstractDwdmLineModelArray, 0, dwdmCliLineModelArray.length);
        System.arraycopy(dwdmTrkLineModelArray, 0, abstractDwdmLineModelArray, dwdmCliLineModelArray.length, dwdmTrkLineModelArray.length);
        return abstractDwdmLineModelArray;
    }

    public IOpticsPmModel[] getOpticsModels() {
        return this.getDwdmLineModels();
    }

    public GfpLineModel[] getGfpLineModels() {
        return (GfpLineModel[])this.getLineModels(eEqType.GFP_PORT);
    }

    public DwdmCliLineModel[] getDwdmCliLineModels() {
        return (DwdmCliLineModel[])this.getLineModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmTrkLineModel[] getDwdmTrkLineModels() {
        return (DwdmTrkLineModel[])this.getLineModels(eEqType.DWDM_TRUNK_PORT);
    }

    public int getFirstTrunkPort() {
        AbstractDwdmLineModel[] abstractDwdmLineModelArray = this.getDwdmLineModels();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!(abstractDwdmLineModelArray[i] instanceof DwdmTrkLineModel)) continue;
            return i;
        }
        return 0;
    }

    public DwdmTrkLineModel getFirstTrunkLine() {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        return dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0 ? dwdmTrkLineModelArray[0] : null;
    }

    public int getFirstTrunkEntityIndex() throws AbstractCmsNoSuchEntityException {
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (dwdmTrkLineModelArray != null && dwdmTrkLineModelArray.length > 0) {
            return dwdmTrkLineModelArray[0].getPortModel().getEntityIndex();
        }
        return 0;
    }

    public void setPayloadTypeEnum(ePayloadType ePayloadType2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setPayloadTypeEnum(ePayloadType2);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            SDebug.printStackTrace((Throwable)interruptedException);
        }
    }

    public void setTermModeEnum(eTermMode eTermMode2) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setTermModeEnum(eTermMode2);
    }

    public void setWavelengthEnum(eWavelength eWavelength2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setWavelengthEnum(eWavelength2);
    }

    public void setRegenPeer(int n) throws NoSuchInterface, WrongInterfaceType, ConfigError {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        dwdmTrkLineModel.setRegenPeer((short)n);
    }

    public void setDwdmCardConfig(sDwdmCardConfig sDwdmCardConfig2) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        this.getFirstTrunkLine().setDwdmCardConfig(sDwdmCardConfig2);
    }

    public short getRegenPeer() throws NoSuchInterface, WrongInterfaceType {
        return this.getFirstTrunkLine().getRegenPeer();
    }

    public boolean hasRegenPeer() {
        try {
            return this.getRegenPeer() != 0;
        }
        catch (NoSuchInterface noSuchInterface) {
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "Dwdm" + super.toString();
    }

    public List getMfgPorts() {
        ArrayList<DwdmPortModel> arrayList = new ArrayList<DwdmPortModel>();
        if (this.supportSfpPort()) {
            DwdmPortModel[] dwdmPortModelArray = this.getDwdmCliPorts();
            for (int i = 0; i < dwdmPortModelArray.length; ++i) {
                if (!(dwdmPortModelArray[i] instanceof MfgPortModel)) continue;
                arrayList.add(dwdmPortModelArray[i]);
            }
        }
        return arrayList;
    }

    public boolean isComboModule() {
        return true;
    }

    public boolean supportSfpPort() {
        switch (this.getEqType()) {
            case 119: 
            case 120: 
            case 121: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsGfpPort() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean supportTiming() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public boolean supportRegenGroup() {
        switch (this.getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 181: {
                return true;
            }
        }
        return false;
    }

    public boolean isDWDM10GCard() {
        switch (this.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                return true;
            }
        }
        return false;
    }

    public boolean supportSectionTermMode() {
        switch (this.getEqType()) {
            case 118: 
            case 119: 
            case 181: 
            case 182: {
                return false;
            }
        }
        return true;
    }

    public boolean supportTCM() {
        switch (this.getEqType()) {
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public String getWavelengthAsString() {
        try {
            int n = this.getFirstTrunkLine().getWavelength();
            if (n == 0) {
                return (String)this.getExtraInfoMap().get("WL");
            }
            return WL_ARRAY[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasOhCircuits() {
        HashSet<PortModel> hashSet = new HashSet<PortModel>();
        hashSet.addAll(Arrays.asList(this.getPortModels()));
        HashSet hashSet2 = new HashSet();
        OhConnectionModelsDelegate ohConnectionModelsDelegate = (OhConnectionModelsDelegate)this.getNodeModel().getOhConnectionModels();
        ArrayList arrayList = new ArrayList(ohConnectionModelsDelegate.getOhTerms().getConnectionModels());
        arrayList.addAll(ohConnectionModelsDelegate.getOhXcons().getConnectionModels());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ConnectionModel connectionModel = (ConnectionModel)iterator.next();
            hashSet2.addAll(connectionModel.getPortModels());
        }
        hashSet2.retainAll(hashSet);
        return !hashSet2.isEmpty();
    }

    public boolean testHigherLayer() {
        boolean bl = true;
        InterfaceModel[] interfaceModelArray = this.getLineModels();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel[] interfaceModelArray2 = interfaceModelArray[i].getHigherLayerModels();
            if (interfaceModelArray2 != null && interfaceModelArray2.length >= 1) continue;
            db.info("Higher is NULL!!! for " + interfaceModelArray[i]);
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isLineTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isLineTerminated();
    }

    public boolean isSectionTerminated() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isSectionTerminated();
    }

    public boolean isTransparent() {
        DwdmTrkLineModel dwdmTrkLineModel = this.getFirstTrunkLine();
        return dwdmTrkLineModel.isTransparent();
    }

    public boolean supportsOTN() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return false;
            }
        }
        return true;
    }

    public boolean supportsAls() {
        return true;
    }

    public IRmonModel[] getRmonModels() {
        int n;
        DwdmTrkLineModel[] dwdmTrkLineModelArray = this.getDwdmTrkLineModels();
        if (dwdmTrkLineModelArray.length > 0 && (n = this.getEqType()) != 183 && n != 184 && dwdmTrkLineModelArray[0].getRmonModel() == null) {
            return new IRmonModel[0];
        }
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        arrayList.addAll(Arrays.asList(this.getLineModels()));
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InterfaceModel interfaceModel = (InterfaceModel)iterator.next();
            if (interfaceModel instanceof ISupportsRMON) continue;
            iterator.remove();
        }
        return this.getRmonModels(arrayList.toArray(new ISupportsRMON[arrayList.size()]));
    }

    public IRmonModel[] getRmonModels(ISupportsRMON[] iSupportsRMONArray) {
        ArrayList<IRmonModel> arrayList = new ArrayList<IRmonModel>();
        for (int i = 0; i < iSupportsRMONArray.length; ++i) {
            IRmonModel iRmonModel = iSupportsRMONArray[i].getRmonModel();
            if (iRmonModel == null) continue;
            arrayList.add(iRmonModel);
        }
        return arrayList.toArray(new IRmonModel[arrayList.size()]);
    }

    public TdmLineModel[] getSonetLines() {
        return DwdmModuleModel.getTdmLineModels(this.getDwdmLineModels());
    }

    public static TdmLineModel[] getTdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<TdmLineModel> arrayList = new ArrayList<TdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getTdmLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new TdmLineModel[arrayList.size()]);
    }

    public static FcmrLineModel[] getFcmrLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<FcmrLineModel> arrayList = new ArrayList<FcmrLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            try {
                arrayList.add(abstractDwdmLineModelArray[i].getFcmrLineModel());
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                // empty catch block
            }
        }
        return arrayList.toArray(new FcmrLineModel[arrayList.size()]);
    }

    public static AbstractDwdmLineModel[] getTdmDwdmLineModels(AbstractDwdmLineModel[] abstractDwdmLineModelArray) {
        ArrayList<AbstractDwdmLineModel> arrayList = new ArrayList<AbstractDwdmLineModel>();
        for (int i = 0; i < abstractDwdmLineModelArray.length; ++i) {
            if (!abstractDwdmLineModelArray[i].isSonetSdhPayload()) continue;
            arrayList.add(abstractDwdmLineModelArray[i]);
        }
        return arrayList.toArray(new AbstractDwdmLineModel[arrayList.size()]);
    }

    public DwdmPortModel[] getDwdmCliPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_CLIENT_PORT);
    }

    public DwdmPortModel[] getDwdmTrkPorts() {
        return (DwdmPortModel[])this.getPortModels(eEqType.DWDM_TRUNK_PORT);
    }

    public boolean isMxpMr25G() {
        switch (this.getEqType()) {
            case 183: 
            case 184: {
                return true;
            }
        }
        return false;
    }

    public boolean supportPPM() {
        switch (this.getEqType()) {
            case 118: {
                return false;
            }
        }
        return true;
    }

    public boolean supportUtilization() {
        switch (this.getEqType()) {
            case 120: 
            case 121: {
                return false;
            }
        }
        return true;
    }

    public MrSlot getMrSlot() {
        List list = this.getChildrenOfType(eEqType.MR_SLOT);
        int n = list == null ? 0 : list.size();
        return n == 1 ? (MrSlot)list.get(0) : null;
    }

    boolean isPortNumUnique(int n) {
        return false;
    }

    boolean allowsPortEditing(PpmModel ppmModel) {
        return false;
    }

    public PortModel[] getAlarmablePorts() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>(Arrays.asList(this.getPortModels()));
        arrayList.removeAll(Arrays.asList(this.getDwdmCliPorts()));
        return arrayList.toArray(new PortModel[arrayList.size()]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int i = 0; i < WL_ARRAY.length; ++i) {
            DwdmModuleModel.WL_ARRAY[i] = WL_ARRAY[i].substring(3).replace('_', '.');
        }
        db = new SDebug("DwdmModuleModel");
    }
}

