/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Equipment.Entity;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractDwdmLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmTrkLineModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.InvalidLoopbackProvision;
import cerent.cms.model.InvalidState;
import cerent.cms.model.MfgPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhTerms;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.YCableModel;
import cerent.util.SDebug;
import java.util.Iterator;

public class DwdmPortModel
extends MfgPortModel
implements IDwdmPortModel {
    static /* synthetic */ Class class$cerent$cms$model$DwdmPortModel;

    public DwdmPortModel(NodeModelDelegate nodeModelDelegate, Entity entity, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, entity, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(class$cerent$cms$model$DwdmPortModel == null ? (class$cerent$cms$model$DwdmPortModel = DwdmPortModel.class$("cerent.cms.model.DwdmPortModel")) : class$cerent$cms$model$DwdmPortModel));
        this.index = n;
    }

    public void init() {
        super.init();
    }

    public boolean isOptical() {
        return true;
    }

    public boolean hasOpticalProtection() {
        return false;
    }

    public boolean hasYCableProtection() {
        boolean bl = false;
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                bl = true;
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return bl;
    }

    public int getYCableWorkingEntityIndex() {
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                return ((YCableModel)elementModel).getMainEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return -1;
    }

    public int getMediumType() {
        int n = 1;
        try {
            if (this.getDwdmLineModel().getFramingType() == 1) {
                n = 0;
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        return n;
    }

    public int getYCableProtectEntityIndex() {
        try {
            ElementModel elementModel = this.getDwdmLineModel().getElementModel();
            if (elementModel instanceof YCableModel) {
                return ((YCableModel)elementModel).getProtectEntityIndex();
            }
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
        }
        return -1;
    }

    public IElementModel getElementModel() throws AbstractCmsNoSuchElementException {
        return this.getDwdmLineModel().getElementModel();
    }

    public boolean isClientPort() {
        return 122 == this.getEqType();
    }

    public boolean isSpecial() {
        return !this.isClientPort();
    }

    public AbstractDwdmLineModel getDwdmLineModel() {
        return (AbstractDwdmLineModel)this.getInterfaceModel();
    }

    public boolean isSonetDccTermination() {
        boolean bl;
        OhTerms ohTerms = ((OhConnectionModelsDelegate)this.getNodeModel().getOhConnectionModels()).getOhTerms();
        boolean bl2 = bl = ohTerms.isChannelInUse(this.entityIndex, OhChannelType.SDCC_OBJ) || ohTerms.isChannelInUse(this.entityIndex, OhChannelType.LDCC_OBJ);
        if (this.isGccTermination()) {
            bl = false;
        }
        return bl;
    }

    public boolean isGccTermination() {
        boolean bl = false;
        if (!this.isClientPort()) {
            DwdmTrkLineModel dwdmTrkLineModel = (DwdmTrkLineModel)this.getDwdmLineModel();
            OhTerms ohTerms = ((OhConnectionModelsDelegate)this.getNodeModel().getOhConnectionModels()).getOhTerms();
            try {
                if (dwdmTrkLineModel.getOTNStatus() && (ohTerms.isChannelInUse(this.entityIndex, OhChannelType.SDCC_OBJ) || ohTerms.isChannelInUse(this.entityIndex, OhChannelType.LDCC_OBJ))) {
                    bl = true;
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return bl;
    }

    public boolean isPortIS() {
        try {
            return this.getDwdmLineModel().getAdminStateEnum() == eAdminState.ADMIN_IS;
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return false;
        }
    }

    public void setPortOOS() {
        try {
            this.getDwdmLineModel().setAdminState(eAdminState.ADMIN_OOS_DSBLD);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (InvalidLoopbackProvision invalidLoopbackProvision) {
            SDebug.printStackTrace((Throwable)invalidLoopbackProvision);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
        }
        catch (SyncProvError syncProvError) {
            SDebug.printStackTrace((Throwable)syncProvError);
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
        }
    }

    public void setPortIS() {
        try {
            this.getDwdmLineModel().setAdminState(eAdminState.ADMIN_IS);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        catch (InvalidLoopbackProvision invalidLoopbackProvision) {
            SDebug.printStackTrace((Throwable)invalidLoopbackProvision);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            SDebug.printStackTrace((Throwable)unsupportedOperation);
        }
        catch (SyncProvError syncProvError) {
            SDebug.printStackTrace((Throwable)syncProvError);
        }
        catch (InvalidState invalidState) {
            SDebug.printStackTrace((Throwable)invalidState);
        }
    }

    private boolean isPayloadCompatible() {
        boolean bl = true;
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        try {
            switch (abstractDwdmLineModel.getPayloadType()) {
                case 2: 
                case 3: 
                case 4: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.db.severe("Failed retrieving payload type!");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, InvalidLoopbackProvision, UnsupportedOperation, SyncProvError, InvalidState {
        this.db.fine("DwdmPortModel.maybeSetAdminState()");
        boolean bl = false;
        boolean bl2 = true;
        int n4 = this.getAdminState();
        if (n4 != 1 && n != 0 && n4 != n) {
            bl2 = this.isPayloadCompatible();
            if (!bl2) {
                n = -1;
                this.db.fine("Overwrite targetAdminState! due to failure or payload type is not SONET/SDH!");
            } else {
                boolean bl3 = bl2 = !this.isTimingSource() && !this.hasOhChannel() && !this.inProhibitiveOpticalProtectionGroup();
                if (bl2 && n == 1 && n2 != 1 && this.isSonetDccTermination()) {
                    this.db.fine("Skipping SonetDccTermination");
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            bl = super.maybeSetAdminState(n, n2, n3);
        } else {
            this.db.info("Skipping because TDM level services provided by port");
        }
        return bl;
    }

    private boolean inProhibitiveOpticalProtectionGroup() {
        boolean bl = false;
        if (this.hasYCableProtection()) {
            int n = this.getYCableWorkingEntityIndex();
            if (n != this.getIndex()) {
                IEntityModel iEntityModel = null;
                try {
                    iEntityModel = this.getNodeModelDelegate().getEntityTableModel().getEntityModelByIndex(n);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.db.severe(abstractCmsNoSuchEntityException.toString());
                }
                if (iEntityModel instanceof DwdmPortModel) {
                    DwdmPortModel dwdmPortModel = (DwdmPortModel)iEntityModel;
                    bl = dwdmPortModel.hasOhChannel() || dwdmPortModel.isTimingSource();
                }
            }
        } else if (this.hasOpticalProtection()) {
            bl = true;
        }
        return bl;
    }

    public boolean hasOhChannel() {
        IOhConnectionModels iOhConnectionModels = this.getNodeModel().getOhConnectionModels();
        Iterator iterator = OhChannelType.getAllOhChannelTypes().iterator();
        while (iterator.hasNext()) {
            if (!iOhConnectionModels.isChannelInUse(this.entityIndex, (OhChannelType)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean isInLoopback() {
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        try {
            return abstractDwdmLineModel != null && abstractDwdmLineModel.getLoopbackAsInt() != 0;
        }
        catch (Exception exception) {
            this.db.println("Ignoring Exceptions and returning NO LOOPBACK");
            return false;
        }
    }

    public String toString() {
        return "Dwdm" + super.toString();
    }

    public String getActualEqType() {
        if (((DwdmModuleModel)this.getModuleModel()).supportSfpPort() && this.isClientPort()) {
            return this.getMfgData().name;
        }
        return "";
    }

    public boolean supportTiming() {
        switch (this.getModuleModel().getEqType()) {
            case 118: 
            case 120: 
            case 121: 
            case 184: {
                return false;
            }
            case 183: {
                return !this.isClientPort();
            }
            case 181: {
                return this.isClientPort();
            }
        }
        AbstractDwdmLineModel abstractDwdmLineModel = this.getDwdmLineModel();
        return abstractDwdmLineModel.isSonetSdhPayload() && (this.isClientPort() || abstractDwdmLineModel.isLineTerminated());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

