/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.xProvisionError;
import cerent.cms.model.AdminState;
import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ElAttributeMaps;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.SDHTDMTerminology;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Color;
import java.util.TreeMap;
import org.omg.CORBA.UserException;

public abstract class ElementDefaults {
    public static final String LINES_REMOVE_LPBK = "Some lines will be removed from loopback since their new state does not allow loopback.";
    public static final String MEDIA_CHANGED = "Some lines have their media changed.";
    public static final String AUTO_NEGOTIATION_CHANGED = "Some lines have their auto  negotiation control changed.";
    public static final String FLOW_CONTROL_CHANGED = "Some lines have their flow control changed.";
    public static final String LINES_IN_LPBK = "Some lines are being placed in Loopback.";
    public static final String LINES_IN_FAC_LPBK = "Changing to Facility (Line) loopback may cause a timing loop\nif line is used as a timing reference by far-end equipment.";
    public static final String TERM_LPBK_WHILE_TXP = "Terminal loopback has no effect if a line is\nin transponder mode.";
    public static final String APPLY_CHANGE_NSA = "Apply changes?";
    public static final String APPLY_CHANGE_SA = "Service may be affected.\n\nApply changes?";
    public static final String BOOLEAN_STRING = "boolean";
    public static final String TRUE_BOOLEAN_STRING = "booleanTRUE";
    public static final String FALSE_BOOLEAN_STRING = "booleanFALSE";
    public static final String PM_CLEARING_SECURITY_LEVELS_STRING = "securityPmClearingSecurityLevels";
    public static final String MODULE_OP_STRING = "moduleOp";
    public static final String PROT_STATE_STRING = "protectionState";
    public static final String TIMING_MAN_SWITCH_STRING = "timingManSwitchType";
    public static final String TIMING_REF_STRING = "timingRef";
    public static final String TIMING_STATE_STRING = "timingState";
    public static final String TIMING_ADMIN_STATE_STRING = "timingAdminState";
    public static final String TIMING_REFERENCE_CONDITION_STRING = "timingReferenceCondition";
    public static final String TIMING_SSM_QUALITY_STRING = "timingSsmQuality";
    public static final String TIMING_SONET_SSM_QUALITY_STRING = "timingSonetSsmQuality";
    public static final String TIMING_SDH_SSM_QUALITY_STRING = "timingSdhSsmQuality";
    public static final String TIMING_BITS_LBO_STRING = "timingBitsLineBuildout";
    public static final String TIMING_BITS_FACILITY_TYPE_STRING = "timingBitsFacilityType";
    public static final String TIMING_BITS_FACILITY_TYPE_OUT_STRING = "timingBitsFacilityTypeOut";
    public static final String TIMING_BITS_FACILITY_TYPE_DS1_STRING = "ds1TimingBitsFaciltyType";
    public static final String TIMING_BITS_FACILITY_TYPE_64K_STRING = "64KTimingBitsFaciltyType";
    public static final String TIMING_BITS_FACILITY_TYPE_6M_STRING = "6MTimingBitsFaciltyType";
    public static final String TIMING_BITS_CODING_FULL_SET_STRING = "fullSetTimingBitsCoding";
    public static final String TIMING_BITS_CODING_64K_STRING = "64KTimingBitsCoding";
    public static final String TIMING_BITS_FRAMING_FULL_SET_STRING = "fullSetTimingBitsFraming";
    public static final String TIMING_BITS_FRAMING_64K_STRING = "64KTimingBitsFraming";
    public static final String DECLARE_SD_BERLEVEL_STRING = "declareSdBerLevel";
    public static final String DECLARE_SF_BERLEVEL_STRING = "declareSfBerLevel";
    public static final String PROTECTION_OP_STRING = "protectionOp";
    public static final String PROTECTION_OP_STRING_APS_CLEAR = "protectionOpApsClear";
    public static final String PROTECTION_OP_STRING_LOCKOUT_OF_SWITCHING = "LOCKOUT_OF_SWITCHING";
    public static final String BLSR_TYPE_STRING = "blsrType";
    public static final String BLSR_CHANNEL_STATE_STRING = "blsrChannelState";
    public static final String BLSR_OP_STRING_2F_MIN = "blsrOp.2F.min";
    public static final String BLSR_OP_STRING_2F_FULL = "blsrOp.2F.full";
    public static final String BLSR_OP_STRING_4F_MIN = "blsrOp.4F.min";
    public static final String BLSR_OP_STRING_4F_FULL = "blsrOp.4F.full";
    public static final String BLSR_OP_STRING_2F_MAN_RING_MIN = "blsrOp.2F.manRing.min";
    public static final String BLSR_OP_STRING_2F_EXER_RING_MIN = "blsrOp.2F.exerRing.min";
    public static final String BLSR_OP_STRING_2F_FORCE_RING_FULL = "blsrOp.2F.forceRing.full";
    public static final String BLSR_OP_STRING_2F_MAN_RING_FULL = "blsrOp.2F.manRing.full";
    public static final String BLSR_OP_STRING_2F_EXER_RING_FULL = "blsrOp.2F.exerRing.full";
    public static final String BLSR_OP_STRING_2F_LOCK_FULL = "blsrOp.2F.lock.full";
    public static final String BLSR_OP_STRING_CLEAR = "blsrOp.clear";
    public static final String BLSR_OP_STRING_4F_MAN_SPAN_MIN = "blsrOp.4F.manSpan.min";
    public static final String BLSR_OP_STRING_4F_MAN_RING_MIN = "blsrOp.4F.manRing.min";
    public static final String BLSR_OP_STRING_4F_EXER_SPAN_MIN = "blsrOp.4F.exerSpan.min";
    public static final String BLSR_OP_STRING_4F_EXER_RING_MIN = "blsrOp.4F.exerRing.min";
    public static final String BLSR_OP_STRING_4F_FORCE_SPAN_FULL = "blsrOp.4F.forceSpan.full";
    public static final String BLSR_OP_STRING_4F_FORCE_RING_FULL = "blsrOp.4F.forceRing.full";
    public static final String BLSR_OP_STRING_4F_MAN_SPAN_FULL = "blsrOp.4F.manSpan.full";
    public static final String BLSR_OP_STRING_4F_MAN_RING_FULL = "blsrOp.4F.manRing.full";
    public static final String BLSR_OP_STRING_4F_EXER_SPAN_FULL = "blsrOp.4F.exerSpan.full";
    public static final String BLSR_OP_STRING_4F_EXER_RING_FULL = "blsrOp.4F.exerRing.full";
    public static final String BLSR_OP_STRING_4F_LOCK_FULL = "blsrOp.4F.lock.full";
    public static final String BLSR_OP_STRING_4F_FULL_APS_CLEAR = "blsrOp.apsClear";
    public static final String LINE_LENGTH_STRING = "Line Length";
    public static final String FDL_MODE_MASK_STRING = "FdlModeMask";
    public static final String FDL_T1_403_ONLY_MODE_MASK_STRING = "T1403OnlyFdlModeMask";
    public static final String SYSTEM_STRING = "SYSTEM";
    public static final String DS1_EQTYPE_STRING = "DS1_LINE_CARD";
    public static final String E1N_EQTYPE_STRING = "E1N_LINE_CARD";
    public static final String E3_EQTYPE_STRING = "E3_LINE_CARD";
    public static final String DS3XM_EQTYPE_STRING = "DS3XM_LINE_CARD";
    public static final String DS3XM12_EQTYPE_STRING = "DS3XM_12_LINE_CARD";
    public static final String DS3XM_DS1_EQTYPE_STRING = "DS3XMDS1";
    public static final String DS3XM12_DS1_EQTYPE_STRING = "DS3XM12DS1";
    public static final String DS3_EQTYPE_STRING = "DS3_LINE_CARD";
    public static final String DS3I_EQTYPE_STRING = "DS3I_LINE_CARD";
    public static final String DS3E_EQTYPE_STRING = "DS3E_LINE_CARD";
    public static final String DS3_EC1_EQTYPE_STRING = "DS3_EC1_48_LINE_CARD";
    public static final String ETHER_EQTYPE_STRING = "ETHER";
    public static final String ETHER10_EQTYPE_STRING = "ETHER10";
    public static final String ETHER100_EQTYPE_STRING = "ETHER100";
    public static final String ETHER1000_EQTYPE_STRING = "ETHER1000";
    public static final String FCMR_ADMIN_STATE = "FCMR_ADMIN_STATE";
    public static final String SONET_EQTYPE_STRING = "SONET";
    public static final String DS123_EQTYPE_STRING = "DS123";
    public static final String EC1_EQTYPE_STRING = "EC1";
    public static final String AIC_ENV_ALARM_STRING = "AICEnvAlarm";
    public static final String AIC_ENV_CONTROL_STRING = "AICControl";
    public static final String SONET_LINEBUILDOUT_STRING = "SonetLineBuildout";
    public static final String ETHER_ENCAPSULATION_STRING = "EtherEncapsulation";
    public static final String ETHER_PRIORITY_STRING = "EtherPriority";
    public static final String VLAN_STRING = "Vlan";
    public static final String STM1E_12_EQTYPE_STRING = "STM1E_12_LINE_CARD";
    public static final String STM1E_C2_STRING = "STM1E_C2";
    public static final String DCC_STRING = "DCC";
    public static final String G1000_PORT_MAX_SIZE = "G1000 Port Max Size";
    public static final String G1000_LOOPBACK_TYPE = "G1000 Loopback Type";
    public static final String G1000_ADMIN_STATE = "G1000 Admin State";
    public static final String G1000_TRANSPONDER_MODE = "G1000 Transponder Mode";
    public static final String G1000_TRANSPONDER_PORT = "G1000 Transponder Port";
    public static final String G1000_WATER_MARKS = "G1000 Water Marks Setting";
    public static final String G1000_PAYLOAD_TYPE = "G1000 Payload Type";
    public static final String ETHER_LINK_DUPLEX = "EtherDuplex";
    public static final String ETHER_LINK_SPEED = "EtherSpeed";
    public static final int E1_LINE_LENGTH_1 = 0;
    public static final int DS1_LINE_LENGTH_1 = 131;
    public static final int DS1_LINE_LENGTH_2 = 262;
    public static final int DS1_LINE_LENGTH_3 = 393;
    public static final int DS1_LINE_LENGTH_4 = 524;
    public static final int DS1_LINE_LENGTH_5 = 655;
    public static final int DS3_LINE_LENGTH_1 = 225;
    public static final int DS3_LINE_LENGTH_2 = 450;
    public static final int EC1_LINE_LENGTH_1 = 225;
    public static final int EC1_LINE_LENGTH_2 = 450;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int SES_INDEX = 3;
    public static final int FC_INDEX = 4;
    public static final int BBE_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PSC_INDEX = 6;
    public static final int PSD_INDEX = 7;
    public static final int PSCW_INDEX = 8;
    public static final int PSDW_INDEX = 9;
    public static final int PSCS_INDEX = 10;
    public static final int PSDS_INDEX = 11;
    public static final int PSCR_INDEX = 12;
    public static final int PSDR_INDEX = 13;
    public static final int LAST_INDEX = 13;
    public static final String DWDM_EQTYPE_STRING = "DWDM";
    public static final String DECLARE_ALL_DATA_RATE_STRING = "declAllDataRate";
    public static final String FULL_SET_FRAMING_TYPE_STRING = "declFullSetDwdmFramingType";
    public static final String DECLARE_MXP_10G_FRAMING_TYPE_STRING = "declMXP10GDwdmFramingType";
    public static final String DECLARE_MXP_10E_FRAMING_TYPE_STRING = "declMXP10EDwdmFramingType";
    public static final String DECLARE_TXP_10G_FRAMING_TYPE_STRING = "declTXP10GDwdmFramingType";
    public static final String DECLARE_TXP_10E_FRAMING_TYPE_STRING = "declTXP10EDwdmFramingType";
    public static final String DECLARE_TXP_2_5G_FRAMING_TYPE_STRING = "declTXP25GFramingType";
    public static final String DECLARE_MXP_10G_PAYLOAD_DATA_TYPE_STRING = "declMXP10GPayloadDataType";
    public static final String DECLARE_TXP_10G_PAYLOAD_DATA_TYPE_STRING = "declTXP10GPayloadDataType";
    public static final String DECLARE_TXP_10E_PAYLOAD_DATA_TYPE_STRING = "declTXP10EPayloadDataType";
    public static final String DECLARE_TXP_2_5G_PAYLOAD_DATA_TYPE_STRING = "declTXP25GPayloadDataType";
    public static final String DECLARE_TXP_2_5G_FULL_SET_PAYLOAD_DATA_TYPE_STRING = "declTXP25GPayloadDataTypeFullSet";
    public static final String DECLARE_TXP_2_5G_TRANSPARENT_PAYLOAD_DATA_TYPE_STRING = "declTXP25GPayloadDataTypeTransparent";
    public static final String PPM_SLOT_ASSIGNMENT_STRING = "declPPMSlotAssignment";
    public static final String DECLARE_MXP_10G_PORT_ASSIGNMENT_STRING = "declMXP10GPortEqType";
    public static final String DECLARE_TXP_10G_PORT_ASSIGNMENT_STRING = "declTXP10GPortEqType";
    public static final String DECLARE_TXP_10G_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP10GFullSetPortEqType";
    public static final String DECLARE_TXP_10G_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP10GIsOosMtOosPortEqType";
    public static final String DECLARE_TXP_10E_PORT_ASSIGNMENT_STRING = "declTXP10EPortEqType";
    public static final String DECLARE_TXP_10E_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP10EFullSetPortEqType";
    public static final String DECLARE_TXP_10E_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP10EIsOosMtOosPortEqType";
    public static final String DECLARE_TXP_2_5G_PORT_ASSIGNMENT_STRING = "declTXP25GPortEqType";
    public static final String DECLARE_TXP_2_5G_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP25GPortEqTypeFullSet";
    public static final String DECLARE_TXP_2_5G_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING = "declTXP25GPortEqTypeTransparent";
    public static final String DECLARE_MXP_2_5G_10E_PORT_ASSIGNMENT_STRING = "declMxp25G_10GPortEqType";
    public static final String DECLARE_MXP_MR_2_5G_PORT_ASSIGNMENT_STRING = "declMxpMr25GPortEqType";
    public static final String DECLARE_DWDM_GCC_RATE_STRING = "declDwdmGccRate";
    public static final String DECLARE_DWDM_WAVELENGTH_STRING = "declDwdmWavelength";
    public static final String DECLARE_DWDM_REGEN_PEER_STRING = "declDwdmRegenPeer";
    public static final String DECLARE_DWDM_W_L_BAND_WAVELENGTH_STRING = "declDwdmWLBandWavelength";
    public static final String DECLARE_DWDM_TERM_MODE_STRING = "dwdmTermMode";
    public static final String DECLARE_AIS_SQUELCH_MODE_STRING = "aisSquelch";
    public static final String FULL_SET_TERM_MODE_STRING = "declTermModeFullSet";
    public static final String TRANSPARENT_LINE_TERM_MODE_STRING = "declTermModeTransparentSection";
    public static final String TRANSPARENT_TERM_MODE_STRING = "declTermModeTransparent";
    public static final String TRANSPARENT_SECTION_TERM_MODE_STRING = "mxp25GTermMode";
    public static final String DECLARE_ALS_MODE_STRING = "AlsMode";
    public static final String DECLARE_ALS_MODE_FULL_RANGE_STRING = "AlsModeFullRange";
    public static final String DECLARE_ALS_MODE_RESTRICTED_RANGE_STRING = "AlsModeRestrictedRange";
    public static final String DECLARE_NO_AUTO_ALS_MODE_STRING = "NoAutoAlsMode";
    public static final String DECLARE_MAPPING_TYPE_MXP_STRING = "mxpMappingType";
    public static final String DECLARE_MAPPING_TYPE_TXP_STRING = "txpMappingType";
    public static final String DECLARE_FEC_STRING = "Fec";
    public static final String DECLARE_EFEC_STRING = "EFec";
    public static final String FEC_DISABLED_STRING = "DWDMFecDisabled";
    public static final String FULL_SET_ADMIN_STATE;
    public static final String DECLARE_DWDM_CARD_MODE_STRING = "dwdmCardMode";
    public static final String IS_OOS_ADMIN_STATE = "isOosAdminState";
    public static final String IS_OOS_MT_OOS_ADMIN_STATE = "isOosMtOosAdminState";
    public static final String OOS_ADMIN_STATE_STRING = "OosAdminState";
    public static final Color PROVISIONED_COLOR;
    public static final Color MAJOR_ALARM_COLOR;
    public static final Color MINOR_ALARM_COLOR;
    public static final Color CRITICAL_ALARM_COLOR;
    public static final Color DELETED_COLOR;
    public static final Color IS_COLOR;
    public static final Color OOS_MT_COLOR;
    public static final Color IS_AINS_COLOR;
    public static final Color OOS_DSBLD_COLOR;
    public static final Color PRE_PROVISION_BG;
    public static final Color PRE_PROVISION_FG;
    public static final Color DELETED_BG;
    public static final Color DELETED_FG;
    public static final Color SELECTION_BG;
    public static final Color SELECTION_FG;
    public static final String ETHERGROUP_STRING = "Ethergroup";
    private static ElAttributeMaps SonetAttributeMap;
    private static ElAttributeMaps SdhAttributeMap;
    public static String CIRCUIT_SIZE_STRING;
    public static String CIRCUIT_TYPE_STRING;
    public static final String IPCC_TYPE_STRING = "ipccType";
    public static final String CRC_MODE_STRING = "crcMode";
    public static final String ADMIN_STATE_STRING = "adminState";
    public static final String TNA_TYPE_STRING = "tnaType";
    public static final String UCP_CIRCUIT_STATE_STRING = "ucpCircuitState";
    public static final String CTX_DS1_EQTYPE_STRING = "CTXDS1";
    public static final String FCMR_CARD_MODE = "FcmrCardMode";
    public static final String FCMR_CARD_MODE_ALLOWS_FICON = "FcmrCardModeAllowsFICON";
    public static final String FCMR_CARD_MODE_FORBIDS_FICON = "FcmrCardModeForbidsFICON";
    public static final String DEFAULT_FRONT_IP = "10.10.0.1";
    public static final short DEFAULT_FRONT_IP_NETMASK = 24;
    private static final String[] moduleOps;
    private static final String[] adminState;
    private static final String[] crcMode;
    private static final String[] ipccType;
    private static final String[] tnaType;
    private static final String[] ucpCircuitState;
    private static final String[] protStates;
    private static final String[] envAlarms;
    private static final String[] alarmSeverities;
    private static final String[] virtualWires;
    private static final String[] ctrlModes;
    protected static final String[] ctrlTypes;
    public static final String[] dccStrings;
    public static final String[] owStrings;
    public static final String[] protectionOpStrings;
    public static final Attribute[] PM_INTERVAL_TYPES;
    public static final String[] CURR_PREV_60_COLUMN_NAMES;
    public static final String[] PREV_60_COLUMN_NAMES;
    private static final SDebug db;
    static /* synthetic */ Class class$cerent$cms$idl$Common$eAdminState;
    static /* synthetic */ Class class$cerent$cms$idl$Ds123Media$eLineCoding;
    static /* synthetic */ Class class$cerent$cms$idl$Ds123Media$eLineType;
    static /* synthetic */ Class class$cerent$cms$idl$If$eLoopback;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eModuleOp;
    static /* synthetic */ Class class$cerent$cms$idl$Ds123Media$eSendCode;
    static /* synthetic */ Class class$cerent$cms$idl$FCMedia$eFCMediaType;
    static /* synthetic */ Class class$cerent$cms$idl$FCMedia$eLinkRate;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eMauType;
    static /* synthetic */ Class class$cerent$cms$idl$Epos$eBridgePortState;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eGigEtherOptics;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated;
    static /* synthetic */ Class class$cerent$cms$idl$SonetMedia$eStm1eMode;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvAlrmType;
    static /* synthetic */ Class class$cerent$cms$idl$Alarm$eSeverity;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eVirtWire;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvCtrlMode;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEnvCtrlType;
    static /* synthetic */ Class class$cerent$cms$idl$SonetMedia$eMediumType;
    static /* synthetic */ Class class$cerent$cms$idl$SonetMedia$eDccSubChannel;
    static /* synthetic */ Class class$cerent$cms$idl$SonetTopology$eOwireSubChannel;
    static /* synthetic */ Class class$cerent$cms$idl$SonetTopology$eProtectionOp;

    public static ElAttributeMaps getAttributeMap(IModel iModel) {
        return ElementDefaults.getAttributeMap(iModel, false);
    }

    public static ElAttributeMaps getAttributeMap(IModel iModel, boolean bl) {
        INodeModel iNodeModel = iModel.getNodeModel();
        int n = iNodeModel.getFramingType();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        return ElementDefaults.getAttributeMap(n, tDMTerminology, bl);
    }

    public static ElAttributeMaps getAttributeMap(int n, TDMTerminology tDMTerminology) {
        return ElementDefaults.getAttributeMap(n, tDMTerminology, false);
    }

    public static ElAttributeMaps getAttributeMap(int n, TDMTerminology tDMTerminology, boolean bl) {
        boolean bl2 = FramingType.getFramingType((int)n).isSonet();
        return ElementDefaults.getAttributeMap(bl2, tDMTerminology, bl);
    }

    public static ElAttributeMaps getAttributeMap(boolean bl, TDMTerminology tDMTerminology) {
        return ElementDefaults.getAttributeMap(bl, tDMTerminology, false);
    }

    public static ElAttributeMaps getAttributeMap(boolean bl, TDMTerminology tDMTerminology, boolean bl2) {
        ElAttributeMaps elAttributeMaps;
        ElAttributeMaps elAttributeMaps2 = elAttributeMaps = bl ? SonetAttributeMap : SdhAttributeMap;
        if (elAttributeMaps == null || bl2) {
            ElementDefaults.initializeAttributeMaps(tDMTerminology, bl);
        }
        elAttributeMaps = bl ? SonetAttributeMap : SdhAttributeMap;
        return elAttributeMaps;
    }

    private static void putAttribute(TreeMap treeMap, int n, String string) {
        Integer n2 = new Integer(n);
        treeMap.put(n2, new Attribute(string, n2));
    }

    private static void initializeAttributeMaps(TDMTerminology tDMTerminology, boolean bl) {
        ElAttributeMaps elAttributeMaps = new ElAttributeMaps();
        ElementDefaults.initializeSystem(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeSecurity(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeEqpt(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeSync(elAttributeMaps, tDMTerminology, bl);
        ElementDefaults.initializeDs1(elAttributeMaps, tDMTerminology, bl);
        ElementDefaults.initializeDs3(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3e(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3XM(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3XM12(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeEC1(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3Ec1(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeE1(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeE3(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3i(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs123(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeSonet(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeEther(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeFcmr(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeAIC(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3xmDs1(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDs3xm12Ds1(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeCircuits(elAttributeMaps, tDMTerminology, bl);
        ElementDefaults.initializeUcp(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDcc(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeDwdm(elAttributeMaps, tDMTerminology, bl);
        ElementDefaults.initializeSTM1E(elAttributeMaps, tDMTerminology);
        ElementDefaults.initializeCtxDs1(elAttributeMaps, tDMTerminology);
        if (bl) {
            SonetAttributeMap = elAttributeMaps;
        } else {
            SdhAttributeMap = elAttributeMaps;
        }
    }

    private static void initializeSystem(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = SYSTEM_STRING;
        TreeMap treeMap = new TreeMap();
        String string2 = BOOLEAN_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "FALSE");
        ElementDefaults.putAttribute(treeMap, 1, "TRUE");
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = TRUE_BOOLEAN_STRING;
        ElementDefaults.putAttribute(treeMap, 1, "TRUE");
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = FALSE_BOOLEAN_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "FALSE");
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = FULL_SET_ADMIN_STATE;
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = IS_OOS_ADMIN_STATE;
        ElementDefaults.initializeIsOosAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = IS_OOS_MT_OOS_ADMIN_STATE;
        ElementDefaults.initializeIsOosMtOosAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = "SYSTEM.declareSdBerLevel";
        ElementDefaults.putAttribute(treeMap, 5, "1E-5");
        ElementDefaults.putAttribute(treeMap, 6, "1E-6");
        ElementDefaults.putAttribute(treeMap, 7, "1E-7");
        ElementDefaults.putAttribute(treeMap, 8, "1E-8");
        ElementDefaults.putAttribute(treeMap, 9, "1E-9");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeEqpt(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        ElementDefaults.addMap(elAttributeMaps, MODULE_OP_STRING, moduleOps);
        ElementDefaults.addMap(elAttributeMaps, PROT_STATE_STRING, protStates);
    }

    private static void initializeSync(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology, boolean bl) {
        TreeMap treeMap = new TreeMap();
        String string = TIMING_MAN_SWITCH_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "MANUAL");
        ElementDefaults.putAttribute(treeMap, 1, "FORCE");
        ElementDefaults.putAttribute(treeMap, 2, "AUTOMATIC");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_REF_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "NE");
        ElementDefaults.putAttribute(treeMap, 1, "BITS-1 Out");
        ElementDefaults.putAttribute(treeMap, 2, "BITS-2 Out");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_STATE_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "INIT_STATE");
        ElementDefaults.putAttribute(treeMap, 1, "HOLDOVER_STATE");
        ElementDefaults.putAttribute(treeMap, 2, "FREERUN_STATE");
        ElementDefaults.putAttribute(treeMap, 3, "NO_SYNC_STATE");
        ElementDefaults.putAttribute(treeMap, 4, "NE_SYNCH_STATE");
        ElementDefaults.putAttribute(treeMap, 5, "NORMAL_STATE");
        ElementDefaults.putAttribute(treeMap, 6, "FAST_START_STATE");
        ElementDefaults.putAttribute(treeMap, 7, "FAST_START_FAILEDSTATE");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_ADMIN_STATE_STRING;
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_REFERENCE_CONDITION_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "OKAY");
        ElementDefaults.putAttribute(treeMap, 1, "LOS");
        ElementDefaults.putAttribute(treeMap, 2, "LOF");
        ElementDefaults.putAttribute(treeMap, 3, "AIS");
        ElementDefaults.putAttribute(treeMap, 4, "OOB");
        ElementDefaults.putAttribute(treeMap, 5, "EQP");
        ElementDefaults.putAttribute(treeMap, 6, "BPV");
        ElementDefaults.putAttribute(treeMap, 7, "CCHV");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_SSM_QUALITY_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "PRS");
        ElementDefaults.putAttribute(treeMap, 1, "STU");
        ElementDefaults.putAttribute(treeMap, 2, "ST2");
        ElementDefaults.putAttribute(treeMap, 3, "TNC");
        ElementDefaults.putAttribute(treeMap, 4, "ST3E");
        ElementDefaults.putAttribute(treeMap, 5, "ST3");
        ElementDefaults.putAttribute(treeMap, 6, "SMC");
        ElementDefaults.putAttribute(treeMap, 7, "ST4");
        ElementDefaults.putAttribute(treeMap, 8, "DUS");
        ElementDefaults.putAttribute(treeMap, 9, "RES");
        ElementDefaults.putAttribute(treeMap, 10, "G811");
        ElementDefaults.putAttribute(treeMap, 11, "STU_SDH");
        ElementDefaults.putAttribute(treeMap, 12, "G812T");
        ElementDefaults.putAttribute(treeMap, 13, "G812L");
        ElementDefaults.putAttribute(treeMap, 14, "SETS");
        ElementDefaults.putAttribute(treeMap, 15, "DUS_SDH");
        ElementDefaults.putAttribute(treeMap, 16, "RES_SDH");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_SONET_SSM_QUALITY_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "PRS");
        ElementDefaults.putAttribute(treeMap, 1, "STU");
        ElementDefaults.putAttribute(treeMap, 2, "ST2");
        ElementDefaults.putAttribute(treeMap, 3, "TNC");
        ElementDefaults.putAttribute(treeMap, 4, "ST3E");
        ElementDefaults.putAttribute(treeMap, 5, "ST3");
        ElementDefaults.putAttribute(treeMap, 6, "SMC");
        ElementDefaults.putAttribute(treeMap, 7, "ST4");
        ElementDefaults.putAttribute(treeMap, 8, "DUS");
        ElementDefaults.putAttribute(treeMap, 9, "RES");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_SDH_SSM_QUALITY_STRING;
        ElementDefaults.putAttribute(treeMap, 10, "G811");
        ElementDefaults.putAttribute(treeMap, 11, "STU");
        ElementDefaults.putAttribute(treeMap, 12, "G812T");
        ElementDefaults.putAttribute(treeMap, 13, "G812L");
        ElementDefaults.putAttribute(treeMap, 14, "SETS");
        ElementDefaults.putAttribute(treeMap, 15, "DUS");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_LBO_STRING;
        ElementDefaults.putAttribute(treeMap, 0, "0-133");
        ElementDefaults.putAttribute(treeMap, 1, "134-266");
        ElementDefaults.putAttribute(treeMap, 2, "267-399");
        ElementDefaults.putAttribute(treeMap, 3, "400-533");
        ElementDefaults.putAttribute(treeMap, 4, "534-655");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FACILITY_TYPE_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "DS1");
            ElementDefaults.putAttribute(treeMap, 2, "64Khz+8Khz");
        } else {
            ElementDefaults.putAttribute(treeMap, 1, "E1");
            ElementDefaults.putAttribute(treeMap, 3, "2Mhz");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FACILITY_TYPE_OUT_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "DS1");
            ElementDefaults.putAttribute(treeMap, 2, "6Mhz");
        } else {
            ElementDefaults.putAttribute(treeMap, 1, "E1");
            ElementDefaults.putAttribute(treeMap, 3, "2Mhz");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FACILITY_TYPE_DS1_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "DS1");
        } else {
            ElementDefaults.putAttribute(treeMap, 1, "E1");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FACILITY_TYPE_64K_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 2, "64Khz+8Khz");
        } else {
            ElementDefaults.putAttribute(treeMap, 3, "2Mhz");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FACILITY_TYPE_6M_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 2, "6Mhz");
        } else {
            ElementDefaults.putAttribute(treeMap, 3, "2Mhz");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_CODING_FULL_SET_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 1, "B8ZS");
        } else {
            ElementDefaults.putAttribute(treeMap, 2, "HDB3");
        }
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_CODING_64K_STRING;
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FRAMING_FULL_SET_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 1, "D4");
            ElementDefaults.putAttribute(treeMap, 0, "ESF");
        } else {
            ElementDefaults.putAttribute(treeMap, 17, "Unframed");
            ElementDefaults.putAttribute(treeMap, 16, "FAS");
            ElementDefaults.putAttribute(treeMap, 3, "FAS+CAS");
            ElementDefaults.putAttribute(treeMap, 2, "FAS+CRC");
            ElementDefaults.putAttribute(treeMap, 4, "FAS+CAS+CRC");
        }
        elAttributeMaps.put(string, treeMap);
        treeMap = new TreeMap();
        string = TIMING_BITS_FRAMING_64K_STRING;
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 15, "N/A");
        } else {
            ElementDefaults.putAttribute(treeMap, 19, "Unframed - 2Mhz");
            ElementDefaults.putAttribute(treeMap, 17, "Unframed");
            ElementDefaults.putAttribute(treeMap, 16, "FAS");
            ElementDefaults.putAttribute(treeMap, 3, "FAS+CAS");
            ElementDefaults.putAttribute(treeMap, 2, "FAS+CRC");
            ElementDefaults.putAttribute(treeMap, 4, "FAS+CAS+CRC");
        }
        elAttributeMaps.put(string, treeMap);
    }

    private static void initializeSecurity(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        TreeMap treeMap = new TreeMap();
        String string = PM_CLEARING_SECURITY_LEVELS_STRING;
        ElementDefaults.putAttribute(treeMap, 2, "Provisioning");
        ElementDefaults.putAttribute(treeMap, 3, "Superuser");
        elAttributeMaps.put(string, treeMap);
    }

    private static void initializeDs123(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS123.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "JBZS");
        ElementDefaults.putAttribute(treeMap, 1, "B8ZS");
        ElementDefaults.putAttribute(treeMap, 2, "HDB3");
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        ElementDefaults.putAttribute(treeMap, 4, "ZBTSI");
        ElementDefaults.putAttribute(treeMap, 5, "B6ZS");
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "ESF");
        ElementDefaults.putAttribute(treeMap, 1, "D4");
        ElementDefaults.putAttribute(treeMap, 2, "E1_CRC");
        ElementDefaults.putAttribute(treeMap, 3, "E1_MF");
        ElementDefaults.putAttribute(treeMap, 4, "E1_CRCMF");
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 6, "DS2");
        ElementDefaults.putAttribute(treeMap, 7, "E2");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        ElementDefaults.putAttribute(treeMap, 9, "SYNTRAN");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 11, "E3_FRAME");
        ElementDefaults.putAttribute(treeMap, 12, "E3_PLCP");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO PROVISION FMT");
        ElementDefaults.putAttribute(treeMap, 14, "UNKNOWN");
        ElementDefaults.putAttribute(treeMap, 15, "N/A");
        ElementDefaults.putAttribute(treeMap, 16, "E1_FRAME");
        ElementDefaults.putAttribute(treeMap, 17, "E1_UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 18, "BITS 64k");
        ElementDefaults.putAttribute(treeMap, 19, "BITS 2MHz");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Equipment$eModuleOp == null ? (class$cerent$cms$idl$Equipment$eModuleOp = ElementDefaults.class$("cerent.cms.idl.Equipment.eModuleOp")) : class$cerent$cms$idl$Equipment$eModuleOp).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Reset");
        ElementDefaults.putAttribute(treeMap, 1, "Clear");
        ElementDefaults.putAttribute(treeMap, 2, "Lock Protection");
        ElementDefaults.putAttribute(treeMap, 3, "Manual");
        ElementDefaults.putAttribute(treeMap, 4, "Force");
        ElementDefaults.putAttribute(treeMap, 5, "Span Upgrade");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + FDL_MODE_MASK_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "T1.403");
        ElementDefaults.putAttribute(treeMap, 1, "BFDL");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "FEAC Loopback");
        ElementDefaults.putAttribute(treeMap, 2, "Payload Loopback");
        ElementDefaults.putAttribute(treeMap, 6, "Line Loopback");
        elAttributeMaps.put(string2, treeMap);
    }

    public static void initializeDs3XM12(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3XM_12_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "FEAC Loopback");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3XM(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3XM_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "FEAC Line Loop Code");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3xm12Ds1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3XM12DS1.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = OOS_ADMIN_STATE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.initializeOosAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "ESF");
        ElementDefaults.putAttribute(treeMap, 1, "D4");
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO FRAME");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".allFdlModes";
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "ESF");
        ElementDefaults.putAttribute(treeMap, 1, "D4");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".t1403FdlModeOnly";
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO FRAME");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "B8ZS");
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "FEAC Loopback");
        ElementDefaults.putAttribute(treeMap, 2, "Payload Loopback");
        ElementDefaults.putAttribute(treeMap, 6, "Line Loopback");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 131, "0 - 131 ft");
        ElementDefaults.putAttribute(treeMap, 262, "132 - 262 ft");
        ElementDefaults.putAttribute(treeMap, 393, "263 - 393 ft");
        ElementDefaults.putAttribute(treeMap, 524, "394 - 524 ft");
        ElementDefaults.putAttribute(treeMap, 655, "525 - 655 ft");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + FDL_MODE_MASK_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "T1.403");
        ElementDefaults.putAttribute(treeMap, 1, "BFDL");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + FDL_T1_403_ONLY_MODE_MASK_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "T1.403");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3xmDs1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3XMDS1.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "FEAC Line Loop Code");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology, boolean bl) {
        String string = "DS1_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 1, "B8ZS");
        } else {
            ElementDefaults.putAttribute(treeMap, 2, "HDB3");
        }
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "ESF");
            ElementDefaults.putAttribute(treeMap, 1, "D4");
        } else {
            ElementDefaults.putAttribute(treeMap, 3, "E1_MF");
            ElementDefaults.putAttribute(treeMap, 2, "E1_CRC");
        }
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO PROVISION FMT");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".detected";
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "ESF");
            ElementDefaults.putAttribute(treeMap, 1, "D4");
        } else {
            ElementDefaults.putAttribute(treeMap, 3, "E1_MF");
            ElementDefaults.putAttribute(treeMap, 2, "E1_CRC");
        }
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 14, "UNKNOWN");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".defaults";
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 0, "ESF");
            ElementDefaults.putAttribute(treeMap, 1, "D4");
        } else {
            ElementDefaults.putAttribute(treeMap, 3, "E1_MF");
            ElementDefaults.putAttribute(treeMap, 2, "E1_CRC");
        }
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 131, "0 - 131 ft");
        ElementDefaults.putAttribute(treeMap, 262, "132 - 262 ft");
        ElementDefaults.putAttribute(treeMap, 393, "263 - 393 ft");
        ElementDefaults.putAttribute(treeMap, 524, "394 - 524 ft");
        ElementDefaults.putAttribute(treeMap, 655, "525 - 655 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeCtxDs1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "CTXDS1.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eSendCode == null ? (class$cerent$cms$idl$Ds123Media$eSendCode = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eSendCode")) : class$cerent$cms$idl$Ds123Media$eSendCode).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 2, "Payload Loopback");
        ElementDefaults.putAttribute(treeMap, 6, "Line Loopback");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeE1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "E1N_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 2, "HDB3");
        ElementDefaults.putAttribute(treeMap, 3, "AMI");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "E1_MF");
        ElementDefaults.putAttribute(treeMap, 4, "E1_CRCMF");
        ElementDefaults.putAttribute(treeMap, 17, "E1_UNFRAMED");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "0 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeE3(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "E3_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3i(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3I_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        treeMap = new TreeMap();
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO PROVISION FMT");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".detected";
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 14, "UNKNOWN");
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3e(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3E_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO PROVISION FMT");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".detected";
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 14, "UNKNOWN");
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeDs3Ec1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DS3_EC1_48_LINE_CARD.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineCoding == null ? (class$cerent$cms$idl$Ds123Media$eLineCoding = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineCoding")) : class$cerent$cms$idl$Ds123Media$eLineCoding).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 6, "B3ZS");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        ElementDefaults.putAttribute(treeMap, 13, "AUTO PROVISION FMT");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$Ds123Media$eLineType == null ? (class$cerent$cms$idl$Ds123Media$eLineType = ElementDefaults.class$("cerent.cms.idl.Ds123Media.eLineType")) : class$cerent$cms$idl$Ds123Media$eLineType).getName() + ".detected";
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 14, "UNKNOWN");
        ElementDefaults.putAttribute(treeMap, 5, "UNFRAMED");
        ElementDefaults.putAttribute(treeMap, 10, "C BIT");
        ElementDefaults.putAttribute(treeMap, 8, "M13");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        ElementDefaults.putAttribute(treeMap, 5, "[FEAC] Facility (Line)");
        elAttributeMaps.put(string2, treeMap);
        string2 = string + LINE_LENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 225, "0 - 225 ft");
        ElementDefaults.putAttribute(treeMap, 450, "226 - 450 ft");
        elAttributeMaps.put(string2, treeMap);
    }

    public static void initializeFcmr(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = FCMR_CARD_MODE;
        TreeMap treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 4, "Fibre Channel Line Rate");
        ElementDefaults.putAttribute(treeMap, 5, "Fibre Channel/FICON Enhanced");
        elAttributeMaps.put(string, treeMap);
        string = FCMR_CARD_MODE_ALLOWS_FICON;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "Fibre Channel/FICON Enhanced");
        elAttributeMaps.put(string, treeMap);
        string = FCMR_CARD_MODE_FORBIDS_FICON;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 4, "Fibre Channel Line Rate");
        elAttributeMaps.put(string, treeMap);
        string = (class$cerent$cms$idl$FCMedia$eFCMediaType == null ? (class$cerent$cms$idl$FCMedia$eFCMediaType = ElementDefaults.class$("cerent.cms.idl.FCMedia.eFCMediaType")) : class$cerent$cms$idl$FCMedia$eFCMediaType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Fibre Channel - 1 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 1, "Fibre Channel - 2 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 2, "FICON - 1 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 3, "FICON - 2 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 5, "Undefined");
        elAttributeMaps.put(string, treeMap);
        String string2 = "FCMR_NO_DIST_EXTN";
        string = string2 + (class$cerent$cms$idl$FCMedia$eFCMediaType == null ? (class$cerent$cms$idl$FCMedia$eFCMediaType = ElementDefaults.class$("cerent.cms.idl.FCMedia.eFCMediaType")) : class$cerent$cms$idl$FCMedia$eFCMediaType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Fibre Channel - 1 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 1, "Fibre Channel - 2 Gbps ISL");
        ElementDefaults.putAttribute(treeMap, 5, "Undefined");
        elAttributeMaps.put(string, treeMap);
        string = (class$cerent$cms$idl$FCMedia$eLinkRate == null ? (class$cerent$cms$idl$FCMedia$eLinkRate = ElementDefaults.class$("cerent.cms.idl.FCMedia.eLinkRate")) : class$cerent$cms$idl$FCMedia$eLinkRate).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "1 Gbps");
        ElementDefaults.putAttribute(treeMap, 2, "2 Gbps");
        ElementDefaults.putAttribute(treeMap, 0, "Unknown");
        ElementDefaults.putAttribute(treeMap, 3, "Unplugged");
        elAttributeMaps.put(string, treeMap);
        string = FCMR_ADMIN_STATE;
        treeMap = new TreeMap();
        ElementDefaults.initializeIsOosMtOosAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string, treeMap);
    }

    public static void initializeEther(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "ETHER.";
        String string2 = "ETHER10.";
        String string3 = "ETHER100.";
        String string4 = "ETHER1000.";
        String string5 = string2 + (class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "Auto");
        ElementDefaults.putAttribute(treeMap, 2, "10 Half");
        ElementDefaults.putAttribute(treeMap, 3, "10 Full");
        elAttributeMaps.put(string5, treeMap);
        string5 = string3 + (class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "Auto");
        ElementDefaults.putAttribute(treeMap, 2, "10 Half");
        ElementDefaults.putAttribute(treeMap, 3, "10 Full");
        ElementDefaults.putAttribute(treeMap, 4, "100 Half");
        ElementDefaults.putAttribute(treeMap, 5, "100 Full");
        elAttributeMaps.put(string5, treeMap);
        string5 = string4 + (class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "Auto");
        ElementDefaults.putAttribute(treeMap, 7, "1000 Full");
        elAttributeMaps.put(string5, treeMap);
        string5 = string + (class$cerent$cms$idl$EtherMedia$eMauType == null ? (class$cerent$cms$idl$EtherMedia$eMauType = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eMauType")) : class$cerent$cms$idl$EtherMedia$eMauType).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Down");
        ElementDefaults.putAttribute(treeMap, 1, "Auto");
        ElementDefaults.putAttribute(treeMap, 2, "10 Half");
        ElementDefaults.putAttribute(treeMap, 3, "10 Full");
        ElementDefaults.putAttribute(treeMap, 4, "100 Half");
        ElementDefaults.putAttribute(treeMap, 5, "100 Full");
        ElementDefaults.putAttribute(treeMap, 6, "1000 Half");
        ElementDefaults.putAttribute(treeMap, 7, "1000 Full");
        elAttributeMaps.put(string5, treeMap);
        string5 = string + (class$cerent$cms$idl$Epos$eBridgePortState == null ? (class$cerent$cms$idl$Epos$eBridgePortState = ElementDefaults.class$("cerent.cms.idl.Epos.eBridgePortState")) : class$cerent$cms$idl$Epos$eBridgePortState).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Unknown");
        ElementDefaults.putAttribute(treeMap, 1, "Disabled");
        ElementDefaults.putAttribute(treeMap, 2, "Blocking");
        ElementDefaults.putAttribute(treeMap, 3, "Listening");
        ElementDefaults.putAttribute(treeMap, 4, "Learning");
        ElementDefaults.putAttribute(treeMap, 5, "Forwarding");
        ElementDefaults.putAttribute(treeMap, 6, "Broken");
        elAttributeMaps.put(string5, treeMap);
        string5 = string + VLAN_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "--");
        ElementDefaults.putAttribute(treeMap, 1, "Tagged");
        ElementDefaults.putAttribute(treeMap, 2, "Untag");
        elAttributeMaps.put(string5, treeMap);
        string5 = string + ETHER_PRIORITY_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "0 (Low)");
        ElementDefaults.putAttribute(treeMap, 1, "1 (Low)");
        ElementDefaults.putAttribute(treeMap, 2, "2 (Low)");
        ElementDefaults.putAttribute(treeMap, 3, "3 (Low)");
        ElementDefaults.putAttribute(treeMap, 4, "4 (High)");
        ElementDefaults.putAttribute(treeMap, 5, "5 (High)");
        ElementDefaults.putAttribute(treeMap, 6, "6 (High)");
        ElementDefaults.putAttribute(treeMap, 7, "7 (High)");
        elAttributeMaps.put(string5, treeMap);
        string5 = string + ETHER_ENCAPSULATION_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "LEX");
        ElementDefaults.putAttribute(treeMap, 1, "Proprietary");
        elAttributeMaps.put(string5, treeMap);
        string5 = (class$cerent$cms$idl$EtherMedia$eGigEtherOptics == null ? (class$cerent$cms$idl$EtherMedia$eGigEtherOptics = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eGigEtherOptics")) : class$cerent$cms$idl$EtherMedia$eGigEtherOptics).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "unknown");
        ElementDefaults.putAttribute(treeMap, 1, "SX");
        ElementDefaults.putAttribute(treeMap, 2, "LX");
        ElementDefaults.putAttribute(treeMap, 3, "ZX");
        ElementDefaults.putAttribute(treeMap, 5, "CX");
        ElementDefaults.putAttribute(treeMap, 6, "CWDM-1470");
        ElementDefaults.putAttribute(treeMap, 7, "CWDM-1490");
        ElementDefaults.putAttribute(treeMap, 8, "CWDM-1510");
        ElementDefaults.putAttribute(treeMap, 9, "CWDM-1530");
        ElementDefaults.putAttribute(treeMap, 10, "CWDM-1550");
        ElementDefaults.putAttribute(treeMap, 11, "CWDM-1570");
        ElementDefaults.putAttribute(treeMap, 12, "CWDM-1590");
        ElementDefaults.putAttribute(treeMap, 13, "CWDM-1610");
        ElementDefaults.putAttribute(treeMap, 14, "ITU-1530.33");
        ElementDefaults.putAttribute(treeMap, 15, "ITU-1531.12");
        ElementDefaults.putAttribute(treeMap, 16, "ITU-1531.90");
        ElementDefaults.putAttribute(treeMap, 17, "ITU-1532.68");
        ElementDefaults.putAttribute(treeMap, 18, "ITU-1534.25");
        ElementDefaults.putAttribute(treeMap, 19, "ITU-1535.04");
        ElementDefaults.putAttribute(treeMap, 20, "ITU-1535.82");
        ElementDefaults.putAttribute(treeMap, 21, "ITU-1536.61");
        ElementDefaults.putAttribute(treeMap, 22, "ITU-1538.19");
        ElementDefaults.putAttribute(treeMap, 23, "ITU-1538.98");
        ElementDefaults.putAttribute(treeMap, 24, "ITU-1539.77");
        ElementDefaults.putAttribute(treeMap, 25, "ITU-1540.56");
        ElementDefaults.putAttribute(treeMap, 26, "ITU-1542.14");
        ElementDefaults.putAttribute(treeMap, 27, "ITU-1542.94");
        ElementDefaults.putAttribute(treeMap, 28, "ITU-1543.73");
        ElementDefaults.putAttribute(treeMap, 29, "ITU-1544.53");
        ElementDefaults.putAttribute(treeMap, 30, "ITU-1546.12");
        ElementDefaults.putAttribute(treeMap, 31, "ITU-1546.92");
        ElementDefaults.putAttribute(treeMap, 32, "ITU-1547.72");
        ElementDefaults.putAttribute(treeMap, 33, "ITU-1548.51");
        ElementDefaults.putAttribute(treeMap, 34, "ITU-1550.12");
        ElementDefaults.putAttribute(treeMap, 34, "ITU-1550.12");
        ElementDefaults.putAttribute(treeMap, 36, "ITU-1551.72");
        ElementDefaults.putAttribute(treeMap, 37, "ITU-1552.52");
        ElementDefaults.putAttribute(treeMap, 38, "ITU-1554.13");
        ElementDefaults.putAttribute(treeMap, 39, "ITU-1554.94");
        ElementDefaults.putAttribute(treeMap, 40, "ITU-1555.75");
        ElementDefaults.putAttribute(treeMap, 41, "ITU-1556.55");
        ElementDefaults.putAttribute(treeMap, 42, "ITU-1558.17");
        ElementDefaults.putAttribute(treeMap, 43, "ITU-1558.98");
        ElementDefaults.putAttribute(treeMap, 44, "ITU-1559.79");
        ElementDefaults.putAttribute(treeMap, 45, "ITU-1560.61");
        ElementDefaults.putAttribute(treeMap, 4, "not present");
        elAttributeMaps.put(string5, treeMap);
        string5 = (class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated == null ? (class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated = ElementDefaults.class$("cerent.cms.idl.EtherMedia.eFlowControlNegotiated")) : class$cerent$cms$idl$EtherMedia$eFlowControlNegotiated).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "No Flow Control");
        ElementDefaults.putAttribute(treeMap, 1, "Asym. Flow Control");
        ElementDefaults.putAttribute(treeMap, 2, "Local Asym. Flow Control");
        ElementDefaults.putAttribute(treeMap, 3, "Symm. Flow Control");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_PORT_MAX_SIZE;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1548, "1548");
        ElementDefaults.putAttribute(treeMap, 16384, "Jumbo");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_LOOPBACK_TYPE;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_ADMIN_STATE;
        treeMap = new TreeMap();
        ElementDefaults.initializeIsOosMtOosAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_TRANSPONDER_MODE;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "TX/RX");
        ElementDefaults.putAttribute(treeMap, 2, "TX Only");
        ElementDefaults.putAttribute(treeMap, 3, "RX Only");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_TRANSPONDER_PORT;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Port 1");
        ElementDefaults.putAttribute(treeMap, 2, "Port 2");
        ElementDefaults.putAttribute(treeMap, 3, "Port 3");
        ElementDefaults.putAttribute(treeMap, 4, "Port 4");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_WATER_MARKS;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Default");
        ElementDefaults.putAttribute(treeMap, 1, "Low Latency");
        ElementDefaults.putAttribute(treeMap, 2, "Custom");
        elAttributeMaps.put(string5, treeMap);
        string5 = G1000_PAYLOAD_TYPE;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "LEX-FCS-16");
        ElementDefaults.putAttribute(treeMap, 1, "LEX-FCS-32");
        elAttributeMaps.put(string5, treeMap);
        string5 = ETHER_LINK_DUPLEX;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Full");
        ElementDefaults.putAttribute(treeMap, 1, "Half");
        ElementDefaults.putAttribute(treeMap, 2, "Auto");
        elAttributeMaps.put(string5, treeMap);
        string5 = ETHER_LINK_SPEED;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "10 Mbps");
        ElementDefaults.putAttribute(treeMap, 1, "100 Mbps");
        ElementDefaults.putAttribute(treeMap, 3, "Auto");
        elAttributeMaps.put(string5, treeMap);
    }

    private static void initializeEC1(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "EC1.";
        String string2 = null;
        TreeMap<Integer, Attribute> treeMap = null;
        string2 = string + SONET_LINEBUILDOUT_STRING;
        treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(225), new Attribute("0 - 225", 225));
        treeMap.put(new Integer(450), new Attribute("226 - 450", 450));
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeSTM1E(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "STM1E_12_LINE_CARD.";
        String string2 = null;
        TreeMap<Integer, Attribute> treeMap = null;
        string2 = string + (class$cerent$cms$idl$SonetMedia$eStm1eMode == null ? (class$cerent$cms$idl$SonetMedia$eStm1eMode = ElementDefaults.class$("cerent.cms.idl.SonetMedia.eStm1eMode")) : class$cerent$cms$idl$SonetMedia$eStm1eMode).getName();
        treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("STM1", 0));
        treeMap.put(new Integer(1), new Attribute("E4 framed", 1));
        treeMap.put(new Integer(2), new Attribute("E4 unframed", 2));
        elAttributeMaps.put(string2, treeMap);
        string2 = STM1E_C2_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(0), new Attribute("Unequipped or supervisory-unequipped", 0));
        treeMap.put(new Integer(1), new Attribute("Equipped non specific", 1));
        treeMap.put(new Integer(2), new Attribute("TUG structure", 2));
        treeMap.put(new Integer(3), new Attribute("Locked TU", 3));
        treeMap.put(new Integer(4), new Attribute("Asyncronous mapping of 34368 kb/s or 44736 kb/s into the Container 3 (C3)", 4));
        treeMap.put(new Integer(18), new Attribute("Asyncronous mapping of 139264 kb/s into the Container 4 (C4)", 18));
        treeMap.put(new Integer(19), new Attribute("ATM mapping", 19));
        treeMap.put(new Integer(20), new Attribute("MAN (DQDB) mapping", 20));
        treeMap.put(new Integer(21), new Attribute("FDDI mapping", 21));
        treeMap.put(new Integer(254), new Attribute("Q181 test signal (TSS1 to TSS3) mapping", 254));
        treeMap.put(new Integer(255), new Attribute("VC-AIS", 255));
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initializeSonet(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = SONET_EQTYPE_STRING;
        String string2 = string + "." + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
        string2 = DECLARE_SD_BERLEVEL_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 5, "1E-5");
        ElementDefaults.putAttribute(treeMap, 6, "1E-6");
        ElementDefaults.putAttribute(treeMap, 7, "1E-7");
        ElementDefaults.putAttribute(treeMap, 8, "1E-8");
        ElementDefaults.putAttribute(treeMap, 9, "1E-9");
        elAttributeMaps.put(string2, treeMap);
        string2 = DECLARE_SF_BERLEVEL_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "1E-3");
        ElementDefaults.putAttribute(treeMap, 4, "1E-4");
        ElementDefaults.putAttribute(treeMap, 5, "1E-5");
        elAttributeMaps.put(string2, treeMap);
        string2 = PROTECTION_OP_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        ElementDefaults.putAttribute(treeMap, 6, "MANUAL TO PROTECT");
        ElementDefaults.putAttribute(treeMap, 5, "MANUAL TO WORKING");
        ElementDefaults.putAttribute(treeMap, 4, "FORCE TO PROTECT");
        ElementDefaults.putAttribute(treeMap, 3, "FORCE TO WORKING");
        ElementDefaults.putAttribute(treeMap, 1, "LOCKOUT OF PROTECT");
        elAttributeMaps.put(string2, treeMap);
        string2 = PROTECTION_OP_STRING_APS_CLEAR;
        treeMap = (TreeMap)treeMap.clone();
        ElementDefaults.putAttribute(treeMap, 8, "APS CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 2, "2-Fiber");
        ElementDefaults.putAttribute(treeMap, 3, "4-Fiber");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_CHANNEL_STATE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Act");
        ElementDefaults.putAttribute(treeMap, 1, "Stby");
        ElementDefaults.putAttribute(treeMap, 2, "PCA");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_LOCK_FULL;
        TreeMap treeMap2 = treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_FORCE_RING_FULL;
        TreeMap treeMap3 = treeMap = (TreeMap)treeMap2.clone();
        ElementDefaults.putAttribute(treeMap, 1, "LOCKOUT PROTECT SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_MAN_RING_FULL;
        TreeMap treeMap4 = treeMap = (TreeMap)treeMap3.clone();
        ElementDefaults.putAttribute(treeMap, 3, "FORCE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_EXER_RING_FULL;
        TreeMap treeMap5 = treeMap = (TreeMap)treeMap4.clone();
        ElementDefaults.putAttribute(treeMap, 5, "MANUAL RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_FULL;
        TreeMap treeMap6 = treeMap = (TreeMap)treeMap5.clone();
        ElementDefaults.putAttribute(treeMap, 7, "EXERCISE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_MAN_RING_MIN;
        TreeMap treeMap7 = treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_EXER_RING_MIN;
        TreeMap treeMap8 = treeMap = (TreeMap)treeMap7.clone();
        ElementDefaults.putAttribute(treeMap, 5, "MANUAL RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_2F_MIN;
        TreeMap treeMap9 = treeMap = (TreeMap)treeMap8.clone();
        ElementDefaults.putAttribute(treeMap, 7, "EXERCISE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_LOCK_FULL;
        TreeMap treeMap10 = treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_FORCE_SPAN_FULL;
        TreeMap treeMap11 = treeMap = (TreeMap)treeMap10.clone();
        ElementDefaults.putAttribute(treeMap, 1, "LOCKOUT PROTECT SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_FORCE_RING_FULL;
        TreeMap treeMap12 = treeMap = (TreeMap)treeMap11.clone();
        ElementDefaults.putAttribute(treeMap, 2, "FORCE SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_MAN_SPAN_FULL;
        TreeMap treeMap13 = treeMap = (TreeMap)treeMap12.clone();
        ElementDefaults.putAttribute(treeMap, 3, "FORCE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_MAN_RING_FULL;
        TreeMap treeMap14 = treeMap = (TreeMap)treeMap13.clone();
        ElementDefaults.putAttribute(treeMap, 4, "MANUAL SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_EXER_SPAN_FULL;
        TreeMap treeMap15 = treeMap = (TreeMap)treeMap14.clone();
        ElementDefaults.putAttribute(treeMap, 5, "MANUAL RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_EXER_RING_FULL;
        TreeMap treeMap16 = treeMap = (TreeMap)treeMap15.clone();
        ElementDefaults.putAttribute(treeMap, 6, "EXERCISE SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_FULL;
        TreeMap treeMap17 = treeMap = (TreeMap)treeMap16.clone();
        ElementDefaults.putAttribute(treeMap, 7, "EXERCISE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_MAN_SPAN_MIN;
        TreeMap treeMap18 = treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_MAN_RING_MIN;
        TreeMap treeMap19 = treeMap = (TreeMap)treeMap18.clone();
        ElementDefaults.putAttribute(treeMap, 4, "MANUAL SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_EXER_SPAN_MIN;
        TreeMap treeMap20 = treeMap = (TreeMap)treeMap19.clone();
        ElementDefaults.putAttribute(treeMap, 5, "MANUAL RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_EXER_RING_MIN;
        TreeMap treeMap21 = treeMap = (TreeMap)treeMap20.clone();
        ElementDefaults.putAttribute(treeMap, 6, "EXERCISE SPAN");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_MIN;
        TreeMap treeMap22 = treeMap = (TreeMap)treeMap21.clone();
        ElementDefaults.putAttribute(treeMap, 7, "EXERCISE RING");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_CLEAR;
        TreeMap treeMap23 = treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = BLSR_OP_STRING_4F_FULL_APS_CLEAR;
        treeMap = (TreeMap)treeMap17.clone();
        ElementDefaults.putAttribute(treeMap, 8, "APS CLEAR");
        elAttributeMaps.put(string2, treeMap);
        string2 = DECLARE_ALS_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disabled");
        ElementDefaults.putAttribute(treeMap, 1, "Auto Restart");
        ElementDefaults.putAttribute(treeMap, 2, "Manual Restart");
        ElementDefaults.putAttribute(treeMap, 3, "Manual Restart for Test");
        elAttributeMaps.put(string2, treeMap);
        string2 = DECLARE_ALS_MODE_FULL_RANGE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disabled");
        ElementDefaults.putAttribute(treeMap, 1, "Auto Restart");
        ElementDefaults.putAttribute(treeMap, 2, "Manual Restart");
        elAttributeMaps.put(string2, treeMap);
        string2 = DECLARE_ALS_MODE_RESTRICTED_RANGE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "Manual Restart for Test");
        elAttributeMaps.put(string2, treeMap);
    }

    private static void initCircuitSize(TreeMap treeMap, int n) {
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n);
        ElementDefaults.putAttribute(treeMap, n, iCircuitSize.getCircuitSizeString());
    }

    private static void initCircuitType(TreeMap treeMap, int n, TDMTerminology tDMTerminology) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ElementDefaults.putAttribute(treeMap, n, tDMTerminology.getCircuitTypeString(iCircuitType));
    }

    private static void initializeDwdm(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology, boolean bl) {
        String string = DECLARE_ALL_DATA_RATE_STRING;
        TreeMap treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "OC3");
        ElementDefaults.putAttribute(treeMap, 1, "OC12");
        ElementDefaults.putAttribute(treeMap, 2, "OC48");
        ElementDefaults.putAttribute(treeMap, 3, "OC192");
        ElementDefaults.putAttribute(treeMap, 4, "STM1");
        ElementDefaults.putAttribute(treeMap, 5, "STM4");
        ElementDefaults.putAttribute(treeMap, 6, "STM16");
        ElementDefaults.putAttribute(treeMap, 7, "STM64");
        ElementDefaults.putAttribute(treeMap, 8, "1G Ethernet");
        ElementDefaults.putAttribute(treeMap, 9, "10G Ethernet");
        ElementDefaults.putAttribute(treeMap, 10, "1G FC");
        ElementDefaults.putAttribute(treeMap, 11, "2G FC");
        ElementDefaults.putAttribute(treeMap, 12, "ESCON");
        ElementDefaults.putAttribute(treeMap, 13, "DV6000");
        ElementDefaults.putAttribute(treeMap, 14, "SDI/D1 Video");
        ElementDefaults.putAttribute(treeMap, 15, "HDTV");
        ElementDefaults.putAttribute(treeMap, 16, "Pass Through");
        ElementDefaults.putAttribute(treeMap, 18, "1G FICON");
        ElementDefaults.putAttribute(treeMap, 19, "2G FICON");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MXP_10G_FRAMING_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 1, "SDH");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MXP_10E_FRAMING_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 1, "SDH");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MXP_10G_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 2, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 6, "SDH");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10G_FRAMING_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 1, "SDH");
        ElementDefaults.putAttribute(treeMap, 2, "Ethernet");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10E_FRAMING_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 1, "SDH");
        ElementDefaults.putAttribute(treeMap, 2, "Ethernet");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10G_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "SONET (including 10G Ethernet WAN Phy)");
        ElementDefaults.putAttribute(treeMap, 7, "SDH");
        ElementDefaults.putAttribute(treeMap, 9, "10G Ethernet LAN Phy");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10E_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "SONET (including 10G Ethernet WAN Phy)");
        ElementDefaults.putAttribute(treeMap, 7, "SDH");
        ElementDefaults.putAttribute(treeMap, 9, "10G Ethernet LAN Phy");
        ElementDefaults.putAttribute(treeMap, 17, "10G Fiber Channel");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_FRAMING_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, SONET_EQTYPE_STRING);
        ElementDefaults.putAttribute(treeMap, 1, "SDH");
        ElementDefaults.putAttribute(treeMap, 2, "Ethernet/Fiber Channel");
        ElementDefaults.putAttribute(treeMap, 3, "Fiber Channel");
        ElementDefaults.putAttribute(treeMap, 4, "Unframed");
        elAttributeMaps.put(string, treeMap);
        string = FULL_SET_FRAMING_TYPE_STRING;
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "OC3");
        ElementDefaults.putAttribute(treeMap, 1, "OC12");
        ElementDefaults.putAttribute(treeMap, 2, "OC48");
        ElementDefaults.putAttribute(treeMap, 4, "STM1");
        ElementDefaults.putAttribute(treeMap, 5, "STM4");
        ElementDefaults.putAttribute(treeMap, 6, "STM16");
        ElementDefaults.putAttribute(treeMap, 8, "1G Ethernet");
        ElementDefaults.putAttribute(treeMap, 10, "1G FC");
        ElementDefaults.putAttribute(treeMap, 11, "2G FC/ISC3");
        ElementDefaults.putAttribute(treeMap, 18, "1G FICON");
        ElementDefaults.putAttribute(treeMap, 19, "2G FICON/ISC3");
        ElementDefaults.putAttribute(treeMap, 12, "ESCON");
        ElementDefaults.putAttribute(treeMap, 13, "DV6000");
        ElementDefaults.putAttribute(treeMap, 14, "SDI/D1 Video");
        ElementDefaults.putAttribute(treeMap, 15, "HDTV");
        ElementDefaults.putAttribute(treeMap, 16, "Pass Through");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_FULL_SET_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "OC3");
        ElementDefaults.putAttribute(treeMap, 1, "OC12");
        ElementDefaults.putAttribute(treeMap, 2, "OC48");
        ElementDefaults.putAttribute(treeMap, 4, "STM1");
        ElementDefaults.putAttribute(treeMap, 5, "STM4");
        ElementDefaults.putAttribute(treeMap, 6, "STM16");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_TRANSPARENT_PAYLOAD_DATA_TYPE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 8, "1G Ethernet");
        ElementDefaults.putAttribute(treeMap, 10, "1G FC");
        ElementDefaults.putAttribute(treeMap, 11, "2G FC/ISC3");
        ElementDefaults.putAttribute(treeMap, 18, "1G FICON");
        ElementDefaults.putAttribute(treeMap, 19, "2G FICON/ISC3");
        ElementDefaults.putAttribute(treeMap, 12, "ESCON");
        ElementDefaults.putAttribute(treeMap, 13, "DV6000");
        ElementDefaults.putAttribute(treeMap, 14, "SDI/D1 Video");
        ElementDefaults.putAttribute(treeMap, 15, "HDTV");
        ElementDefaults.putAttribute(treeMap, 16, "Pass Through");
        elAttributeMaps.put(string, treeMap);
        string = PPM_SLOT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        ElementDefaults.putAttribute(treeMap, 150, "PPM (1 Port)");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10G_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 61, "SONET (including 10G Ethernet WAN Phy)");
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet LAN Phy");
        } else {
            ElementDefaults.putAttribute(treeMap, 61, "SDH");
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet");
        }
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10G_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 61, "SONET (including 10G Ethernet WAN Phy)");
        } else {
            ElementDefaults.putAttribute(treeMap, 61, "SDH");
        }
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10G_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet LAN Phy");
        } else {
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet");
        }
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10E_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 61, "SONET (including 10G Ethernet WAN Phy)");
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet LAN Phy");
        } else {
            ElementDefaults.putAttribute(treeMap, 61, "SDH");
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet");
        }
        ElementDefaults.putAttribute(treeMap, 178, "10G Fiber Channel");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10E_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 61, "SONET (including 10G Ethernet WAN Phy)");
        } else {
            ElementDefaults.putAttribute(treeMap, 61, SONET_EQTYPE_STRING);
        }
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_10E_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet LAN Phy");
        } else {
            ElementDefaults.putAttribute(treeMap, 168, "10G Ethernet");
        }
        ElementDefaults.putAttribute(treeMap, 178, "10G Fiber Channel");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        ElementDefaults.putAttribute(treeMap, 170, EntityModel.eqType2Name(tDMTerminology, eEqType.DV6000_PORT));
        ElementDefaults.putAttribute(treeMap, 169, EntityModel.eqType2Name(tDMTerminology, eEqType.ESCON_PORT));
        ElementDefaults.putAttribute(treeMap, 174, EntityModel.eqType2Name(tDMTerminology, eEqType.ETR_CLO_PORT));
        ElementDefaults.putAttribute(treeMap, 172, EntityModel.eqType2Name(tDMTerminology, eEqType.HDTV_PORT));
        ElementDefaults.putAttribute(treeMap, 194, EntityModel.eqType2Name(tDMTerminology, eEqType.ISC3_PORT));
        ElementDefaults.putAttribute(treeMap, 175, EntityModel.eqType2Name(tDMTerminology, eEqType.ISC_PORT));
        ElementDefaults.putAttribute(treeMap, 28, EntityModel.eqType2Name(tDMTerminology, eEqType.OC3_PORT));
        ElementDefaults.putAttribute(treeMap, 29, EntityModel.eqType2Name(tDMTerminology, eEqType.OC12_PORT));
        ElementDefaults.putAttribute(treeMap, 30, EntityModel.eqType2Name(tDMTerminology, eEqType.OC48_PORT));
        ElementDefaults.putAttribute(treeMap, 167, EntityModel.eqType2Name(tDMTerminology, eEqType.ONE_GE_PORT));
        ElementDefaults.putAttribute(treeMap, 179, EntityModel.eqType2Name(tDMTerminology, eEqType.FICON1G_PORT));
        ElementDefaults.putAttribute(treeMap, 176, EntityModel.eqType2Name(tDMTerminology, eEqType.FC1G_PORT));
        ElementDefaults.putAttribute(treeMap, 180, EntityModel.eqType2Name(tDMTerminology, eEqType.FICON2G_PORT));
        ElementDefaults.putAttribute(treeMap, 177, EntityModel.eqType2Name(tDMTerminology, eEqType.FC2G_PORT));
        ElementDefaults.putAttribute(treeMap, 173, EntityModel.eqType2Name(tDMTerminology, eEqType.PASS_THRU_PORT));
        ElementDefaults.putAttribute(treeMap, 171, EntityModel.eqType2Name(tDMTerminology, eEqType.SDI_D1_VIDEO_PORT));
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_FULL_SET_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        ElementDefaults.putAttribute(treeMap, 28, EntityModel.eqType2Name(tDMTerminology, eEqType.OC3_PORT));
        ElementDefaults.putAttribute(treeMap, 29, EntityModel.eqType2Name(tDMTerminology, eEqType.OC12_PORT));
        ElementDefaults.putAttribute(treeMap, 30, EntityModel.eqType2Name(tDMTerminology, eEqType.OC48_PORT));
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_TXP_2_5G_IS_OOS_MT_OOS_ADMIN_STATES_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 170, EntityModel.eqType2Name(tDMTerminology, eEqType.DV6000_PORT));
        ElementDefaults.putAttribute(treeMap, 169, EntityModel.eqType2Name(tDMTerminology, eEqType.ESCON_PORT));
        ElementDefaults.putAttribute(treeMap, 174, EntityModel.eqType2Name(tDMTerminology, eEqType.ETR_CLO_PORT));
        ElementDefaults.putAttribute(treeMap, 172, EntityModel.eqType2Name(tDMTerminology, eEqType.HDTV_PORT));
        ElementDefaults.putAttribute(treeMap, 194, EntityModel.eqType2Name(tDMTerminology, eEqType.ISC3_PORT));
        ElementDefaults.putAttribute(treeMap, 175, EntityModel.eqType2Name(tDMTerminology, eEqType.ISC_PORT));
        ElementDefaults.putAttribute(treeMap, 28, EntityModel.eqType2Name(tDMTerminology, eEqType.OC3_PORT));
        ElementDefaults.putAttribute(treeMap, 29, EntityModel.eqType2Name(tDMTerminology, eEqType.OC12_PORT));
        ElementDefaults.putAttribute(treeMap, 30, EntityModel.eqType2Name(tDMTerminology, eEqType.OC48_PORT));
        ElementDefaults.putAttribute(treeMap, 167, EntityModel.eqType2Name(tDMTerminology, eEqType.ONE_GE_PORT));
        ElementDefaults.putAttribute(treeMap, 179, EntityModel.eqType2Name(tDMTerminology, eEqType.FICON1G_PORT));
        ElementDefaults.putAttribute(treeMap, 176, EntityModel.eqType2Name(tDMTerminology, eEqType.FC1G_PORT));
        ElementDefaults.putAttribute(treeMap, 180, EntityModel.eqType2Name(tDMTerminology, eEqType.FICON2G_PORT));
        ElementDefaults.putAttribute(treeMap, 177, EntityModel.eqType2Name(tDMTerminology, eEqType.FC2G_PORT));
        ElementDefaults.putAttribute(treeMap, 173, EntityModel.eqType2Name(tDMTerminology, eEqType.PASS_THRU_PORT));
        ElementDefaults.putAttribute(treeMap, 171, EntityModel.eqType2Name(tDMTerminology, eEqType.SDI_D1_VIDEO_PORT));
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MXP_2_5G_10E_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        ElementDefaults.putAttribute(treeMap, 30, EntityModel.eqType2Name(tDMTerminology, eEqType.OC48_PORT));
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MXP_MR_2_5G_PORT_ASSIGNMENT_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "UNASSIGNED");
        ElementDefaults.putAttribute(treeMap, 167, "ONE_GE");
        ElementDefaults.putAttribute(treeMap, 179, "FICON1G ISL");
        ElementDefaults.putAttribute(treeMap, 176, "FC1G ISL");
        ElementDefaults.putAttribute(treeMap, 180, "FICON2G ISL");
        ElementDefaults.putAttribute(treeMap, 177, "FC2G ISL");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_GCC_RATE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "192k");
        ElementDefaults.putAttribute(treeMap, 1, "576k");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_WAVELENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "First Tunable Wavelength");
        ElementDefaults.putAttribute(treeMap, 1, "1530.33nm");
        ElementDefaults.putAttribute(treeMap, 2, "1531.12nm");
        ElementDefaults.putAttribute(treeMap, 3, "1531.90nm");
        ElementDefaults.putAttribute(treeMap, 4, "1532.68nm");
        ElementDefaults.putAttribute(treeMap, 5, "1534.25nm");
        ElementDefaults.putAttribute(treeMap, 6, "1535.04nm");
        ElementDefaults.putAttribute(treeMap, 7, "1535.82nm");
        ElementDefaults.putAttribute(treeMap, 8, "1536.61nm");
        ElementDefaults.putAttribute(treeMap, 9, "1538.19nm");
        ElementDefaults.putAttribute(treeMap, 10, "1538.98nm");
        ElementDefaults.putAttribute(treeMap, 11, "1539.77nm");
        ElementDefaults.putAttribute(treeMap, 12, "1540.56nm");
        ElementDefaults.putAttribute(treeMap, 13, "1542.14nm");
        ElementDefaults.putAttribute(treeMap, 14, "1542.94nm");
        ElementDefaults.putAttribute(treeMap, 15, "1543.73nm");
        ElementDefaults.putAttribute(treeMap, 16, "1544.53nm");
        ElementDefaults.putAttribute(treeMap, 17, "1546.12nm");
        ElementDefaults.putAttribute(treeMap, 18, "1546.92nm");
        ElementDefaults.putAttribute(treeMap, 19, "1547.72nm");
        ElementDefaults.putAttribute(treeMap, 20, "1548.51nm");
        ElementDefaults.putAttribute(treeMap, 21, "1550.12nm");
        ElementDefaults.putAttribute(treeMap, 22, "1550.92nm");
        ElementDefaults.putAttribute(treeMap, 23, "1551.72nm");
        ElementDefaults.putAttribute(treeMap, 24, "1552.52nm");
        ElementDefaults.putAttribute(treeMap, 25, "1554.13nm");
        ElementDefaults.putAttribute(treeMap, 26, "1554.94nm");
        ElementDefaults.putAttribute(treeMap, 27, "1555.75nm");
        ElementDefaults.putAttribute(treeMap, 28, "1556.55nm");
        ElementDefaults.putAttribute(treeMap, 29, "1558.17nm");
        ElementDefaults.putAttribute(treeMap, 30, "1558.98nm");
        ElementDefaults.putAttribute(treeMap, 31, "1559.79nm");
        ElementDefaults.putAttribute(treeMap, 32, "1560.61nm");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_REGEN_PEER_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "1");
        ElementDefaults.putAttribute(treeMap, 2, "2");
        ElementDefaults.putAttribute(treeMap, 3, "3");
        ElementDefaults.putAttribute(treeMap, 4, "4");
        ElementDefaults.putAttribute(treeMap, 5, "5");
        ElementDefaults.putAttribute(treeMap, 6, "6");
        ElementDefaults.putAttribute(treeMap, 12, "12");
        ElementDefaults.putAttribute(treeMap, 13, "13");
        ElementDefaults.putAttribute(treeMap, 14, "14");
        ElementDefaults.putAttribute(treeMap, 15, "15");
        ElementDefaults.putAttribute(treeMap, 16, "16");
        ElementDefaults.putAttribute(treeMap, 17, "17");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_W_L_BAND_WAVELENGTH_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "First Tunable Wavelength");
        ElementDefaults.putAttribute(treeMap, 1, "1530.33nm");
        ElementDefaults.putAttribute(treeMap, 2, "1531.12nm");
        ElementDefaults.putAttribute(treeMap, 3, "1531.90nm");
        ElementDefaults.putAttribute(treeMap, 4, "1532.68nm");
        ElementDefaults.putAttribute(treeMap, 5, "1534.25nm");
        ElementDefaults.putAttribute(treeMap, 6, "1535.04nm");
        ElementDefaults.putAttribute(treeMap, 7, "1535.82nm");
        ElementDefaults.putAttribute(treeMap, 8, "1536.61nm");
        ElementDefaults.putAttribute(treeMap, 9, "1538.19nm");
        ElementDefaults.putAttribute(treeMap, 10, "1538.98nm");
        ElementDefaults.putAttribute(treeMap, 11, "1539.77nm");
        ElementDefaults.putAttribute(treeMap, 12, "1540.56nm");
        ElementDefaults.putAttribute(treeMap, 13, "1542.14nm");
        ElementDefaults.putAttribute(treeMap, 14, "1542.94nm");
        ElementDefaults.putAttribute(treeMap, 15, "1543.73nm");
        ElementDefaults.putAttribute(treeMap, 16, "1544.53nm");
        ElementDefaults.putAttribute(treeMap, 17, "1546.12nm");
        ElementDefaults.putAttribute(treeMap, 18, "1546.92nm");
        ElementDefaults.putAttribute(treeMap, 19, "1547.72nm");
        ElementDefaults.putAttribute(treeMap, 20, "1548.51nm");
        ElementDefaults.putAttribute(treeMap, 21, "1550.12nm");
        ElementDefaults.putAttribute(treeMap, 22, "1550.92nm");
        ElementDefaults.putAttribute(treeMap, 23, "1551.72nm");
        ElementDefaults.putAttribute(treeMap, 24, "1552.52nm");
        ElementDefaults.putAttribute(treeMap, 25, "1554.13nm");
        ElementDefaults.putAttribute(treeMap, 26, "1554.94nm");
        ElementDefaults.putAttribute(treeMap, 27, "1555.75nm");
        ElementDefaults.putAttribute(treeMap, 28, "1556.55nm");
        ElementDefaults.putAttribute(treeMap, 29, "1558.17nm");
        ElementDefaults.putAttribute(treeMap, 30, "1558.98nm");
        ElementDefaults.putAttribute(treeMap, 31, "1559.79nm");
        ElementDefaults.putAttribute(treeMap, 32, "1560.61nm");
        ElementDefaults.putAttribute(treeMap, 33, "1577.44nm");
        ElementDefaults.putAttribute(treeMap, 34, "1577.86nm");
        ElementDefaults.putAttribute(treeMap, 35, "1578.27nm");
        ElementDefaults.putAttribute(treeMap, 36, "1578.69nm");
        ElementDefaults.putAttribute(treeMap, 37, "1579.10nm");
        ElementDefaults.putAttribute(treeMap, 38, "1579.52nm");
        ElementDefaults.putAttribute(treeMap, 39, "1579.93nm");
        ElementDefaults.putAttribute(treeMap, 40, "1580.35nm");
        ElementDefaults.putAttribute(treeMap, 41, "1580.77nm");
        ElementDefaults.putAttribute(treeMap, 42, "1581.18nm");
        ElementDefaults.putAttribute(treeMap, 43, "1581.60nm");
        ElementDefaults.putAttribute(treeMap, 44, "1582.02nm");
        ElementDefaults.putAttribute(treeMap, 45, "1582.44nm");
        ElementDefaults.putAttribute(treeMap, 46, "1582.85nm");
        ElementDefaults.putAttribute(treeMap, 47, "1583.27nm");
        ElementDefaults.putAttribute(treeMap, 48, "1583.69nm");
        ElementDefaults.putAttribute(treeMap, 49, "1584.11nm");
        ElementDefaults.putAttribute(treeMap, 50, "1584.53nm");
        ElementDefaults.putAttribute(treeMap, 51, "1584.95nm");
        ElementDefaults.putAttribute(treeMap, 52, "1585.36nm");
        ElementDefaults.putAttribute(treeMap, 53, "1585.78nm");
        ElementDefaults.putAttribute(treeMap, 54, "1586.20nm");
        ElementDefaults.putAttribute(treeMap, 55, "1586.62nm");
        ElementDefaults.putAttribute(treeMap, 56, "1587.04nm");
        ElementDefaults.putAttribute(treeMap, 57, "1587.46nm");
        ElementDefaults.putAttribute(treeMap, 58, "1587.88nm");
        ElementDefaults.putAttribute(treeMap, 59, "1588.30nm");
        ElementDefaults.putAttribute(treeMap, 60, "1588.73nm");
        ElementDefaults.putAttribute(treeMap, 61, "1589.15nm");
        ElementDefaults.putAttribute(treeMap, 62, "1589.57nm");
        ElementDefaults.putAttribute(treeMap, 63, "1589.99nm");
        ElementDefaults.putAttribute(treeMap, 64, "1590.41nm");
        ElementDefaults.putAttribute(treeMap, 65, "1590.83nm");
        ElementDefaults.putAttribute(treeMap, 66, "1591.26nm");
        ElementDefaults.putAttribute(treeMap, 67, "1591.68nm");
        ElementDefaults.putAttribute(treeMap, 68, "1592.10nm");
        ElementDefaults.putAttribute(treeMap, 69, "1592.52nm");
        ElementDefaults.putAttribute(treeMap, 70, "1592.95nm");
        ElementDefaults.putAttribute(treeMap, 71, "1593.37nm");
        ElementDefaults.putAttribute(treeMap, 72, "1593.79nm");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MAPPING_TYPE_MXP_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 3, "ODU Multiplex");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_MAPPING_TYPE_TXP_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 2, "Synch Mapping");
        ElementDefaults.putAttribute(treeMap, 1, "Asynch mapping");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_AIS_SQUELCH_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 1, "Ais");
        ElementDefaults.putAttribute(treeMap, 2, "Squelch");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_FEC_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disable");
        ElementDefaults.putAttribute(treeMap, 1, "Enable");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_EFEC_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disable");
        ElementDefaults.putAttribute(treeMap, 1, "Standard");
        ElementDefaults.putAttribute(treeMap, 2, "Enhanced");
        elAttributeMaps.put(string, treeMap);
        string = FEC_DISABLED_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disable");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_TERM_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Transparent");
        ElementDefaults.putAttribute(treeMap, 2, tDMTerminology.getGeneralTerms(2));
        elAttributeMaps.put(string, treeMap);
        string = FULL_SET_TERM_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Transparent");
        ElementDefaults.putAttribute(treeMap, 1, tDMTerminology.getGeneralTerms(3));
        ElementDefaults.putAttribute(treeMap, 2, tDMTerminology.getGeneralTerms(2));
        elAttributeMaps.put(string, treeMap);
        string = TRANSPARENT_LINE_TERM_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Transparent");
        ElementDefaults.putAttribute(treeMap, 2, tDMTerminology.getGeneralTerms(2));
        elAttributeMaps.put(string, treeMap);
        string = TRANSPARENT_SECTION_TERM_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Transparent");
        ElementDefaults.putAttribute(treeMap, 1, tDMTerminology.getGeneralTerms(3));
        elAttributeMaps.put(string, treeMap);
        string = TRANSPARENT_TERM_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Transparent");
        elAttributeMaps.put(string, treeMap);
        string = "DWDM." + (class$cerent$cms$idl$If$eLoopback == null ? (class$cerent$cms$idl$If$eLoopback = ElementDefaults.class$("cerent.cms.idl.If.eLoopback")) : class$cerent$cms$idl$If$eLoopback).getName();
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "None");
        ElementDefaults.putAttribute(treeMap, 1, "Terminal (Inward)");
        ElementDefaults.putAttribute(treeMap, 2, "Facility (Line)");
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_DWDM_CARD_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "UNDEFINED");
        ElementDefaults.putAttribute(treeMap, 1, "FC_GE");
        elAttributeMaps.put(string, treeMap);
        string = "DWDM." + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string, treeMap);
        string = DECLARE_NO_AUTO_ALS_MODE_STRING;
        treeMap = new TreeMap();
        ElementDefaults.putAttribute(treeMap, 0, "Disabled");
        ElementDefaults.putAttribute(treeMap, 2, "Manual Restart");
        ElementDefaults.putAttribute(treeMap, 3, "Manual Restart for Test");
        elAttributeMaps.put(string, treeMap);
    }

    private static void initializeCircuits(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology, boolean bl) {
        String string = CIRCUIT_SIZE_STRING;
        TreeMap treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.initCircuitSize(treeMap, 0);
            ElementDefaults.initCircuitSize(treeMap, 1);
            ElementDefaults.initCircuitSize(treeMap, 2);
            ElementDefaults.initCircuitSize(treeMap, 3);
            ElementDefaults.initCircuitSize(treeMap, 7);
            ElementDefaults.initCircuitSize(treeMap, 4);
            ElementDefaults.initCircuitSize(treeMap, 8);
            ElementDefaults.initCircuitSize(treeMap, 5);
            ElementDefaults.initCircuitSize(treeMap, 6);
        } else {
            ElementDefaults.initCircuitSize(treeMap, 10);
            ElementDefaults.initCircuitSize(treeMap, 11);
            ElementDefaults.initCircuitSize(treeMap, 12);
            ElementDefaults.initCircuitSize(treeMap, 13);
            ElementDefaults.initCircuitSize(treeMap, 14);
            ElementDefaults.initCircuitSize(treeMap, 15);
            ElementDefaults.initCircuitSize(treeMap, 16);
            ElementDefaults.initCircuitSize(treeMap, 17);
            ElementDefaults.initCircuitSize(treeMap, 18);
        }
        elAttributeMaps.put(string, treeMap);
        string = CIRCUIT_TYPE_STRING;
        treeMap = new TreeMap();
        if (bl) {
            ElementDefaults.initCircuitType(treeMap, 1, tDMTerminology);
            ElementDefaults.initCircuitType(treeMap, 2, tDMTerminology);
            ElementDefaults.initCircuitType(treeMap, 3, tDMTerminology);
        } else {
            ElementDefaults.initCircuitType(treeMap, 4, tDMTerminology);
            ElementDefaults.initCircuitType(treeMap, 5, tDMTerminology);
            ElementDefaults.initCircuitType(treeMap, 6, tDMTerminology);
        }
        elAttributeMaps.put(string, treeMap);
    }

    private static void initializeUcp(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        ElementDefaults.addMap(elAttributeMaps, ADMIN_STATE_STRING, adminState);
        ElementDefaults.addMap(elAttributeMaps, CRC_MODE_STRING, crcMode);
        ElementDefaults.addMap(elAttributeMaps, IPCC_TYPE_STRING, ipccType);
        ElementDefaults.addMap(elAttributeMaps, TNA_TYPE_STRING, tnaType);
        ElementDefaults.addMap(elAttributeMaps, UCP_CIRCUIT_STATE_STRING, ucpCircuitState);
    }

    private static void initializeAIC(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "AICEnvAlarm.";
        String string2 = string + (class$cerent$cms$idl$Equipment$eEnvAlrmType == null ? (class$cerent$cms$idl$Equipment$eEnvAlrmType = ElementDefaults.class$("cerent.cms.idl.Equipment.eEnvAlrmType")) : class$cerent$cms$idl$Equipment$eEnvAlrmType).getName();
        ElementDefaults.addMap(elAttributeMaps, string2, envAlarms);
        string2 = string + (class$cerent$cms$idl$Alarm$eSeverity == null ? (class$cerent$cms$idl$Alarm$eSeverity = ElementDefaults.class$("cerent.cms.idl.Alarm.eSeverity")) : class$cerent$cms$idl$Alarm$eSeverity).getName();
        ElementDefaults.addMap(elAttributeMaps, string2, alarmSeverities);
        string2 = string + (class$cerent$cms$idl$Equipment$eVirtWire == null ? (class$cerent$cms$idl$Equipment$eVirtWire = ElementDefaults.class$("cerent.cms.idl.Equipment.eVirtWire")) : class$cerent$cms$idl$Equipment$eVirtWire).getName();
        ElementDefaults.addMap(elAttributeMaps, string2, virtualWires);
        string = "AICControl.";
        string2 = string + (class$cerent$cms$idl$Equipment$eEnvCtrlMode == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlMode = ElementDefaults.class$("cerent.cms.idl.Equipment.eEnvCtrlMode")) : class$cerent$cms$idl$Equipment$eEnvCtrlMode).getName();
        ElementDefaults.addMap(elAttributeMaps, string2, ctrlModes);
        string2 = string + (class$cerent$cms$idl$Equipment$eEnvCtrlType == null ? (class$cerent$cms$idl$Equipment$eEnvCtrlType = ElementDefaults.class$("cerent.cms.idl.Equipment.eEnvCtrlType")) : class$cerent$cms$idl$Equipment$eEnvCtrlType).getName();
        ElementDefaults.addMap(elAttributeMaps, string2, ctrlTypes);
    }

    private static void initializeDcc(ElAttributeMaps elAttributeMaps, TDMTerminology tDMTerminology) {
        String string = "DCC.";
        String string2 = string + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        TreeMap treeMap = new TreeMap();
        ElementDefaults.initializeAdminStateMap(treeMap, tDMTerminology);
        elAttributeMaps.put(string2, treeMap);
    }

    public static String securityLevelToString(int n) {
        switch (n) {
            case 2: {
                return "Provisioning";
            }
            case 1: {
                return "Maintenance";
            }
            case 0: {
                return "Retrieve";
            }
            case 3: {
                return "Superuser";
            }
        }
        return "Unknown";
    }

    public static String securityLevelToString(SecurityLevel securityLevel) {
        return ElementDefaults.securityLevelToString(securityLevel.value());
    }

    public static String eqStateToString(eEqState eEqState2) {
        if (eEqState2 == null) {
            return null;
        }
        String string = "Unknown";
        switch (eEqState2.value()) {
            case 0: {
                string = "Not Present";
                break;
            }
            case 1: {
                string = "Mismatch";
                break;
            }
            case 2: {
                string = "Loading";
                break;
            }
            case 3: {
                string = "Failed";
                break;
            }
            case 4: {
                string = "Standby";
                break;
            }
            case 5: {
                string = "Active";
            }
        }
        return string;
    }

    public static String eqStateToOCNString(eEqState eEqState2) {
        String string = "Unknown";
        switch (eEqState2.value()) {
            case 0: {
                string = "Not Present";
                break;
            }
            case 1: {
                string = "Mismatch";
                break;
            }
            case 2: {
                string = "Loading";
                break;
            }
            case 3: {
                string = "Failed";
                break;
            }
            case 4: 
            case 5: {
                string = "Present";
            }
        }
        return string;
    }

    public static String getPortMediumString(int n) {
        return n != -1 ? EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetMedia$eMediumType == null ? (class$cerent$cms$idl$SonetMedia$eMediumType = ElementDefaults.class$("cerent.cms.idl.SonetMedia.eMediumType")) : class$cerent$cms$idl$SonetMedia$eMediumType))[n] : null;
    }

    private static void initializeAdminStateMap(TreeMap treeMap, TDMTerminology tDMTerminology) {
        AdminState[] adminStateArray = AdminState.getDefaultAdminStates(AdminState.isANSI(tDMTerminology));
        ElementDefaults.setAdminStateMap(treeMap, adminStateArray);
    }

    private static void initializeIsOosMtOosAdminStateMap(TreeMap treeMap, TDMTerminology tDMTerminology) {
        AdminState[] adminStateArray = AdminState.getAdminStatesNoAINS(AdminState.isANSI(tDMTerminology));
        ElementDefaults.setAdminStateMap(treeMap, adminStateArray);
    }

    private static void initializeIsOosAdminStateMap(TreeMap treeMap, TDMTerminology tDMTerminology) {
        AdminState[] adminStateArray = AdminState.getAdminStatesIS_DSBLD(AdminState.isANSI(tDMTerminology));
        ElementDefaults.setAdminStateMap(treeMap, adminStateArray);
    }

    private static void initializeOosAdminStateMap(TreeMap treeMap, TDMTerminology tDMTerminology) {
        AdminState[] adminStateArray = AdminState.getAdminStatesDSBLD(AdminState.isANSI(tDMTerminology));
        ElementDefaults.setAdminStateMap(treeMap, adminStateArray);
    }

    private static void setAdminStateMap(TreeMap treeMap, AdminState[] adminStateArray) {
        for (int i = 0; i < adminStateArray.length; ++i) {
            ElementDefaults.putAttribute(treeMap, adminStateArray[i].getAdminStateEnum().value(), adminStateArray[i].toString());
        }
    }

    public static String protectionOpToString(int n) {
        return n != -1 ? protectionOpStrings[n] : null;
    }

    public static String protectionOpStringForOnePlusOneOpt(int n) {
        String string = n == 1 || n == 2 ? PROTECTION_OP_STRING_LOCKOUT_OF_SWITCHING : (n != -1 ? protectionOpStrings[n] : null);
        return string;
    }

    public static int protectionOpFromString(String string) {
        for (int i = 0; i < protectionOpStrings.length; ++i) {
            if (protectionOpStrings[i] != string) continue;
            return i;
        }
        return -1;
    }

    public static void addMap(AttributeMaps attributeMaps, String string, String[] stringArray) {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            ElementDefaults.putAttribute(treeMap, i, stringArray[i]);
        }
        attributeMaps.put(string, treeMap);
    }

    public static String[] getPmColumnNames(int n, TDMTerminology tDMTerminology) {
        return ElementDefaults.getPmColumnNames(n, tDMTerminology, true);
    }

    public static String[] getPmColumnNames(int n, TDMTerminology tDMTerminology, boolean bl) {
        int n2 = 5;
        switch (n) {
            case 12: {
                if (!bl) break;
                n2 = 5;
                break;
            }
            case 9: 
            case 106: 
            case 157: {
                if (!bl) break;
                n2 = 7;
                break;
            }
            case 10: 
            case 85: {
                if (!bl) break;
                n2 = 9;
                break;
            }
            default: {
                if (!bl) break;
                n2 = 13;
            }
        }
        String[] stringArray = new String[n2 + 1];
        try {
            stringArray[0] = "Port ";
            stringArray[1] = tDMTerminology.getPmStat(1);
            stringArray[2] = tDMTerminology.getPmStat(2);
            stringArray[3] = tDMTerminology.getPmStat(3);
            stringArray[4] = tDMTerminology instanceof SDHTDMTerminology ? tDMTerminology.getPmStat(5) : tDMTerminology.getPmStat(0);
            stringArray[5] = tDMTerminology.getPmStat(9);
            if (6 < n2) {
                stringArray[6] = tDMTerminology.getPmStat(14);
                stringArray[7] = tDMTerminology.getPmStat(15);
            }
            if (8 < n2) {
                stringArray[8] = tDMTerminology.getPmStat(16);
                stringArray[9] = tDMTerminology.getPmStat(17);
            }
            if (10 < n2) {
                stringArray[10] = tDMTerminology.getPmStat(18);
                stringArray[11] = tDMTerminology.getPmStat(19);
                stringArray[12] = tDMTerminology.getPmStat(20);
                stringArray[13] = tDMTerminology.getPmStat(21);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static short getMaxBuckets(int n) {
        switch (n) {
            case 0: {
                return 32;
            }
            case 1: {
                return 7;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 24;
            }
        }
        return 0;
    }

    public static Attribute getAttributeForCardOperMode(ModuleModel moduleModel, String string) {
        return ElementDefaults.getAttributeMap(moduleModel).getAttributeForVal(string, moduleModel.getCardOperMode().value());
    }

    public static String getCardOperModeString(ModuleModel moduleModel) {
        return ElementDefaults.getAttributeMap(moduleModel).getAttributeForVal(DECLARE_DWDM_CARD_MODE_STRING, moduleModel.getCardOperMode().value()).getKey();
    }

    public static ProvisionError getProvisionError(xProvisionError xProvisionError2, TDMTerminology tDMTerminology) {
        EID eID = null;
        Object[] objectArray = null;
        switch (xProvisionError2.dataError.value()) {
            case 1: {
                eID = EMC.EID_NO_PARENT_ENTITY;
                break;
            }
            case 2: {
                eID = EMC.EID_NO_PARENT_PPM;
                break;
            }
            case 3: {
                eID = EMC.EID_UNSUPPORTED_EQTYPE;
                break;
            }
            case 4: {
                eID = EMC.EID_INVALID_PPM_PORT;
                break;
            }
            case 5: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = new Object[]{"Trunk port", AdminState.getAdminTermIS(tDMTerminology)};
                break;
            }
            case 6: {
                eID = EMC.EID_HAS_REGENERATION;
                break;
            }
            case 7: {
                eID = EMC.EID_OUT_OF_MEMORY;
                break;
            }
            case 9: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = new Object[]{"Port", AdminState.getAdminTermIS(tDMTerminology)};
                break;
            }
            case 10: {
                eID = EMC.EID_PORT_PRESENT;
                break;
            }
            case 11: {
                eID = EMC.EID_USED_AS_CLOCK_SOURCE;
                break;
            }
            case 12: {
                eID = EMC.EID_DCC_GCC_PRESENT;
                break;
            }
            case 14: {
                eID = EMC.EID_HAS_PROTECTION;
                break;
            }
            case 15: {
                eID = EMC.EID_HAS_OVERHEAD_CIRCUIT;
                break;
            }
            case 16: {
                eID = EMC.EID_INVALID_OTN_MODE;
                break;
            }
            case 17: {
                eID = EMC.EID_PORT_IN_LOOPBACK;
                break;
            }
            case 18: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = new Object[]{"Trunk port", "not " + AdminState.getAdminTermDSBLD(tDMTerminology)};
                break;
            }
            case 19: {
                eID = EMC.EID_PORT_ADMIN_STATE_PARAM_2;
                objectArray = new Object[]{"Protect trunk port", AdminState.getAdminTermIS(tDMTerminology)};
                break;
            }
            default: {
                return xProvisionError2.message.length() != 0 ? new ProvisionError(xProvisionError2.message) : new ProvisionError((UserException)xProvisionError2);
            }
        }
        return new ProvisionError(eID, objectArray);
    }

    protected ElementDefaults() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        FULL_SET_ADMIN_STATE = "DWDM." + (class$cerent$cms$idl$Common$eAdminState == null ? (class$cerent$cms$idl$Common$eAdminState = ElementDefaults.class$("cerent.cms.idl.Common.eAdminState")) : class$cerent$cms$idl$Common$eAdminState).getName();
        PROVISIONED_COLOR = new Color(205, 205, 255);
        MAJOR_ALARM_COLOR = Color.orange;
        MINOR_ALARM_COLOR = Color.yellow;
        CRITICAL_ALARM_COLOR = Color.red;
        DELETED_COLOR = Color.lightGray;
        IS_COLOR = Color.green;
        OOS_MT_COLOR = Color.cyan;
        IS_AINS_COLOR = new Color(180, 180, 255);
        OOS_DSBLD_COLOR = Color.lightGray;
        PRE_PROVISION_BG = PROVISIONED_COLOR;
        PRE_PROVISION_FG = Color.black;
        DELETED_BG = DELETED_COLOR;
        DELETED_FG = Color.black;
        SELECTION_BG = new Color(79, 101, 125);
        SELECTION_FG = Color.white;
        CIRCUIT_SIZE_STRING = "circuitSize";
        CIRCUIT_TYPE_STRING = "circuitType";
        moduleOps = new String[]{"Reset", "Clear", "Lock Out", "Lock On", "Switch", "Upgrade Span", "Test LEDs", "Unlock", "Lock Duplex", "Unlock Duplex"};
        adminState = new String[]{"Up", "Down"};
        crcMode = new String[]{"16-Bit", "32-Bit"};
        ipccType = new String[]{"SDCC", "Routed"};
        tnaType = new String[]{"IPv4", "IPv6", "NSAP"};
        ucpCircuitState = new String[]{"Closed", "Opening", "Wait_CC", "Retry", "Listening", "Open_Pending", "Clearing", "Open", "Failed"};
        protStates = new String[]{"Normal", "Locked On", "Locked Out", "Switched", "Upgrading", "Locked"};
        envAlarms = new String[]{null, "Compressor Failure", "Air Cond Fail", "Air Dryer Fail", "Battery Discharge", "Battery Fail", "Cool Fan Fail", "Ctrl PwrMaj fail", "Ctrl PwrMin fail", "Engine fail", "Engine Operating", "Explosive Gas", "Fire Detector fail", "Fire", "Flood", "Fuse Fail", "Generator Fail", "High airflow", "High Humidity", "High Temp", "High water", "Intrusion", "Low Batt", "Low fuel", "Low Humidity", "Low Cable Press", "Low Temp", "Low Water", "Misc", "Open Door", "Comm. Pwr Fail", "Pump Fail", "48 Power supp fail", "Rectifier fail", "Rectifier high volt", "Rectifier low volt", "Smoke", "Toxic gas", "Ventilation fail"};
        alarmSeverities = new String[]{"Not Reported", "Not Alarmed", "Minor", "Major", "Critical"};
        virtualWires = new String[]{"None", "Wire 1", "Wire 2", "Wire 3", "Wire 4"};
        ctrlModes = new String[]{"Auto ", "Manual Open", "Manual Closed", "Momentary Closed"};
        ctrlTypes = new String[]{null, "Air conditioning", "Engine", "Fan", "Generator", "Heat", "Light", "Miscellaneous", "Sprinkler"};
        dccStrings = EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetMedia$eDccSubChannel == null ? (class$cerent$cms$idl$SonetMedia$eDccSubChannel = ElementDefaults.class$("cerent.cms.idl.SonetMedia.eDccSubChannel")) : class$cerent$cms$idl$SonetMedia$eDccSubChannel));
        for (n = 0; n < dccStrings.length; ++n) {
            ElementDefaults.dccStrings[n] = dccStrings[n].substring(4);
        }
        owStrings = EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetTopology$eOwireSubChannel == null ? (class$cerent$cms$idl$SonetTopology$eOwireSubChannel = ElementDefaults.class$("cerent.cms.idl.SonetTopology.eOwireSubChannel")) : class$cerent$cms$idl$SonetTopology$eOwireSubChannel));
        for (n = 0; n < owStrings.length; ++n) {
            ElementDefaults.owStrings[n] = owStrings[n].substring(11);
        }
        protectionOpStrings = EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetTopology$eProtectionOp == null ? (class$cerent$cms$idl$SonetTopology$eProtectionOp = ElementDefaults.class$("cerent.cms.idl.SonetTopology.eProtectionOp")) : class$cerent$cms$idl$SonetTopology$eProtectionOp));
        PM_INTERVAL_TYPES = new Attribute[]{new Attribute("15 min", 0), new Attribute("1 day", 1), new Attribute("1 min", 2), new Attribute("1 hour", 3)};
        CURR_PREV_60_COLUMN_NAMES = new String[61];
        PREV_60_COLUMN_NAMES = new String[60];
        ElementDefaults.CURR_PREV_60_COLUMN_NAMES[0] = "Curr";
        ElementDefaults.PREV_60_COLUMN_NAMES[0] = "Prev";
        ElementDefaults.CURR_PREV_60_COLUMN_NAMES[1] = "Prev";
        for (n = 1; n < PREV_60_COLUMN_NAMES.length; ++n) {
            ElementDefaults.CURR_PREV_60_COLUMN_NAMES[n + 1] = ElementDefaults.PREV_60_COLUMN_NAMES[n] = "Prev-" + n;
        }
        db = new SDebug("ElementDefaults");
    }
}

