/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetTopology.Blsr;
import cerent.cms.idl.SonetTopology.Element;
import cerent.cms.idl.SonetTopology.OnePlusOne;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.YCable;
import cerent.cms.idl.SonetTopology.eDetectionGuardTimer;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.idl.SonetTopology.eRecoveryGuardTimer;
import cerent.cms.idl.SonetTopology.eVerifyGuardTimer;
import cerent.cms.idl.SonetTopology.sBlsrItem;
import cerent.cms.idl.SonetTopology.sBlsrLimits;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.SonetTopology.sBlsrProvisionHolder;
import cerent.cms.idl.SonetTopology.sOnePlusOneItem;
import cerent.cms.idl.SonetTopology.sOnePlusOneProvision;
import cerent.cms.idl.SonetTopology.sUnprotectedLineItem;
import cerent.cms.idl.SonetTopology.sYCableItem;
import cerent.cms.idl.SonetTopology.sYCableProvision;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xDropsExceedMax;
import cerent.cms.idl.SonetTopology.xNoMoreVtCapableSts;
import cerent.cms.idl.SonetTopology.xProvisionError;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractElementModels;
import cerent.cms.model.BlsrLimits;
import cerent.cms.model.BlsrModel;
import cerent.cms.model.BlsrProvisionFactory;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsNoSuchElementException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.DwdmModuleModel;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.IBlsrLimits;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreVtCapableSts;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PoolModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnprotectedLineModel;
import cerent.cms.model.YCableModel;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.UserException;

public class ElementModelsDelegate
extends AbstractElementModels
implements IElementModels {
    public static final boolean VERSION_2_1 = true;
    private NodeModelDelegate nmd;
    private Map elementModels = new HashMap();
    private CreateOnePlusOne createOnePlusOne;
    private BlsrLimitsCV blsrLimits;
    private CreateYCable createYCable;
    private CreateBlsr createBlsr;
    private FindElement findElement;
    private ElementType elementType;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection elementModelsDelegateSingletons;
    BLSRList blsrList;
    UnprotectedLineList unprotectedLineList;
    OnePlusOneList onePlusOneList;
    YCableList yCableList;
    private static final String MY_DEBUG_KEY = "EMD";
    static /* synthetic */ Class class$cerent$cms$model$ElementModelsDelegate;
    static /* synthetic */ Class class$cerent$cms$idl$SonetTopology$eElementType;
    static /* synthetic */ Class class$cerent$cms$idl$Equipment$eEqType;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    public static synchronized ElementModelsDelegate getInstance(NodeModelDelegate nodeModelDelegate) {
        ElementModelsDelegate elementModelsDelegate;
        if (elementModelsDelegateSingletons == null) {
            elementModelsDelegateSingletons = ModelSingletonCollection.getMSCInstanceByName("ElementModelsDelegate");
        }
        if ((elementModelsDelegate = (ElementModelsDelegate)elementModelsDelegateSingletons.get(nodeModelDelegate)) == null) {
            elementModelsDelegate = new ElementModelsDelegate(nodeModelDelegate);
            elementModelsDelegateSingletons.add(nodeModelDelegate, elementModelsDelegate);
        }
        return elementModelsDelegate;
    }

    private ElementModelsDelegate(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$ElementModelsDelegate == null ? (class$cerent$cms$model$ElementModelsDelegate = ElementModelsDelegate.class$("cerent.cms.model.ElementModelsDelegate")) : class$cerent$cms$model$ElementModelsDelegate));
        this.nmd = nodeModelDelegate;
        this.db = new EMDDebug(nodeModelDelegate.db);
        this.index = 0;
        this.createOnePlusOne = new CreateOnePlusOne("ElementModels.createOnePlusOne");
        this.blsrLimits = new BlsrLimitsCV("ElementModels.blsrLimits");
        this.createYCable = new CreateYCable("ElementModels.createYCable");
        this.createBlsr = new CreateBlsr("ElementModels.createBlsr");
        this.findElement = new FindElement("ElementModels.findElement");
        this.elementType = new ElementType("ElementModels.elementType");
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IllegalArgumentException {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " init() entry");
        }
        super.init0();
        Map map = this.elementModels;
        synchronized (map) {
            ElementModelFactory elementModelFactory = new ElementModelFactory(this.nmd);
            this.elementModels = elementModelFactory.getElements();
        }
        this.initElementModels();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectTopologyElementList, 0, (Observer)this);
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " init() exit");
        }
        if (this.db.on()) {
            map = this.getBlsrLimits();
            this.db.println("ElementModelsDelegate says the max_num_blsr is " + map.getMaxBlsr() + " and max_4F is " + map.getMax4FBlsr() + " and max nodes in 2f ring is " + map.getMaxNodesIn2FiberRing() + " and max nodes in 4f ring is " + map.getMaxNodesIn4FiberRing());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " dispose(): entry");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectTopologyElementList, 0, (Observer)this);
            this.dispatcher = null;
        }
        Map map2 = this.elementModels;
        synchronized (map2) {
            map = this.elementModels;
            this.elementModels = new HashMap();
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ElementModel elementModel = (ElementModel)entry.getValue();
            iterator.remove();
            elementModel.destroy();
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public Element getElementRef(int n) {
        try {
            return (Element)this.findElement.get(new Integer(n));
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getElementRef", userException);
        }
    }

    private void initElementModels() {
        Iterator iterator = this.elementModels.values().iterator();
        while (iterator.hasNext()) {
            ((ElementModel)iterator.next()).init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementModel findElementModel(int n) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " findElementModel( " + Integer.toHexString(n) + " )");
        }
        Map map = this.elementModels;
        synchronized (map) {
            return this.findElementModel(this.elementModels.values(), n);
        }
    }

    private ElementModel findElementModel(Collection collection, int n) {
        if (this.db.on) {
            this.db.println("findElementModel( " + collection + ", " + Integer.toHexString(n) + " )");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            if (!elementModel.referencesEntityIndex(n)) continue;
            if (this.db.on) {
                this.db.println("findElementModel(...): exit [FOUND " + elementModel.toString() + "]");
            }
            return elementModel;
        }
        if (this.db.on) {
            this.db.println("findElementModel(...): exit [NO MATCH FOUND]");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel getElementModel(PoolModel poolModel) throws CmsNoSuchElementException {
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                if (!elementModel.containsPool(poolModel)) continue;
                return elementModel;
            }
        }
        throw new CmsNoSuchElementException("ElementModel does not exist for pool=" + poolModel + " on node=" + this.nmd.getHostName() + ".");
    }

    public ElementModel getElementModel(int n) throws CmsNoSuchElementException {
        ElementModel elementModel;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getElementModel( " + Integer.toHexString(n) + " )");
        }
        if ((elementModel = this.findElementModel(n)) != null) {
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " getElementModel() -> " + elementModel.toString());
            }
            return elementModel;
        }
        if (this.db.on()) {
            this.db.println(this.nmd.dbName() + " getElementModel() NO MATCH FOUND!");
        }
        throw new CmsNoSuchElementException("ElementModel does not exist for index=" + Integer.toHexString(n) + " on node=" + this.nmd.getHostName() + ".");
    }

    public ElementModel getElementModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getElementModel() for entityModel=" + iEntityModel.toString());
        }
        return this.getElementModel(iEntityModel.getEntityIndex());
    }

    public IElementModel getIElementModel(IEntityModel iEntityModel) throws AbstractCmsNoSuchElementException {
        return this.getElementModel(iEntityModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel getElementModel(String string) {
        Map map = this.elementModels;
        synchronized (map) {
            Collection collection = this.elementModels.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    ElementModel elementModel = (ElementModel)iterator.next();
                    if (!string.equals(elementModel.getName())) continue;
                    return elementModel;
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!this.db.on()) continue;
                    this.db.println("no such entity in getElementModel");
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementModel[] getElementArray() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getElementArray()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            return this.elementModels.values().toArray(new ElementModel[0]);
        }
    }

    public Set getElementsOfType(eElementType eElementType2) {
        return this.getElementsOfType(eElementType2.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getElementsOfType(int n) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        eElementType eElementType2 = eElementType.from_int(n);
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getElementsOfType(" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetTopology$eElementType == null ? (class$cerent$cms$idl$SonetTopology$eElementType = ElementModelsDelegate.class$("cerent.cms.idl.SonetTopology.eElementType")) : class$cerent$cms$idl$SonetTopology$eElementType))[eElementType2.value()] + "): entry");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    if (eElementType2.value() != elementModel.getType()) continue;
                    hashSet.add(elementModel);
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!this.db.on()) continue;
                    this.db.println("Element no longer exists");
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
            }
        }
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + " getElementsOfType(): list", hashSet);
            this.db.println(this.nmd.dbName() + " getElementsOfType(" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetTopology$eElementType == null ? (class$cerent$cms$idl$SonetTopology$eElementType = ElementModelsDelegate.class$("cerent.cms.idl.SonetTopology.eElementType")) : class$cerent$cms$idl$SonetTopology$eElementType))[eElementType2.value()] + "): exit");
        }
        return hashSet;
    }

    public Set getEntitiesOfType(int n) {
        return this.getEntitiesOfType(eElementType.from_int(n));
    }

    public Set getEntitiesOfType(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getEntitiesOfType()");
        }
        return this.toEntities(this.getElementsOfType(eElementType2));
    }

    public Set getUnprotectedLineElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getUnprotectedLineElements(): entry");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        this.getSortedModels(this.elementModels, hashSet, hashSet2, hashSet3, hashSet4);
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getUnprotectedLineElements()", hashSet3);
            this.db.println(this.nmd.dbName() + "getUnprotectedLineElements(): exit");
        }
        return hashSet3;
    }

    public Set getUnprotectedLineEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getUnprotectedLineEntities()");
        }
        return this.toEntities(this.getUnprotectedLineElements());
    }

    public Set getOnePlusOneElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneElements(): entry");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        this.getSortedModels(this.elementModels, hashSet, hashSet2, hashSet3, hashSet4);
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getOnePlusOneElements(): list", hashSet);
            this.db.println(this.nmd.dbName() + "getOnePlusOneElements(): exit");
        }
        return hashSet;
    }

    public Set getOnePlusOneEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneEntities()");
        }
        return this.toEntities(this.getOnePlusOneElements());
    }

    public Set getYCableElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getYCableElements(): entry");
        }
        Set set = this.getElementsOfType(eElementType.Y_CABLE);
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getYCableElements(): list", set);
            this.db.println(this.nmd.dbName() + "getYCableElements(): exit");
        }
        return set;
    }

    public Set getYCableEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getYCableEntities()");
        }
        return this.toEntities(this.getYCableElements());
    }

    public Set getBlsrElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrElements(): entry");
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        this.getSortedModels(this.elementModels, hashSet, hashSet2, hashSet3, hashSet4);
        if (this.db.on) {
            this.debugDump(this.nmd.dbName() + "getBlsrElements(): list", hashSet4);
            this.db.println(this.nmd.dbName() + "getBlsrElements(): exit");
        }
        return hashSet4;
    }

    public Set getBlsrEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrEntities()");
        }
        return this.toEntities(this.getBlsrElements());
    }

    public Set getElementsOfEntityType(int n) {
        return this.getElementsOfEntityType(eEqType.from_int(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getElementsOfEntityType(eEqType eEqType2) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getElementsOfEntityType(" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eEqType == null ? (class$cerent$cms$idl$Equipment$eEqType = ElementModelsDelegate.class$("cerent.cms.idl.Equipment.eEqType")) : class$cerent$cms$idl$Equipment$eEqType))[eEqType2.value()] + "): entry");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    if (this.db.on) {
                        this.db.println("element.getEntityEqType : " + elementModel.getEntityEqType());
                    }
                    if (eEqType2.value() != elementModel.getEntityEqType()) continue;
                    hashSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("no such entity in getElementsOfEntityType");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getElementsOfEntityType(" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Equipment$eEqType == null ? (class$cerent$cms$idl$Equipment$eEqType = ElementModelsDelegate.class$("cerent.cms.idl.Equipment.eEqType")) : class$cerent$cms$idl$Equipment$eEqType))[eEqType2.value()] + ")", hashSet);
        }
        return hashSet;
    }

    public IBlsrLimits getBlsrLimits() {
        BlsrLimits blsrLimits = null;
        sBlsrLimits sBlsrLimits2 = null;
        try {
            sBlsrLimits2 = (sBlsrLimits)this.blsrLimits.get();
            blsrLimits = new BlsrLimits(sBlsrLimits2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            blsrLimits = new BlsrLimits(null);
        }
        if (blsrLimits.wasNullBlsrLimits()) {
            this.db.severe("Got a null BLSR limits");
        }
        return blsrLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getOpticalElements() {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOpticalElements()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    eElementType eElementType2 = elementModel.getTypeEnum();
                    int n = elementModel.getEntityEqType();
                    if (eElementType2 != eElementType.BLSR_2_WIRE && eElementType2 != eElementType.BLSR_4_WIRE && eElementType2 != eElementType.ONE_PLUS_ONE && (eElementType2 != eElementType.UNPROTECTED_LINE || n != 28 && n != 29 && n != 30 && n != 61)) continue;
                    hashSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("no such entity in getOpticalElements");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) continue;
                    this.db.println("AbstractCmsIOException in getOpticalElements");
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getOpticalElements()", hashSet);
        }
        return hashSet;
    }

    public Set getSTM1EEntities() {
        return this.toNonProtectEntities(this.getElementsOfEntityType(eEqType.STM1E_PORT));
    }

    public Set getOpticalEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOpticalEntities()");
        }
        return this.toEntities(this.getOpticalElements());
    }

    public Set getNonProtectOpticalEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getNonProtectOpticalEntities()");
        }
        return this.toNonProtectEntities(this.getOpticalElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDwdmElements() {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getDwdmElements()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    eElementType eElementType2 = elementModel.getTypeEnum();
                    int n = elementModel.getEntityEqType();
                    if (eElementType2 != eElementType.Y_CABLE && eElementType2 != eElementType.SPLITTER && (eElementType2 != eElementType.UNPROTECTED_LINE || n != 122 && n != 123)) continue;
                    hashSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("no such entity in getDwdmElements");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.db.on()) continue;
                    this.db.println("AbstractCmsIOException in getDwdmElements");
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump("getDwdmElements()", hashSet);
        }
        return hashSet;
    }

    public Set getDwdmEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getDwdmEntities()");
        }
        return this.toEntities(this.getDwdmElements());
    }

    public Set getNonProtectDwdmEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getNonProtectDwdmEntities()");
        }
        return this.toNonProtectEntities(this.getDwdmElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getBlsrCapableElements(eElementType eElementType2) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrCapableElements()");
        }
        Map map = this.elementModels;
        synchronized (map) {
            Iterator iterator = this.elementModels.values().iterator();
            while (iterator.hasNext()) {
                ElementModel elementModel = (ElementModel)iterator.next();
                try {
                    int n = elementModel.getEntityEqType();
                    if ((n != 29 || eElementType2 != eElementType.BLSR_2_WIRE || this.nmd.getPlatform().is600()) && n != 30 && n != 61 || ((TdmPortModel)elementModel.getEntityModel()).isLdccTermination()) continue;
                    hashSet.add(elementModel);
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) continue;
                    this.db.println("no such entity in getBlsrCapableElements");
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "getBlsrCapableElements()", hashSet);
        }
        return hashSet;
    }

    public Set getBlsrCapableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrCapableEntities()");
        }
        return this.toEntities(this.getBlsrCapableElements(eElementType2));
    }

    private boolean isSlotDiversityRequired() {
        if (this.nmd.getPlatform().is600()) {
            return false;
        }
        return !this.getNodeModel().provides(Feature.UPSR_SLOTDIV_NR);
    }

    public Set getOnePlusOneAvailableWorkingElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableWorkingElements()");
        }
        Set set = this.getOpticalElements();
        set.retainAll(this.getUnprotectedLineElements());
        if (this.db.on()) {
            this.debugDump("getOnePlusOneAvailableWorkingElements()", set);
        }
        return set;
    }

    public Set getOnePlusOneAvailableElements(eOnePlusOneType eOnePlusOneType2) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        Set set = null;
        TdmPortModel tdmPortModel = null;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableElements()" + ": type=" + eOnePlusOneType2);
        }
        set = this.getOpticalElements();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            try {
                tdmPortModel = (TdmPortModel)elementModel.getEntityModel();
                if (tdmPortModel.isSonetDccTermination() || eOnePlusOneType2 == eOnePlusOneType.ONEPLUSONE_OPTIMIZED && (tdmPortModel.getEqType() != 28 || tdmPortModel.getPayloadType() != 7)) continue;
                hashSet.add(elementModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("getAvailableOnePlusOnePorts: Entity not found for index=" + tdmPortModel.getIndex());
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            catch (Exception exception) {
                if (!this.db.on()) continue;
                this.db.println(exception + "in getAvailableOnePlusOnePorts for Index=" + tdmPortModel.getIndex());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        hashSet.retainAll(this.getUnprotectedLineElements());
        if (this.db.on()) {
            this.debugDump("getOnePlusOneAvailableElements()", hashSet);
        }
        return hashSet;
    }

    public Set getOnePlusOneAvailableEntities(eOnePlusOneType eOnePlusOneType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneAvailableEntities()");
        }
        return this.toEntities(this.getOnePlusOneAvailableElements(eOnePlusOneType2));
    }

    private void filterTrunkRegenGroup(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IEntityModel iEntityModel = ((ElementModel)iterator.next()).getEntityModel();
                if (!(iEntityModel instanceof DwdmPortModel)) continue;
                DwdmModuleModel dwdmModuleModel = (DwdmModuleModel)iEntityModel.getModuleModel();
                if (((DwdmPortModel)iEntityModel).isClientPort() && (dwdmModuleModel == null || !dwdmModuleModel.hasRegenPeer() && dwdmModuleModel.getEqType() != 121 && dwdmModuleModel.getEqType() != 184)) continue;
                iterator.remove();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {}
        }
    }

    public Set getYCableAvailableElements() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getYCableAvailableElements()");
        }
        Set set = this.getDwdmElements();
        set.retainAll(this.getUnprotectedLineElements());
        this.filterTrunkRegenGroup(set);
        if (this.db.on()) {
            this.debugDump("getYCableAvailableElements()", set);
        }
        return set;
    }

    public Set getYCableAvailableEntities() {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getYCableAvailableEntities()");
        }
        return this.toEntities(this.getYCableAvailableElements());
    }

    public Set getAvailableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getAvailableEntities()");
        }
        switch (eElementType2.value()) {
            case 1: {
                return this.toEntities(this.getOnePlusOneAvailableWorkingElements());
            }
            case 4: {
                return this.toEntities(this.getYCableAvailableElements());
            }
            case 2: 
            case 3: {
                return this.toEntities(this.getBlsrAvailableElements(eElementType2));
            }
            case 0: {
                return this.toEntities(this.getUnprotectedLineElements());
            }
        }
        return null;
    }

    public Set getBlsrAvailableElements(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrAvailableElements()");
        }
        Set set = this.getBlsrCapableElements(eElementType2);
        int n = this.getNodeModel().getFramingType();
        if (n == 0) {
            set.retainAll(this.getUnprotectedSonetElements());
        } else {
            set.retainAll(this.getUnprotectedLineElements());
        }
        set = this.excludeUcpElements(set);
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "getBlsrAvailableElements()", set);
        }
        return set;
    }

    private Collection getUnprotectedSonetElements() {
        Set set = this.getUnprotectedLineElements();
        ArrayList<ElementModel> arrayList = new ArrayList<ElementModel>();
        if (set == null) {
            return new ArrayList();
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            try {
                if (elementModel.getEntityModel().getMediumType() != 1) continue;
                arrayList.add(elementModel);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        return arrayList;
    }

    public Set getBlsrAvailableEntities(eElementType eElementType2) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getBlsrAvailableEntities()");
        }
        return this.toEntities(this.getBlsrAvailableElements(eElementType2));
    }

    public Set getBlsrAvailableEntities(int n) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "Bridge for Blsr Wizard -- getBlsrAvailableEntities()");
        }
        return this.getBlsrAvailableEntities(eElementType.from_int(n));
    }

    public Set getOnePlusOneCompatibleElements(ElementModel elementModel) {
        Object object;
        Object object2;
        EntityModel entityModel;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "Entering 1+1 Compatible elements:" + elementModel.toString());
        }
        boolean bl = false;
        EntityModel entityModel2 = null;
        TdmLineModel tdmLineModel = null;
        int n = -1;
        EntityModel entityModel3 = null;
        try {
            n = elementModel.getEntityEqType();
            entityModel3 = (EntityModel)elementModel.getEntityModel();
            if (entityModel3 instanceof TdmPortModel) {
                entityModel = (TdmPortModel)entityModel3;
                tdmLineModel = entityModel.getTdmLineModel();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("no such entity in getOnePlusOneCompatibleElements");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return new HashSet();
        }
        entityModel = entityModel3.getAncestorOfType(eEqType.IO_SLOT);
        int[] nArray = ((IPortModel)entityModel3).getPortNum();
        List list = entityModel3.getAncestorOfType(eClass.E_MODULE).getChildren();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = (IPortModel)object3.next();
            if (ComparisonUtil.compare(object2.getPortNum(), nArray) == 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + "Skipping self.");
                continue;
            }
            try {
                object = this.getElementModel((IEntityModel)object2);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) continue;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                continue;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Testing sibling: " + ((ElementModel)object).toString());
            }
            if (((ElementModel)object).getType() != 1) continue;
            bl = true;
            try {
                entityModel2 = ((EntityModel)((OnePlusOneModel)object).getMainEntityModel()).getAncestorOfType(eEqType.IO_SLOT);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("no such entity in getMainEntityModel");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (!this.db.on) continue;
            this.db.println(this.nmd.dbName() + "Narrowing to:" + ((Object)entityModel2).toString());
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "Getting 1+1 available elements.");
        }
        object3 = this.getOnePlusOneAvailableWorkingElements();
        object2 = new HashSet();
        object = object3.iterator();
        while (object.hasNext()) {
            Model model;
            IPortModel iPortModel;
            boolean bl2 = true;
            ElementModel elementModel2 = (ElementModel)object.next();
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Testing candidate: " + elementModel2.toString());
            }
            EntityModel entityModel4 = null;
            try {
                if (elementModel2.getEntityEqType() != n) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + "Incompatible port type.");
                    continue;
                }
                entityModel4 = (EntityModel)elementModel2.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("no such entity in getEntityModel");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (entityModel4 == entityModel3) {
                if (!this.db.on()) continue;
                this.db.println(this.nmd.dbName() + "Excluding the port that we are retrieving on.");
                continue;
            }
            EntityModel entityModel5 = entityModel4.getAncestorOfType(eEqType.IO_SLOT);
            if (this.isSlotDiversityRequired()) {
                if (entityModel5 == entityModel) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + "Same slot.");
                    continue;
                }
                iPortModel = (IPortModel)entityModel4;
                if (ComparisonUtil.compare(iPortModel.getPortNum(), nArray) != 0) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + "Different port.");
                    continue;
                }
            }
            if (entityModel3 != null && entityModel4 instanceof TdmPortModel && (model = (iPortModel = (TdmPortModel)entityModel4).getTdmLineModel()) != null && model.getMediumType() != tdmLineModel.getMediumType()) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + "Incompatible port medium type.");
                continue;
            }
            if (this.isSlotDiversityRequired()) {
                if (n == 29) {
                    int n2 = entityModel3.getParent().getEqType();
                    int n3 = entityModel4.getParent().getEqType();
                    if (n2 == 85 && n3 != n2 || n2 == 10 && n3 == 85) continue;
                }
                if (n == 28) {
                    int n4 = entityModel3.getParent().getEqType();
                    int n5 = entityModel4.getParent().getEqType();
                    if (n4 == 106 && n5 != n4 || n4 == 9 && n5 == 106) continue;
                }
                if (bl) {
                    if (entityModel5 != entityModel2) {
                        if (!this.db.on) continue;
                        this.db.println(this.nmd.dbName() + "Not in same slot as basis' sibling's peer port.");
                        continue;
                    }
                } else {
                    List list2 = entityModel4.getAncestorOfType(eClass.E_MODULE).getChildren();
                    model = null;
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        block37: {
                            ElementModel elementModel3;
                            EntityModel entityModel6 = (EntityModel)iterator.next();
                            if (this.db.on) {
                                this.db.println(this.nmd.dbName() + " Testing candidate sibling " + entityModel6.toString());
                            }
                            try {
                                elementModel3 = this.getElementModel(entityModel6);
                            }
                            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                                if (!this.db.on()) continue;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                                continue;
                            }
                            if (elementModel3.getType() != 1) continue;
                            int n6 = ((TdmPortModel)entityModel6).getOnePlusOneProtectEntityIndex();
                            try {
                                model = (EntityModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n6).getParent();
                            }
                            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                if (!this.db.on) break block37;
                                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                            }
                        }
                        if (model == entityModel) continue;
                        bl2 = false;
                        if (!this.db.on) break;
                        this.db.println(this.nmd.dbName() + "Candidate has sibling with " + "peer in another slot.");
                        break;
                    }
                }
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + "Keep = " + bl2);
            }
            if (!bl2) continue;
            object2.add(elementModel2);
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "getOnePlusOneCompatibleElements()", (Collection)object2);
        }
        return object2;
    }

    public Set getOnePlusOneCompatibleEntities(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getOnePlusOneCompatibleEntities()");
        }
        return this.toEntities(this.getOnePlusOneCompatibleElements(elementModel));
    }

    public Set getOnePlusOneCompatibleEntities(IElementModel iElementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " getOnePlusOneCompatibleEntities()");
        }
        if (iElementModel instanceof ElementModel) {
            return this.toEntities(this.getOnePlusOneCompatibleElements((ElementModel)iElementModel));
        }
        return new HashSet();
    }

    public Set getYCableCompatibleElements(ElementModel elementModel) {
        Object object;
        Object object2;
        EntityModel entityModel;
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " **** Entering Y Cable Compatible elements:" + elementModel.toString());
        }
        boolean bl = false;
        EntityModel entityModel2 = null;
        DwdmCliLineModel dwdmCliLineModel = null;
        int n = -1;
        EntityModel entityModel3 = null;
        try {
            n = elementModel.getEntityEqType();
            entityModel3 = (EntityModel)elementModel.getEntityModel();
            if (entityModel3 instanceof DwdmPortModel && ((DwdmPortModel)(entityModel = (DwdmPortModel)entityModel3)).isClientPort()) {
                dwdmCliLineModel = (DwdmCliLineModel)((DwdmPortModel)entityModel).getDwdmLineModel();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                this.db.println("no such entity in getYCableCompatibleElements");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            return new HashSet();
        }
        entityModel = entityModel3.getAncestorOfType(eEqType.IO_SLOT);
        int[] nArray = ((IPortModel)entityModel3).getPortNum();
        List list = entityModel3.getAncestorOfType(eClass.E_MODULE).getChildren();
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (!(object2 instanceof IPortModel)) continue;
            object = (IPortModel)object2;
            if (ComparisonUtil.compare(object.getPortNum(), nArray) == 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Skipping self.");
                continue;
            }
            ElementModel elementModel2 = null;
            try {
                elementModel2 = this.getElementModel((IEntityModel)object);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                elementModel2 = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                elementModel2 = null;
            }
            if (elementModel2 == null) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Skipping non-existant element (" + object + ")");
                continue;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " >>>>> Testing sibling: " + elementModel2);
            }
            if (elementModel2.getType() != 4) continue;
            bl = true;
            try {
                entityModel2 = ((EntityModel)((YCableModel)elementModel2).getMainEntityModel()).getAncestorOfType(eEqType.IO_SLOT);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("no such entity in getMainEntityModel");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (!this.db.on) continue;
            this.db.println(this.nmd.dbName() + " Narrowing to:" + ((Object)entityModel2).toString());
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + " ***** Getting Y Cable available elements.");
        }
        object3 = this.getYCableAvailableElements();
        object2 = new HashSet();
        object = object3.iterator();
        while (object.hasNext()) {
            int n2;
            boolean bl2 = true;
            ElementModel elementModel3 = (ElementModel)object.next();
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Testing candidate: " + elementModel3.toString());
            }
            EntityModel entityModel4 = null;
            try {
                if (elementModel3.getEntityEqType() != n) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + " Incompatible port type.");
                    continue;
                }
                entityModel4 = (EntityModel)elementModel3.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) continue;
                this.db.println("no such entity in getEntityModel");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                continue;
            }
            if (entityModel4 == entityModel3) {
                if (!this.db.on()) continue;
                this.db.println(this.nmd.dbName() + "Excluding the port that we are retrieving on.");
                continue;
            }
            EntityModel entityModel5 = entityModel4.getAncestorOfType(eEqType.IO_SLOT);
            if (entityModel5 == entityModel) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Same slot.");
                continue;
            }
            IPortModel iPortModel = (IPortModel)entityModel4;
            if (ComparisonUtil.compare(iPortModel.getPortNum(), nArray) != 0) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Different port.");
                continue;
            }
            int n3 = entityModel3.getParent().getEqType();
            if (n3 != (n2 = entityModel4.getParent().getEqType())) {
                if (!this.db.on) continue;
                this.db.println(this.nmd.dbName() + " Incompatible card types.");
                continue;
            }
            if (bl) {
                if (entityModel5 != entityModel2) {
                    if (!this.db.on) continue;
                    this.db.println(this.nmd.dbName() + " Not in same slot as basis' sibling's peer port.");
                    continue;
                }
            } else {
                List list2 = entityModel4.getAncestorOfType(eClass.E_MODULE).getChildren();
                EntityModel entityModel6 = null;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    block37: {
                        EntityModel entityModel7 = (EntityModel)iterator.next();
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + " Testing candidate sibling " + entityModel7.toString());
                        }
                        ElementModel elementModel4 = null;
                        try {
                            elementModel4 = this.getElementModel(entityModel7);
                        }
                        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                            elementModel4 = null;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            elementModel4 = null;
                        }
                        if (elementModel4 == null) {
                            if (!this.db.on) continue;
                            this.db.println(this.nmd.dbName() + " Skipping non-existant element (" + entityModel7 + ")");
                            continue;
                        }
                        if (elementModel4.getType() != 4) continue;
                        int n4 = ((DwdmPortModel)entityModel7).getYCableProtectEntityIndex();
                        try {
                            entityModel6 = (EntityModel)this.nmd.getEntityTableModel().getEntityModelByIndex(n4).getParent();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!this.db.on) break block37;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                    if (entityModel6 == entityModel) continue;
                    bl2 = false;
                    if (!this.db.on) break;
                    this.db.println(this.nmd.dbName() + " Candidate has sibling with " + "peer in another slot.");
                    break;
                }
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + " Keep = " + bl2);
            }
            if (!bl2) continue;
            object2.add((ElementModel)elementModel3);
        }
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + " getYCableCompatibleElements() -> ", (Collection)object2);
        }
        return object2;
    }

    public Set getYCableCompatibleEntities(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "getYCableCompatibleEntities()");
        }
        return this.toEntities(this.getYCableCompatibleElements(elementModel));
    }

    public Set toEntities(ElementModel elementModel) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "toEntities() from=" + elementModel.toString());
        }
        hashSet.add(elementModel);
        if (this.db.on()) {
            this.debugDump(this.nmd.dbName() + "toEntities() to=", hashSet);
        }
        return this.toEntities(hashSet);
    }

    public Set excludeSDH(Set set) {
        HashSet<EntityModel> hashSet = new HashSet<EntityModel>();
        int n = this.getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EntityModel entityModel = (EntityModel)iterator.next();
            if (!(entityModel instanceof TdmPortModel)) continue;
            TdmPortModel tdmPortModel = (TdmPortModel)entityModel;
            TdmLineModel tdmLineModel = tdmPortModel.getTdmLineModel();
            if (iFramingType.getMediumType() != tdmLineModel.getMediumType()) continue;
            hashSet.add(entityModel);
        }
        if (this.db.on()) {
            this.debugDump("excludeSDH() exit=", hashSet);
        }
        return hashSet;
    }

    public Set excludeUcpElements(Set set) {
        HashSet<ElementModel> hashSet = new HashSet<ElementModel>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            if (!(elementModel instanceof ElementModel) || this.nmd.getUcpNodeModel().getUcpInterfaces().isUcpInterface(elementModel.getIndex())) continue;
            hashSet.add(elementModel);
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    public Set toEntities(Set var1_1, boolean var2_2) {
        var3_3 = new HashSet<IEntityModel>();
        if (this.db.on()) {
            this.debugDump("toEntities() from=", var1_1);
        }
        var5_4 = var1_1.iterator();
        block17: while (var5_4.hasNext()) {
            var4_5 = (ElementModel)var5_4.next();
            switch (var4_5.getType()) {
                case 0: {
                    try {
                        var3_3.add(((UnprotectedLineModel)var4_5).getMainEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_7) {
                        if (!this.db.on()) continue block17;
                        this.db.println("no such entity in toEntities/unprotected line");
                        SDebug.printStackTrace((Throwable)var6_7);
                    }
                    continue block17;
                }
                case 1: {
                    try {
                        var3_3.add(((OnePlusOneModel)var4_5).getMainEntityModel());
                        if (!var2_2) continue block17;
                        var3_3.add(((OnePlusOneModel)var4_5).getProtectEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_8) {
                        if (!this.db.on()) continue block17;
                        this.db.println("no such entity in toEntities/1+1");
                        SDebug.printStackTrace((Throwable)var6_8);
                    }
                    continue block17;
                }
                case 4: 
                case 5: {
                    try {
                        var3_3.add(((YCableModel)var4_5).getMainEntityModel());
                        if (!var2_2) continue block17;
                        var3_3.add(((YCableModel)var4_5).getProtectEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_9) {
                        if (!this.db.on()) continue block17;
                        this.db.println("no such entity in toEntities/1+1");
                        SDebug.printStackTrace((Throwable)var6_9);
                    }
                    continue block17;
                }
                case 3: {
                    try {
                        if (var2_2) {
                            var3_3.add(((BlsrModel)var4_5).getEastProtectEntityModel());
                            var3_3.add(((BlsrModel)var4_5).getWestProtectEntityModel());
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException var6_10) {
                        if (!this.db.on()) ** GOTO lbl60
                        this.db.println("no such entity in toEntities/blsr 2/4 wire");
                        SDebug.printStackTrace((Throwable)var6_10);
                    }
                }
lbl60:
                // 4 sources

                case 2: {
                    try {
                        var3_3.add(((BlsrModel)var4_5).getEastEntityModel());
                        var3_3.add(((BlsrModel)var4_5).getWestEntityModel());
                    }
                    catch (AbstractCmsNoSuchEntityException var6_11) {
                        if (!this.db.on()) continue block17;
                        this.db.println("no such entity in toEntities/blsr 2/4 wire");
                        SDebug.printStackTrace((Throwable)var6_11);
                    }
                    continue block17;
                }
            }
        }
        return var3_3;
    }

    public Set toNonProtectEntities(Set set) {
        return this.toEntities(set, false);
    }

    public Set toEntities(Set set) {
        return this.toEntities(set, true);
    }

    public boolean createOnePlusOne(int n, int n2, IRevertiveBehavior iRevertiveBehavior, boolean bl, String string) {
        sRevertiveBehavior sRevertiveBehavior2 = RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior);
        sOnePlusOneProvision sOnePlusOneProvision2 = new sOnePlusOneProvision(n, n2, sRevertiveBehavior2, bl, eOnePlusOneType.ONEPLUSONE_STANDARD, eVerifyGuardTimer.from_int(0), eRecoveryGuardTimer.from_int(0), eDetectionGuardTimer.from_int(0));
        try {
            OnePlusOne onePlusOne = this.createOnePlusOne(sOnePlusOneProvision2, string);
            return onePlusOne != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public OnePlusOne createOnePlusOne(sOnePlusOneProvision sOnePlusOneProvision2, String string) throws Busy, ProvisionError, NoMoreVtCapableSts, DropsExceedMax {
        try {
            Object[] objectArray = new Object[]{sOnePlusOneProvision2, string};
            return (OnePlusOne)this.createOnePlusOne.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2, new Boolean(xBusy2.usedAsClockSource));
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xNoMoreVtCapableSts xNoMoreVtCapableSts2) {
            throw new NoMoreVtCapableSts((UserException)xNoMoreVtCapableSts2);
        }
        catch (xDropsExceedMax xDropsExceedMax2) {
            throw new DropsExceedMax((UserException)xDropsExceedMax2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createOnePlusOne", userException);
        }
    }

    public YCable createYCable(sYCableProvision sYCableProvision2, String string) throws Busy, ProvisionError, NoMoreVtCapableSts {
        try {
            Object[] objectArray = new Object[]{sYCableProvision2, string};
            return (YCable)this.createYCable.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (xNoMoreVtCapableSts xNoMoreVtCapableSts2) {
            throw new NoMoreVtCapableSts((UserException)xNoMoreVtCapableSts2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createYCable", userException);
        }
    }

    public void createBlsr(sBlsrProvision sBlsrProvision2, eElementType eElementType2, String string) throws Busy, ProvisionError {
        try {
            Object[] objectArray = new Object[]{sBlsrProvision2, eElementType2, string};
            Blsr blsr = (Blsr)this.createBlsr.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createBlsr", userException);
        }
    }

    public void createBlsr(IBlsrProvision iBlsrProvision, int n, String string) throws Busy, ProvisionError {
        this.createBlsr(BlsrProvisionFactory.getBlsrProvision(iBlsrProvision), eElementType.from_int(n), string);
    }

    private void debugDump(String string, Collection collection) {
        this.db.println("---- " + string + " ----");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            this.db.println("        " + model.toString());
            this.db.println("          Observers:");
            model.printObservers();
        }
    }

    private synchronized void debugDumpHexIndexes(String string, Collection collection) {
        this.db.println("---- " + string + " ----");
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            String string2 = "        ";
            string2 = string2 + Integer.toHexString((Integer)iterator.next());
            while (iterator.hasNext()) {
                string2 = string2 + ", ";
                string2 = string2 + Integer.toHexString((Integer)iterator.next());
            }
            this.db.println(string2);
        }
        this.db.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpElementModels() {
        Map map = this.elementModels;
        synchronized (map) {
            this.debugDump("SONET Topology Elements for node " + this.nmd.dbName(), this.elementModels.values());
            this.db.println("---------------------------------\n");
        }
    }

    public synchronized void add(ElementModel elementModel) {
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "add(" + elementModel.toString() + ")");
        }
        if (elementModel != null) {
            this.elementModels.put(new Integer(elementModel.getIndex()), elementModel);
            this.dumpElementModels();
        }
    }

    public synchronized void remove(int n) {
        block4: {
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + "remove(" + Integer.toHexString(n) + "): entry");
            }
            try {
                this.remove(this.getElementModel(n));
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
        }
        this.dumpElementModels();
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "remove(" + Integer.toHexString(n) + "): exit");
        }
    }

    public void remove(ElementModel elementModel) {
        String string = "";
        if (this.db.on()) {
            if (elementModel != null) {
                try {
                    string = elementModel.toString();
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    string = "removed";
                }
                catch (NullPointerException nullPointerException) {
                    string = "removed";
                }
            } else {
                string = "null";
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + "remove(" + string + "): entry");
            }
        }
        this.internalRemove(elementModel);
        this.updateStructure();
        this.notifyObservers(ModelUpdateType.ADDED);
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "remove(" + string + "): exit");
        }
    }

    public void removeBlsr(IBlsrModel iBlsrModel) {
        if (iBlsrModel instanceof BlsrModel) {
            this.remove((BlsrModel)iBlsrModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemove(ElementModel elementModel) {
        String string = "";
        if (elementModel != null) {
            if (this.db.on()) {
                try {
                    string = elementModel.toString();
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    string = "removed";
                }
                catch (NullPointerException nullPointerException) {
                    string = "removed";
                }
                if (this.db.on) {
                    this.db.println(this.nmd.dbName() + "internalRemove(" + string + "): entry");
                }
            }
            Map map = this.elementModels;
            synchronized (map) {
                this.elementModels.remove(new Integer(elementModel.getIndex()));
            }
            elementModel.destroy();
            if (this.db.on()) {
                this.dumpElementModels();
            }
        } else if (this.db.on) {
            this.db.println(this.nmd.dbName() + "internalRemove(" + string + "): Element already removed.");
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "internalRemove(" + string + "): exit");
        }
    }

    protected void updateLocal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateStructure() {
        HashMap hashMap = new HashMap();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        HashSet hashSet6 = new HashSet();
        HashSet hashSet7 = new HashSet();
        HashSet hashSet8 = new HashSet();
        ElementModelFactory elementModelFactory = new ElementModelFactory(this.nmd);
        hashMap = elementModelFactory.getElements();
        this.getSortedModels(hashMap, hashSet2, hashSet4, hashSet6, hashSet8);
        this.getSortedModels(this.elementModels, hashSet, hashSet3, hashSet5, hashSet7);
        HashSet hashSet9 = new HashSet(hashSet2);
        hashSet9.removeAll(hashSet);
        HashSet hashSet10 = new HashSet(hashSet);
        hashSet10.removeAll(hashSet2);
        HashSet hashSet11 = new HashSet(hashSet4);
        hashSet11.removeAll(hashSet3);
        HashSet hashSet12 = new HashSet(hashSet3);
        hashSet12.removeAll(hashSet4);
        HashSet hashSet13 = new HashSet(hashSet6);
        hashSet13.removeAll(hashSet5);
        HashSet hashSet14 = new HashSet(hashSet5);
        hashSet14.removeAll(hashSet6);
        HashSet hashSet15 = new HashSet(hashSet8);
        hashSet15.removeAll(hashSet7);
        HashSet hashSet16 = new HashSet(hashSet7);
        hashSet16.removeAll(hashSet8);
        Map map = this.elementModels;
        synchronized (map) {
            this.deleteUpdate(hashSet10);
            this.deleteUpdate(hashSet12);
            this.deleteUpdate(hashSet14);
            this.deleteUpdate(hashSet16);
            this.addUpdate(hashSet9, hashMap);
            this.addUpdate(hashSet11, hashMap);
            this.addUpdate(hashSet13, hashMap);
            this.addUpdate(hashSet15, hashMap);
        }
        if (hashSet10.size() > 0 || hashSet12.size() > 0 || hashSet14.size() > 0 || hashSet16.size() > 0 || hashSet9.size() > 0 || hashSet11.size() > 0 || hashSet13.size() > 0 || hashSet15.size() > 0) {
            this.setChanged();
        }
    }

    private void getSortedModels(Map map, Set set, Set set2, Set set3, Set set4) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            if (elementModel instanceof BlsrModel) {
                set4.add(elementModel);
                continue;
            }
            if (elementModel instanceof OnePlusOneModel) {
                set.add(elementModel);
                continue;
            }
            if (elementModel instanceof YCableModel) {
                set2.add(elementModel);
                continue;
            }
            if (elementModel instanceof UnprotectedLineModel) {
                set3.add(elementModel);
                continue;
            }
            if (!this.db.on) continue;
            this.db.println("Wrong ElementType in list in ElementModels:ElementModelFactory::getSortedModels ");
        }
    }

    private void deleteUpdate(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                this.internalRemove((ElementModel)iterator.next());
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) continue;
                this.db.println("index already deleted in deleteUpdate");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void addUpdate(Set set, HashMap hashMap) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ElementModel elementModel = (ElementModel)iterator.next();
            Integer n = new Integer(elementModel.getIndex());
            if (elementModel != null) {
                this.elementModels.put(n, elementModel);
                elementModel.init();
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("Cannot find new added element in ElementModels:ElementModelFactory::addUpdate");
        }
    }

    public void update(Observable observable, Object object) {
        block14: {
            block13: {
                if (this.db.on) {
                    this.db.println(this.nmd.dbName() + "update(): entry");
                }
                if (!(observable instanceof CmsObservable)) break block13;
                int n = ((IObjectMessageInfo)object).getUpdateType();
                if (this.db.on) {
                    this.db.println(this.nmd.dbName() + "update(): Observable = " + observable.toString() + ", arg = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = ElementModelsDelegate.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
                }
                switch (n) {
                    case 0: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): this DELETED.  " + "Should not happen!!!!!");
                            break;
                        }
                        break block14;
                    }
                    case 1: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): this CHANGED.  " + "Should not happen!!!!!");
                            break;
                        }
                        break block14;
                    }
                    case 2: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): ADDED");
                        }
                        this.updateStructure();
                        this.notifyObservers(ModelUpdateType.ADDED);
                        break;
                    }
                    default: {
                        if (this.db.on) {
                            this.db.println(this.nmd.dbName() + "update(): UNKNOWN NE UPDATE TYPE = " + n);
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            if (this.db.on) {
                this.db.println(this.nmd.dbName() + "update(): Unrecognized Observable = " + observable.toString() + ", arg = " + object.toString());
            }
        }
        if (this.db.on) {
            this.db.println(this.nmd.dbName() + "update(): exit");
        }
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    private SonetFactory getSFRef() {
        return this.nmd.getIorRepository().getSonetFactoryRef();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class EMDDebug
    extends SDebug {
        EMDDebug(KDebug kDebug) {
            super(kDebug, ElementModelsDelegate.MY_DEBUG_KEY);
        }

        public final void dump() {
            ElementModelsDelegate.this.dumpElementModels();
            ElementModelsDelegate.this.db.println("Observers:");
            ElementModelsDelegate.this.printObservers();
        }
    }

    private class ElementModelFactory {
        NodeModelDelegate nmd;
        sBlsrItem[] blsrArray;
        sUnprotectedLineItem[] unprotectedArray;
        sOnePlusOneItem[] onePlusOneArray;
        sYCableItem[] yCableArray;
        HashMap elementsCache = new HashMap();

        public ElementModelFactory(NodeModelDelegate nodeModelDelegate) {
            this.nmd = nodeModelDelegate;
            ElementModelsDelegate.this.blsrList = new BLSRList("ElementModelsDelegate::ElementFactory::BLSRList");
            ElementModelsDelegate.this.unprotectedLineList = new UnprotectedLineList("ElementModelsDelegate::ElementFactory::UnprotectedLineList");
            ElementModelsDelegate.this.onePlusOneList = new OnePlusOneList("ElementModelsDelegate::ElementFactory::OnePlusOneList");
            ElementModelsDelegate.this.yCableList = new YCableList("ElementModelsDelegate::ElementFactory::YCableList");
        }

        private ElementModelFactory() {
        }

        private HashMap getElements() {
            try {
                this.blsrArray = (sBlsrItem[])ElementModelsDelegate.this.blsrList.get();
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                if (ElementModelsDelegate.this.db.on()) {
                    ElementModelsDelegate.this.db.println("NE doesn't support getBlsrList operation");
                }
            }
            catch (UserException userException) {
                SDebug cfr_ignored_0 = ElementModelsDelegate.this.db;
                SDebug.printStackTrace((Throwable)userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return this.elementsCache;
            }
            try {
                this.unprotectedArray = (sUnprotectedLineItem[])ElementModelsDelegate.this.unprotectedLineList.get();
                this.onePlusOneArray = (sOnePlusOneItem[])ElementModelsDelegate.this.onePlusOneList.get();
                this.yCableArray = (sYCableItem[])ElementModelsDelegate.this.yCableList.get();
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("unprotected length = " + this.unprotectedArray.length + "One plus one length = " + this.onePlusOneArray.length + "Y Cable length = " + this.yCableArray.length);
                }
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                if (ElementModelsDelegate.this.db.on()) {
                    ElementModelsDelegate.this.db.println("NE doesn't support getYCableList operation");
                }
            }
            catch (UserException userException) {
                SDebug cfr_ignored_1 = ElementModelsDelegate.this.db;
                SDebug.printStackTrace((Throwable)userException);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return this.elementsCache;
            }
            this.createElementsAndPutInCache();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.debugDumpHexIndexes("2.1 Elements", this.elementsCache.keySet());
                ElementModelsDelegate.this.db.println("Exit getElements()");
            }
            return this.elementsCache;
        }

        private void createElementsAndPutInCache() {
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Enter createElementsAndPutInCache()");
            }
            this.createBlsrElements();
            this.createUnprotectedElements();
            this.createOnePlusOneElements();
            this.createYCableElements();
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Exit createElementsAndPutInCache()");
            }
        }

        private void createBlsrElements() {
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Enter createBlsrElements()");
            }
            ElementModel elementModel = null;
            if (this.blsrArray == null) {
                return;
            }
            for (int i = 0; i < this.blsrArray.length; ++i) {
                int n = this.blsrArray[i].provision.eastPort;
                elementModel = ElementModelsDelegate.this.findElementModel(this.elementsCache.values(), n);
                if (elementModel != null) continue;
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Creating Blsr element with Index " + n);
                }
                try {
                    elementModel = new BlsrModel(this.nmd, n, this.blsrArray[i]);
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    if (ElementModelsDelegate.this.db.on) {
                        ElementModelsDelegate.this.db.println("Got Object not exist on BLSR");
                    }
                    elementModel = null;
                }
                if (elementModel == null) continue;
                this.elementsCache.put(new Integer(elementModel.getIndex()), elementModel);
            }
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Exit createBlsrElements()");
            }
        }

        private void createOnePlusOneElements() {
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Enter createOnePlusOneElements()");
            }
            ElementModel elementModel = null;
            for (int i = 0; i < this.onePlusOneArray.length; ++i) {
                int n = this.onePlusOneArray[i].provision.main;
                elementModel = ElementModelsDelegate.this.findElementModel(this.elementsCache.values(), n);
                if (elementModel != null) continue;
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Creating onePlusOne Index: " + n);
                }
                try {
                    elementModel = new OnePlusOneModel(this.nmd, n, this.onePlusOneArray[i]);
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    if (ElementModelsDelegate.this.db.on) {
                        ElementModelsDelegate.this.db.println("Got object not exist on One plus one");
                    }
                    elementModel = null;
                }
                if (elementModel == null) continue;
                this.elementsCache.put(new Integer(elementModel.getIndex()), elementModel);
            }
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Exit createOnePlusOneElements()");
            }
        }

        private void createYCableElements() {
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Enter createYCableElements()");
            }
            ElementModel elementModel = null;
            if (this.yCableArray == null) {
                return;
            }
            for (int i = 0; i < this.yCableArray.length; ++i) {
                int n = this.yCableArray[i].provision.main;
                elementModel = ElementModelsDelegate.this.findElementModel(this.elementsCache.values(), n);
                if (elementModel != null) continue;
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Creating YCable Index: " + n);
                }
                try {
                    elementModel = new YCableModel(this.nmd, n, this.yCableArray[i]);
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    if (ElementModelsDelegate.this.db.on) {
                        ElementModelsDelegate.this.db.println("Got object not exist on One plus one");
                    }
                    elementModel = null;
                }
                if (elementModel == null) continue;
                this.elementsCache.put(new Integer(elementModel.getIndex()), elementModel);
            }
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Exit createYCableElements()");
            }
        }

        private void createUnprotectedElements() {
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Enter createUnprotectedElements()");
            }
            ElementModel elementModel = null;
            for (int i = 0; i < this.unprotectedArray.length; ++i) {
                int n = this.unprotectedArray[i].provision.main;
                elementModel = ElementModelsDelegate.this.findElementModel(this.elementsCache.values(), n);
                if (elementModel != null) continue;
                if (ElementModelsDelegate.this.db.on) {
                    ElementModelsDelegate.this.db.println("Creating Unprotected Index: " + n);
                }
                try {
                    elementModel = new UnprotectedLineModel(this.nmd, n, this.unprotectedArray[i]);
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    if (ElementModelsDelegate.this.db.on) {
                        ElementModelsDelegate.this.db.println("Got CORBA not Exist for Unprotected");
                    }
                    elementModel = null;
                }
                if (elementModel == null) continue;
                this.elementsCache.put(new Integer(elementModel.getIndex()), elementModel);
            }
            if (ElementModelsDelegate.this.db.on) {
                ElementModelsDelegate.this.db.println("Exit createUnprotectedElements()");
            }
        }
    }

    private class YCableList
    extends NonCachedValue {
        public YCableList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getYCableList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class OnePlusOneList
    extends NonCachedValue {
        public OnePlusOneList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getOnePlusOneList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class UnprotectedLineList
    extends NonCachedValue {
        public UnprotectedLineList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getUnprotectedLineList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    private class BLSRList
    extends NonCachedValue {
        public BLSRList(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue() throws UserException {
            return this.getValue(null);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getBlsrList();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class ElementType
    extends NonCachedValue {
        public ElementType(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ((Element)object).type();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class FindElement
    extends NonCachedValue {
        public FindElement(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            return ElementModelsDelegate.this.getSFRef().getElement((Integer)object);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateBlsr
    extends NonCachedValue {
        public CreateBlsr(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createBlsr(new sBlsrProvisionHolder((sBlsrProvision)objectArray[0]), (eElementType)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateYCable
    extends NonCachedValue {
        public CreateYCable(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createYCable((sYCableProvision)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class BlsrLimitsCV
    extends CachedValue {
        public BlsrLimitsCV(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return ElementModelsDelegate.this.getSFRef().getBlsrLimits();
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }

    class CreateOnePlusOne
    extends NonCachedValue {
        public CreateOnePlusOne(String string) {
            super(ElementModelsDelegate.this.nmd, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return ElementModelsDelegate.this.getSFRef().createOnePlusOne((sOnePlusOneProvision)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return ElementModelsDelegate.this;
        }
    }
}

