/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.eEncapsulationType;
import cerent.cms.idl.Epos.sBridgePortAdminInfo;
import cerent.cms.idl.Epos.sBridgePortAdminInfo_2_2;
import cerent.cms.idl.Epos.sBridgePortInfo;
import cerent.cms.idl.Epos.xDuplicateCircuit;
import cerent.cms.idl.Epos.xDuplicateVlan;
import cerent.cms.idl.Epos.xNoMoreEtherCircuit;
import cerent.cms.idl.Epos.xNoMoreSpanningTree;
import cerent.cms.idl.Epos.xNoMoreVlan;
import cerent.cms.idl.Epos.xNoSuchCircuit;
import cerent.cms.idl.Epos.xNoSuchVlan;
import cerent.cms.idl.Epos.xVlanIdOutOfRange;
import cerent.cms.idl.Epos.xVlanInUse;
import cerent.cms.idl.Epos.xVlanNameTooLong;
import cerent.cms.idl.Epos.xVlanSpanningTreeViolation;
import cerent.cms.idl.Vlan.sVlanInfo;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DuplicateCircuit;
import cerent.cms.model.DuplicateVlan;
import cerent.cms.model.EtherPmModel;
import cerent.cms.model.EtherPortModel;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.Feature;
import cerent.cms.model.IBridgePortInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreEtherCircuit;
import cerent.cms.model.NoMoreSpanningTree;
import cerent.cms.model.NoMoreVlan;
import cerent.cms.model.NoSuchCircuit;
import cerent.cms.model.NoSuchVlan;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.SpanningTreeModel;
import cerent.cms.model.VlanIdOutOfRange;
import cerent.cms.model.VlanInUse;
import cerent.cms.model.VlanModel;
import cerent.cms.model.VlanNameTooLong;
import cerent.cms.model.VlanSpanningTreeViolation;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class EtherBridgeModel
extends Model
implements IEtherBridgeModel {
    private VlanList vlanList;
    private VlanInfoList vlanInfoList;
    private CreateVlan createVlan;
    private DeleteVlan deleteVlan;
    private FinalizePortProvisioning provAllPorts;
    private SpanningTreeList spanningTreeList;
    private CreateCircuit createCircuit;
    private ChangeCircuit changeCircuit;
    private DeleteCircuit deleteCircuit;
    private CreateCircuitTest createCircuitTest;
    private ChangeCircuitTest changeCircuitTest;
    private DeleteCircuitTest deleteCircuitTest;
    private PortInfo portInfo;
    private GetCircuitEndPorts getCircuitEndPorts;
    private VlanModelFromId vlanModelFromId;
    private VlanIdFromIndex vlanIdFromIndex;
    private NodeModelDelegate nmd;
    private Map vlanMap;
    private Map spanningTreeMap;
    private CreatePointToPointCircuitTest createPointToPointCircuitTest;
    private EtherPmModel etherPmModel;
    private EventDispatcher dispatcher;
    private static ModelSingletonCollection etherBridgeModelSingletons;
    static /* synthetic */ Class class$cerent$cms$model$EtherBridgeModel;
    static /* synthetic */ Class class$cerent$cms$idl$Event$eUpdateType;

    public static synchronized EtherBridgeModel getInstance(NodeModelDelegate nodeModelDelegate) {
        EtherBridgeModel etherBridgeModel;
        if (etherBridgeModelSingletons == null) {
            etherBridgeModelSingletons = ModelSingletonCollection.getMSCInstanceByName("EtherBridgeModel");
        }
        if ((etherBridgeModel = (EtherBridgeModel)etherBridgeModelSingletons.get(nodeModelDelegate)) == null) {
            etherBridgeModel = new EtherBridgeModel(nodeModelDelegate);
            etherBridgeModelSingletons.add(nodeModelDelegate, etherBridgeModel);
        }
        return etherBridgeModel;
    }

    private EtherBridgeModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$cerent$cms$model$EtherBridgeModel == null ? (class$cerent$cms$model$EtherBridgeModel = EtherBridgeModel.class$("cerent.cms.model.EtherBridgeModel")) : class$cerent$cms$model$EtherBridgeModel));
        this.nmd = nodeModelDelegate;
        this.index = 0;
        this.spanningTreeList = new SpanningTreeList(this.nmd, "EtherBridgeModel::spanningTreeList");
        this.vlanList = new VlanList(this.nmd, "EtherBridgeModel::vlanList");
        this.vlanInfoList = new VlanInfoList(this.nmd, "EtherBridgeModel::vlanInfoList");
        this.createVlan = new CreateVlan(this.nmd, "EtherBridgeModel::createVlan");
        this.deleteVlan = new DeleteVlan(this.nmd, "EtherBridgeModel::deleteVlan");
        this.provAllPorts = new FinalizePortProvisioning(this.nmd, "EtherBridgeModel::provAllPorts");
        this.createCircuit = new CreateCircuit(this.nmd, "EtherBridgeModel::createCircuit");
        this.changeCircuit = new ChangeCircuit(this.nmd, "EtherBridgeModel::changeCircuit");
        this.deleteCircuit = new DeleteCircuit(this.nmd, "EtherBridgeModel::deleteCircuit");
        this.createCircuitTest = new CreateCircuitTest(this.nmd, "EtherBridgeModel::createCircuit");
        this.changeCircuitTest = new ChangeCircuitTest(this.nmd, "EtherBridgeModel::changeCircuit");
        this.deleteCircuitTest = new DeleteCircuitTest(this.nmd, "EtherBridgeModel::deleteCircuit");
        this.getCircuitEndPorts = new GetCircuitEndPorts(this.nmd, "EtherBridgeModel::getCircuitEndPorts");
        this.portInfo = new PortInfo(this.nmd, "EtherBridgeModel::getPortInfo");
        this.createPointToPointCircuitTest = new CreatePointToPointCircuitTest(this.nmd, "EtherBridgeModel::createPointToPointCircuitTest");
        this.vlanModelFromId = new VlanModelFromId(this.nmd, "EtherBridgeModel::vlanModelFromId");
        this.vlanIdFromIndex = new VlanIdFromIndex(this.nmd, "EtherBridgeModel::vlanIdFromIndex");
        this.vlanMap = new TreeMap();
        this.spanningTreeMap = new TreeMap();
        this.etherPmModel = EtherPmModel.getInstance(this.nmd);
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::init");
        }
        Map map = this.vlanMap;
        synchronized (map) {
            this.discoverVlans(this.vlanMap);
            this.initializeVlans();
        }
        map = this.spanningTreeMap;
        synchronized (map) {
            this.discoverSpanningTree(this.spanningTreeMap);
            this.initializeSpanningTreeModels();
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectEtherBridge, 0, (Observer)this);
        }
        this.etherPmModel.init();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    private void disposeEtherPmModel() {
        this.etherPmModel.dispose();
    }

    private void discoverVlans(Map map) {
        sVlanInfo[] sVlanInfoArray = null;
        try {
            sVlanInfoArray = (sVlanInfo[])this.vlanInfoList.get();
        }
        catch (UserException userException) {
            this.db.println("EtherBridgeModel.discoverVlans(): CORBA user exception");
            SDebug.printStackTrace((Throwable)userException);
            return;
        }
        for (int i = 0; i < sVlanInfoArray.length; ++i) {
            VlanModel vlanModel = new VlanModel(this.nmd, sVlanInfoArray[i].vlanId, sVlanInfoArray[i].vlanName);
            map.put(new Short(sVlanInfoArray[i].vlanId), vlanModel);
        }
    }

    private void discoverSpanningTree(Map map) {
        short[] sArray = null;
        try {
            sArray = (short[])this.spanningTreeList.get();
        }
        catch (UserException userException) {
            this.db.println("EtherBridgeModel.discoverSpanningTree(): CORBA user exception");
            SDebug.printStackTrace((Throwable)userException);
            return;
        }
        for (int i = 0; i < sArray.length; ++i) {
            SpanningTreeModel spanningTreeModel = new SpanningTreeModel(this.nmd, sArray[i]);
            map.put(new Short(sArray[i]), spanningTreeModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVlans() {
        Map map = this.vlanMap;
        synchronized (map) {
            Iterator iterator = this.vlanMap.values().iterator();
            while (iterator.hasNext()) {
                VlanModel vlanModel = (VlanModel)iterator.next();
                vlanModel.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSpanningTreeModels() {
        Map map = this.spanningTreeMap;
        synchronized (map) {
            Iterator iterator = this.spanningTreeMap.values().iterator();
            while (iterator.hasNext()) {
                SpanningTreeModel spanningTreeModel = (SpanningTreeModel)iterator.next();
                spanningTreeModel.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyVlans() {
        Map map = this.vlanMap;
        synchronized (map) {
            Iterator iterator = this.vlanMap.values().iterator();
            while (iterator.hasNext()) {
                VlanModel vlanModel = (VlanModel)iterator.next();
                vlanModel.destroy();
            }
            this.vlanMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySpanningTreeModels() {
        Map map = this.spanningTreeMap;
        synchronized (map) {
            Iterator iterator = this.spanningTreeMap.values().iterator();
            while (iterator.hasNext()) {
                SpanningTreeModel spanningTreeModel = (SpanningTreeModel)iterator.next();
                spanningTreeModel.destroy();
            }
            this.spanningTreeMap.clear();
        }
    }

    public boolean createPointToPointCircuitTest(IVlanModel[] iVlanModelArray) throws NoSuchVlan, NoMoreSpanningTree, VlanSpanningTreeViolation, NoSuchCircuit {
        if (iVlanModelArray == null) {
            return false;
        }
        short[] sArray = new short[iVlanModelArray.length];
        Boolean bl = null;
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            sArray[i] = iVlanModelArray[i].getId();
        }
        try {
            bl = (Boolean)this.createPointToPointCircuitTest.get(sArray);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            this.db.println("user exception in createPointToPointCircuitTest");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
        return bl;
    }

    public EtherPmModel getEtherPmModel() {
        return this.etherPmModel;
    }

    public EtherPmModel getEtherPm() {
        return this.getEtherPmModel();
    }

    public void destroy() {
        super.destroy();
        this.etherPmModel.destroy();
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::dispose");
        }
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectEtherBridge, 0, (Observer)this);
            this.dispatcher = null;
        }
        this.destroyVlans();
        this.destroySpanningTreeModels();
        this.disposeEtherPmModel();
        super.dispose();
    }

    public void finalizePortProvisioning() {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::finalizePortProvisioning");
        }
        try {
            this.provAllPorts.set();
        }
        catch (UserException userException) {
            throw this.doUnknown("finalizePortProvisioning", userException);
        }
    }

    public SpanningTreeModel[] getSpanningTreeList() {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::getSpanningTreeList");
        }
        return this.spanningTreeMap.values().toArray(new SpanningTreeModel[0]);
    }

    public void createVlan(short s, String string) throws VlanIdOutOfRange, NoMoreVlan, DuplicateVlan, VlanNameTooLong {
        try {
            Object[] objectArray = new Object[]{new Short(s), string};
            this.createVlan.set(objectArray);
        }
        catch (xVlanIdOutOfRange xVlanIdOutOfRange2) {
            throw new VlanIdOutOfRange((UserException)xVlanIdOutOfRange2);
        }
        catch (xNoMoreVlan xNoMoreVlan2) {
            throw new NoMoreVlan((UserException)xNoMoreVlan2);
        }
        catch (xDuplicateVlan xDuplicateVlan2) {
            throw new DuplicateVlan((UserException)xDuplicateVlan2);
        }
        catch (xVlanNameTooLong xVlanNameTooLong2) {
            throw new VlanNameTooLong((UserException)xVlanNameTooLong2);
        }
        catch (UserException userException) {
            this.db.println("user exception in createVlan");
            SDebug.printStackTrace((Throwable)userException);
            return;
        }
        this.updateStructure();
    }

    public void deleteVlan(short s) throws VlanInUse, NoSuchVlan {
        try {
            Object object = new Object();
            object = new Short(s);
            this.deleteVlan.set(object);
        }
        catch (xVlanInUse xVlanInUse2) {
            throw new VlanInUse((UserException)xVlanInUse2);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void createCircuit(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws NoMoreEtherCircuit, NoMoreSpanningTree, NoSuchVlan, VlanSpanningTreeViolation, DuplicateCircuit {
        short[] sArray = new short[iVlanModelArray.length];
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            sArray[i] = iVlanModelArray[i].getId();
        }
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sArray};
            this.createCircuit.set(objectArray);
        }
        catch (xNoMoreEtherCircuit xNoMoreEtherCircuit2) {
            throw new NoMoreEtherCircuit((UserException)xNoMoreEtherCircuit2);
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
        }
        catch (xDuplicateCircuit xDuplicateCircuit2) {
            throw new DuplicateCircuit((UserException)xDuplicateCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void changeCircuit(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws VlanSpanningTreeViolation, NoMoreSpanningTree, NoSuchVlan, NoSuchCircuit {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        short[] sArray = new short[iVlanModelArray.length];
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            sArray[i] = iVlanModelArray[i].getId();
        }
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sArray};
            this.changeCircuit.set(objectArray);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getCircuitEndPorts(ICircuitId iCircuitId, IBridgePortInfo iBridgePortInfo, IBridgePortInfo iBridgePortInfo2) throws NoSuchCircuit {
        Boolean bl = null;
        IntHolder intHolder = new IntHolder(0);
        IntHolder intHolder2 = new IntHolder(0);
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sBridgePortInfo sBridgePortInfo2 = new sBridgePortInfo();
        sBridgePortInfo sBridgePortInfo3 = new sBridgePortInfo();
        Object[] objectArray = new Object[]{sCircuitId2, intHolder, intHolder2};
        try {
            bl = (Boolean)this.getCircuitEndPorts.get(objectArray);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            this.db.println("user exception in getCircuitEndPorts");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
        if (intHolder.value != 0 && intHolder2.value != 0) {
            try {
                this.copyPortInfo(sBridgePortInfo2, (sBridgePortInfo)this.portInfo.get(new Integer(intHolder.value)));
                this.copyPortInfo(sBridgePortInfo3, (sBridgePortInfo)this.portInfo.get(new Integer(intHolder2.value)));
            }
            catch (UserException userException) {
                this.db.println("user exception in getCircuitEndPorts/copyPortInfo");
                SDebug.printStackTrace((Throwable)userException);
                return false;
            }
        }
        return bl;
    }

    private void copyPortInfo(sBridgePortInfo sBridgePortInfo2, sBridgePortInfo sBridgePortInfo3) {
        sBridgePortInfo2.macAddr = sBridgePortInfo3.macAddr;
        sBridgePortInfo2.portId = sBridgePortInfo3.portId;
        sBridgePortInfo2.portState = sBridgePortInfo3.portState;
        sBridgePortInfo2.spanningTreeInstance = sBridgePortInfo3.spanningTreeInstance;
        sBridgePortInfo2.stpDesignatedBridge = sBridgePortInfo3.stpDesignatedBridge;
        sBridgePortInfo2.stpDesignatedCost = sBridgePortInfo3.stpDesignatedCost;
        sBridgePortInfo2.stpDesignatedPort = sBridgePortInfo3.stpDesignatedPort;
        sBridgePortInfo2.stpDesignatedRoot = sBridgePortInfo3.stpDesignatedRoot;
        sBridgePortInfo2.stpForwardTransitions = sBridgePortInfo3.stpForwardTransitions;
    }

    public void deleteCircuit(ICircuitId iCircuitId) throws VlanInUse, NoSuchCircuit {
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        try {
            this.deleteCircuit.set(sCircuitId2);
        }
        catch (xVlanInUse xVlanInUse2) {
            throw new VlanInUse((UserException)xVlanInUse2);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean createCircuitTest(IVlanModel[] iVlanModelArray) throws NoMoreEtherCircuit, NoMoreSpanningTree, NoSuchVlan, VlanSpanningTreeViolation, DuplicateCircuit {
        short[] sArray = new short[iVlanModelArray.length];
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            sArray[i] = iVlanModelArray[i].getId();
        }
        try {
            return (Boolean)this.createCircuitTest.get(sArray);
        }
        catch (xNoMoreEtherCircuit xNoMoreEtherCircuit2) {
            throw new NoMoreEtherCircuit((UserException)xNoMoreEtherCircuit2);
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
        }
        catch (xDuplicateCircuit xDuplicateCircuit2) {
            throw new DuplicateCircuit((UserException)xDuplicateCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean changeCircuitTest(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws VlanSpanningTreeViolation, NoMoreSpanningTree, NoSuchVlan, NoSuchCircuit {
        short[] sArray = new short[iVlanModelArray.length];
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        for (int i = 0; i < iVlanModelArray.length; ++i) {
            sArray[i] = iVlanModelArray[i].getId();
        }
        try {
            Object[] objectArray = new Object[]{sCircuitId2, sArray};
            return (Boolean)this.changeCircuitTest.get(objectArray);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw new NoSuchVlan((UserException)xNoSuchVlan2);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean deleteCircuitTest(ICircuitId iCircuitId) throws VlanInUse, NoSuchCircuit {
        if (this.nmd.provides(Feature.IDL_220)) {
            return true;
        }
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        try {
            return (Boolean)this.deleteCircuitTest.get(sCircuitId2);
        }
        catch (xVlanInUse xVlanInUse2) {
            throw new VlanInUse((UserException)xVlanInUse2);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public IVlanModel[] getVlanList() {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::getVlanList");
        }
        return this.vlanMap.values().toArray(new IVlanModel[0]);
    }

    public String getVlanName(short s) {
        VlanModel vlanModel = (VlanModel)this.vlanMap.get(new Short(s));
        if (vlanModel != null) {
            return vlanModel.getName();
        }
        return null;
    }

    public Collection getVlanIdList() {
        try {
            return (Collection)this.vlanList.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(IVlanModel iVlanModel) {
        Object v;
        Map map = this.vlanMap;
        synchronized (map) {
            v = this.vlanMap.remove(new Short(iVlanModel.getId()));
        }
        if (this.db.on()) {
            this.db.println("In removeVlan Deleted " + v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSpanningTree(SpanningTreeModel spanningTreeModel) {
        Object v;
        Map map = this.spanningTreeMap;
        synchronized (map) {
            v = this.spanningTreeMap.remove(new Integer(spanningTreeModel.getIndex()));
        }
        if (this.db.on()) {
            this.db.println("In removeSpanningTree Deleted " + v);
        }
    }

    public IVlanModel[] getPortVlanList(IPortModel iPortModel) throws IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::getPortVlanList");
        }
        if (iPortModel instanceof EtherPortModel) {
            try {
                EtherPortModel etherPortModel = (EtherPortModel)iPortModel;
                short[] sArray = etherPortModel.getPortVlanIDs();
                IVlanModel iVlanModel = etherPortModel.getPortVlanTagging();
                LinkedList<IVlanModel> linkedList = new LinkedList<IVlanModel>();
                linkedList.add(iVlanModel);
                for (int i = 0; i < sArray.length; ++i) {
                    IVlanModel iVlanModel2 = (IVlanModel)this.vlanMap.get(new Short(sArray[i]));
                    if (iVlanModel2 == null) {
                        this.db.println("Can't find vlan model for id=" + sArray[i]);
                        continue;
                    }
                    linkedList.add(iVlanModel2);
                }
                IVlanModel[] iVlanModelArray = linkedList.toArray(new IVlanModel[0]);
                if (this.db.on()) {
                    this.db.println("Vlan list for slot=" + etherPortModel.getSlot() + " port=" + PortHelper.getConcatenatedString((int[])etherPortModel.getPortNum()) + " [first is untagged vlan]");
                    for (int i = 0; i < iVlanModelArray.length; ++i) {
                        this.db.println("   " + iVlanModelArray[i]);
                    }
                }
                return iVlanModelArray;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            throw new IllegalArgumentException("Not an EtherPortModel:" + iPortModel);
        }
        return new IVlanModel[0];
    }

    public int getPortStpId(IPortModel iPortModel) {
        int n = -1;
        if (iPortModel instanceof EtherPortModel) {
            try {
                sBridgePortInfo sBridgePortInfo2 = (sBridgePortInfo)this.portInfo.get(new Integer(iPortModel.getIndex()));
                n = sBridgePortInfo2.spanningTreeInstance;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        } else {
            throw new IllegalArgumentException("Not an EtherPortModel:" + iPortModel);
        }
        return n;
    }

    public IPortModel[] getStpFrontPorts() {
        LinkedList<EtherPortModel> linkedList = new LinkedList<EtherPortModel>();
        IEntityModel iEntityModel = this.nmd.getChassis();
        List list = iEntityModel.getDescendantsOfClassType(7);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IPortModel iPortModel = (IPortModel)iterator.next();
            if (!(iPortModel instanceof EtherPortModel)) continue;
            EtherPortModel etherPortModel = (EtherPortModel)iPortModel;
            if (!etherPortModel.getBridgePortAdminInfo().stpEnabled) continue;
            linkedList.add(etherPortModel);
        }
        return linkedList.toArray(new IPortModel[0]);
    }

    public int getCircuitStpId(ICircuitId iCircuitId) throws NoSuchCircuit {
        IntHolder intHolder = new IntHolder(0);
        IntHolder intHolder2 = new IntHolder(0);
        sCircuitId sCircuitId2 = CircuitIdFactory.getCircuitId(iCircuitId);
        sBridgePortInfo sBridgePortInfo2 = new sBridgePortInfo();
        sBridgePortInfo sBridgePortInfo3 = new sBridgePortInfo();
        Object[] objectArray = new Object[]{sCircuitId2, intHolder, intHolder2};
        try {
            this.getCircuitEndPorts.get(objectArray);
        }
        catch (xNoSuchCircuit xNoSuchCircuit2) {
            throw new NoSuchCircuit((UserException)xNoSuchCircuit2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
        int n = intHolder.value;
        if (n == 0) {
            n = intHolder2.value;
        }
        if (n == 0) {
            this.db.println("getCircuitEndPorts returned 2 null indices for " + iCircuitId);
            return -1;
        }
        try {
            sBridgePortInfo sBridgePortInfo4 = (sBridgePortInfo)this.portInfo.get(new Integer(n));
            return sBridgePortInfo4.spanningTreeInstance;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("EtherBridgeModel::update");
        }
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this.toString() + ", From=" + observable + ", arg=" + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Event$eUpdateType == null ? (class$cerent$cms$idl$Event$eUpdateType = EtherBridgeModel.class$("cerent.cms.idl.Event.eUpdateType")) : class$cerent$cms$idl$Event$eUpdateType))[n]);
            }
            switch (n) {
                case 2: {
                    if (this.db.on()) {
                        this.db.println("Making structural changes.");
                    }
                    this.updateStructure();
                    break;
                }
                case 1: {
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (this.db.on()) {
            this.db.println("update(): Unrecognized Observable = " + observable + ", arg = " + object);
        }
    }

    private void updateStructure() {
        boolean bl = this.updateVlanStructure();
        boolean bl2 = this.updateSpanningTreeStructure();
        if (bl || bl2) {
            if (this.db.on()) {
                this.db.println("Sending UpdateStructure");
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateVlanStructure() {
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Enter updateVlanStructure()");
        }
        Map map = this.vlanMap;
        synchronized (map) {
            VlanModel vlanModel;
            Object e;
            Collection collection = this.getVlanIdList();
            Collection collection2 = this.getAddedObjects(this.vlanMap.keySet(), collection);
            Collection collection3 = this.getDeletedObjects(this.vlanMap.keySet(), collection);
            if (this.db.on()) {
                this.db.println("No of added Vlans " + collection2.size());
            }
            if (this.db.on()) {
                this.db.println("No of deleted Vlans" + collection3.size());
            }
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                vlanModel = new VlanModel(this.nmd, (Short)e);
                vlanModel.init();
                if (this.db.on()) {
                    this.db.println("Found a new Vlan adding it " + vlanModel);
                }
                this.vlanMap.put(e, vlanModel);
                bl = true;
            }
            iterator = collection3.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                vlanModel = (VlanModel)this.vlanMap.get(e);
                if (this.db.on()) {
                    this.db.println("Deleting a Vlan " + vlanModel);
                }
                this.vlanMap.remove(e);
                vlanModel.destroy();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit UpdateVlanStructure()");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSpanningTreeStructure() {
        HashMap hashMap = new HashMap();
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Enter updateVlanStructure()");
        }
        Map map = this.spanningTreeMap;
        synchronized (map) {
            SpanningTreeModel spanningTreeModel;
            Object e;
            this.discoverSpanningTree(hashMap);
            Collection collection = this.getAddedObjects(this.spanningTreeMap.keySet(), hashMap.keySet());
            Collection collection2 = this.getDeletedObjects(this.spanningTreeMap.keySet(), hashMap.keySet());
            if (this.db.on()) {
                this.db.println("No of added SpanningTree " + collection.size());
            }
            if (this.db.on()) {
                this.db.println("No of deleted SpanningTree" + collection2.size());
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                spanningTreeModel = (SpanningTreeModel)hashMap.get(e);
                spanningTreeModel.init();
                if (this.db.on()) {
                    this.db.println("Found a new SpanningTree adding it " + spanningTreeModel);
                }
                this.spanningTreeMap.put(e, spanningTreeModel);
                bl = true;
            }
            iterator = collection2.iterator();
            while (iterator.hasNext()) {
                e = iterator.next();
                spanningTreeModel = (SpanningTreeModel)this.spanningTreeMap.get(e);
                if (this.db.on()) {
                    this.db.println("Deleting a Vlan " + spanningTreeModel);
                }
                this.spanningTreeMap.remove(e);
                spanningTreeModel.destroy();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit UpdateVlanStructure()");
        }
        return bl;
    }

    private Collection getAddedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection2);
        hashSet.removeAll(collection);
        return hashSet;
    }

    private Collection getDeletedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        hashSet.removeAll(collection2);
        return hashSet;
    }

    public sBridgePortAdminInfo_2_2 convertBridgePortAdminInfo_2_2(sBridgePortAdminInfo sBridgePortAdminInfo2) {
        return new sBridgePortAdminInfo_2_2(sBridgePortAdminInfo2.portEnabled, sBridgePortAdminInfo2.stpPriority, sBridgePortAdminInfo2.stpPathCost, sBridgePortAdminInfo2.queuingPriority, sBridgePortAdminInfo2.broadcastLimit, sBridgePortAdminInfo2.cir, true, eEncapsulationType.NONLEX);
    }

    public sBridgePortAdminInfo convertBridgePortAdminInfo(sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22) {
        return new sBridgePortAdminInfo(sBridgePortAdminInfo_2_22.portEnabled, sBridgePortAdminInfo_2_22.stpPriority, sBridgePortAdminInfo_2_22.stpPathCost, sBridgePortAdminInfo_2_22.queuingPriority, sBridgePortAdminInfo_2_22.broadcastLimit, sBridgePortAdminInfo_2_22.cir);
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        SDebug.printStackTrace((Throwable)userException);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class VlanIdFromIndex
    extends NonCachedValue {
        public VlanIdFromIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) {
            int n = (Integer)object;
            short s = 0;
            Iterator iterator = EtherBridgeModel.this.vlanMap.values().iterator();
            while (iterator.hasNext()) {
                VlanModel vlanModel = (VlanModel)iterator.next();
                if (vlanModel.getIndex() != n) continue;
                s = vlanModel.getId();
                break;
            }
            return new Short(s);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    public class VlanModelFromId
    extends NonCachedValue {
        public VlanModelFromId(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) {
            return (VlanModel)EtherBridgeModel.this.vlanMap.get((Short)object);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class CreatePointToPointCircuitTest
    extends NonCachedValue {
        public CreatePointToPointCircuitTest(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Boolean(this.node.getIorRepository().getEtherBridgeRef().createPointToPointCircuitTest((short[])object));
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class PortInfo
    extends NonCachedValue {
        public PortInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return this.node.getIorRepository().getEtherBridgeRef().getPortInfo((Integer)object);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class DeleteCircuitTest
    extends NonCachedValue {
        public DeleteCircuitTest(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Boolean(this.node.getIorRepository().getEtherBridgeRef().deleteCircuitTest((sCircuitId)object));
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class ChangeCircuitTest
    extends NonCachedValue {
        public ChangeCircuitTest(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return new Boolean(this.node.getIorRepository().getEtherBridgeRef().changeCircuitTest((sCircuitId)objectArray[0], (short[])objectArray[1]));
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class CreateCircuitTest
    extends NonCachedValue {
        public CreateCircuitTest(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Boolean(this.node.getIorRepository().getEtherBridgeRef().createCircuitTest((short[])object));
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class DeleteCircuit
    extends NonCachedValue {
        public DeleteCircuit(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherBridgeRef().deleteCircuit((sCircuitId)object);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class ChangeCircuit
    extends NonCachedValue {
        public ChangeCircuit(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getEtherBridgeRef().changeCircuit((sCircuitId)objectArray[0], (short[])objectArray[1]);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class CreateCircuit
    extends NonCachedValue {
        public CreateCircuit(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getEtherBridgeRef().createCircuit((sCircuitId)objectArray[0], (short[])objectArray[1]);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class SpanningTreeList
    extends NonCachedValue {
        public SpanningTreeList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected synchronized Object getValue() throws UserException {
            short[] sArray = this.node.getIorRepository().getEtherBridgeRef().getSpanningTreeList();
            return sArray;
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class GetCircuitEndPorts
    extends NonCachedValue {
        public GetCircuitEndPorts(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            boolean bl = this.node.getIorRepository().getEtherBridgeRef().getCircuitEndPorts((sCircuitId)objectArray[0], (IntHolder)objectArray[1], (IntHolder)objectArray[2]);
            return new Boolean(bl);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class VlanInfoList
    extends NonCachedValue {
        public VlanInfoList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sVlanInfo[] sVlanInfoArray = this.node.getIorRepository().getEtherBridgeRef().getVlanInfoList();
            return sVlanInfoArray;
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class VlanList
    extends NonCachedValue {
        public VlanList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            short[] sArray = this.node.getIorRepository().getEtherBridgeRef().getVlanList();
            ArrayList<Short> arrayList = new ArrayList<Short>();
            for (int i = 0; i < sArray.length; ++i) {
                arrayList.add(new Short(sArray[i]));
            }
            return arrayList;
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class FinalizePortProvisioning
    extends NonCachedValue {
        public FinalizePortProvisioning(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws UserException {
            this.node.getIorRepository().getEtherBridgeRef().finalizePortProvisioning();
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class DeleteVlan
    extends NonCachedValue {
        public DeleteVlan(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            this.node.getIorRepository().getEtherBridgeRef().deleteVlan((Short)object);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }

    class CreateVlan
    extends NonCachedValue {
        public CreateVlan(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            this.node.getIorRepository().getEtherBridgeRef().createVlan((Short)objectArray[0], (String)objectArray[1]);
        }

        public Object outer() {
            return EtherBridgeModel.this;
        }
    }
}

