/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Dwdm.eGccRate;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.Busy;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTermModel;
import cerent.cms.model.ResourceInUse;
import java.util.Set;

public class GccTermConnectionModel
extends AbstractTermConnectionModel {
    private static OhChannelType GCC_192K_TERM_CHANNEL_TYPE = OhChannelType.SDCC_OBJ;
    private static OhChannelType GCC_576K_TERM_CHANNEL_TYPE = OhChannelType.LDCC_OBJ;
    private static ModelSingletonCollection gccConnectionModelSingletons;

    public static synchronized GccTermConnectionModel getInstance(NodeModelDelegate nodeModelDelegate) {
        GccTermConnectionModel gccTermConnectionModel;
        if (gccConnectionModelSingletons == null) {
            gccConnectionModelSingletons = ModelSingletonCollection.getMSCInstanceByName("GccTermConnectionModel");
        }
        if ((gccTermConnectionModel = (GccTermConnectionModel)gccConnectionModelSingletons.get(nodeModelDelegate)) == null) {
            gccTermConnectionModel = new GccTermConnectionModel(nodeModelDelegate);
            gccConnectionModelSingletons.add(nodeModelDelegate, gccTermConnectionModel);
        }
        return gccTermConnectionModel;
    }

    private GccTermConnectionModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
    }

    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) {
        GccTermConnectionModel gccTermConnectionModel = (GccTermConnectionModel)nodeModelDelegate.getGccTermConnectionModel();
        gccTermConnectionModel.init();
    }

    public boolean entityExistsInTerminations(IEntityModel iEntityModel) {
        return this.getTermModel(iEntityModel.getIndex()) != null;
    }

    public IEntityModel[] getTermCandidates() {
        if (this.elementModels == null) {
            this.elementModels = this.nmd.getElementModelsDelegate();
        }
        Set set = this.dwdmTrunkPorts(this.elementModels.getNonProtectDwdmEntities());
        set.removeAll(this.nonOTNPorts(set));
        set.removeAll(this.dwdmUnframedPorts(set));
        set.removeAll(this.ocmd.getUsedOpticalPorts(GCC_192K_TERM_CHANNEL_TYPE));
        set.removeAll(this.ocmd.getUsedOpticalPorts(GCC_576K_TERM_CHANNEL_TYPE));
        Set set2 = this.excludeUcpTerms(set);
        return set2.toArray(new IEntityModel[0]);
    }

    protected String getTypeName() {
        return "GCC";
    }

    public void createTermination(IEntityModel iEntityModel, eGccRate eGccRate2, boolean bl) throws InvalidOhTerm, Busy, ResourceInUse, OhMaxConnections {
        this.createTermination(iEntityModel, new Object[]{new Boolean(bl), Boolean.FALSE, new Integer(eGccRate2.value())});
    }

    protected OhChannelType getChannelType(Object object) {
        Object[] objectArray = (Object[])object;
        eGccRate eGccRate2 = eGccRate.from_int((Integer)objectArray[2]);
        return eGccRate2 == eGccRate.GCC_RATE_192K ? GCC_192K_TERM_CHANNEL_TYPE : GCC_576K_TERM_CHANNEL_TYPE;
    }

    protected boolean getOspfEnable(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        Object[] objectArray = (Object[])object;
        if (objectArray[0] instanceof Boolean) {
            return (Boolean)objectArray[0];
        }
        if (this.db.on()) {
            this.db.println("getOspfEnable: got unexpected argument");
        }
        return false;
    }

    protected boolean termQualifies(OhTermModel ohTermModel) {
        return this.isGccTerm(ohTermModel) && !this.isOscTerm(ohTermModel);
    }
}

