/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Common.xInvalidRange;
import cerent.cms.idl.Epos.sBridgePortAdminInfo_2_2;
import cerent.cms.idl.Epos.sBridgePortInfo;
import cerent.cms.idl.Epos.xNoMoreSpanningTree;
import cerent.cms.idl.Epos.xVlanSpanningTreeViolation;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.SonetMedia.eDriNodeType;
import cerent.cms.idl.SonetMedia.sStsPathDef;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.StsCircuitPart;
import cerent.cms.idl.SonetTopology.StsConnection;
import cerent.cms.idl.SonetTopology.eConnectionType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.idl.SonetTopology.eTopologyUpgradeState;
import cerent.cms.idl.SonetTopology.eTopologyUpgradeType;
import cerent.cms.idl.SonetTopology.sBridgePortAssociation;
import cerent.cms.idl.SonetTopology.sConnCreateAttrs;
import cerent.cms.idl.SonetTopology.sStsConnectionItem;
import cerent.cms.idl.SonetTopology.sStsTopologyUpgradeItem;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xConnectionInLoopback;
import cerent.cms.idl.SonetTopology.xConnectionInRoll;
import cerent.cms.idl.SonetTopology.xConnectionInTestAccess;
import cerent.cms.idl.SonetTopology.xConnectionInTopologyUpgrade;
import cerent.cms.idl.SonetTopology.xConnectionTypeError;
import cerent.cms.idl.SonetTopology.xDeleteInstead;
import cerent.cms.idl.SonetTopology.xDropsExceedMax;
import cerent.cms.idl.SonetTopology.xInvalidPath;
import cerent.cms.idl.SonetTopology.xInvalidProtectionOp;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.idl.SonetTopology.xPathInUse;
import cerent.cms.idl.SonetTopology.xPathListIncomplete;
import cerent.cms.idl.SonetTopology.xPathNotSupported;
import cerent.cms.idl.SonetTopology.xTopologyUpgradeNotAllowed;
import cerent.cms.idl.SonetTopology.xVcatMemberNotOutOfGroup;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BridgePortAssociation;
import cerent.cms.model.BridgePortInfoFactory;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitIdFactory;
import cerent.cms.model.CloneHelper;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.ConnCreateAttrsFactory;
import cerent.cms.model.ConnectionConversionFactory;
import cerent.cms.model.ConnectionConversionModel;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Connections;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.Ds3IModuleModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EtherBackPlaneModel;
import cerent.cms.model.EtherModuleModel;
import cerent.cms.model.Feature;
import cerent.cms.model.HoCircuitPartModel;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.HoPathDefModelFactory;
import cerent.cms.model.HoTapModel;
import cerent.cms.model.IBridgePortInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IPmStat;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoMoreSpanningTree;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchLoopback;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.PmStatFactory;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.UpsrSelector;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.VlanSpanningTreeViolation;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class HoConnectionModel
extends HoCircuitPartModel
implements IHoConnectionModel,
UpsrSelector {
    private StsConnection stsConnectionRef;
    private ActivePaths activePaths = null;
    private AddOutput addOutput = null;
    private ChangeIntendedType changeIntendedType = null;
    private Destroy destroy = null;
    private GetSwitchCount getSwitchCount = null;
    private GetReverseSwitchCount getReverseSwitchCount = null;
    private ClearSwitchCount clearSwitchCount = null;
    private IntendedType intendedType = null;
    private Paths paths = null;
    private ProtectionOp protectionOp = null;
    private ReverseProtectionOp reverseProtectionOp = null;
    private HoldoffTime holdoffTime = null;
    private ReverseHoldoffTime reverseHoldoffTime = null;
    private HoldoffTimeForPath holdoffTimeForPath = null;
    private UpsrSdBerLevelForPath upsrSdBerLevelForPath = null;
    private UpsrSfBerLevelForPath upsrSfBerLevelForPath = null;
    private RemoveOutput removeOutput = null;
    private SetProtectionOp setProtectionOp = null;
    private SetReverseProtectionOp setReverseProtectionOp = null;
    private UpsrReversion upsrReversion = null;
    private GetReverseUpsrReversion getReverseUpsrReversion = null;
    private SetReverseUpsrReversion setReverseUpsrReversion = null;
    private UpsrBerLevel upsrBerLevel = null;
    private UpsrSdBerLevel upsrSdBerLevel = null;
    private UpsrSfBerLevel upsrSfBerLevel = null;
    private ReverseUpsrSdBerLevel reverseUpsrSdBerLevel = null;
    private ReverseUpsrSfBerLevel reverseUpsrSfBerLevel = null;
    private UpsrSwitchOnPdiP upsrSwitchOnPdiP = null;
    private GetReverseUpsrSwitchOnPdiP getReverseUpsrSwitchOnPdiP = null;
    private SetReverseUpsrSwitchOnPdiP setReverseUpsrSwitchOnPdiP = null;
    private InRoll inRoll = null;
    private Boolean isUnstitched = null;
    private PathEntities pathEntities = null;
    private PortEntities portEntities = null;
    private BridgePortAssociationList bridgePortAssociationList = null;
    private DriNodeType driNodeType = null;
    private TopologyUpgrade topologyUpgrade = null;
    private IsInTopologyUpgrade isInTopologyUpgrade = null;
    static /* synthetic */ Class class$cerent$cms$idl$SonetMedia$eDriNodeType;
    static /* synthetic */ Class class$cerent$cms$model$IConnectionType;

    public HoConnectionModel(NodeModelDelegate nodeModelDelegate, StsConnection stsConnection, Connections connections, SDebug sDebug) {
        super(nodeModelDelegate, connections, sDebug);
        this.stsConnectionRef = stsConnection;
        this.activePaths = new ActivePaths(nodeModelDelegate, "HoConnectionModel.activePaths");
        this.addOutput = new AddOutput(nodeModelDelegate, "HoConnectionModel.addOutput");
        this.changeIntendedType = new ChangeIntendedType(nodeModelDelegate, "HoConnectionModel.changeIntendedType");
        this.destroy = new Destroy(nodeModelDelegate, "HoConnectionModel.destroy");
        this.getSwitchCount = new GetSwitchCount(nodeModelDelegate, "HoConnectionModel.getSwitchCount");
        this.getReverseSwitchCount = new GetReverseSwitchCount(nodeModelDelegate, "HoConnectionModel.getReverseSwitchCount");
        this.clearSwitchCount = new ClearSwitchCount(nodeModelDelegate, "HoConnectionModel.clearSwitchCount");
        this.intendedType = new IntendedType(nodeModelDelegate, "HoConnectionModel.intendedType");
        this.paths = new Paths(nodeModelDelegate, "HoConnectionModel.paths");
        this.protectionOp = new ProtectionOp(nodeModelDelegate, "HoConnectionModel.protectionOp");
        this.reverseProtectionOp = new ReverseProtectionOp(nodeModelDelegate, "HoConnectionModel.reverseProtectionOp");
        this.holdoffTime = new HoldoffTime(nodeModelDelegate, "HoConnectionModel.holdoffTime");
        this.reverseHoldoffTime = new ReverseHoldoffTime(nodeModelDelegate, "HoConnectionModel.reverseHoldoffTime");
        this.holdoffTimeForPath = new HoldoffTimeForPath(nodeModelDelegate, "HoConnectionModel.holdoffTimeForPath");
        this.upsrSdBerLevelForPath = new UpsrSdBerLevelForPath(nodeModelDelegate, "HoConnectionModel.upsrSdBerLevelForPath");
        this.upsrSfBerLevelForPath = new UpsrSfBerLevelForPath(nodeModelDelegate, "HoConnectionModel.upsrSfBerLevelForPath");
        this.removeOutput = new RemoveOutput(nodeModelDelegate, "HoConnectionModel.removeOutput");
        this.setProtectionOp = new SetProtectionOp(nodeModelDelegate, "HoConnectionModel.setProtectionOp");
        this.setReverseProtectionOp = new SetReverseProtectionOp(nodeModelDelegate, "HoConnectionModel.setReverseProtectionOp");
        this.upsrBerLevel = new UpsrBerLevel(nodeModelDelegate, "HoConnectionModel.upsrBerLevel");
        this.upsrReversion = new UpsrReversion(nodeModelDelegate, "HoConnectionModel.upsrReversion");
        this.getReverseUpsrReversion = new GetReverseUpsrReversion(nodeModelDelegate, "HoConnectionModel.getReverseUpsrReversion");
        this.setReverseUpsrReversion = new SetReverseUpsrReversion(nodeModelDelegate, "HoConnectionModel.setReverseUpsrReversion");
        this.upsrSdBerLevel = new UpsrSdBerLevel(nodeModelDelegate, "HoConnectionModel.upsrBerLevel");
        this.upsrSfBerLevel = new UpsrSfBerLevel(nodeModelDelegate, "HoConnectionModel.upsrSfBerLevel");
        this.reverseUpsrSdBerLevel = new ReverseUpsrSdBerLevel(nodeModelDelegate, "HoConnectionModel.reverseUpsrBerLevel");
        this.reverseUpsrSfBerLevel = new ReverseUpsrSfBerLevel(nodeModelDelegate, "HoConnectionModel.reverseUpsrSfBerLevel");
        this.upsrSwitchOnPdiP = new UpsrSwitchOnPdiP(nodeModelDelegate, "HoConnectionModel.UpsrSwitchOnPdiP");
        this.getReverseUpsrSwitchOnPdiP = new GetReverseUpsrSwitchOnPdiP(nodeModelDelegate, "HoConnectionModel.getReverseUpsrSwitchOnPdiP");
        this.setReverseUpsrSwitchOnPdiP = new SetReverseUpsrSwitchOnPdiP(nodeModelDelegate, "HoConnectionModel.setReverseUpsrSwitchOnPdiP");
        this.driNodeType = new DriNodeType(nodeModelDelegate, "HoConnectionModel.driNodeType");
        if (!this.nmd.getPlatform().is600()) {
            this.bridgePortAssociationList = new BridgePortAssociationList(nodeModelDelegate, "HoConnectionModel.bridgePortAssociationList");
        }
        this.pathEntities = new PathEntities(nodeModelDelegate, "HoConnectionModel.pathEntites");
        this.portEntities = new PortEntities(nodeModelDelegate, "HoConnectionModel.getPortModels");
        if (this.nmd.getPlatform().isBridgeAndRollCapable()) {
            this.inRoll = new InRoll(nodeModelDelegate, "StsConnectionModel.inRoll");
        }
        this.topologyUpgrade = new TopologyUpgrade(nodeModelDelegate, "HoConnectionModel.topologyUpgrade");
        this.isInTopologyUpgrade = new IsInTopologyUpgrade(nodeModelDelegate, "HoConnectionModel.isInTopologyUpgrade");
    }

    public HoConnectionModel(NodeModelDelegate nodeModelDelegate, sStsConnectionItem sStsConnectionItem2, Connections connections, SDebug sDebug) {
        this(nodeModelDelegate, sStsConnectionItem2.stsConn, connections, sDebug);
        this.setAttributes(sStsConnectionItem2);
    }

    public void init() {
        if (!this.nmd.getPlatform().is600()) {
            this.initializeLinkToEtherBackPlane();
        }
        super.init();
    }

    public void setAttributes(sStsConnectionItem sStsConnectionItem2) {
        super.setAttributes(sStsConnectionItem2);
        this.activePaths.setValueExternally(sStsConnectionItem2.activePaths);
        this.intendedType.setValueExternally(sStsConnectionItem2.intendedType);
        this.paths.setValueExternally(sStsConnectionItem2.paths);
        if (!this.nmd.getPlatform().is600()) {
            this.bridgePortAssociationList.setValueExternally(sStsConnectionItem2.bridgePortAssociations);
        }
        if (this.nmd.getPlatform().isBridgeAndRollCapable() && this.inRoll != null) {
            this.inRoll.setValueExternally(sStsConnectionItem2.inRoll);
        }
        this.isInTopologyUpgrade.setValueExternally(new Boolean(sStsConnectionItem2.inTopologyUpgrade));
    }

    protected void updateLocal() {
        this.activePaths.update();
        this.intendedType.update();
        this.paths.update();
        this.protectionOp.update();
        this.reverseProtectionOp.update();
        this.holdoffTime.update();
        this.reverseHoldoffTime.update();
        this.upsrBerLevel.update();
        this.upsrReversion.update();
        this.upsrSdBerLevel.update();
        this.upsrSfBerLevel.update();
        this.reverseUpsrSdBerLevel.update();
        this.reverseUpsrSfBerLevel.update();
        this.driNodeType.update();
        this.upsrSwitchOnPdiP.update();
        if (this.inRoll != null) {
            this.inRoll.update();
        }
        this.pathEntities.update();
        this.portEntities.update();
        if (!this.nmd.getPlatform().is600()) {
            this.updateLinkToEtherBackPlane();
        }
        this.topologyUpgrade.update();
        this.isInTopologyUpgrade.update();
        this.isUnstitched = null;
        this.ccm = null;
        super.updateLocal();
    }

    public void dispose() {
        this.activePaths.dispose();
        this.intendedType.dispose();
        this.paths.dispose();
        this.protectionOp.dispose();
        this.reverseProtectionOp.dispose();
        this.holdoffTime.dispose();
        this.reverseHoldoffTime.dispose();
        this.upsrBerLevel.dispose();
        this.upsrReversion.dispose();
        this.upsrSdBerLevel.dispose();
        this.upsrSfBerLevel.dispose();
        this.reverseUpsrSdBerLevel.dispose();
        this.reverseUpsrSfBerLevel.dispose();
        this.upsrSwitchOnPdiP.dispose();
        this.driNodeType.dispose();
        if (this.inRoll != null) {
            this.inRoll.dispose();
        }
        this.pathEntities.dispose();
        this.portEntities.dispose();
        if (!this.nmd.getPlatform().is600()) {
            this.bridgePortAssociationList.dispose();
        }
        this.topologyUpgrade.dispose();
        this.isInTopologyUpgrade.dispose();
        this.isUnstitched = null;
        this.ccm = null;
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        this.stsConnectionRef = null;
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public StsConnection getStsConnectionRef() {
        if (this.stsConnectionRef == null) {
            throw new CmsObjectNotExistException("Attempt to access an StsConnection that has been destroyed.");
        }
        return this.stsConnectionRef;
    }

    protected StsCircuitPart getCircuitPart() {
        if (this.stsConnectionRef == null) {
            throw new CmsObjectNotExistException("Attempt to access an StsConnection that has been destroyed.");
        }
        return this.stsConnectionRef;
    }

    public IHoPathDefModel[] getActivePaths() {
        try {
            return (IHoPathDefModel[])this.activePaths.get();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getActivePaths(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public List getActivePathList() {
        return Arrays.asList(this.getActivePaths());
    }

    public BridgePortAssociation[] getBridgePortAssociations() {
        try {
            if (this.bridgePortAssociationList == null) {
                return null;
            }
            return (BridgePortAssociation[])this.bridgePortAssociationList.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            this.db.println("HoConnectionModel.getBridgePortAssociations(): caught xNoSuchInterface");
            SDebug.printStackTrace((Throwable)((Object)xNoSuchInterface2));
            return null;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getBridgePortAssociations(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private List getBridgePortAssociationList() {
        return Arrays.asList(this.getBridgePortAssociations());
    }

    private boolean canBeEthernet() {
        return this.getConnectionType() == eConnectionType.TWOWAY.value() || this.getConnectionType() == eConnectionType.UPSR.value() || this.getConnectionType() == eConnectionType.ETHER_STITCH.value();
    }

    public int getIntendedType() {
        try {
            eConnectionType eConnectionType2 = (eConnectionType)this.intendedType.get();
            return eConnectionType2.value();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getIntendedType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public IHoPathDefModel[] getPaths() {
        if (this.db.on()) {
            this.db.println("getPaths called on" + this);
        }
        try {
            IHoPathDefModel[] iHoPathDefModelArray = (IHoPathDefModel[])this.paths.get();
            if (this.db.on) {
                this.db.println("Paths(size=" + iHoPathDefModelArray.length + ")= " + Arrays.asList(iHoPathDefModelArray));
            }
            return iHoPathDefModelArray;
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getPaths", userException);
        }
    }

    protected void markPoolsDirty() {
        try {
            IHoPathDefModel[] iHoPathDefModelArray = this.getPaths();
            for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
                ((PoolModel)iHoPathDefModelArray[i].getPool()).updateLocal();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
    }

    public List getPathList() {
        return Arrays.asList(this.getPaths());
    }

    public int getProtectionOp() {
        try {
            eProtectionOp eProtectionOp2 = (eProtectionOp)this.protectionOp.get();
            return eProtectionOp2.value();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getProtectionOp(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getReverseProtectionOp() {
        try {
            eProtectionOp eProtectionOp2 = (eProtectionOp)this.reverseProtectionOp.get();
            return eProtectionOp2.value();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseProtectionOp(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getHoldoffTime() {
        try {
            Integer n = (Integer)this.holdoffTime.get();
            return n;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getHoldoffTime(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getReverseHoldoffTime() {
        try {
            Integer n = (Integer)this.reverseHoldoffTime.get();
            return n;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseiHoldoffTime(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public int getHoldoffTimeForPath(IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Integer n = (Integer)this.holdoffTimeForPath.get(sStsPathDef2);
            return n;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public IEntityModel[] getPathEntities() {
        try {
            return (EntityModel[])this.pathEntities.get();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getPathEntities(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBridgePortInfo[] getBridgePortInfoList() throws NoSuchInterface {
        if (this.nmd.getPlatform().is600()) {
            return new IBridgePortInfo[0];
        }
        if (this.db.on) {
            this.db.println("Enter getBridgePortInfoList");
        }
        BridgePortAssociation[] bridgePortAssociationArray = this.getBridgePortAssociations();
        sBridgePortInfo[] sBridgePortInfoArray = new sBridgePortInfo[]{};
        if (bridgePortAssociationArray == null) {
            return new IBridgePortInfo[0];
        }
        sBridgePortInfoArray = new sBridgePortInfo[bridgePortAssociationArray.length];
        for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
            sBridgePortInfoArray[i] = ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).getBridgePortInfo();
        }
        if (this.db.on) {
            this.db.println("Exit getBridgePortInfoList ");
        }
        return BridgePortInfoFactory.getIBridgePortInfoArray(sBridgePortInfoArray);
    }

    public short getUpsrBerLevel() {
        try {
            return (Short)this.upsrBerLevel.get();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getUpsrBerLevel(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public short getUpsrSdBerLevel() {
        try {
            return (Short)this.upsrSdBerLevel.get();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getUpsrSdBerLevel(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setUpsrSdBerLevel(short s) {
        try {
            this.upsrSdBerLevel.set(new Short(s));
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setUpsrSdBerLevel(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getUpsrSfBerLevel() {
        try {
            return (Short)this.upsrSfBerLevel.get();
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getUpsrSfBerLevel(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setUpsrSfBerLevel(short s) {
        try {
            this.upsrSfBerLevel.set(new Short(s));
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setUpsrSfBerLevel(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean getUpsrSwitchOnPdiP() throws ConnectionTypeError {
        try {
            return (Boolean)this.upsrSwitchOnPdiP.get();
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getUpsrSwitchOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public boolean getReverseUpsrSwitchOnPdiP() throws ConnectionTypeError, InvalidPath {
        try {
            return (Boolean)this.getReverseUpsrSwitchOnPdiP.get();
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void setUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError {
        try {
            this.upsrSwitchOnPdiP.set(new Boolean(bl));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setUpsrSwitchOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseUpsrSwitchOnPdiP(boolean bl) throws ConnectionTypeError, InvalidPath {
        try {
            this.setReverseUpsrSwitchOnPdiP.set(new Boolean(bl));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setReverseUpsrSwichOnPdiP(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean inRoll() {
        try {
            if (this.inRoll != null) {
                return (Boolean)this.inRoll.get();
            }
            return false;
        }
        catch (UserException userException) {
            this.db.println("StsConnectionModel.inRoll(): caught CORBA UserException");
            return false;
        }
    }

    public IRevertiveBehavior getUpsrReversion() {
        try {
            sRevertiveBehavior sRevertiveBehavior2 = (sRevertiveBehavior)this.upsrReversion.get();
            return RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IRevertiveBehavior getReverseUpsrReversion() throws ConnectionTypeError {
        try {
            sRevertiveBehavior sRevertiveBehavior2 = (sRevertiveBehavior)this.getReverseUpsrReversion.get();
            return RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setUpsrReversion(IRevertiveBehavior iRevertiveBehavior) {
        try {
            this.upsrReversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseUpsrReversion(IRevertiveBehavior iRevertiveBehavior) throws ConnectionTypeError {
        try {
            this.setReverseUpsrReversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.setReverseUpsrReversion(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void addOutput(IHoPathDefModel iHoPathDefModel) throws InvalidPath, PathInUse, ConnectionTypeError, DropsExceedMax, PathNotSupported, CTCUserException {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Object[] objectArray = new Object[]{sStsPathDef2};
            this.addOutput.get(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xDropsExceedMax xDropsExceedMax2) {
            throw new DropsExceedMax((UserException)xDropsExceedMax2);
        }
        catch (xPathNotSupported xPathNotSupported2) {
            throw new PathNotSupported((UserException)xPathNotSupported2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.addOutput(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            throw new CTCUserException(userException);
        }
    }

    public void changeIntendedType(int n) throws ConnectionTypeError {
        eConnectionType eConnectionType2 = eConnectionType.from_int(n);
        try {
            Object[] objectArray = new Object[]{eConnectionType2};
            this.changeIntendedType.get(objectArray);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.changeIntendedType(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void localDestroy() throws Busy, ConnectionInRoll, ConnectionInTestAccess {
    }

    public void localDestroy(boolean bl) throws Busy, ConnectionInRoll, ConnectionInTestAccess, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.destroy.get(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xConnectionInRoll xConnectionInRoll2) {
            throw new ConnectionInRoll((UserException)xConnectionInRoll2);
        }
        catch (xConnectionInTestAccess xConnectionInTestAccess2) {
            throw new ConnectionInTestAccess((UserException)xConnectionInTestAccess2);
        }
        catch (xConnectionInTopologyUpgrade xConnectionInTopologyUpgrade2) {
            throw new ConnectionInTopologyUpgrade((UserException)xConnectionInTopologyUpgrade2);
        }
        catch (xVcatMemberNotOutOfGroup xVcatMemberNotOutOfGroup2) {
            throw new VcatMemberNotOutOfGroup((UserException)xVcatMemberNotOutOfGroup2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.destroy(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void clearSwitchCountStat(int n) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n)};
            this.clearSwitchCount.set(objectArray);
        }
        catch (UserException userException) {
            this.db.println("VtConnectionModel: user exception in clearSwitchCount");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IPmStat getSwitchCountStat(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            sPmStat sPmStat2 = (sPmStat)this.getSwitchCount.get(objectArray);
            return PmStatFactory.getIPmStat(sPmStat2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            this.db.println("HoConnectionModel.getSwitchCountStat(): caught CORBA xConnection");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (xInternalCommError xInternalCommError2) {
            this.db.println("HoConnectionModel.getSwitchCountStat(): caught CORBA xInternalComm");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getSwitchCountStat(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return PmStatFactory.NULL_PMSTAT;
        }
    }

    public int getSwitchCount(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getSwitchCount.get((Object)objectArray)).cnt;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getSwitchCount(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getSwitchCountValidity(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getSwitchCount.get((Object)objectArray)).valid;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getSwitchCountValidity(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public IPmStat getReverseSwitchCountStat(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            sPmStat sPmStat2 = (sPmStat)this.getReverseSwitchCount.get(objectArray);
            return PmStatFactory.getIPmStat(sPmStat2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            this.db.println("HoConnectionModel.getReverseSwitchCountStat(): caught CORBA xConnection");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (xInternalCommError xInternalCommError2) {
            this.db.println("HoConnectionModel.getReverseSwitchCountStat(): caught CORBA xInternalComm");
            return PmStatFactory.NULL_PMSTAT;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseSwitchCountStat(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return PmStatFactory.NULL_PMSTAT;
        }
    }

    public int getReverseSwitchCount(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getReverseSwitchCount.get((Object)objectArray)).cnt;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseSwitchCount(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public boolean getReverseSwitchCountValidity(int n, short s) {
        try {
            Object[] objectArray = new Object[]{eIntervalType.from_int(n), new Short(s)};
            return ((sPmStat)this.getReverseSwitchCount.get((Object)objectArray)).valid;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.getReverseSwitchCountValidity(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
            return false;
        }
    }

    public void removeOutput(IHoPathDefModel iHoPathDefModel) throws InvalidPath, DeleteInstead, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Object[] objectArray = new Object[]{sStsPathDef2};
            this.removeOutput.get(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xDeleteInstead xDeleteInstead2) {
            throw new DeleteInstead((UserException)xDeleteInstead2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel.removeOutput(): caught CORBA UserException");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setProtectionOp(int n) throws InvalidProtectionOp, InternalCommError, ConnectionInLoopback {
        try {
            Object[] objectArray = new Object[]{eProtectionOp.from_int(n)};
            this.setProtectionOp.get(objectArray);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseProtectionOp(int n) throws InvalidProtectionOp, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eProtectionOp.from_int(n)};
            this.setReverseProtectionOp.get(objectArray);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        try {
            this.holdoffTime.set(new Integer(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setReverseHoldoffTime(int n) throws ConnectionTypeError, InvalidRange {
        try {
            this.reverseHoldoffTime.set(new Integer(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getReverseUpsrSdBerLevel() throws ConnectionTypeError {
        try {
            Short s = (Short)this.reverseUpsrSdBerLevel.get();
            return s;
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReverseUpsrSdBerLevel (HoConn)", userException);
        }
    }

    public short getReverseUpsrSfBerLevel() throws ConnectionTypeError {
        try {
            Short s = (Short)this.reverseUpsrSfBerLevel.get();
            return s;
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReverseUpsrSfBerLevel (HoConn)", userException);
        }
    }

    public void setReverseUpsrSdBerLevel(short s) throws ConnectionTypeError {
        try {
            this.reverseUpsrSdBerLevel.set(new Short(s));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setReverseUpsrSdBerLevel (HoConn)", userException);
        }
    }

    public void setReverseUpsrSfBerLevel(short s) throws ConnectionTypeError {
        try {
            this.reverseUpsrSfBerLevel.set(new Short(s));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setReverseUpsrSfBerLevel (LoConn)", userException);
        }
    }

    public void setHoldoffTimeForPath(int n, IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError, InvalidRange {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Object[] objectArray = new Object[]{new Integer(n), sStsPathDef2};
            this.holdoffTimeForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (xInvalidRange xInvalidRange2) {
            throw new InvalidRange((UserException)xInvalidRange2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public short getUpsrSdBerLevelForPath(IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Short s = (Short)this.upsrSdBerLevelForPath.get(sStsPathDef2);
            return s;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getUpsrSdBerLevelForPath (HoConn)", userException);
        }
    }

    public void setUpsrSdBerLevelForPath(short s, IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Object[] objectArray = new Object[]{new Short(s), sStsPathDef2};
            this.upsrSdBerLevelForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setUpsrSdBerLevelForPath (HoConn)", userException);
        }
    }

    public short getUpsrSfBerLevelForPath(IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Short s = (Short)this.upsrSfBerLevelForPath.get(sStsPathDef2);
            return s;
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getUpsrSfBerLevelForPath (HoConn)", userException);
        }
    }

    public void setUpsrSfBerLevelForPath(short s, IHoPathDefModel iHoPathDefModel) throws InvalidPath, ConnectionTypeError {
        sStsPathDef sStsPathDef2 = HoPathDefModelFactory.getStsPathDef(iHoPathDefModel);
        try {
            Object[] objectArray = new Object[]{new Short(s), sStsPathDef2};
            this.upsrSfBerLevelForPath.set(objectArray);
        }
        catch (xInvalidPath xInvalidPath2) {
            throw new InvalidPath((UserException)xInvalidPath2);
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setUpsrSfBerLevelForPath (HoConn)", userException);
        }
    }

    private void updateLinkToEtherBackPlane() {
        this.removeLinksToEtherBackPlane();
        this.bridgePortAssociationList.update();
        this.initializeLinkToEtherBackPlane();
    }

    private void initializeLinkToEtherBackPlane() {
        block6: {
            try {
                if (!this.nmd.provides(Feature.IDL_220) || !this.canBeEthernet()) {
                    return;
                }
                BridgePortAssociation[] bridgePortAssociationArray = this.getBridgePortAssociations();
                for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
                    ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).setHoConnection(this);
                    if (!this.db.on) continue;
                    this.db.println("Initializing links to backplaneModel " + bridgePortAssociationArray[i].getEtherBackPlane());
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on) {
                    this.db.println("i/o exception in initializeLinkToEtherBackPlane");
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                if (!this.db.on) break block6;
                this.db.println("bad operation in initializeLinkToEtherBackPlane");
                SDebug.printStackTrace((Throwable)bAD_OPERATION);
            }
        }
    }

    private void removeLinksToEtherBackPlane() {
        block9: {
            try {
                if (!this.nmd.provides(Feature.IDL_220) || !this.canBeEthernet()) {
                    return;
                }
                BridgePortAssociation[] bridgePortAssociationArray = this.getBridgePortAssociations();
                for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
                    if (this.db.on) {
                        this.db.println("removing links to backplaneModel " + i);
                    }
                    ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).removeHoConnection();
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on) {
                    this.db.println("i/o exception in removeLinksToEtherBackPlane");
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                if (this.db.on) {
                    this.db.println("bad operation in removeLinksToEtherBackPlane");
                    SDebug.printStackTrace((Throwable)bAD_OPERATION);
                }
            }
            catch (Exception exception) {
                if (!this.db.on) break block9;
                this.db.println("exception in removeLinksToEtherBackPlane");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean isUnstitchedEthernet() {
        if (this.isUnstitched == null) {
            int n = this.getConnectionType();
            this.isUnstitched = new Boolean(false);
            if (n == eConnectionType.TWOWAY.value()) {
                EntityModel[] entityModelArray = (EntityModel[])this.getPathEntities();
                if (entityModelArray.length < 2) {
                    if (this.db.on) {
                        this.db.println(" Path length is less than 2");
                    }
                } else if (entityModelArray[0] instanceof EtherModuleModel || entityModelArray[1] instanceof EtherModuleModel) {
                    this.isUnstitched = new Boolean(true);
                }
            } else if (n == eConnectionType.UPSR.value()) {
                EntityModel[] entityModelArray = (EntityModel[])this.getPathEntities();
                if (entityModelArray.length < 3) {
                    if (this.db.on) {
                        this.db.println("Length of paths < 3 for upsr");
                    }
                } else if (entityModelArray[2] instanceof EtherModuleModel) {
                    this.isUnstitched = new Boolean(true);
                }
            }
        }
        return this.isUnstitched;
    }

    public boolean getStpEnabled() {
        BridgePortAssociation[] bridgePortAssociationArray = this.getBridgePortAssociations();
        if (this.nmd.getPlatform().is600()) {
            return true;
        }
        if (bridgePortAssociationArray.length < 1) {
            return false;
        }
        for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
            try {
                sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22 = ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).getBridgePortAdminInfo();
                if (sBridgePortAdminInfo_2_22.stpEnabled) continue;
                return false;
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                this.db.println("getStpEnabled(): caught CORBA Exception");
                SDebug.printStackTrace((Throwable)bAD_OPERATION);
            }
        }
        return true;
    }

    public void setStpEnabled(boolean bl) throws NoMoreSpanningTree, VlanSpanningTreeViolation {
        if (this.db.on()) {
            this.db.println("in StsConnectionModel, attempting to set STP to " + bl);
        }
        BridgePortAssociation[] bridgePortAssociationArray = this.getBridgePortAssociations();
        for (int i = 0; i < bridgePortAssociationArray.length; ++i) {
            try {
                sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22 = ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).getBridgePortAdminInfo();
                if (this.db.on()) {
                    this.db.println("stpEnabled currently " + sBridgePortAdminInfo_2_22.stpEnabled + ", setting to " + bl);
                }
                sBridgePortAdminInfo_2_22.stpEnabled = bl;
                ((EtherBackPlaneModel)bridgePortAssociationArray[i].getEtherBackPlane()).setBridgePortAdminInfoNoProv(sBridgePortAdminInfo_2_22);
                continue;
            }
            catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
                throw new NoMoreSpanningTree((UserException)xNoMoreSpanningTree2);
            }
            catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
                throw new VlanSpanningTreeViolation((UserException)xVlanSpanningTreeViolation2);
            }
        }
    }

    public List getPortModels() {
        try {
            return (List)this.portEntities.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return new LinkedList();
        }
    }

    protected void printString(SDebug sDebug) {
        IHoPathDefModel[] iHoPathDefModelArray = this.getPaths();
        super.printString(sDebug);
        sDebug.println("Number of Paths Are " + iHoPathDefModelArray.length);
        for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
            sDebug.println("Path " + i + iHoPathDefModelArray[i]);
        }
    }

    private boolean hoModelHasXcLoopback(IHoPathDefModel iHoPathDefModel, IPortModel iPortModel) throws InvalidPath {
        boolean bl = false;
        IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
        TdmHoModel tdmHoModel = (TdmHoModel)iPortModel.getTdmHoModel(iHoNum);
        if (tdmHoModel != null) {
            bl = tdmHoModel.hasXcLoopback();
        }
        return bl;
    }

    public boolean hasXcLoopback() throws AbstractCmsNoSuchEntityException, InvalidPath {
        boolean bl = false;
        Throwable throwable = null;
        IHoPathDefModel[] iHoPathDefModelArray = this.getPaths();
        if (iHoPathDefModelArray != null) {
            for (int i = 0; i < iHoPathDefModelArray.length && !bl; ++i) {
                try {
                    IEntityModel iEntityModel = iHoPathDefModelArray[i].getPool().getEntityModel();
                    if (iEntityModel instanceof ModuleModel) {
                        PortModel[] portModelArray = ((ModuleModel)iEntityModel).getPortModels();
                        for (int j = 0; j < portModelArray.length && !(bl = this.hoModelHasXcLoopback(iHoPathDefModelArray[i], portModelArray[j])); ++j) {
                        }
                        continue;
                    }
                    bl = this.hoModelHasXcLoopback(iHoPathDefModelArray[i], (IPortModel)iEntityModel);
                    continue;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (throwable != null) continue;
                    throwable = abstractCmsNoSuchEntityException;
                    continue;
                }
                catch (InvalidPath invalidPath) {
                    if (throwable != null) continue;
                    throwable = invalidPath;
                }
            }
        }
        if (bl || throwable == null) {
            return bl;
        }
        if (throwable instanceof AbstractCmsNoSuchEntityException) {
            throw (AbstractCmsNoSuchEntityException)throwable;
        }
        throw (InvalidPath)throwable;
    }

    public void setXcLoopback(IHoPathDefModel iHoPathDefModel, boolean bl) throws ConnectionInLoopback, ConnectionInTestAccess, InvalidPath, InvalidState, LoopbackActive, ConnectionInRoll, NoSuchConnection, AbstractCmsNoSuchEntityException, NoSuchLoopback {
        ((TdmHoModel)((IPortModel)iHoPathDefModel.getPool().getEntityModel()).getTdmHoModel(iHoPathDefModel.getStartingHo())).setXcLoopback(bl);
    }

    public boolean hasTestAccess() {
        IHoPathDefModel[] iHoPathDefModelArray = this.getPaths();
        if (iHoPathDefModelArray == null) {
            return false;
        }
        HoTapModel[] hoTapModelArray = this.getNodeModelDelegate().getTapModels().getHoTapModels().getHoTapModels();
        for (int i = 0; i < hoTapModelArray.length; ++i) {
            for (int j = 0; j < iHoPathDefModelArray.length; ++j) {
                if (!iHoPathDefModelArray[j].equals(hoTapModelArray[i].getPathE()) && !iHoPathDefModelArray[j].equals(hoTapModelArray[i].getPathF())) continue;
                return true;
            }
        }
        return false;
    }

    public int getDriNodeType() {
        if (this.db.on()) {
            this.db.print("In HoConnectionModel::getDriNodeType  ");
        }
        try {
            int n = ((eDriNodeType)this.driNodeType.get()).value();
            if (this.db.on()) {
                this.db.println("returning DriNodeType = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetMedia$eDriNodeType == null ? (class$cerent$cms$idl$SonetMedia$eDriNodeType = HoConnectionModel.class$("cerent.cms.idl.SonetMedia.eDriNodeType")) : class$cerent$cms$idl$SonetMedia$eDriNodeType))[n]);
            }
            return n;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                this.db.println("HoConnectionModel: i/o exception in getDriNodeType");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return -1;
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel: user exception in getDriNodeType");
            SDebug.printStackTrace((Throwable)userException);
            return -1;
        }
    }

    public void setDriNodeType(int n) throws ConnectionTypeError {
        if (this.db.on()) {
            this.db.print("In HoConnectionModel::setDriNodeType   ");
        }
        if (this.db.on()) {
            this.db.println("setting DriNodeType = " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$SonetMedia$eDriNodeType == null ? (class$cerent$cms$idl$SonetMedia$eDriNodeType = HoConnectionModel.class$("cerent.cms.idl.SonetMedia.eDriNodeType")) : class$cerent$cms$idl$SonetMedia$eDriNodeType))[n]);
        }
        try {
            this.driNodeType.set(eDriNodeType.from_int(n));
        }
        catch (xConnectionTypeError xConnectionTypeError2) {
            throw new ConnectionTypeError((UserException)xConnectionTypeError2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("HoConnectionModel: i/0 exception in setDriNodeType");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
        }
        catch (UserException userException) {
            this.db.println("HoConnectionModel: user exception in setDriNodeType");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    protected void markDirty() {
        this.isInTopologyUpgrade.update();
        this.paths.update();
        this.intendedType.update();
    }

    public IConnectionConversionModel createConnectionConversionModel(List list, int n, ICircuitId iCircuitId, List list2, int n2, IConnCreateAttrs iConnCreateAttrs, int n3, boolean bl, boolean bl2) throws NoSuchConnection, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, PathInUse {
        Object[] objectArray = new Object[9];
        IHoPathDefModel[] iHoPathDefModelArray = new IHoPathDefModel[]{};
        iHoPathDefModelArray = list.toArray(iHoPathDefModelArray);
        ICircuitId[] iCircuitIdArray = new ICircuitId[]{};
        iCircuitIdArray = list2.toArray(iCircuitIdArray);
        objectArray[0] = HoPathDefModelFactory.getStsPathDefArray(iHoPathDefModelArray);
        objectArray[1] = eTopologyUpgradeType.from_int(n);
        objectArray[2] = CircuitIdFactory.getCircuitId(iCircuitId);
        objectArray[3] = CircuitIdFactory.getCircuitId(iCircuitIdArray);
        objectArray[4] = eConnectionType.from_int(n2);
        objectArray[5] = ConnCreateAttrsFactory.getConnCreateAttrs(iConnCreateAttrs);
        objectArray[6] = eTopologyUpgradeState.from_int(n3);
        objectArray[7] = new Boolean(bl);
        objectArray[8] = new Boolean(bl2);
        if (this.db.on()) {
            this.db.println("createConnectionConversionModel: creating new conn conv model, conn type => " + EnumStrings.getString((Class)(class$cerent$cms$model$IConnectionType == null ? (class$cerent$cms$model$IConnectionType = HoConnectionModel.class$("cerent.cms.model.IConnectionType")) : class$cerent$cms$model$IConnectionType), (int)n2));
        }
        try {
            this.topologyUpgrade.set(objectArray);
            if (this.db.on()) {
                this.db.println("createConnectionConversionModel: creation was successful");
            }
            this.markDirty();
            return this.getConnectionConversionModel();
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw new NoSuchConnection((UserException)xNoSuchConnection2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xPathListIncomplete xPathListIncomplete2) {
            throw new PathListIncomplete((UserException)xPathListIncomplete2);
        }
        catch (xConnectionInRoll xConnectionInRoll2) {
            throw new ConnectionInRoll((UserException)xConnectionInRoll2);
        }
        catch (xConnectionInTopologyUpgrade xConnectionInTopologyUpgrade2) {
            throw new ConnectionInTopologyUpgrade((UserException)xConnectionInTopologyUpgrade2);
        }
        catch (xConnectionInTestAccess xConnectionInTestAccess2) {
            throw new ConnectionInTestAccess((UserException)xConnectionInTestAccess2);
        }
        catch (xConnectionInLoopback xConnectionInLoopback2) {
            throw new ConnectionInLoopback((UserException)xConnectionInLoopback2);
        }
        catch (xTopologyUpgradeNotAllowed xTopologyUpgradeNotAllowed2) {
            throw new TopologyUpgradeNotAllowed((UserException)xTopologyUpgradeNotAllowed2);
        }
        catch (xPathInUse xPathInUse2) {
            throw new PathInUse((UserException)xPathInUse2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createConnectionConversionModel", userException);
        }
    }

    public boolean inConnectionConversion() {
        boolean bl;
        block3: {
            bl = false;
            try {
                bl = (Boolean)this.isInTopologyUpgrade.get();
            }
            catch (UserException userException) {
                if (!this.db.on) break block3;
                this.db.println("Could not retrieve IsInTopologyUpgrade");
            }
        }
        if (this.db.on) {
            this.db.println("inConnectionConversion: state => " + bl);
        }
        return bl;
    }

    public boolean isBlsrDri() {
        return this.getDriNodeType() != 0;
    }

    public IConnectionConversionModel getConnectionConversionModel() {
        if (this.db.on()) {
            this.db.println("getConnectionConversionModel: getting ccm");
        }
        if (this.inConnectionConversion()) {
            if (this.ccm == null) {
                try {
                    this.ccm = (ConnectionConversionModel)ConnectionConversionFactory.getIConnectionConversionModel((sStsTopologyUpgradeItem)this.topologyUpgrade.get(), this.getNodeModelDelegate(), this);
                    if (this.db.on()) {
                        this.db.println("getConnectionConversionModel: obtained ccm");
                        this.db.println("getConnectionConversionModel: ccm.getState => " + this.ccm.getState());
                        this.db.println("getConnectionConversionModel: ccm.getNewConnType => " + this.ccm.getNewConnType());
                    }
                }
                catch (UserException userException) {
                    if (this.db.on) {
                        this.db.println("Failed to retrieve Topology Upgrade");
                    }
                }
            }
        } else {
            this.ccm = null;
        }
        return this.ccm;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.getNodeModelDelegate().getIorRepository().getSonetFactoryRef();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TopologyUpgrade
    extends CachedValue {
        public TopologyUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchConnection {
            return HoConnectionModel.this.getSonetFactoryRef().getStsTopologyUpgrade(HoConnectionModel.this.getIndex());
        }

        protected void setValue(Object object) throws xNoSuchConnection, xBusy, xPathListIncomplete, xConnectionInRoll, xConnectionInTopologyUpgrade, xConnectionInTestAccess, xConnectionInLoopback, xTopologyUpgradeNotAllowed, xPathInUse {
            Object[] objectArray = (Object[])object;
            sStsPathDef[] sStsPathDefArray = (sStsPathDef[])objectArray[0];
            int n = HoConnectionModel.this.getIndex();
            eTopologyUpgradeType eTopologyUpgradeType2 = (eTopologyUpgradeType)objectArray[1];
            sCircuitId sCircuitId2 = (sCircuitId)objectArray[2];
            sCircuitId[] sCircuitIdArray = (sCircuitId[])objectArray[3];
            eConnectionType eConnectionType2 = (eConnectionType)objectArray[4];
            sConnCreateAttrs sConnCreateAttrs2 = (sConnCreateAttrs)objectArray[5];
            eTopologyUpgradeState eTopologyUpgradeState2 = (eTopologyUpgradeState)objectArray[6];
            boolean bl = (Boolean)objectArray[7];
            boolean bl2 = (Boolean)objectArray[8];
            HoConnectionModel.this.getSonetFactoryRef().createStsTopologyUpgrade(sStsPathDefArray, n, eTopologyUpgradeType2, sCircuitIdArray, eConnectionType2, sConnCreateAttrs2, eTopologyUpgradeState2, bl2, bl);
        }
    }

    private class IsInTopologyUpgrade
    extends CachedValue {
        public IsInTopologyUpgrade(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(HoConnectionModel.this.getStsConnectionRef().isInTopologyUpgrade());
        }

        public void setValueExternally(Object object) {
            super.setValueExternally((Boolean)object);
        }
    }

    private class UpsrSfBerLevelForPath
    extends NonCachedValue {
        public UpsrSfBerLevelForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidPath, xConnectionTypeError {
            return new Short(HoConnectionModel.this.getStsConnectionRef().getUpsrSfBerLevelForPath((sStsPathDef)object));
        }

        protected void setValue(Object object) throws xInvalidPath, xConnectionTypeError {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[0];
            sStsPathDef sStsPathDef2 = (sStsPathDef)objectArray[1];
            HoConnectionModel.this.getStsConnectionRef().setUpsrSfBerLevelForPath(s, sStsPathDef2);
        }
    }

    private class UpsrSdBerLevelForPath
    extends NonCachedValue {
        public UpsrSdBerLevelForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xInvalidPath, xConnectionTypeError {
            return new Short(HoConnectionModel.this.getStsConnectionRef().getUpsrSdBerLevelForPath((sStsPathDef)object));
        }

        protected void setValue(Object object) throws xInvalidPath, xConnectionTypeError {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[0];
            sStsPathDef sStsPathDef2 = (sStsPathDef)objectArray[1];
            HoConnectionModel.this.getStsConnectionRef().setUpsrSdBerLevelForPath(s, sStsPathDef2);
        }
    }

    private class ReverseUpsrSfBerLevel
    extends CachedValue {
        public ReverseUpsrSfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Short(HoConnectionModel.this.getStsConnectionRef().getReverseUpsrSfBerLevel());
        }

        protected void setValue(Object object) throws xConnectionTypeError {
            HoConnectionModel.this.getStsConnectionRef().setReverseUpsrSfBerLevel((Short)object);
        }
    }

    private class ReverseUpsrSdBerLevel
    extends CachedValue {
        public ReverseUpsrSdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Short(HoConnectionModel.this.getStsConnectionRef().getReverseUpsrSdBerLevel());
        }

        protected void setValue(Object object) throws xConnectionTypeError {
            HoConnectionModel.this.getStsConnectionRef().setReverseUpsrSdBerLevel((Short)object);
        }
    }

    private class DriNodeType
    extends CachedValue {
        public DriNodeType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().getDriNodeType();
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().setDriNodeType((eDriNodeType)object);
        }
    }

    private class HoldoffTimeForPath
    extends NonCachedValue {
        public HoldoffTimeForPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return new Integer(HoConnectionModel.this.getStsConnectionRef().getHoldoffTimeForPath((sStsPathDef)object));
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            sStsPathDef sStsPathDef2 = (sStsPathDef)objectArray[1];
            HoConnectionModel.this.getStsConnectionRef().setHoldoffTimeForPath(n, sStsPathDef2);
        }
    }

    private class ReverseHoldoffTime
    extends CachedValue {
        public ReverseHoldoffTime(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(HoConnectionModel.this.getStsConnectionRef().getReverseHoldoffTime());
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().setReverseHoldoffTime((Integer)object);
        }
    }

    private class HoldoffTime
    extends CachedValue {
        public HoldoffTime(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(HoConnectionModel.this.getStsConnectionRef().getHoldoffTime());
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().setHoldoffTime((Integer)object);
        }
    }

    private class SetReverseProtectionOp
    extends NonCachedValue {
        public SetReverseProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().setReverseProtectionOp((eProtectionOp)objectArray[0]);
            return null;
        }
    }

    private class SetProtectionOp
    extends NonCachedValue {
        public SetProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().setProtectionOp((eProtectionOp)objectArray[0]);
            return null;
        }
    }

    private class RemoveOutput
    extends NonCachedValue {
        public RemoveOutput(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().removeOutput((sStsPathDef)objectArray[0]);
            return null;
        }
    }

    private class ClearSwitchCount
    extends NonCachedValue {
        public ClearSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().clearSwitchCount((eIntervalType)objectArray[0]);
        }
    }

    private class GetReverseSwitchCount
    extends NonCachedValue {
        public GetReverseSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return HoConnectionModel.this.getStsConnectionRef().getReverseSwitchCount((eIntervalType)objectArray[0], (Short)objectArray[1]);
        }
    }

    private class GetSwitchCount
    extends NonCachedValue {
        public GetSwitchCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            return HoConnectionModel.this.getStsConnectionRef().getSwitchCount((eIntervalType)objectArray[0], (Short)objectArray[1]);
        }
    }

    private class Destroy
    extends NonCachedValue {
        public Destroy(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().destroy((Boolean)objectArray[0]);
            return null;
        }
    }

    private class ChangeIntendedType
    extends NonCachedValue {
        public ChangeIntendedType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().changeIntendedType((eConnectionType)objectArray[0]);
            return null;
        }
    }

    private class AddOutput
    extends NonCachedValue {
        public AddOutput(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            HoConnectionModel.this.getStsConnectionRef().addOutput((sStsPathDef)objectArray[0]);
            return null;
        }
    }

    private class InRoll
    extends CachedValue {
        public InRoll(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(HoConnectionModel.this.getStsConnectionRef().inRoll());
        }

        public void setValueExternally(boolean bl) {
            super.setValueExternally(new Boolean(bl));
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class SetReverseUpsrSwitchOnPdiP
    extends NonCachedValue {
        public SetReverseUpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().setReverseUpsrSwitchOnPdiP((Boolean)object);
        }
    }

    private class GetReverseUpsrSwitchOnPdiP
    extends NonCachedValue {
        public GetReverseUpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Boolean(HoConnectionModel.this.getStsConnectionRef().getReverseUpsrSwitchOnPdiP());
        }

        public Object outer() {
            return HoConnectionModel.this;
        }
    }

    private class UpsrSwitchOnPdiP
    extends CachedValue {
        public UpsrSwitchOnPdiP(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xConnectionTypeError {
            return new Boolean(HoConnectionModel.this.getStsConnectionRef().getUpsrSwitchOnPdiP());
        }

        protected void setValue(Object object) throws xConnectionTypeError {
            HoConnectionModel.this.getStsConnectionRef().setUpsrSwitchOnPdiP((Boolean)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Boolean)this.value);
        }
    }

    private class UpsrSfBerLevel
    extends CachedValue {
        public UpsrSfBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(HoConnectionModel.this.getStsConnectionRef().upsrSfBerLevel());
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().upsrSfBerLevel((Short)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Short)this.value);
        }
    }

    private class UpsrSdBerLevel
    extends CachedValue {
        public UpsrSdBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(HoConnectionModel.this.getStsConnectionRef().upsrSdBerLevel());
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().upsrSdBerLevel((Short)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Short)this.value);
        }
    }

    private class SetReverseUpsrReversion
    extends NonCachedValue {
        public SetReverseUpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().setReverseUpsrReversion((sRevertiveBehavior)object);
        }
    }

    private class GetReverseUpsrReversion
    extends NonCachedValue {
        public GetReverseUpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().getReverseUpsrReversion();
        }

        public Object outer() {
            return HoConnectionModel.this;
        }
    }

    private class UpsrReversion
    extends CachedValue {
        public UpsrReversion(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().upsrReversion();
        }

        protected void setValue(Object object) throws UserException {
            HoConnectionModel.this.getStsConnectionRef().upsrReversion((sRevertiveBehavior)object);
        }

        protected Object cloneValue() {
            return CloneHelper.clone((sRevertiveBehavior)this.value);
        }
    }

    private class UpsrBerLevel
    extends CachedValue {
        public UpsrBerLevel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Short(HoConnectionModel.this.getStsConnectionRef().upsrBerLevel());
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((Short)this.value);
        }
    }

    private class Paths
    extends CachedValue {
        public Paths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoPathDefModelFactory.getIHoPathDefArray(this.node, HoConnectionModel.this.getStsConnectionRef().paths());
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(HoPathDefModelFactory.getIHoPathDefArray(this.node, (sStsPathDef[])object));
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((IHoPathDefModel[])this.value);
        }
    }

    private class ReverseProtectionOp
    extends CachedValue {
        public ReverseProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().reverseProtectionOp();
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eProtectionOp)this.value);
        }
    }

    private class ProtectionOp
    extends CachedValue {
        public ProtectionOp(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().protectionOp();
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((eProtectionOp)this.value);
        }
    }

    private class IntendedType
    extends CachedValue {
        public IntendedType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnectionModel.this.getStsConnectionRef().intendedType();
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class PortEntities
    extends CachedValue {
        public PortEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            IHoPathDefModel[] iHoPathDefModelArray = null;
            LinkedList linkedList = new LinkedList();
            try {
                iHoPathDefModelArray = HoConnectionModel.this.getPaths();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                if (HoConnectionModel.this.db.on()) {
                    SDebug cfr_ignored_0 = HoConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)((Object)cmsObjectNotExistException));
                }
                return linkedList;
            }
            if (iHoPathDefModelArray != null) {
                for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
                    try {
                        if (iHoPathDefModelArray[i] == null) continue;
                        PoolModel poolModel = (PoolModel)iHoPathDefModelArray[i].getPool();
                        IEntityModel iEntityModel = poolModel.getEntityModel();
                        if (iEntityModel.getEqType() == 66 && HoConnectionModel.this.getNodeModelDelegate().getFramingType() == 0) {
                            linkedList.addAll(((Ds3IModuleModel)iEntityModel).getPortsInGroup(iHoPathDefModelArray[i].getStartingHo()));
                            continue;
                        }
                        linkedList.addAll(poolModel.getPortModels());
                        continue;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!HoConnectionModel.this.db.on()) continue;
                        SDebug cfr_ignored_1 = HoConnectionModel.this.db;
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
            }
            return linkedList;
        }

        protected void setValue(Object object) throws UserException {
        }
    }

    private class PathEntities
    extends CachedValue {
        public PathEntities(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            try {
                return this.getPathEntityModels();
            }
            catch (CmsNoSuchEntityException cmsNoSuchEntityException) {
                if (HoConnectionModel.this.db.on) {
                    HoConnectionModel.this.db.println("no such entity in PathEntities.getValue");
                    SDebug cfr_ignored_0 = HoConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)((Object)cmsNoSuchEntityException));
                }
                return new EntityModel[0];
            }
        }

        protected void setValue(Object object) throws UserException {
        }

        public IEntityModel[] getPathEntityModels() throws CmsNoSuchEntityException {
            sStsPathDef[] sStsPathDefArray = HoPathDefModelFactory.getStsPathDefArray(HoConnectionModel.this.getPaths());
            IEntityModel[] iEntityModelArray = new EntityModel[]{};
            if (HoConnectionModel.this.paths == null) {
                return iEntityModelArray;
            }
            iEntityModelArray = new EntityModel[sStsPathDefArray.length];
            for (int i = 0; i < sStsPathDefArray.length; ++i) {
                iEntityModelArray[i] = this.getEntityModelForPathDef(sStsPathDefArray[i]);
                if (iEntityModelArray[i] != null) continue;
                throw new CmsNoSuchEntityException("Cannot find entity for StsPathDef");
            }
            return iEntityModelArray;
        }

        protected IEntityModel getEntityModelForPathDef(sStsPathDef sStsPathDef2) throws CmsNoSuchEntityException {
            IEntityModel iEntityModel = null;
            PoolModel poolModel = ((PoolModelsDelegate)HoConnectionModel.this.nmd.getPoolModels()).find(sStsPathDef2.stsPool);
            if (poolModel == null) {
                HoConnectionModel.this.db.println("PoolM is null\nindex = " + sStsPathDef2.stsPool.objIndex());
                return null;
            }
            try {
                iEntityModel = poolModel.getEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return null;
            }
            return iEntityModel;
        }
    }

    private class BridgePortAssociationList
    extends CachedValue {
        public BridgePortAssociationList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            sBridgePortAssociation[] sBridgePortAssociationArray = HoConnectionModel.this.getStsConnectionRef().bridgePortAssociationList();
            return this.createBridgePortAssociations(sBridgePortAssociationArray);
        }

        protected void setValue(Object object) throws UserException {
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(this.createBridgePortAssociations((sBridgePortAssociation[])object));
        }

        private BridgePortAssociation[] createBridgePortAssociations(sBridgePortAssociation[] sBridgePortAssociationArray) {
            BridgePortAssociation[] bridgePortAssociationArray = new BridgePortAssociation[sBridgePortAssociationArray.length];
            for (int i = 0; i < sBridgePortAssociationArray.length; ++i) {
                try {
                    bridgePortAssociationArray[i] = new BridgePortAssociation(this.node, sBridgePortAssociationArray[i].path, sBridgePortAssociationArray[i].ifIndex);
                    continue;
                }
                catch (NoSuchInterface noSuchInterface) {
                    SDebug cfr_ignored_0 = HoConnectionModel.this.db;
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
            }
            return bridgePortAssociationArray;
        }
    }

    private class ActivePaths
    extends CachedValue {
        public ActivePaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoPathDefModelFactory.getIHoPathDefArray(this.node, HoConnectionModel.this.getStsConnectionRef().activePaths());
        }

        public void setValueExternally(Object object) {
            super.setValueExternally(HoPathDefModelFactory.getIHoPathDefArray(this.node, (sStsPathDef[])object));
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object cloneValue() {
            return CloneHelper.clone((IHoPathDefModel[])this.value);
        }
    }
}

