/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.StsRoll;
import cerent.cms.idl.SonetTopology.sStsRollItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.HoRollModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.Rolls;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class HoRolls
extends Rolls
implements Observer {
    private ConnectionModelsDelegate container;
    private GetHoRollItems getHoRollItems;
    private GetHoRollItem getHoRollItem;
    private GetConnectionIndex getConnectionIndex;
    private EventDispatcher dispatcher;
    protected static SDebug db = new SDebug("HoRolls");

    public HoRolls(ConnectionModelsDelegate connectionModelsDelegate) {
        super(connectionModelsDelegate.node);
        this.container = connectionModelsDelegate;
        this.getHoRollItems = new GetHoRollItems(this.node, "HoRolls::getHoRollItems");
        this.getHoRollItem = new GetHoRollItem(this.node, "HoRolls::getHoRollItem");
        this.dispatcher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectRollList, 0, (Observer)this);
        }
        HoRolls hoRolls = this;
        synchronized (hoRolls) {
            block7: {
                try {
                    this.discover(this.rollModels);
                    Iterator iterator = this.rollModels.values().iterator();
                    while (iterator.hasNext()) {
                        ((HoRollModel)iterator.next()).init();
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block7;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    protected void discoverRollItems(HashMap hashMap) {
        sStsRollItem[] sStsRollItemArray = this.getHoRollItems();
        if (sStsRollItemArray == null) {
            return;
        }
        for (int i = 0; i < sStsRollItemArray.length; ++i) {
            hashMap.put(new Integer(sStsRollItemArray[i].connectionIndex), sStsRollItemArray[i]);
        }
    }

    private synchronized void discover(Map map) {
        sStsRollItem[] sStsRollItemArray = null;
        sStsRollItemArray = this.getHoRollItems();
        if (sStsRollItemArray == null) {
            db.println("Error in getting HoRolls (null) HoRolls::discover");
            return;
        }
        for (int i = 0; i < sStsRollItemArray.length; ++i) {
            if (sStsRollItemArray[i] == null) continue;
            Integer n = new Integer(sStsRollItemArray[i].connectionIndex);
            map.put(n, new HoRollModel(this.node, this, sStsRollItemArray[i]));
        }
    }

    private sStsRollItem getHoRollItem(int n) {
        sStsRollItem sStsRollItem2;
        try {
            sStsRollItem2 = (sStsRollItem)this.getHoRollItem.get(new Integer(n));
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.println("Error in getting hoRollItem " + (Object)((Object)abstractCmsIOException));
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            return null;
        }
        catch (UserException userException) {
            if (db.on()) {
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
        return sStsRollItem2;
    }

    private sStsRollItem[] getHoRollItems() {
        sStsRollItem[] sStsRollItemArray = new sStsRollItem[]{};
        try {
            sStsRollItemArray = (sStsRollItem[])this.getHoRollItems.get();
            if (db.on()) {
                db.println("Found " + sStsRollItemArray.length + " rolls");
                for (int i = 0; i < sStsRollItemArray.length; ++i) {
                    db.println("Roll[" + i + "]" + " with connection Index " + sStsRollItemArray[i].connectionIndex + " and roll mode " + sStsRollItemArray[i].rollMode);
                }
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("Error in getting stsRolls " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
        return sStsRollItemArray;
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectRollList, 0, (Observer)this);
        }
        super.dispose();
    }

    public synchronized HoRollModel getRollModel(int n) throws NoSuchConnection {
        return (HoRollModel)this.rollModels.get(new Integer(n));
    }

    public synchronized HoRollModel[] getRollModels() {
        return this.rollModels.values().toArray(new HoRollModel[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HoRollModel findHoRollModel(sStsRollItem sStsRollItem2) {
        Object var2_2 = null;
        if (sStsRollItem2 != null) {
            HoRolls hoRolls = this;
            synchronized (hoRolls) {
                var2_2 = this.rollModels.get(new Integer(sStsRollItem2.connectionIndex));
            }
        }
        if (var2_2 == null) {
            // empty if block
        }
        return var2_2;
    }

    protected HoRollModel add(StsRoll stsRoll) {
        sStsRollItem sStsRollItem2 = this.getHoRollItem(stsRoll.connectionIndex());
        return this.add(sStsRollItem2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HoRollModel add(sStsRollItem sStsRollItem2) {
        HoRollModel hoRollModel = null;
        if (sStsRollItem2 == null) {
            return null;
        }
        HoRolls hoRolls = this;
        synchronized (hoRolls) {
            block8: {
                hoRollModel = this.findHoRollModel(sStsRollItem2);
                if (hoRollModel == null) {
                    try {
                        hoRollModel = new HoRollModel(this.node, this, sStsRollItem2);
                        hoRollModel.init();
                        Integer n = new Integer(hoRollModel.getConnectionIndex());
                        this.rollModels.put(n, hoRollModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (db.on()) {
                            db.println("Exception in add-HoRoll " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (hoRollModel == null) break block8;
                        hoRollModel.dispose();
                        hoRollModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return hoRollModel;
    }

    private void discoverHoRollItems(HashMap hashMap) {
        sStsRollItem[] sStsRollItemArray = this.getHoRollItems();
        if (sStsRollItemArray == null) {
            return;
        }
        for (int i = 0; i < sStsRollItemArray.length; ++i) {
            hashMap.put(new Integer(sStsRollItemArray[i].connectionIndex), sStsRollItemArray[i]);
        }
    }

    private synchronized boolean updateHoRollStructure() {
        HoRollModel hoRollModel;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        boolean bl = false;
        this.discoverHoRollItems(hashMap);
        Collection collection = HoRolls.getAddedObjects(hashMap.keySet(), this.rollModels.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (db.on()) {
                    db.println("New ho found # " + collection.size());
                }
                if (db.on()) {
                    db.println(" ho # " + object2);
                }
                object = (sStsRollItem)hashMap.get(object2);
                hoRollModel = new HoRollModel(this.node, this, (sStsRollItem)object);
                this.rollModels.put(object2, hoRollModel);
                hoRollModel.init();
            }
            bl = true;
        }
        if ((object2 = HoRolls.getDeletedObjects(hashMap.keySet(), this.rollModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (db.on()) {
                    db.println("Deleted ho found # " + object2.size());
                }
                if (db.on()) {
                    db.println("Deleted ho index " + object);
                }
                if ((hoRollModel = (HoRollModel)this.rollModels.get(object)) == null) continue;
                hoRollModel.delete();
            }
        }
        if (db.on()) {
            db.println("Exit:: HoRolls::updateHoRollStructure()");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        int n = ((IObjectMessageInfo)object).getUpdateType();
        if (n == 1) {
            if (HoRolls.db.on) {
                db.println("Got a changed Message for StsConn");
            }
            this.container.updateLocal();
        } else if (n == 2) {
            if (HoRolls.db.on) {
                db.println("Got an update Structure Message");
            }
            if (this.updateHoRollStructure()) {
                if (HoRolls.db.on) {
                    db.println("Going to Update Structure");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
            }
        } else {
            db.println("Unknown update type in HoRolls");
        }
    }

    protected class GetHoRollItem
    extends NonCachedValue {
        public GetHoRollItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws xNoSuchConnection {
            return HoRolls.this.getSonetFactoryRef().getStsRoll((Integer)object);
        }
    }

    protected class GetHoRollItems
    extends NonCachedValue {
        public GetHoRollItems(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() throws UserException {
            return HoRolls.this.getSonetFactoryRef().getStsRolls();
        }
    }

    private class GetConnectionIndex
    extends NonCachedValue {
        public GetConnectionIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((StsRoll)object).connectionIndex();
            return new Integer(n);
        }
    }
}

