/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.Attribute;

public class LANAccessMode
extends Attribute {
    public static final int _DCC_ONLY = 0;
    public static final int _BACKPLANE_ONLY = 1;
    public static final int _FRONT_ONLY = 2;
    public static final int _FRONT_BACKPLANE = 3;
    public static final LANAccessMode DCC_ONLY = new LANAccessMode(0, "No LAN Access");
    public static final LANAccessMode BACKPLANE_ONLY = new LANAccessMode(1, "Backplane Only");
    public static final LANAccessMode FRONT_ONLY = new LANAccessMode(2, "Front Only");
    public static final LANAccessMode FRONT_BACKPLANE = new LANAccessMode(3, "Front & Backplane");

    protected LANAccessMode(int n, String string) {
        super(string, n);
    }

    public int value() {
        return this.getIntValue();
    }

    public boolean isFrontLANAccessEnabled() {
        return this.getIntValue() == 2 || this.getIntValue() == 3;
    }

    public boolean isBackLANAccessEnabled() {
        return this.getIntValue() == 1 || this.getIntValue() == 3;
    }

    public static LANAccessMode from_int(int n) {
        switch (n) {
            case 0: {
                return DCC_ONLY;
            }
            case 1: {
                return BACKPLANE_ONLY;
            }
            case 2: {
                return FRONT_ONLY;
            }
            case 3: {
                return FRONT_BACKPLANE;
            }
        }
        throw new IllegalArgumentException("" + n);
    }

    public static LANAccessMode from_string(String string) {
        if (string.equals(DCC_ONLY.toString())) {
            return DCC_ONLY;
        }
        if (string.equals(BACKPLANE_ONLY.toString())) {
            return BACKPLANE_ONLY;
        }
        if (string.equals(FRONT_ONLY.toString())) {
            return FRONT_ONLY;
        }
        if (string.equals(FRONT_BACKPLANE.toString())) {
            return FRONT_BACKPLANE;
        }
        throw new IllegalArgumentException(string);
    }

    public boolean transitionMayDisconnect(LANAccessMode lANAccessMode) {
        boolean bl = false;
        if (this.value() != lANAccessMode.value() && lANAccessMode.value() != 2 && lANAccessMode.value() != 3) {
            bl = true;
        }
        return bl;
    }
}

